/// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.Random;

import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.display.DisplayManager;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;
import net.cellcomputing.himawari.util.AccessSupplier;
import net.cellcomputing.himawari.util.HimawariLogger;

import static net.cellcomputing.himawari.library.Float_h.*;

/**
 * 
 * RI֘ÃO[oϐE֐Q
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiGlobal {
	public static SpeedCheck spd = new SpeedCheck();
//	************************  ri.h  **********************************//
	public static final	boolean RI_FALSE = false;
	public static final	boolean RI_TRUE	= true;
	public static final	float RI_INFINITY = FLT_MAX;
	public static final	float RI_EPSILON = FLT_EPSILON;
	public static final	String RI_NULL = null;

	public static final	float RI_FLOATMIN = FLT_MIN;
	public static final	float RI_FLOATMAX = FLT_MAX;

	public static final	float RI_PI = 3.14159265359f;
	public static final	float RI_PIO2 =	RI_PI/2;

	public static final String RI_SHADER_EXTENSION = ".slx";
	
	//Collections.shufflep̃_̃V[h
	public static final Random rand = new Random(53);
	
//	************************  validate.h  **********************************//
//	! Range check funtion using CqRangeCheckCallback
	/**
	 *	Do the range check
	 *
	 *	Calls a CqRangeCheckCallback functor class, which is responsible for the output.
	 *  @return A boolean indicating whether the variable val is inside the range [min,max]
	 *
	 *@``FbN֐B
	 */
	public static boolean  CheckMinMax( final float val, final float min, final float max, CqRangeCheckCallback callBack)
	{
		if( val < min )
		{
			callBack.valueAt( CqRangeCheckCallback.LOWER_BOUND_HIT );
			return false;
		}
		
		if( val > max )
		{
			callBack.valueAt( CqRangeCheckCallback.UPPER_BOUND_HIT );
			return false;
		}
		callBack.valueAt( CqRangeCheckCallback.VALID );
		return true;
	}
	
//	************************  texture.cpp **********************************//
	
	/**
	 * s\ł邩ǂtO
	 */
	public static boolean  m_critical = false;
	//texturemap.cppɒ`Ăϐ
	public static final int MEG1 = 8192 * 1024;
//	************************  version.h  **********************************//
	public static final String	STRNAME		= "Aqsis";
	
	public static final int		VERMAJOR	= 1;
	public static final int		VERMINOR	= 0;
	public static final int		BUILD		= 0;
	public static final String	VERSION_STR	= "2.0.2";
	
//	************************  ishader.h  **********************************//
	
	public static boolean USES(int a,int b)
	{
		return (( (a)&(0x00000001<<(b)) ) != 0);
	}
	
	public static boolean isDONE(int a,int b)
	{
		return (( (a)&(0x00000001<<(b)) ) != 0);
	}
//	public static boolean DONE(int a,int b)ڒu悢
//	{
//		((a)=(a)|(0x00000001<<(b)));
//	}

	
//  ************************  aqsis_types.h  **********************************//

	public static float LERP(float t,float x0,float x1)  
	{
		return ((x0) + (t)*((x1)-(x0)));
	}
	
//	**********************  color.cpp̃O[o֐ ***************************//
//	/ Global white color
	public static final CqColor	gColWhite = new CqColor( 1, 1, 1 );
//	/ Global black color
	public static final CqColor	gColBlack = new CqColor( 0, 0, 0 );
//	/ Global pure red color
	public static final CqColor	gColRed = new CqColor( 1, 0, 0 );
//	public static final / Global pure green color
	public static final CqColor	gColGreen = new CqColor( 0, 1, 0 );
//	/ Global pure blue color
	public static final CqColor	gColBlue = new CqColor( 0, 0, 1 );
	
//**********************  render.cpp̃O[o֐ ***************************//
	public static CqRenderer pCurrRenderer;
	//eXgp
//		public static CqRendererDriver pCurrRenderer;
	
	//	 Forward declaration
	//	-------------------------------- Tiff error handlers
//void TIFF_ErrorHandler(const char*, const char*, va_list);
//void TIFF_WarnHandler(const char*, const char*, va_list);


	public static long ohash = "object".hashCode(); //< == "object"
	public static long shash = "shader".hashCode(); //< == "shader"
	public static long chash = "camera".hashCode(); //< == "camera"
	public static long cuhash = "current".hashCode(); //< == "current"

	public static CqMatrix[] oldkey = { new CqMatrix(), new CqMatrix() };  //< to eliminate Inverse(), Transpose() matrix ops.
	public static CqMatrix[] oldresult = { new CqMatrix(), new CqMatrix() };
	
	
	public static CqRenderer QGetRenderContext()
	{
	    return ( pCurrRenderer );
	}
	
//	eXgp
//	public static CqRendererDriver QGetRenderContext()
//	{
//	    return ( pCurrRenderer );
//	}

	public static void	QSetRenderContext( CqRenderer pRenderer )
	{
	    pCurrRenderer = pRenderer;
	}
	
//	eXgp
//	public static void	QSetRenderContext( CqRendererDriver pRenderer )
//	{
//	    pCurrRenderer = pRenderer;
//	}
	
	public static IqRenderer QGetRenderContextI()
	{
	    return ( pCurrRenderer );
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
//**************************@ ishaderexecenv.h̃O[o֐  *********************//
	
	/** Templatised derivative function. Calculates the derivative of the provided stack entry with respect to u.
	 */
	public static final CqVector3D SO_DuType_CqVector3D( IqShaderData Var, int i, IqShaderExecEnv ps, CqVector3D Def )
	{
		CqVector3D Ret = new CqVector3D();
	    int uRes = ps.uGridRes();
	    int GridX = i % ( uRes + 1 );

	    p_float fdu = new p_float();
	    ps.du() .GetFloat( fdu );

	    if ( fdu.value == 0 ) return ( Def );

	    CqVector3D v1 = new CqVector3D();
	    CqVector3D v2 = new CqVector3D();
	    if ( GridX < uRes )
	    {
	        Var.GetValue( v1, i + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.sub( v2 ) ).div( fdu.value );
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - 1 );
	        Ret = ( v1.sub( v2 ) ).div( fdu.value );
	    }
	    return ( Ret );
	}
	public static final CqColor SO_DuType_CqColor( IqShaderData Var, int i, IqShaderExecEnv ps, CqColor Def )
	{
		CqColor Ret = new CqColor();
	    int uRes = ps.uGridRes();
	    int GridX = i % ( uRes + 1 );

	    p_float fdu = new p_float();
	    ps.du() .GetFloat( fdu );

	    if ( fdu.value == 0 ) return ( Def );

	    CqColor v1 = new CqColor();
	    CqColor v2 = new CqColor();
	    if ( GridX < uRes )
	    {
	        Var.GetValue( v1, i + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.sub( v2 ) ).div( fdu.value );
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - 1 );
	        Ret = ( v1.sub( v2 ) ).div( fdu.value );
	    }
	    return ( Ret );
	}
	public static final float SO_DuType_TqFloat( IqShaderData Var, int i, IqShaderExecEnv ps, float Def )
	{
		float Ret;
	    int uRes = ps.uGridRes();
	    int GridX = i % ( uRes + 1 );

	    p_float fdu = new p_float();
	    ps.du() .GetFloat( fdu );

	    if ( fdu.value == 0 ) return ( Def );

	    p_float v1 = new p_float();
	    p_float v2 = new p_float();
	    if ( GridX < uRes )
	    {
	        Var.GetValue( v1, i + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.value - v2.value ) / fdu.value;
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - 1 );
	        Ret = ( v1.value - v2.value ) / fdu.value;
	    }
	    return ( Ret );
	}
	
	/** Templatised derivative function. Calculates the derivative of the provided stack entry with respect to v.
	 */
	public static final CqVector3D SO_DvType_CqVector3D( IqShaderData Var, int i, IqShaderExecEnv ps, CqVector3D Def )
	{
		CqVector3D Ret = new CqVector3D();
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridY = ( i / ( uRes + 1 ) );

	    p_float fdv = new p_float();
	    ps.dv().GetFloat( fdv );

	    if ( fdv.value == 0 ) return ( Def );

	    CqVector3D v1 = new CqVector3D();
	    CqVector3D v2 = new CqVector3D();
	    if ( GridY < vRes )
	    {
	        Var.GetValue( v1, i + uRes + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.sub( v2 ) ).div( fdv.value );
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - ( uRes + 1 ) );
	        Ret = ( v1.sub( v2 ) ).div( fdv.value );
	    }
	    return ( Ret );
	}
	public static final CqColor SO_DvType_CqColor( IqShaderData Var, int i, IqShaderExecEnv ps, CqColor Def )
	{
		CqColor Ret = new CqColor();
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridY = ( i / ( uRes + 1 ) );

	    p_float fdv = new p_float();
	    ps.dv().GetFloat( fdv );

	    if ( fdv.value == 0 ) return ( Def );

	    CqColor v1 = new CqColor();
	    CqColor v2 = new CqColor();
	    if ( GridY < vRes )
	    {
	        Var.GetValue( v1, i + uRes + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.sub( v2 ) ).div( fdv.value );
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - ( uRes + 1 ) );
	        Ret = ( v1.sub( v2 ) ).div( fdv.value );
	    }
	    return ( Ret );
	}
	public static final float SO_DvType_TqFloat( IqShaderData Var, int i, IqShaderExecEnv ps, float Def )
	{
		float Ret;
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridY = ( i / ( uRes + 1 ) );

	    p_float fdv = new p_float();
	    ps.dv().GetFloat( fdv );

	    if ( fdv.value == 0 ) return ( Def );

	    p_float v1 = new p_float();
	    p_float v2 = new p_float();
	    if ( GridY < vRes )
	    {
	        Var.GetValue( v1, i + uRes + 1 );
	        Var.GetValue( v2, i );
	        Ret = ( v1.value - v2.value ) / fdv.value;
	    }
	    else
	    {
	        Var.GetValue( v1, i );
	        Var.GetValue( v2, i - ( uRes + 1 ) );
	        Ret = ( v1.value - v2.value ) / fdv.value;
	    }
	    return ( Ret );
	}

	/** Templatised derivative function. Calculates the derivative of the provided stack entry with respect to a second stack entry.
	 */
	public static final CqVector3D SO_DerivType_CqVector3D( IqShaderData Var, IqShaderData den, int i, IqShaderExecEnv ps )
	{
	    assert( null != Var );

	    CqVector3D Retu = new CqVector3D();
	    CqVector3D Retv = new CqVector3D();
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridX = i % ( uRes + 1 );
	    int GridY = ( i / ( uRes + 1 ) );

	    CqVector3D val1 = new CqVector3D();
	    CqVector3D val2 = new CqVector3D();
	    p_float u1 = new p_float( 1.0f );
	    p_float u2 = new p_float( 0.0f );
	    p_float v1 = new p_float( 1.0f );
	    p_float v2 = new p_float( 0.0f );

	    // Calculate deriviative in u
	    if ( GridX < uRes )
	    {
	        Var.GetValue( val1, i + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( u1, i + 1 );
	            den.GetValue( u2, i );
			}
			if( ( !val1.equals(val2) ) && ( u1.value != u2.value ) )
				Retu = val1.sub( val2 ).div( u1.value - u2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - 1 );
	        if ( null != den )
			{
	            den.GetValue( u1, i );
	            den.GetValue( u2, i - 1 );
			}
			if( ( !val1.equals(val2) ) && ( u1.value != u2.value ) )
				Retu = val2.sub( val1 ).div( u2.value - u1.value );
	    }

	    // Calculate deriviative in v
	    if ( GridY < vRes )
	    {
	        Var.GetValue( val1, i + uRes + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( v1, i + uRes + 1 );
	            den.GetValue( v2, i );
			}
			if( ( !val1.equals(val2) ) && ( v1.value != v2.value ) )
				Retv = val1.sub( val2 ).div( v1.value - v2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - ( uRes - 1 ) );
	        if ( null != den )
			{
	            den.GetValue( v1, i );
	            den.GetValue( v2, i - ( uRes - 1 ) );
			}
			if( ( !val1.equals(val2) ) && ( v1.value != v2.value ) )
				Retv = val2.sub( val1 ).div( v2.value - v1.value );
	    }

	    return Retu.add( Retv );
	}
	public static final CqColor SO_DerivType_CqColor( IqShaderData Var, IqShaderData den, int i, IqShaderExecEnv ps )
	{
	    assert( null != Var );

	    CqColor Retu = new CqColor();
	    CqColor Retv = new CqColor();
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridX = i % ( uRes + 1 );
	    int GridY = ( i / ( uRes + 1 ) );

	    CqColor val1 = new CqColor();
	    CqColor val2 = new CqColor();
	    p_float u1 = new p_float( 1.0f );
	    p_float u2 = new p_float( 0.0f );
	    p_float v1 = new p_float( 1.0f );
	    p_float v2 = new p_float( 0.0f );

	    // Calculate deriviative in u
	    if ( GridX < uRes )
	    {
	        Var.GetValue( val1, i + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( u1, i + 1 );
	            den.GetValue( u2, i );
			}
			if( ( !val1.equals(val2) ) && ( u1.value != u2.value ) )
				Retu = val1.sub( val2 ).div( u1.value - u2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - 1 );
	        if ( null != den )
			{
	            den.GetValue( u1, i );
	            den.GetValue( u2, i - 1 );
			}
			if( ( !val1.equals(val2) ) && ( u1.value != u2.value ) )
				Retu = val2.sub( val1 ).div( u2.value - u1.value );
	    }

	    // Calculate deriviative in v
	    if ( GridY < vRes )
	    {
	        Var.GetValue( val1, i + uRes + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( v1, i + uRes + 1 );
	            den.GetValue( v2, i );
			}
			if( ( !val1.equals(val2) ) && ( v1.value != v2.value ) )
				Retv = val1.sub( val2 ).div( v1.value - v2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - ( uRes - 1 ) );
	        if ( null != den )
			{
	            den.GetValue( v1, i );
	            den.GetValue( v2, i - ( uRes - 1 ) );
			}
			if( ( !val1.equals(val2) ) && ( v1.value != v2.value ) )
				Retv = val2.sub( val1 ).div( v2.value - v1.value );
	    }

	    return Retu.add( Retv );
	}
	public static final float SO_DerivType_TqFloat( IqShaderData Var, IqShaderData den, int i, IqShaderExecEnv ps )
	{
	    assert( null != Var );

	    float Retu = 0.0f;
	    float Retv = 0.0f;
	    int uRes = ps.uGridRes();
	    int vRes = ps.vGridRes();
	    int GridX = i % ( uRes + 1 );
	    int GridY = ( i / ( uRes + 1 ) );

	    p_float val1 = new p_float();
	    p_float val2 = new p_float();
	    p_float u1 = new p_float( 1.0f );
	    p_float u2 = new p_float( 0.0f );
	    p_float v1 = new p_float( 1.0f );
	    p_float v2 = new p_float( 0.0f );

	    // Calculate deriviative in u
	    if ( GridX < uRes )
	    {
	        Var.GetValue( val1, i + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( u1, i + 1 );
	            den.GetValue( u2, i );
			}
			if( ( val1.value != val2.value ) && ( u1.value != u2.value ) )
				Retu = ( val1.value - val2.value ) / ( u1.value - u2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - 1 );
	        if ( null != den )
			{
	            den.GetValue( u1, i );
	            den.GetValue( u2, i - 1 );
			}
			if( ( val1.value != val2.value ) && ( u1.value != u2.value ) )
				Retu = ( val2.value - val1.value ) / ( u2.value - u1.value );
	    }

	    // Calculate deriviative in v
	    if ( GridY < vRes )
	    {
	        Var.GetValue( val1, i + uRes + 1 );
	        Var.GetValue( val2, i );
	        if ( null != den )
			{
	            den.GetValue( v1, i + uRes + 1 );
	            den.GetValue( v2, i );
			}
			if( ( val1.value != val2.value ) && ( v1.value != v2.value ) )
				Retv = ( val1.value - val2.value ) / ( v1.value - v2.value );
	    }
	    else
	    {
	        Var.GetValue( val1, i );
	        Var.GetValue( val2, i - ( uRes - 1 ) );
	        if ( null != den )
			{
	            den.GetValue( v1, i );
	            den.GetValue( v2, i - ( uRes - 1 ) );
			}
			if( ( val1.value != val2.value ) && ( v1.value != v2.value ) )
				Retv = ( val2.value - val1.value ) / ( v2.value - v1.value );
	    }

	    return ( Retu + Retv );
	}
	
	
	

//*************************  raytrace.cpp̃O[o֐   **********************//
/// Required function that implements Class Factory design pattern for Raytrace libraries

	public static IqRaytrace CreateRaytracer()
	{
		IqRaytrace cqraytrace = new CqRaytrace();
	    return cqraytrace;
	}

//**************************@ DDManeger.cpp̃O[o֐  *********************//
/// Required function that implements Class Factory design pattern for DDManager libraries

	public static IqDDManager CreateDisplayDriverManager()
	{
//		IqDDManager iqddmanager = new CqDDManager(); //2005/11/17 nttdata ύX Display
		IqDDManager iqddmanager = new DisplayManager();
	    return iqddmanager;
	}

//**************************@ lights.cpp̃O[o֐  ************************//
	public static LinkedList<CqLightsource> Lightsource_stack = new LinkedList<CqLightsource>();
	
//**************************@ attributes.cpp̃O[oϐ ǉ  ************************//
	public static LinkedList<CqAttributes> Attribute_Stack = new LinkedList<CqAttributes>();
	
//	**************************@ bilinear.h̃O[o֐ ǉ  ************************//
	/** 
	 * Bilinearly evalute the four specified values at the specified intervals.
	 * attention The type to be interpolated must support operator+, operator- and operator*.
	 * +,-,*Zq`ĂKv
	 * 
	 * @param A min u min v.
	 * @param B max u min v.
	 * @param C min u max v.
	 * @param D max u max v.
	 * @param s the fraction in the u direction.
	 * @param t the fraction in the v direction.
	 * @return the interpolated value.
	 */
//	@SuppressWarnings("unchecked")
//	public static<T> 	T BilinearEvaluate( final T A, final T B, final T C, final T D, float s, float t,Class TClass )
//	{
//		T AB;
//		T CD;
//		T R;
//		try {
//			AB = (T)(TClass.newInstance());
//			CD = (T)(TClass.newInstance());
//			R = (T)(TClass.newInstance());
//		} catch (InstantiationException e) {
//			HimawariLogger.outputException( e );
//			return null;
//		} catch (IllegalAccessException e) {
//			HimawariLogger.outputException( e );
//			return null;
//		}
//		
//		//--ǉ ꍇ킯s 2005/09/13
//		//p_float̏ꍇ
//		if(A instanceof p_float){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((p_float)AB).value = ((p_float)A).value;
//				((p_float)CD).value = ((p_float)C).value;
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((p_float)AB).value = ((p_float)B).value;
//					((p_float)CD).value = ((p_float)D).value;
//				}
//				else
//				{
//					((p_float)AB).value = ( ( ((p_float)B).value - ((p_float)A).value ) * s + ((p_float)A).value );
//					((p_float)CD).value = ( ( ((p_float)D).value - ((p_float)C).value ) * s + ((p_float)C).value );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				((p_float)R).value = ((p_float)AB).value;
//			else
//			{
//				if ( t >= 1.0 )
//					((p_float)R).value = ((p_float)CD).value;
//				else
//					((p_float)R).value = ( ( ((p_float)CD).value - ((p_float)AB).value ) * t + ((p_float)AB).value );
//			}
//		}else if(A instanceof CqColor){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((CqColor)AB).assignment((CqColor)A);
//				((CqColor)CD).assignment((CqColor)C);
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((CqColor)AB).assignment((CqColor) B);
//					((CqColor)CD).assignment((CqColor) D);
//				}
//				else
//				{
//					((CqColor)AB).assignment( ( (((CqColor)B).sub((CqColor)A)).mul(s)).add((CqColor)A) );
//					((CqColor)CD).assignment( ( (((CqColor)D).sub((CqColor)C)).mul(s)).add((CqColor)C) );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				R = AB;
//			else
//			{
//				if ( t >= 1.0 )
//					((CqColor)R).assignment((CqColor)CD);
//				else
//					((CqColor)R).assignment( ( (((CqColor)CD).sub((CqColor)AB)).mul(t)).add((CqColor)AB) );
//			}
//			
//		}else if(A instanceof CqVector3D){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((CqVector3D)AB).assignment((CqVector3D)A);
//				((CqVector3D)CD).assignment((CqVector3D)C);
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((CqVector3D)AB).assignment((CqVector3D) B);
//					((CqVector3D)CD).assignment((CqVector3D) D);
//				}
//				else
//				{
//					((CqVector3D)AB).assignment( ( (((CqVector3D)B).sub((CqVector3D)A)).mul(s)).add((CqVector3D)A) );
//					((CqVector3D)CD).assignment( ( (((CqVector3D)D).sub((CqVector3D)C)).mul(s)).add((CqVector3D)C) );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				R = AB;
//			else
//			{
//				if ( t >= 1.0 )
//					((CqVector3D)R).assignment((CqVector3D)CD);
//				else
//					((CqVector3D)R).assignment( ( (((CqVector3D)CD).sub((CqVector3D)AB)).mul(t)).add((CqVector3D)AB) );
//			}
//			
//		}else if(A instanceof CqMatrix){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((CqMatrix)AB).assignment((CqMatrix)A);
//				((CqMatrix)CD).assignment((CqMatrix)C);
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((CqMatrix)AB).assignment((CqMatrix) B);
//					((CqMatrix)CD).assignment((CqMatrix) D);
//				}
//				else
//				{
//					((CqMatrix)AB).assignment( ( (((CqMatrix)B).sub((CqMatrix)A)).multiply(s)).add((CqMatrix)A) );
//					((CqMatrix)CD).assignment( ( (((CqMatrix)D).sub((CqMatrix)C)).multiply(s)).add((CqMatrix)C) );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				R = AB;
//			else
//			{
//				if ( t >= 1.0 )
//					((CqMatrix)R).assignment((CqMatrix)CD);
//				else
//					((CqMatrix)R).assignment( ( (((CqMatrix)CD).sub((CqMatrix)AB)).multiply(t)).add((CqMatrix)AB) );
//			}
//			
//		}else if(A instanceof CqVector4D){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((CqVector4D)AB).assignment((CqVector4D)A);
//				((CqVector4D)CD).assignment((CqVector4D)C);
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((CqVector4D)AB).assignment((CqVector4D) B);
//					((CqVector4D)CD).assignment((CqVector4D) D);
//				}
//				else
//				{
//					((CqVector4D)AB).assignment( ( (((CqVector4D)B).sub((CqVector4D)A)).mul(s)).add((CqVector4D)A) );
//					((CqVector4D)CD).assignment( ( (((CqVector4D)D).sub((CqVector4D)C)).mul(s)).add((CqVector4D)C) );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				R = AB;
//			else
//			{
//				if ( t >= 1.0 )
//					((CqVector4D)R).assignment((CqVector4D)CD);
//				else
//					((CqVector4D)R).assignment( ( (((CqVector4D)CD).sub((CqVector4D)AB)).mul(t)).add((CqVector4D)AB) );
//			}
//			
//		}else if(A instanceof p_int){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((p_int)AB).value = ((p_int)A).value;
//				((p_int)CD).value = ((p_int)C).value;
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((p_int)AB).value = ((p_int)B).value;
//					((p_int)CD).value = ((p_int)D).value;
//				}
//				else
//				{
//					((p_int)AB).value = (int)( ( ((p_int)B).value - ((p_int)A).value ) * s + ((p_int)A).value );
//					((p_int)CD).value = (int)( ( ((p_int)D).value - ((p_int)C).value ) * s + ((p_int)C).value );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				((p_int)R).value = ((p_int)AB).value;
//			else
//			{
//				if ( t >= 1.0 )
//					((p_int)R).value = ((p_int)CD).value;
//				else
//					((p_int)R).value = (int)( ( ((p_int)CD).value - ((p_int)AB).value ) * t + ((p_int)AB).value );
//			}
//		}else if(A instanceof CqVector2D){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((CqVector2D)AB).assignment((CqVector2D)A);
//				((CqVector2D)CD).assignment((CqVector2D)C);
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((CqVector2D)AB).assignment((CqVector2D) B);
//					((CqVector2D)CD).assignment((CqVector2D) D);
//				}
//				else
//				{
//					((CqVector2D)AB).assignment( ( (((CqVector2D)B).sub((CqVector2D)A)).mul(s)).add((CqVector2D)A) );
//					((CqVector2D)CD).assignment( ( (((CqVector2D)D).sub((CqVector2D)C)).mul(s)).add((CqVector2D)C) );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				R = AB;
//			else
//			{
//				if ( t >= 1.0 )
//					((CqVector2D)R).assignment((CqVector2D)CD);
//				else
//					((CqVector2D)R).assignment( ( (((CqVector2D)CD).sub((CqVector2D)AB)).mul(t)).add((CqVector2D)AB) );
//			}
//			
//		}else if(A instanceof p_String){
//			// Work out where the u points are first, then linear interpolate the v value.
//			if ( s <= 0.0 )
//			{
//				((p_String)AB).value = ((p_String)A).value;
//				((p_String)CD).value = ((p_String)C).value;
//			}
//			else
//			{
//				if ( s >= 1.0 )
//				{
//					((p_String)AB).value = ((p_String)B).value;
//					((p_String)CD).value = ((p_String)D).value;
//				}
//				else
//				{
//					((p_String)AB).value = ( ( ((p_String)B).value) + ((p_String)A).value );
//					((p_String)CD).value = ( ( ((p_String)D).value) + ((p_String)C).value );
//				}
//			}
//			
//			if ( t <= 0.0 )
//				((p_String)R).value = ((p_String)AB).value;
//			else
//			{
//				if ( t >= 1.0 )
//					((p_String)R).value = ((p_String)CD).value;
//				else
//					((p_String)R).value = ( ( ((p_String)CD).value) + ((p_String)AB).value );
//			}
//		}
//		return ( R );
//	}
	
	public static<T> 	T BilinearEvaluate( final T A, final T B, final T C, final T D, float s, float t,Class TClass )
	{
		
		//--ǉ ꍇ킯s 2005/09/13
		//p_float̏ꍇ
		if(A instanceof p_float){
			
			p_float AB = new p_float();
			p_float CD = new p_float();
			p_float R = new p_float();
			
			// Work out where the u points are first, then linear interpolate the v value.
			if ( s <= 0.0 )
			{
				AB.value = ((p_float)A).value;
				CD.value = ((p_float)C).value;
			}
			else
			{
				if ( s >= 1.0 )
				{
					((p_float)AB).value = ((p_float)B).value;
					((p_float)CD).value = ((p_float)D).value;
				}
				else
				{
					((p_float)AB).value = ( ( ((p_float)B).value - ((p_float)A).value ) * s + ((p_float)A).value );
					((p_float)CD).value = ( ( ((p_float)D).value - ((p_float)C).value ) * s + ((p_float)C).value );
				}
			}
			
			if ( t <= 0.0 )
				((p_float)R).value = ((p_float)AB).value;
			else
			{
				if ( t >= 1.0 )
					((p_float)R).value = ((p_float)CD).value;
				else
					((p_float)R).value = ( ( ((p_float)CD).value - ((p_float)AB).value ) * t + ((p_float)AB).value );
			}
			
			return (T)R;
			
		}else if(A instanceof CqVector4D){
			// Work out where the u points are first, then linear interpolate the v value.
			CqVector4D AB;// = new CqVector4D();
			CqVector4D CD;// = new CqVector4D();
			CqVector4D R = new CqVector4D();
			
			if ( s <= 0.0 )
			{
				AB = ((CqVector4D)A);
				CD = ((CqVector4D)C);
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB = ((CqVector4D) B);
					CD = ((CqVector4D) D);
				}
				else
				{
					AB = ( ( (((CqVector4D)B).sub((CqVector4D)A)).mul(s)).add((CqVector4D)A) );
					CD = ( ( (((CqVector4D)D).sub((CqVector4D)C)).mul(s)).add((CqVector4D)C) );
				}
			}
			
			if ( t <= 0.0 )
				//R = AB;
				R.assignment(AB);
			else
			{
				if ( t >= 1.0 )
					R.assignment(CD);
				else
					R.assignment( CD.sub(AB).mul(t).add(AB) );
			}
			return (T)R;
			
		}else if(A instanceof CqVector3D){
			// Work out where the u points are first, then linear interpolate the v value.
			
			CqVector3D AB;// = new CqVector3D();
			CqVector3D CD;// = new CqVector3D();
			CqVector3D R = new CqVector3D();
			
			if ( s <= 0.0 )
			{
				AB = ((CqVector3D)A);
				CD = ((CqVector3D)C);
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB = ((CqVector3D) B);
					CD = ((CqVector3D) D);
				}
				else
				{
					AB = ( ( (((CqVector3D)B).sub((CqVector3D)A)).mul(s)).add((CqVector3D)A) );
					CD = ( ( (((CqVector3D)D).sub((CqVector3D)C)).mul(s)).add((CqVector3D)C) );
				}
			}
			
			if ( t <= 0.0 )
				R.assignment(AB);
			else
			{
				if ( t >= 1.0 )
					R.assignment(CD);
				else
					R.assignment( CD.sub(AB).mul(t).add(AB) );
			}
			return (T)R;
			
		}else if(A instanceof CqColor){
			// Work out where the u points are first, then linear interpolate the v value.
			CqColor AB;// = new CqColor();
			CqColor CD;// = new CqColor();
			CqColor R = new CqColor();
			
			if ( s <= 0.0 )
			{
				AB = (CqColor)A;
				CD = (CqColor)C;
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB = (CqColor) B;
					CD = (CqColor) D;
				}
				else
				{
					AB = ( (((CqColor)B).sub((CqColor)A)).mul(s)).add((CqColor)A);
					CD = ( (((CqColor)D).sub((CqColor)C)).mul(s)).add((CqColor)C);
				}
			}
			
			if ( t <= 0.0 )
				R.assignment(AB);
			else
			{
				if ( t >= 1.0 )
					R.assignment(CD);
				else
					R.assignment( CD.sub(AB).mul(t).add(AB) );
			}
			
			return (T)R;
			
		}else if(A instanceof CqMatrix){
			// Work out where the u points are first, then linear interpolate the v value.
			CqMatrix AB;// = new CqMatrix();
			CqMatrix CD;// = new CqMatrix();
			CqMatrix R = new CqMatrix();
			
			if ( s <= 0.0 )
			{
				AB = (CqMatrix)A;
				CD = (CqMatrix)C;
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB = (CqMatrix) B;
					CD = (CqMatrix) D;
				}
				else
				{
					AB = ( (((CqMatrix)B).sub((CqMatrix)A)).multiply(s)).add((CqMatrix)A) ;
					CD = ( (((CqMatrix)D).sub((CqMatrix)C)).multiply(s)).add((CqMatrix)C) ;
				}
			}
			
			if ( t <= 0.0 )
				R.assignment(AB);
			else
			{
				if ( t >= 1.0 )
					R.assignment(CD);
				else
					R.assignment( (CD).sub(AB).multiply(t).add(AB) );
			}
			return (T)R;
			
		}else if(A instanceof p_int){
			// Work out where the u points are first, then linear interpolate the v value.
			p_int AB = new p_int();
			p_int CD = new p_int();
			p_int R = new p_int();
			
			if ( s <= 0.0 )
			{
				AB.value = ((p_int)A).value;
				CD.value = ((p_int)C).value;
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB.value = ((p_int)B).value;
					CD.value = ((p_int)D).value;
				}
				else
				{
					AB.value = (int)( ( ((p_int)B).value - ((p_int)A).value ) * s + ((p_int)A).value );
					CD.value = (int)( ( ((p_int)D).value - ((p_int)C).value ) * s + ((p_int)C).value );
				}
			}
			
			if ( t <= 0.0 )
				((p_int)R).value = ((p_int)AB).value;
			else
			{
				if ( t >= 1.0 )
					R.value = ((p_int)CD).value;
				else
					R.value = (int)( ( ((p_int)CD).value - ((p_int)AB).value ) * t + ((p_int)AB).value );
			}
			return (T)R;
			
		}else if(A instanceof CqVector2D){
			// Work out where the u points are first, then linear interpolate the v value.
			CqVector2D AB ;//= new CqVector2D();
			CqVector2D CD ;//= new CqVector2D();
			CqVector2D R = new CqVector2D();
			
			if ( s <= 0.0 )
			{
				AB = (CqVector2D)A;
				CD = (CqVector2D)C;
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB = (CqVector2D) B;
					CD = (CqVector2D) D;
				}
				else
				{
					AB = ( (((CqVector2D)B).sub((CqVector2D)A)).mul(s)).add((CqVector2D)A);
					CD = ( (((CqVector2D)D).sub((CqVector2D)C)).mul(s)).add((CqVector2D)C);
				}
			}
			
			if ( t <= 0.0 )
				R.assignment(AB);
			else
			{
				if ( t >= 1.0 )
					R.assignment(CD);
				else
					R.assignment( (CD).sub(AB).mul(t).add(AB) );
			}
			return (T)R;
			
		}else if(A instanceof p_String){
			// Work out where the u points are first, then linear interpolate the v value.
			p_String AB = new p_String();
			p_String CD = new p_String();
			p_String R = new p_String();
			
			if ( s <= 0.0 )
			{
				AB.value = ((p_String)A).value;
				CD.value = ((p_String)C).value;
			}
			else
			{
				if ( s >= 1.0 )
				{
					AB.value = ((p_String)B).value;
					CD.value = ((p_String)D).value;
				}
				else
				{
					AB.value = ( ( ((p_String)B).value) + ((p_String)A).value );
					CD.value = ( ( ((p_String)D).value) + ((p_String)C).value );
				}
			}
			
			if ( t <= 0.0 )
				R.value = ((p_String)AB).value;
			else
			{
				if ( t >= 1.0 )
					R.value = ((p_String)CD).value;
				else
					R.value = ( ( ((p_String)CD).value) + ((p_String)AB).value );
			}
			return (T)R;
		}
		return null;
	}
	
//	**************************@ parameter.cpp̃O[o֐  ************************//
	
	public static Method[] gVariableCreateFuncsConstant =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedConstant.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };


	public static Method[] gVariableCreateFuncsUniform = {
		null,
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		null,
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		null,
		AccessSupplier.getMethod( CqParameterTypedUniform.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
		null,
		null,
	};


	public static Method[] gVariableCreateFuncsVarying =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVarying.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };

	public static Method[] gVariableCreateFuncsVertex =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVertex.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };


	public static Method[] gVariableCreateFuncsFaceVarying =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVarying.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };


	public static Method[] gVariableCreateFuncsConstantArray =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedConstantArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };


	public static Method[] gVariableCreateFuncsUniformArray =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedUniformArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };

	public static Method[] gVariableCreateFuncsVaryingArray =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVaryingArray.class, "Create", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };

	public static Method[] gVariableCreateFuncsVertexArray =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedVertexArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };

	public static Method[] gVariableCreateFuncsFaceVaryingArray =
    {
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        AccessSupplier.getMethod( CqParameterTypedFaceVaryingArray.class, "Create2", String.class, int.class, EqVariableType.class, Class.class, Class.class ),
        null,
        null,
    };
}

