/// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * Interface definition for access to lightsources.
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface IqLightsource {
	
	public void destruct();
	
	/** 
	 * Get a pointer to the associated lightsource shader.
	 * 
	 * @return a pointer to a IqShader derived class.
	 */
	public IqShader		pShader();
	
	/** 
	 * Initialise the shader execution environment.
	 * @param uGridRes Integer grid size, not used.
	 * @param vGridRes Integer grid size, not used.
	 */
	public void	Initialise( int uGridRes, int vGridRes );
	
	//			void		GenerateShadowMap(const char* strShadowName);
	
	/** 
	 * Evaluate the shader.
	 * @param pPs the point being lit.
	 */
	public void	Evaluate( IqShaderData pPs, IqShaderData pNs, IqSurface pSurface );
	
	/** 
	 * Get a pointer to the attributes associated with this lightsource.
	 * @return a CqAttributes pointer.
	 */
	public IqAttributes	pAttributes();
	
	// Redirect acces via IqShaderExecEnv
	public int	uGridRes();
	public int	vGridRes();
	public int	GridSize();
	public CqMatrix		matObjectToWorld();
	public IqShaderData Cs();
	public IqShaderData Os();
	public IqShaderData Ng();
	public IqShaderData du();
	public IqShaderData dv();
	public IqShaderData L();
	public IqShaderData Cl();
	public IqShaderData Ol();
	public IqShaderData P();
	public IqShaderData dPdu();
	public IqShaderData dPdv();
	public IqShaderData N();
	public IqShaderData u();
	public IqShaderData v();
	public IqShaderData s();
	public IqShaderData t();
	public IqShaderData I();
	public IqShaderData Ci();
	public IqShaderData Oi();
	public IqShaderData Ps();
	public IqShaderData E();
	public IqShaderData ncomps();
	public IqShaderData time();
	public IqShaderData alpha();
	
	public IqShaderData Ns();
}
