// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.library.types.CqColor;

/**
 * 
 * oPbgC^[tF[X
 * 
 * @author NTT DATA Corporation
 */
public strictfp interface IqBucket {

    /**
     * Get the bucket size in X <br>
     * oPbg̉擾
     * @return	oPbg̉
     */
    public int	Width();
    
    /** 
     * Get the bucket size in Y <br>
     * oPbg̏c擾
     * @return	oPbg̏c
     */
    public int	Height();
    
    /**
     * Get the bucket size in X including filtering extra
     * @return
     */
    public int	RealWidth();
    
    /** 
     * Get the bucket size in Y including filtering extra
     * @return
     */
    public int	RealHeight();
    
    /** 
     * Get the position of this bucket in X <br>
     * ݂̃oPbg̉ʒu擾
     * @return	݂̃oPbg̉ʒu
     */
    public int	XOrigin();
    
    /** 
     * Get the position of this bucket in Y <br>
     * ݂̃oPbg̏cʒu擾
     * @return	݂̃oPbg̏cʒu
     */
    public int	YOrigin();

    /** 
     * Get an element color from this bucket. If the requested address is not within this bucket, returns black.
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return 
     */
    public CqColor Color( int iXPos, int iYPos );
    
    /** 
     * Get an element opacity from this bucket. If the requested address is not within this bucket, returns transparent.
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return
     */
    public CqColor Opacity( int iXPos, int iYPos );
    
    /** 
     * Get an element coverage from this bucket. If the requested address is not within this bucket, returns 0.
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return
     */
    public float Coverage( int iXPos, int iYPos );
    
    /** 
     * Get an element depth from this bucket. If the requested address is not within this bucket, returns FLT_MAX.
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return
     */
    public float Depth( int iXPos, int iYPos );
    
    /** 
     * Get a count of samples
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return
     */
    public int DataSize( int iXPos, int iYPos );
    
    /** 
     * Get a pointer to the sample array
     * @param iXPos Screen position of the requested element.
     * @param iYPos Screen position of the requested element.
     * @return
     */
    public Valarray Data( int iXPos, int iYPos );
	
}
