// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqVector2D;

/**
 * 
 * g~O[vzƂĂ܂Ƃ߂ĈNXB<br>
 * ̈ CqTrimLoopŃ[vƂȂB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqTrimLoopArray {
	
	/** defurlt constructer */
	public CqTrimLoopArray(){}
	
	/** destructer */
	public void destract(){}
	
	/**
	 * v~eBu؂g~O[ṽxN^ԂB
	 * 
	 * @return	m_aLoops	g~O[v
	 */
	public STLVector<CqTrimLoop> aLoops()
	{
		return ( m_aLoops );
	}
	
	
	/**
	 * g~OOՂ̓_肷B
	 * 
	 * @param pSurface	g~O
	 */
	public void	Prepare( CqSurface pSurface )
	{
		for ( CqTrimLoop iLoop : m_aLoops )
			iLoop.Prepare( pSurface );
	}
	
	
	/**
	 * eXg|Cgɂ邩Oɂ邩𔻒肷B
	 * 
	 * @param @v	ʒu𒲂ׂ_̍W
	 * @return	true() / false(O)
	 */
	public	boolean	TrimPoint( final CqVector2D v )
	{
		// Early out if no trim loops at all.
		if ( m_aLoops.size() == 0 )
			return ( false );
		
		// eXg|Cgꍇ̃JE^
		int	cCrosses = 0; 
		for ( CqTrimLoop iLoop : m_aLoops )
			cCrosses += iLoop.TrimPoint( v )? 1 : 0;
		
		//@Ȃtrue, Ȃfalse
		return ( ( cCrosses & 1 ) == 0 );
	}
	
	
	/**
	 * g~O}`ƌ_ǂ̔sB
	 * 
	 * @param 	v1	\_W
	 * @param 	v2	\_W
	 * @return	true(_L) / false(_Ȃ)
	 */
	public	boolean	LineIntersects(final CqVector2D v1, final CqVector2D v2)
	{
		// Early out if no trim loops at all.
		if ( m_aLoops.size() == 0 )
			return ( false );
		
		for ( CqTrimLoop iLoop : m_aLoops ){
			if(iLoop.LineIntersects( v1, v2 ))
				return(true);
		}
		return ( false );
	}
	
	
	/** g~O[vNAB */
	void	Clear()
	{
		m_aLoops.clear();
	}
	
	private   STLVector<CqTrimLoop>	m_aLoops = new STLVector<CqTrimLoop>( CqTrimLoop.class );
	
	
}
