// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

/**
 * C^[oƂ̃_OvZX̃^C~OvNX<br>
 * Start()AStop()\bhp邱ƂŎԂ𑪒肷B<br>
 * assignAdd\bhŃ^C}[m̎Ԃ킹邱ƂłB
 * 
 * @author NTT DATA Corporation
 */

public strictfp class CqStatTimer {
	private long	m_timeStart;		///< Time at which the current interval started.
	private long	m_timeTotal;		///< ̃^C}[ő肵
	private int	m_cStarted;				///<timerX^[g++,Stop--JE^
	
	/**
	 * RXgN^
	 * SĂ̑0ɏ
	 */
	public CqStatTimer(){
		m_timeStart = 0;
		m_timeTotal = 0;
		m_cStarted =0;
	}
	
	
	/** 
	 * m_timeTotalgetter
	 */
	long	TimeTotal()
	{
		return ( m_timeTotal );
	}
	
	/** 
	 * Start the timer, asserts that the timer has not already been started, nesting is not allowed.
	 * ^C}[X^[gĂȂꍇ
	 * ^C}[X^[gB
	 * lXg͋Ȃ(`FbN̋@\͎ĂȂ)
	 * 
	 */
	void	Start()
	{
		if ( m_cStarted == 0 )
			m_timeStart = System.currentTimeMillis();//ύX 2005/08/02 clock();
		m_cStarted++;
	}
	
	/** Stop the timer and update the total time for this timer. Asserts that the timer was actually running.
	 * Ƀ^C}[ĂꍇA
	 * ^C}[~߁Atotal timeXVB
	 * 
	 */
	void	Stop()
	{
		assert( m_cStarted > 0 );
		m_cStarted--;
		if ( m_cStarted == 0 )
			m_timeTotal += System.currentTimeMillis() - m_timeStart;//ύX 2005/08/02 clock()
	}
	
	/** Reset the total time for this timer, asserts that the timer is not running.
	 * ^C}[ĂȂꍇAtotal timeZbgB
	 * (A`FbN̋@\͎ĂȂ)
	 */
	void	Reset()
	{
		m_timeTotal = 0;
		m_cStarted = 0;
	}
	
	/** Check if this timer is started.
	 * ^C}[Ă邩ǂԂ
	 * @return timerX^[gĂtrue
	 * 
	 */
	boolean isStarted()
	{
		return( m_cStarted > 0 );
	}
	
	/** 
	 * Q̎v̏𓝍B
	 * Ŏw肳ꂽv̑ԂZB
	 * @param from 鎞v
	 * @return gԂ
	 */
	CqStatTimer assignAdd(final CqStatTimer from )
	{
		m_timeTotal += from.m_timeTotal;
		return(this);
	}
	
	
	/**
	 * m_cStartedgetter
	 * @return Returns the m_cStarted.
	 */
	public int getM_cStarted() {
		return m_cStarted;
	}
	
	
	/**
	 * m_timeStartgetter
	 * @return Returns the m_timeStart.
	 */
	public long getM_timeStart() {
		return m_timeStart;
	}
}
