// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqEnvVars.*;
import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * VF[_̎
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqShader implements IqShader {

	protected int m_Uses;			///< Bit vector representing the system variables used by this shader.
	private CqMatrix m_matCurrent = new CqMatrix();	///< Transformation matrix to world coordinates in effect at the time this shader was instantiated.
	private String m_strName = "";		///< The name of this shader.
	
	/**
	 * ftHgRXgN^
	 */
	public CqShader() {
		m_Uses = 0xFFFFFFFF;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#destruct()
	 */
	public void destruct()
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#matCurrent()
	 */
	public CqMatrix matCurrent()
	{
		return ( m_matCurrent );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#SetstrName(java.lang.String)
	 */
	public void SetstrName(String strName)
	{
	     m_strName = strName;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#strName()
	 */
	public String strName() 
	{
		 return ( m_strName );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#SetArgument(java.lang.String, net.cellcomputing.himawari.library.EqVariableType, java.lang.String, java.lang.Object)
	 */
	public void SetArgument(String name, EqVariableType type, String space, Object val)
	{
		
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#SetArgument(net.cellcomputing.himawari.library.CqParameter, net.cellcomputing.himawari.library.IqSurface)
	 */
	public void SetArgument(CqParameter pParam, IqSurface pSurface) 
	{
		
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#FindArgument(java.lang.String)
	 */
	public IqShaderData FindArgument(String name) {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#GetValue(java.lang.String, net.cellcomputing.himawari.library.IqShaderData)
	 */
	public boolean GetValue(String name, IqShaderData res)
	{
		  return ( false );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#Evaluate(net.cellcomputing.himawari.library.IqShaderExecEnv)
	 */
	public void Evaluate(IqShaderExecEnv pEnv)
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#PrepareDefArgs()
	 */
	public void PrepareDefArgs()
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#Initialise(int, int, net.cellcomputing.himawari.library.IqShaderExecEnv)
	 */
	public void Initialise(int uGridRes, int vGridRes, IqShaderExecEnv pEnv)
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#fAmbient()
	 */
	public boolean fAmbient()
	{
		return false;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#Clone()
	 */
	public IqShader Clone()
	{
		return ( new CqShader() );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#Uses(int)
	 */
	public boolean Uses(int Var)
	{
		 assert( Var >= 0 && Var < EnvVars_Last );
//		 return ( Uses( static_cast<EqEnvVars>( Var ) ) );
		 return ( Uses(Var) );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#Uses()
	 */
	public int Uses()
	{
		  return ( m_Uses );
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariable(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String, boolean, boolean)
	 */
	public IqShaderData CreateVariable(EqVariableType Type, EqVariableClass Class, String name, boolean fArgument, boolean fOutput)
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariableArray(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String, int, boolean, boolean)
	 */
	public IqShaderData CreateVariableArray(EqVariableType Type, EqVariableClass Class, String name, int Count, boolean fArgument, boolean fOutput)
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateTemporaryStorage(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass)
	 */
	public IqShaderData CreateTemporaryStorage(EqVariableType type, EqVariableClass _class)
	{
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#DeleteTemporaryStorage(net.cellcomputing.himawari.library.IqShaderData)
	 */
	public void DeleteTemporaryStorage(IqShaderData pData)
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#DefaultSurface()
	 */
	public void DefaultSurface()
	{
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariable(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String, boolean)
	 */
	public IqShaderData CreateVariable(EqVariableType Type, EqVariableClass Class, String name, boolean fArgument) {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariable(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String)
	 */
	public IqShaderData CreateVariable(EqVariableType Type, EqVariableClass Class, String name) {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariableArray(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String, int, boolean)
	 */
	public IqShaderData CreateVariableArray(EqVariableType Type, EqVariableClass Class, String name, int Count, boolean fArgument) {
		return null;
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.IqShader#CreateVariableArray(net.cellcomputing.himawari.library.EqVariableType, net.cellcomputing.himawari.library.EqVariableClass, java.lang.String, int)
	 */
	public IqShaderData CreateVariableArray(EqVariableType Type, EqVariableClass Class, String name, int Count) {
		return null;
	}
	

}
