// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.types.CqMatrix;

/**
 * 
 * |Cg|ST[tF[Xv~eBuB
 * Points array for PointsPolygons surface primitive.
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqPolygonPoints extends CqSurface {
	
	protected int		m_cVertices;		///< Count of vertices in this list.
	protected boolean	m_Transformed;		///< Flag indicatign that the list has been transformed.
	protected int		m_cFaces;			///< Expected count of faces referencing this list.
	protected int		m_sumnVerts;
	
	public CqPolygonPoints( int cVertices, int cFaces, int sumnVerts )
	{
		m_cVertices		= cVertices;
		m_Transformed	= false;
		m_cFaces		= cFaces;
		m_sumnVerts		= sumnVerts;
	}
	
	public CqPolygonPoints( final CqPolygonPoints From )
	{
		super( From );
		m_cVertices		= From.m_cVertices;
		m_Transformed	= From.m_Transformed;
		m_cFaces		= From.m_cFaces;
		m_sumnVerts		= From.m_sumnVerts;
	}
	 
	public CqBound Bound()
	{
		return new CqBound();
	}

	@Override
	public CqMicroPolyGridBase Dice()
	{
		return ( null );
	}
	
	@Override
	public int	Split( STLVector<CqBasicSurface> aSplits )
	{
		return ( 0 );
	}
	
	@Override
	public boolean Diceable()
	{
		return ( false );
	}

	/** 
	 * Determine whether the passed surface is valid to be used as a
	 *  frame in motion blur for this surface.
	 */
	public boolean IsMotionBlurMatch( CqBasicSurface pSurf )
	{
		return( false );
	}

	final public void Transform( final CqMatrix matTx, final CqMatrix matITTx, final CqMatrix matRTx )
	{
		Transform( matTx, matITTx, matRTx, 0 );
	}
	
	public void Transform( final CqMatrix matTx, final CqMatrix matITTx, final CqMatrix matRTx, int iTime )
	{
	    if ( m_Transformed ) return ;

	    super.Transform( matTx, matITTx, matRTx, iTime );

	    m_Transformed = true;
	}

	public int cUniform()
	{
		return ( m_cFaces );
	}
	public int cVarying()
	{
		return ( m_cVertices );
	}
	public int cVertex()
	{
		return ( m_cVertices );
	}
	public int cFaceVarying()
	{
		return ( m_sumnVerts );
	}

	/** Get the number of vertices in the list.
	 */
	public int	NumVertices()
	{
		return ( (int)cVertex() );
	}

}
