// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;

/**
 * [Vu[𗘗pNX̊ƂȂNXB<br>
 * handling any class capable of being motion blurred.
 * 
 * @author NTT DATA Corporation
 */

public abstract strictfp class CqMotionSpec<T> implements IqMotionSpec<T> {
	
	//^CXbgB
	//  ^CXbgƂ̓t[ԂۑVectorłB
	private STLVector<Float>	m_aTimes = new STLVector<Float>( Float.class );		///< Array of float timeslot times.
	private STLVector<T>		m_aObjects;		///< Array of motion objects for each timeslot.
	private T					m_DefObject;						///< Default motion object, used when expanding the list of timeslots
	
	/**
	 * ftHgRXgN^
	 * @param a [VIuWFNg̃ftHg̒lB<br>
	 * 
	 */
	@SuppressWarnings("unchecked")
	public CqMotionSpec( final T a )
	{
		m_DefObject = a;
		m_aObjects = new STLVector( a.getClass() );
	}
	
	public CqMotionSpec( final T a, final Class<T> cls )
	{
		m_DefObject = a;
		m_aObjects = new STLVector<T>( cls );
	}
	
	/** 
	 * Rs[RXgN^
	 */
	@SuppressWarnings("unchecked")
	public CqMotionSpec( final CqMotionSpec<T> From )
	{
		m_aObjects = new STLVector( From.m_DefObject.getClass() );
		this.assignment( From );
	}
	
	/**
	 * fXgN^
	 */
	public void destruct()
	{
		//for(std::vector<T>::iterator i=m_aObjects.begin(); i<m_aObjects.end(); i++)
		//	ClearMotionObject((*i));
	}
	
	/** 
	 * ZqB<br>
	 * SĂ̗vfRs[B
	 */
	public void assignment( final CqMotionSpec<T> From )
	{
		m_aTimes.clear();
		m_aObjects.clear();
		
		m_aTimes.addAll( From.m_aTimes );
		m_aObjects.addAll( From.m_aObjects );
		m_DefObject = From.m_DefObject;
	}
	
	/** 
	 * [VIuWFNgƂ̃t[ԂǉB
	 * ̎Ԃ̃f[^݂ȂΐVKɍ쐬A݂΂㏑܂B
	 * @param time ǉIuWFNg̎Ԉʒuit[ԁj
	 * @param Object w莞ԂɒǉIuWFNg
	 */
	public void	AddTimeSlot( float time, final T Object )
	{
		p_int iIndex = new p_int();
		if ( iTimes() == 0 )
		{
			m_aTimes.add( time );
			m_aObjects.add( Object );
			return ;
		}
		
		if ( TimeSlotExists( time, iIndex ) )
		{
			ClearMotionObject( m_aObjects.elementAt( iIndex.value ) );
			m_aObjects.setElementAt(Object ,iIndex.value );
		}
		else
		{
			// Insert the timeslot at the proper place.
			int index = 0;
			while(index != m_aTimes.size() && m_aTimes.elementAt(index) < time )
			{
				index++;
			}
			m_aTimes.add( index, time );
			m_aObjects.add( index, Object );
		}
	}
	
	/** 
	 * [VIuWFNgwt[Ԃ̃IuWFNgƌB
	 * A̎ԈʒuɃIuWFNgȂ΁AwIuWFNĝ܂ܐVKǉB
	 * 
	 * @param time Ώۂ̃t[
	 * @param Object IuWFNg
	 */
	public void	ConcatTimeSlot( float time, final T Object )
	{
		p_int iIndex = new p_int();
		if ( TimeSlotExists( time, iIndex ) )
		{
			m_aObjects.setElementAt( ConcatMotionObjects( m_aObjects.elementAt( iIndex.value ), Object ), iIndex.value );
		}
		else
		{
			// Add a new slot a nd set it to the default value before concatenating the
			// specified value.
			AddTimeSlot( time, m_DefObject );
			TimeSlotExists( time, iIndex );
			m_aObjects.setElementAt( ConcatMotionObjects( m_aObjects.elementAt( iIndex.value ), Object ), iIndex.value );
		}
	}
	
	/** 
	 * SẴ^CXbgɑ΂ĎwIuWFNg
	 * @param Object IuWFNg
	 */
	public void	ConcatAllTimeSlots( final T Object )
	{
		for( int index=0; index<m_aObjects.size(); index++ ){
			m_aObjects.setElementAt( ConcatMotionObjects( m_aObjects.elementAt( index ), Object ), index );
		}
	}
	
	
	/** 
	 * wʒuɊi[Ăt[ԂԂB
	 * @param index ^CXbg̃CfbNX
	 * @return t[
	 */
	public float	Time( int index )
	{
		if ( m_aTimes.size() == 0 )
			return ( 0.0f );
		else if ( index < 0 )
			return ( m_aTimes.elementAt( 0 ) );
		else if ( index < iTimes() )
			return ( m_aTimes.elementAt( index ) );
		else
			return ( m_aTimes.lastElement() );
	}
	
	/** 
	 * ^CXbgɊi[Ă鐔ԂB
	 * @return ^CXbg̃TCY
	 */
	public int	iTimes()
	{
		return ( m_aTimes.size() );
	}
	
	/** 
	 * 
	 * ̃[VubNۂɃ[Vu[sĂ邩ۂB
	 * @return [Vu[sĂ邩ۂ
	 */
	public boolean fMotionBlurred()
	{
		return ( iTimes() > 1 );
	}
	
	/** 
	 * 
	 * wt[Ԃ^CXbgɊi[ĂCfbNXԂB<br>
	 * A̎ԂɐmɈvCfbNXȂꍇɂ́Ał߂CfbNXԂAO`P͈̔͂ł̌덷FractionɃZbgB
	 * Get the index of the timeslot for the specified time, and if not exact, the fractional
	 * distance between it and the following timeslot 0-1.
	 * 
	 * @param time I)t[
	 * @param iIndex O)^CXbg̃CfbNX
	 * @param Fraction O)덷䗦
	 * @return CfbNXmǂB
	 */
	public boolean GetTimeSlot( float time, p_int iIndex, p_float Fraction )
	{
		assert( iTimes() > 0 );
		
		if ( time >= m_aTimes.lastElement() )
		{
			iIndex.value = m_aTimes.size() - 1;
			return ( true );
		}
		else if ( time <= m_aTimes.firstElement() )
		{
			iIndex.value = 0;
			return ( true );
		}
		else
		{
			// Find the appropriate time span.
			iIndex.value = 0;
			while ( time >= m_aTimes.elementAt( iIndex.value + 1 ) )
				iIndex.value += 1;
			Fraction.value = ( time - m_aTimes.elementAt( iIndex.value ) ) / ( m_aTimes.elementAt( iIndex.value + 1 ) - m_aTimes.elementAt( iIndex.value ) );
			return ( m_aTimes.elementAt( iIndex.value ) == time );
		}
	}
	
	/** 
	 * ^CXbg̎wt[Ԃi[ĂCfbNXԂB
	 * @param time I)t[
	 * @param iIndex O)CfbNX
	 * @return CfbNX擾łǂB
	 */
	public boolean	TimeSlotExists( float time, p_int iIndex )
	{
		//assert( cTimes() > 0 );
		//assert(time>=0.0f);
		
		// Find the appropriate time span.
		iIndex.value = 0;
		while ( iIndex.value < iTimes() && time != m_aTimes.elementAt( iIndex.value ) )
			iIndex.value += 1;
		return ( iIndex.value < iTimes() );
	}
	
	/** 
	 * w莞Ԃ̃[VIuWFNg̎擾B<br>
	 * w肵ԂȂꍇAӂ̃f[^烊jAɕ⊮ꂽ[VIuWFNgԂB
	 * @param time t[
	 * @return w莞Ԃ̃[VIuWFNg
	 */
	public T	GetMotionObjectInterpolated( float time )
	{
		p_int iIndex = new p_int();
		p_float Fraction = new p_float();
		if ( GetTimeSlot( time, iIndex, Fraction ) )
			return ( m_aObjects.elementAt(iIndex.value) );
		else
			return ( LinearInterpolateMotionObjects( Fraction.value, m_aObjects.elementAt(iIndex.value), m_aObjects.elementAt( iIndex.value + 1 ) ) );
	}
	
	/** 
	 * w莞Ԃ̃[VIuWFNg̎擾B<br>
	 * w肵ԂȂꍇAftHg̃[VIuWFNgԂB
	 * @param time t[
	 * @return w莞Ԃ̃[VIuWFNg
	 */
	public T GetMotionObject( float time )
	{
		p_int iIndex = new p_int();
		p_float Fraction = new p_float();
		if ( GetTimeSlot( time, iIndex, Fraction ) )
			return ( m_aObjects.elementAt(iIndex.value) );
		else
		{
			assert( false );
			return ( m_DefObject );
		}
	}
	
	/** 
	 * wCfbNXɊi[Ă郂[VIuWFNgԂB
	 * @param iIndex ^CXbgiVectorj̃CfbNX
	 * @return [VIuWFNg
	 */
	public T GetMotionObject( int iIndex )
	{
		assert( iIndex >= 0 && iIndex < iTimes() );
		return ( m_aObjects.elementAt(iIndex) );
	}
	
	/** 
	 * ftHg̃[VIuWFNgݒB<br>
	 * ftHg̃[VIuWFNg̓^CXbggۂ̏lȂǂɎgB
	 * @param a ftHg̃[VIuWFNg
	 */
	public void	SetDefaultObject( final T a )
	{
		m_DefObject = a;
	}
	
	/** 
	 * SẴIuWFNgƃ^CXbgNAB
	 *
	 */
	public void	Reset()
	{
		m_aTimes.clear();
		for ( T tmp : m_aObjects ) {
			ClearMotionObject(tmp);
		}
		m_aObjects.clear();
	}
	
	/**
	 * 
	 * [VIuWFNgNAB<br>
	 * IuWFNg̎`Ԃɂ킹ĎĂB
	 * 
	 * @param A	NAΏۂ̃IuWFNg
	 */
//	abstract public void	ClearMotionObject( T A );
	
	/**
	 * 
	 * [VIuWFNgB<br>
	 * IuWFNg̎`Ԃɂ킹ĎĂB
	 * 
	 * @param A	[VIuWFNg
	 * @param B	[VIuWFNg
	 * @return	
	 */
//	abstract public T ConcatMotionObjects( final T A, final T B );
	
	/**
	 * 
	 * [VIuWFNgԂjAɕ⊮B<br>
	 * IuWFNg̎`Ԃɂ킹ĎĂB
	 * 
	 * @param Fraction	덷䗦
	 * @param A	⊮Ώۂ̈ʒuÖʒuɂ郂[VIuWFNg
	 * @param B	⊮Ώۂ̈ʒüʒuɂ郂[VIuWFNg
	 * @return	⊮
	 */
//	abstract public T LinearInterpolateMotionObjects( float Fraction, final T A, final T B );
	
	
}
