// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.CqStats.STATS_INC;
import static net.cellcomputing.himawari.library.EqIntIndex.GPR_created;
import static net.cellcomputing.himawari.library.EqModeBlock.Motion;
import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.util.HimawariLogger;

/**
 * 
 * Define the context that exists between calls to RiMotionBegin/RiMotionEnd.
 *  RiMotionBegin/RiMotionEndĂ΂ĂԂɑ݂AReLXg`B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqMotionModeBlock extends CqModeBlock
{
	
	/**
	 * RXgN^B@l̐ݒB
	 * @param N	times[]̃TCYB
	 * @param times	[V̎w莞ԁB
	 * @param pconParent	ÕReLXgB
	 */
	public CqMotionModeBlock( int N, float times[], final CqModeBlock pconParent )
	{
		super( pconParent, Motion );
	    
		// Copy the parents attributes, as this state change doesn't save attributes.
		//@Ԃ̕ωŕςAgr[g͕ۑȂ߁AẽAgr[gRs[
	    if ( pconParent != null)
	        m_pattrCurrent = pconParent.m_pattrCurrent;
	    else
	    { //pconParent@== null̏ꍇ͎dlNȂBBƎvB
	        m_pattrCurrent = new CqAttributes();
	        m_pattrCurrent.AddRef(); //ADD Ȃ@Relese@H
	    }

	    if ( pconParent != null)
	    {
			m_ptransCurrent = new CqTransform(pconParent.m_ptransCurrent );
	
			// Set the default 'new time slot' matrix to the current 0 time matrix, this
	        // takes care of the case of moving from non-Motion to Motion.
			// ݂̃}gNXɃftHgl'new time slot'ݒB 񃂁[V烂[V܂ł̓ǗB
		    
			//m_ptransCurrent->SetDefaultObject( m_ptransCurrent->GetMotionObject( m_ptransCurrent->Time( 0 ) ) );
			SqTransformation ct = new SqTransformation();
			ct.m_matTransform.assignment( m_ptransCurrent.matObjectToWorld( m_ptransCurrent.Time( 0 ) ) );
			ct.m_Handedness = m_ptransCurrent.GetHandedness( m_ptransCurrent.Time( 0 ) );
			m_ptransCurrent.SetDefaultObject( new SqTransformation(ct) );
	    }
	    else
	    {
	        m_ptransCurrent = new CqTransform();
	    }


	    // Store the array of times.
	    int i;
	    for ( i = 0; i < N; i++ )
	        m_aTimes.add( times[ i ] );

	    m_iTime = 0;
	}
	
	
	/** 
	 * fXgN^B@ȂB
	 * @see net.cellcomputing.himawari.library.CqModeBlock#destruct()
	 */
	@Override
	public void destruct()
	{}

	
    /**
     * Create a main context.<br>
     * 	C̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
	@Override
    public CqModeBlock BeginMainModeBlock()
    {
        return 	null;	// Error
    }		
    
    
    /** 
     * Create a frame context.<br>
     * t[̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
    @Override
    public CqModeBlock BeginFrameModeBlock()
    {
        return	null;	// Error
    }		
    
    
    /** 
     * Create a world context.<br>
     * 	[h̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
    @Override
    public CqModeBlock BeginWorldModeBlock()
    {
        return 	null;	// Error
    }		
    
    
    /** 
     * Create a attribute context.<br>
     * 	Agr[g̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     */
    @Override
    public CqModeBlock BeginAttributeModeBlock()
    {
        return	null;	// Error
    }		
    
    
    /**
     * Create a transform context.<br>
     * 	gXtH[̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginTransformModeBlock()
     */
    @Override
    public CqModeBlock BeginTransformModeBlock()
    {
        return	null;	// Error
    }	
    
    
    /**
     * Create a solid context.<br>
     * 	\bh̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginSolidModeBlock(java.lang.String)
     */
    @Override
    public CqModeBlock	BeginSolidModeBlock( String type )
    {
        return	null;	// Error
    }	
    
    
    /**
     * Create a object context.<br>
     * 	IuWFNg̃ReLXg쐬B
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginObjectModeBlock()
     */
    @Override
    public CqModeBlock BeginObjectModeBlock()
    {
        return	null;	// Error
    }	
    
    
    /**
     * Create a motion context.<br>
     * 	[ṼReLXg쐬B	// Error
     * 
     * @warning [VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#BeginMotionModeBlock(int, float[])
     */
    @Override
    public CqModeBlock BeginMotionModeBlock( int N, float times[] )
    {
        return	null;	// Error
    }		

   
    /**
     * Delete the object context.<br>
     * 	IuWFNg̃ReLXgB
     * 
     * @attention 	[VReLXg̒ŁÃ\bhĂ΂ꂽꍇG[ƂȂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#EndMotionModeBlock()
     */
    @Override
    public void EndMotionModeBlock()
    {
        if( m_pDeformingSurface != null )
        {
        	//check motion object size
        	if( m_pDeformingSurface.m_aObjects.size() < 2 ) {
        		HimawariLogger.getLogger().error( "Motion Objects is more 2 necessary.\n " );
        		if( m_pDeformingSurface.m_aObjects.size()==1 )QGetRenderContext().pImage().PostSurface( m_pDeformingSurface.m_aObjects.get(0) );
        	}
        	else{
        		QGetRenderContext().pImage().PostSurface( m_pDeformingSurface );
        	}
            STATS_INC( GPR_created );
        }
    }
    
   
    /**
     * Get a reference to the options at the parent context, <br>
     * 	as motion context doesn't store options.<br>
     * 	IvṼQb^B<br>
     * 	[VReLXg̓IvVۑȂ߁AẽIvVԂB	
     * 
     * @return	ẽIvV
     * @see net.cellcomputing.himawari.library.CqModeBlock#optCurrent()
     */
    @Override
    public CqOptions optCurrent()
    {
        return ( pconParent().optCurrent() );
    }

    
    /**
     * Get the current time,<br> 
     * as specified at initialisation of the block.<br>
     * 	ubN̏Ŏw肳ꂽԂ擾B
     * 
     * @return ݂̎B@w莞ԂzĂꍇ0ԂB
     * @see net.cellcomputing.himawari.library.CqModeBlock#Time()
     */
    @Override
    public float Time()
    {
        if ( m_iTime < m_aTimes.size() )
            return ( m_aTimes.get( m_iTime ).floatValue() );
        else
            return ( 0.0f );
    }
    
   
    /**
     * Advance the current time to the next specified time.<br>
     *  ݂̎Ԃw肳ꂽ̎Ԃɐi߂B
     *  
     * @see net.cellcomputing.himawari.library.CqModeBlock#AdvanceTime()
     */
    @Override
    public void	AdvanceTime()
    {
        m_iTime++;
    }
    
    
    /**
     * Get the current frame index if in a motion block.<br>
     * ݂̃t[CfbNX̃Qb^B<br>
     *  [VubN̒ȂÃ݂t[̃CfbNX擾B
     *  
     * @see net.cellcomputing.himawari.library.CqModeBlock#TimeIndex()
     */
    @Override
    public int	TimeIndex()
    {
		return( m_iTime );
	}
    
    
    /** 
     * Indicate that this is a motion block.<br>
     * 	[VubN̒ł΁AtrueԂB
     * 
     * @return @true
     */
    @Override
    public boolean	fMotionBlock()
    {
        return ( true );
    }
    
    
    /**
     * Get the CqDeformingSurface,<br> 
     * if generating a deformation motion blur sequence.<br>
     * 	CqDeformingSurfacẽQb^B<br>
     * 	ό`[Vu[n𔭐ꍇɎgpB
     * 
     * @return	m_pDeformingSurface	݂m_pDeformingSurface
     */
    public CqDeformingSurface GetDeformingSurface()
    {
        return( m_pDeformingSurface );
    }
    
    
    /**
     * Set the CqDeformingSurface, <br>
     * if generating a deformation motion blur sequence.<br>
     * CqDeformingSurfacẽZb^B<br>
     * 	ό`[Vu[n𔭐ꍇɎgpB
     * ό`[Vu[n𔭐ȂACqDeformingSurfaceݒ肵ĂB
     * 
     * @param pDeformingSurface	ZbgIuWFNg
     */
    public void SetDeformingSurface( final CqDeformingSurface pDeformingSurface)
    {
        m_pDeformingSurface = pDeformingSurface;
    }
    
    private int					m_iTime;		///< t[Ԃ̃CfbNXB < The index of the current frame time.
    private STLVector<Float>		m_aTimes = new STLVector<Float>( Float.class );		///< An array of specified frame times.
    private CqDeformingSurface	m_pDeformingSurface;
}