// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import java.util.Collections;
import java.util.Iterator;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.util.HimawariLogger;


import static net.cellcomputing.himawari.library.Float_h.*;
import static net.cellcomputing.himawari.library.RiGlobal.*;

//-----------------------------------------------------------------------
/** Storage class for all data relating to a single pixel in the image.<br>
 * C[W1fɊ֘A邷ׂẴf[^̂߂̋LNXB
 */
public strictfp class CqImagePixel {
	
	
//	----------------------------------------------------------------------
	/** RXgN^
	 */
	public CqImagePixel()
	{
		m_XSamples =  0 ;
		m_YSamples =  0 ;
		m_MaxDepth = FLT_MAX ;
		m_MinDepth = FLT_MAX ;
		m_OcclusionBoxId = -1 ;
		m_NeedsZUpdate = false ;
	}
	
	/** Rs[RXgN^
	 */
	public CqImagePixel( CqImagePixel ieFrom )
	{
		this.m_AnySampleUsesSampleList = ieFrom.m_AnySampleUsesSampleList;
		this.m_aValues = ieFrom.m_aValues;
		this.m_Data = ieFrom.m_Data;
		this.m_DofOffsetIndices = ieFrom.m_DofOffsetIndices;
		this.m_MaxDepth = ieFrom.m_MaxDepth;
		this.m_MinDepth = ieFrom.m_MinDepth;
		this.m_NeedsZUpdate = ieFrom.m_NeedsZUpdate;
		this.m_OcclusionBoxId = ieFrom.m_OcclusionBoxId;
		this.m_OpaqueSampleCount = ieFrom.m_OpaqueSampleCount;
		this.m_Samples = ieFrom.m_Samples;
		this.m_XSamples = ieFrom.m_XSamples;
		this.m_YSamples = ieFrom.m_YSamples;
		this.random = ieFrom.random;
	}
//	----------------------------------------------------------------------
	/** fXgN^
	 */
	public void destruct()
	{
		
	}
	
	/** ̃TvԂB
	 * @return int^̐ԂB
	 */
	public int	XSamples()
	{
		return ( m_XSamples );
	}
	/** ̃TvԂB
	 * @return int^̐ԂB
	 */
	public int	YSamples()
	{
		return ( m_YSamples );
	}
	
//	----------------------------------------------------------------------
	/** 
	 * sNZ̃TCYw肵āÃ̕mۂB
	 * @param XSamples XInteger̃JEgB
	 * @param YSamples xInteger̃JEgB
	 */
	public void	AllocateSamples( int XSamples, int YSamples )
	{
		if( m_XSamples != XSamples || m_YSamples != YSamples )
		{
			m_XSamples = XSamples;
			m_YSamples = YSamples;
			int numSamples = m_XSamples * m_YSamples;
			
			if ( XSamples > 0 && YSamples > 0 )
			{
				m_aValues.resize( numSamples );
				// Initialise the OpaqueSampleEntries to the correct depth for the data we are
				// rendering, including any AOV data.
				
//				m_OpaqueValues.setSize( numSamples, def );
				for(int i = m_OpaqueValues.size() ; i< numSamples ;i++)
					m_OpaqueValues.add(new SqImageSample( QGetRenderContext().GetOutputDataTotalSize() ) );
				
				m_Samples.setSize( numSamples );
				m_DofOffsetIndices.setSize( numSamples );
			}
		}
	}
	
//	----------------------------------------------------------------------
	/** 
	 * Tvz}`Wb^[@\gĖB@\
	 * @param vecPixel Cq2DVector ̃C[WvfŃsNZR[fBl[gĂBTv|CgmɑΓIł̂ł͂ȂA΂ɂȂ悤ɂ̂ɂāA
	 * gpĂ܂B
	 * @param fJitter Wb^OTv|CgɓKp邩ǂāAołB
	 */
	private CqRandom random = new CqRandom( 53 );
	
	public void	InitialiseSamples( STLVector<CqVector2D> vecSamples )
	{
		InitialiseSamples(vecSamples,true);
	}
	public void	InitialiseSamples( STLVector<CqVector2D> vecSamples, boolean fJitter )
	{
		p_float opentime = new p_float( QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "Shutter" , 0 ).value );
		p_float closetime = new p_float( QGetRenderContext().optCurrent().GetFloatOptionIndex( "System", "Shutter" , 1 ).value );
		
		int numSamples = m_XSamples * m_YSamples;
		float subcell_width = 1.0f / numSamples;
		int m = m_XSamples;
		int n = m_YSamples;
		int i, j;
		
		vecSamples.setSize(numSamples);
		
		if ( !fJitter )
		{
			//@^񒆂̃|CggăTvB
			float XInc = ( 1.0f / m_XSamples ) / 2.0f;
			float YInc = ( 1.0f / m_YSamples ) / 2.0f;
			int y;
			for ( y = 0; y < m_YSamples; y++ )
			{
				float YSam = YInc + ( YInc * y );
				int x;
				for ( x = 0; x < m_XSamples; x++ )
//					vecSamples.set( ( y * m_XSamples ) + x ,new CqVector2D( XInc + ( XInc * x ), YSam ) );
					vecSamples.get( ( y * m_XSamples ) + x ).assignment( new CqVector2D( XInc + ( XInc * x ), YSam ) );
			}
			
			// [Vu[ƁALODƃTuẐ߂̎ԂB
			float time = 0;
			int nSamples = m_XSamples*m_YSamples;
			float dtime = 1.0f / nSamples;
			
			for ( i = 0; i < nSamples; i++ )
			{
				m_Samples.get( i ).m_SubCellIndex = 0;
				m_Samples.get( i ).m_DetailLevel = m_Samples.get( i ).m_Time = time;
				time += dtime;
			}
			
			
		}
		else
		{
//			static CqRandom random = new CqRandom( 53 );vCx[gɂď֏oB
			
			// |Cgucanonicalv}`Wb^[p^[ɏĂB
			for ( i = 0; i < n; i++ )
			{
				for ( j = 0; j < m; j++ )
				{
					int which = i * m + j;
					vecSamples.get(which).x( i );
					vecSamples.get(which).y( j );
				}
			}
			
			//@ꂼ̗̃Z̒yWVbtĂB
			for ( i = 0; i < n; i++ )
			{
				for ( j = 0; j < m; j++ )
				{
					float t;
					int k;
					
					k = (int)random.RandomInt( n - 1 - i ) + i;
					int i1 = i * m + j;
					int i2 = k * m + j;
					assert( i1 < vecSamples.size() && i2 < vecSamples.size() );
					t = vecSamples.get( i1 ).y;
					vecSamples.get( i1 ).y( vecSamples.get( i2 ).y );
					vecSamples.get( i2 ).y( t );
				}
			}
			
			//@ꂼ̃J̃Z̒xWVbtĂB
			for ( i = 0; i < m; i++ )
			{
				for ( j = 0; j < n; j++ )
				{
					float t;
					int k;
					
					k = (int)random.RandomInt( n - 1 - j ) + j;
					int i1 = j * m + i;
					int i2 = k * m + i;
					assert( i1 < vecSamples.size() && i2 < vecSamples.size() );
					t = vecSamples.get( i1 ).x;
					vecSamples.get( i1 ).x( vecSamples.get( i2 ).x );
					vecSamples.get( i2 ).x( t );
					
				}
			}
			
			
			float subpixelheight = 1.0f / m_YSamples;
			float subpixelwidth = 1.0f / m_XSamples;
			
			int which = 0;
			for ( i = 0; i < n; i++ )
			{
				float sy = i * subpixelheight;
				for ( j = 0; j < m; j++ )
				{
					float sx = j * subpixelwidth;
					float xindex = vecSamples.get( which ).x;
					float yindex = vecSamples.get( which ).y;
					vecSamples.get( which ).x( xindex * subcell_width + ( subcell_width * 0.5f ) + sx );
					vecSamples.get( which ).y( yindex * subcell_width + ( subcell_width * 0.5f ) + sy );
					m_Samples.get( which ).m_SubCellIndex = (int)( ( yindex * m_YSamples ) + xindex );
					which++;
				}
			}
			
			// [Vu[̂߂̃TvԁALOD̂߂̏ڍ׃xADoFɋLĂB
			float time = 0;
			float dtime = 1.0f / numSamples;
			
			// ͉f̒̊eTvɓׂ̃ItZbggp܂B
			// ͂܂GCAVOĂԁAłǂ\ȓKp͈͂mɂ܂B
			// (A). GŏƂȂ点ׂłB					
			float randomTime = random.RandomFloat( dtime );
			
			float lod = 0;
			float dlod = dtime;
			
			for ( i = 0; i < numSamples; i++ )
			{
				// Scale the value of time to the shutter time.
				float t = time + randomTime;
				t = ( closetime.value - opentime.value ) * t + opentime.value;
				m_Samples.get( i ).m_Time = t;
				time += dtime;
				
				m_Samples.get( i ).m_DetailLevel = lod + random.RandomFloat( dlod );
				lod += dlod;
			}
			
			// we calculate dof offsets in a grid inside the unit cube and then
			// project them into the unit circle. This means that the offset
			// positions match the offset bounding boxes calculated in CqBucket.
			// The sample test in RenderMicroPoly then can be split into a number
			// of smaller bounding boxes where we know in advance which samples
			// fall into each. (This is analagous to what we do for mb now as well).
			// note that there is an implied symmetry to the way we number the bounding
			// boxes here and in the bucket code where the bb's are created (it
			// should be left to right, top to bottom).
			float dx = 2.0f / m_XSamples;
			float dy = 2.0f / m_YSamples;
			
			// ͉f̒̊eTvɓׂ̃ItZbggp܂B
			// ͂܂GCAVOĂԁAłǂ\ȓKp͈͂mɂ܂B
			// (A). GŏƂȂ点ׂłB							
			float sx = random.RandomFloat(dx);
			float sy = random.RandomFloat(dy);
			float xOffset = -1.0f + sx;
			float yOffset = -1.0f + sy;
			which = 0;
			STLVector<CqVector2D> tmpDofOffsets = new STLVector<CqVector2D>(CqVector2D.class,numSamples);
			for ( i = 0; i < m_YSamples; ++i )
			{
				for ( j = 0; j < m_XSamples; ++j )
				{
					tmpDofOffsets.get( which ).x(xOffset);
					tmpDofOffsets.get( which ).y(yOffset);
					ProjectToCircle( tmpDofOffsets.get(which) );
					
					m_DofOffsetIndices.set(which , which);
					
					xOffset += dx;
					which++;
				}
				yOffset += dy;
				xOffset = -1.0f + sx;
			}
			
			// DofItZbgVbt邪Aǂ֍s͊oĂB
//			std::random_shuffle(m_DofOffsetIndices.begin(), m_DofOffsetIndices.end());
			Collections.shuffle(m_DofOffsetIndices, rand);
			for( i = 0; i < numSamples; ++i)
			{
				m_Samples.get(m_DofOffsetIndices.get(i).intValue() ).m_DofOffset = tmpDofOffsets.get(i);
			}
		}
		m_Data.m_Data.resize( QGetRenderContext().GetOutputDataTotalSize() );
	}
	
	
//	----------------------------------------------------------------------
	/** Shuffle the sample data to avoid repeating patterns in the sampling.
	 * W{̒ŁAJԂ̃p^[邽߂ɁATvf[^VbtB
	 */
	public void	ShuffleSamples()
	{
		int numSamples = m_XSamples * m_YSamples;
		
		// DoF̃ItZbgCfbNXXgVbtĂB
//		int which = 0;
		STLVector<CqVector2D> tmpDofOffsets = new STLVector<CqVector2D>(CqVector2D.class,numSamples);
		
		// W{o̊Ԓ邱ƂɊւĂꂽ肪܂Ă̂ۏ؂鐳Ȗ߂ɂDoFItZbgi[ĂB
		
		int i;
		for( i = 0; i < numSamples; ++i)
		{
//			tmpDofOffsets.set(i,m_Samples.get(m_DofOffsetIndices.get(i)).m_DofOffset);
			tmpDofOffsets.get(i).assignment( m_Samples.get(m_DofOffsetIndices.get(i)).m_DofOffset );
			m_DofOffsetIndices.set(i,i);
		}
		
//		DofItZbgVbt邪Aǂ֍s͊oĂB
//		std::random_shuffle(m_DofOffsetIndices.begin(), m_DofOffsetIndices.end());
//		Collections.shuffle(m_DofOffsetIndices);//2005/12/20 C Random
		Collections.shuffle(m_DofOffsetIndices,rand);

		for( i = 0; i < numSamples; ++i)
		{
			m_Samples.get(m_DofOffsetIndices.get(i).intValue()).m_DofOffset.assignment( tmpDofOffsets.get(i));
		}
	}
	
	/** 
	 * sNZ̕\n̍WnႤ̂ŁA\nƕێĂf[^ł̉摜̍Wϊ
	 * 
	 * @param vecPixel@ύXl
	 * @param vecSamples@̃FN^[
	 */
	public void	OffsetSamples(CqVector2D vecPixel, STLVector<CqVector2D> vecSamples)
	{
		// sNZEItZbgɉĂB
		final int numSamples = m_XSamples * m_YSamples;
		for ( int i = 0; i < numSamples; i++ )
		{
			m_Samples.get( i ).m_Position.assignment( vecSamples.get( i ) );
			m_Samples.get( i ).m_Position.assignAdd( vecPixel );
		}
	}
//	nttdata 
	public void	OffsetSamples(CqVector2D vecPixel, CqVector2D[] vecSamples)
	{
		// sNZEItZbgɉĂB
		final int numSamples = m_XSamples * m_YSamples;
		for ( int i = 0; i < numSamples; i++ )
		{
			m_Samples.get( i ).m_Position.assignment( vecSamples[ i ] );
			m_Samples.get( i ).m_Position.assignAdd( vecPixel );
		}
	}
	
	/** ̉f̑̂̓Kp͈͂ɓĂB
	 * @return Float Jo[ꂽf̉̈B
	 */
	public float	Coverage()
	{
		return ( m_Data.Coverage() );
	}
	public void	SetCoverage( float c )
	{
		m_Data.SetCoverage( c );
	}
	/** ̉f̕ςF𓾂ĂB
	 * @return ̉fŕςF\FB
	 * @attention łFilterBucket()ǂݍłꍇɂ̂ݎgĂB
	 */
	public CqColor	Color()
	{
		return ( m_Data.Cs() );
	}
	public void	SetColor(final CqColor col)
	{
		m_Data.SetCs( col );
	}
	/** ̉f̕ςx𓾂Ă
	 * @return ̉fŕςx\FB
	 * @attention łFilterBucket()ǂݍłꍇɂ̂ݎgĂB
	 */
	public CqColor	Opacity()
	{
		return ( m_Data.Os() );
	}
	public void	SetOpacity(final CqColor col)
	{
		m_Data.SetOs( col );
	}
	/** ̉f̕ς[𓾂ĂB
	 * @return ̉fŕς[\FloatB
	 * @attention łFilterBucket()ǂݍłꍇɂ̂ݎgĂB
	 */
	public float	Depth()
	{
		return ( m_Data.Depth() );
	}
	public void	SetDepth( float d )
	{
		m_Data.SetDepth( d );
	}
	/** ̉f̑O|ZꂽAt@𓾂ĂB
	 * @return ̉f̑O|Zꂽl\܂floatB
	 * @attention łFilterBucket()ǂݍłꍇɂ̂ݎgĂB
	 */
	public float	Alpha()
	{
		return ( m_Data.Alpha() );
	}
	public void	SetAlpha( float a )
	{
		m_Data.SetAlpha( a );
	}
	/** wjW{f[^ɓĂB
	 * @return W{f[^ւ̈̎wjB
	 */
	public Valarray Data()
	{
		return ( m_Data.m_Data );
	}
	
	public SqImageSample	GetPixelSample()
	{
		return ( m_Data );
	}
	/** f[^̐擾B
	 * @return ̉fɂTv̐B
	 */
	public int	DataSize()
	{
		return ( m_Data.m_Data.size() );
	}
	/** ̉f̍ő̐[𓾂ĂB
	 * @return ̉fōő̐[\FloatB
	 */
	public float	MaxDepth()
	{
		return ( m_MaxDepth );
	}
	public void	SetMaxDepth( float d )
	{
		m_MaxDepth = d;
	}
	/** ̉f̍ŏ̐[𓾂ĂB
	 * @return ̉fōŏ̐[\FloatB
	 */
	public float	MinDepth()
	{
		return ( m_MinDepth );
	}
	public void	SetMinDepth( float d )
	{
		m_MinDepth = d;
	}
	/**̃sNZJo[IL[W{bNXid擾Ă
	 * @return IL[W{bNXid
	 */
	public int	OcclusionBoxId()
	{
		return ( m_OcclusionBoxId );
	}
	public void	SetOcclusionBoxId( int id )
	{
		m_OcclusionBoxId = id;
	}
	/** ̃sNZAsNZ̍ŏlƍől̂l̍ČvZƂċL^B
	 */
	public void	MarkForZUpdate()
	{
		m_NeedsZUpdate = true;
	}
	public boolean	NeedsZUpdating()
	{
		return m_NeedsZUpdate;
	}
	/** ׂẴTvʂăXLāAŏƍőzlĂB
	 */
//	----------------------------------------------------------------------
	/** ReCalculate͂̉f̍ŏƍőzlłB
	 */
	public void	UpdateZValues()
	{
		float currentMax = 0.0f;
		float currentMin = FLT_MAX;
		int sampleIndex = 0;
		int sx, sy;
		for ( sy = 0; sy < m_YSamples; sy++ )
		{
			for ( sx = 0; sx < m_XSamples; sx++ )
			{
				SqImageSample opaqueSample = m_OpaqueValues.get( sampleIndex );
				if( (opaqueSample.m_flags & SqImageSample.Flag_Valid ) != 0)
				{
					if ( opaqueSample.Depth() > currentMax )
					{
						currentMax = opaqueSample.Depth();
					}
					if ( opaqueSample.Depth() < currentMin )
					{
						currentMin = opaqueSample.Depth();
					}
				}
				else
				{
					currentMax = FLT_MAX;
				}
				
				sampleIndex++;
			}
		}
		
		m_MaxDepth = currentMax;
		m_MinDepth = currentMin;
	}
	
//	----------------------------------------------------------------------
	/** Ɏg߂ɂC[Wvf̊֘Af[^NAĂB
	 */
	public void	Clear()
	{
		int i;
		for ( i = ( m_XSamples * m_YSamples ) - 1; i >= 0; i-- )
		{
			if(!m_aValues.get(i).isEmpty())
				m_aValues.get( i ).clear( );
			
			m_OpaqueValues.get( i ).m_flags = 0;
		}
		
		m_OpaqueSampleCount = 0;
		m_AnySampleUsesSampleList = false;
		m_MaxDepth = FLT_MAX;
		m_MinDepth =  FLT_MAX;
		m_OcclusionBoxId = -1;
		m_NeedsZUpdate = false;
	}
	
	/** w肳ꂽTv̂߂ɎQƂׂēĂB
	 * @return SqImageSamplef[^̃xNgւ̎Q
	 */
	public STLVector<SqImageSample>	Values( int index )
	{
		assert( index < m_XSamples*m_YSamples );
		return ( m_aValues.get( index ) );
	}
	
	public SqImageSample OpaqueValues( int index )
	{
		assert( index < m_XSamples*m_YSamples );
		return ( m_OpaqueValues.get( index ) );
	}
	
	public void IncOpaqueSampleCount()
	{
		m_OpaqueSampleCount++;
	}
	
	public void SetUsesSampleList()
	{
		m_AnySampleUsesSampleList = true;
	}
	
	
//	----------------------------------------------------------------------
	/** w肳ꂽTv|Cgł̎F邱ƂɂāAF𓾂ĂB
	 */
	public void	Combine()
	{
		int depthfilter = 0;
		HimawariLogger logger = HimawariLogger.getLogger();
		final String[] pstrDepthFilter = QGetRenderContext().optCurrent().GetStringOption( "Hider", "depthfilter" );//VhE}bv̎ɏo͂sNZ̉slŏAőAςIłB    
		final CqColor[] pzThreshold = QGetRenderContext().optCurrent().GetColorOption( "limits", "zthreshold" );//VhE}bv̎Ȃ̂eɂ邩̐ݒɎg
		
		CqColor zThreshold = new CqColor(1.0f, 1.0f, 1.0f);	// Default threshold of 1,1,1 means that any objects that are partially transparent won't appear in shadow maps.
		if(null != pzThreshold)
			zThreshold = pzThreshold[0];
		
		if ( null != pstrDepthFilter )
		{
			if( (pstrDepthFilter[ 0 ].compareTo( "min" ) == 0) )
				depthfilter = 0;
			else if ( pstrDepthFilter[ 0 ].compareTo( "midpoint" ) == 0)
				depthfilter = 1;
			else if ( pstrDepthFilter[ 0 ].compareTo( "max" ) == 0)
				depthfilter = 2;
			else if ( pstrDepthFilter[ 0 ].compareTo( "average" ) == 0 )
				depthfilter = 3;
			else
				logger.warning( "Invalid depthfilter \"" + pstrDepthFilter[ 0 ] + "\", depthfilter set to \"min\"" );
		}
		
		int samplecount = 0;
//		int numsamples = XSamples() * YSamples();
		if(m_AnySampleUsesSampleList)//ȕ̂Ƃifɓ炵B
		{
			int sampleIndex = 0;
//			Vector<Vector<SqImageSample> >.iterator end = m_aValues.end();
//			for ( Vector<Vctor<SqImageSample> >.iterator samples = m_aValues.begin(); samples != end; ++samples )
			Iterator<STLVector<SqImageSample>> Firstsamples = m_aValues.iterator();
			
			while(Firstsamples.hasNext())
			{
				STLVector<SqImageSample> samples =  (STLVector<SqImageSample>) Firstsamples.next();
				
				SqImageSample opaqueValue = m_OpaqueValues.get( sampleIndex );
				sampleIndex++;
				
				
				if(!samples.isEmpty())
				{
					if( (opaqueValue.m_flags & SqImageSample.Flag_Valid) != 0)
					{
						//	ʒuopaqueValueTvɑ}ĂB
//						Vector<SqImageSample>.iterator isi = samples.begin();
//						Vector<SqImageSample>.iterator isend = samples.end();
						Iterator isi = samples.iterator();
						int index = 0;
						while( isi.hasNext() )
						{
							SqImageSample tmp = (SqImageSample) isi.next();
							
							if( tmp.Depth() >= opaqueValue.Depth())
								break;
							
//							++isi;
							++index;
						}
//						samples.insert(isi, opaqueValue);
						samples.insertElementAt( opaqueValue ,index );
					}
					
					// Tv̂ǂꂩCSG؂ɂ邩ׂB
					boolean bProcessed;
					boolean CqCSGRequired = CqCSGTreeNode.IsRequired();
					if (CqCSGRequired)
						do
						{
							bProcessed = false;
							//Warning ProcessTree add or remove elements in samples list
							//We could not optimized the for loop here at all.
							for( SqImageSample isample : samples )
							{
								if( isample.m_pCSGNode != null )
								{
									isample.m_pCSGNode.ProcessTree( samples );
									bProcessed = true;
									break;
								}
							}
						} while ( bProcessed );
					
					CqColor samplecolor = new CqColor( gColBlack );
					CqColor sampleopacity = new CqColor( gColBlack );
					boolean samplehit = false;
					float[] opaqueDepths = { FLT_MAX, FLT_MAX };
					float maxOpaqueDepth = FLT_MAX;

					//reverse iterator
					int Size = samples.size();
					
					for(int index = Size-1;index >= 0 ; index--)
					{
						SqImageSample sample = samples.get(index);
						
						if ( ( sample.m_flags & SqImageSample.Flag_Matte ) != 0 )
						{
							if ( ( sample.m_flags & SqImageSample.Flag_Occludes ) != 0 )
							{
								// Optimise common case
								samplecolor.assignment( gColBlack );
								sampleopacity.assignment( gColBlack );
							}
							else
							{
								samplecolor.SetColorRGB(
										LERP( sample.Os().fRed(), samplecolor.fRed(), 0 ),
										LERP( sample.Os().fGreen(), samplecolor.fGreen(), 0 ),
										LERP( sample.Os().fBlue(), samplecolor.fBlue(), 0 )
								);
								sampleopacity.SetColorRGB(
										LERP( sample.Os().fRed(), sampleopacity.fRed(), 0 ),
										LERP( sample.Os().fGreen(), sampleopacity.fGreen(), 0 ),
										LERP( sample.Os().fBlue(), sampleopacity.fBlue(), 0 )
								);
							}
						}
						else
						{
//							samplecolor = ( samplecolor * ( gColWhite - sample.Os() ) ) + sample.Cs();
//							sampleopacity = ( ( gColWhite - sampleopacity ) * sample.Os() ) + sampleopacity;
							samplecolor.assignment(  samplecolor.mul( gColWhite.sub( sample.Os() ) ).add( sample.Cs()) );
							sampleopacity.assignment( gColWhite.sub( sampleopacity ).mul( sample.Os() ).add( sampleopacity ) );
						}
						
						// Now determine if the sample opacity meets the limit for depth mapping.
						// If so, store the depth in the appropriate nearest opaque sample slot.
						// The test is, if any channel of the opacity color is greater or equal to the threshold.
						if(sample.Os().fRed() >= zThreshold.fRed() || sample.Os().fGreen() >= zThreshold.fGreen() || sample.Os().fBlue() >= zThreshold.fBlue())
						{
							// Make sure we store the nearest and second nearest depth values.
							opaqueDepths[1] = opaqueDepths[0];
							opaqueDepths[0] = sample.Depth();
							// Store the max opaque depth too, if not already stored.
							if(!(maxOpaqueDepth < FLT_MAX))
								maxOpaqueDepth = sample.Depth();
						}
						samplehit = true;
					}
					
					if ( samplehit )
					{
						samplecount++;
					}
					
					// Write the collapsed color values back into the opaque entry.
					//@sȃGg[ɂF̒l̕ԎĂB
					if ( !samples.isEmpty() )
					{
						// F̓xݒ肵ĂB
						opaqueValue.SetCs( samplecolor );
						opaqueValue.SetOs( sampleopacity );
						opaqueValue.m_flags |= SqImageSample.Flag_Valid;
						
						if ( depthfilter != 0)
						{
							if ( depthfilter == 1 )
							{
								//std::cerr << debug << "OpaqueDepths: " << opaqueDepths[0] << " - " << opaqueDepths[1] << std::endl;
								// Use midpoint for depth
								if ( samples.size() > 1 )
									opaqueValue.SetDepth( ( opaqueDepths[0] + opaqueDepths[1] ) * 0.5f );
								else
									opaqueValue.SetDepth( FLT_MAX );
							}
							else if ( depthfilter == 2)
							{
								opaqueValue.SetDepth( maxOpaqueDepth );
							}
							else if ( depthfilter == 3 )
							{
//								Vector<SqImageSample>.iterator sample;
								Iterator sample = samples.iterator();
								float totDepth = 0.0f;
								int totCount = 0;
//								for ( sample = samples.begin(); sample != samples.end(); sample++ )
								while(sample.hasNext())
								{
									SqImageSample tmp = (SqImageSample) sample.next();
									if(tmp.Os().fRed() >= zThreshold.fRed() || tmp.Os().fGreen() >= zThreshold.fGreen() || tmp.Os().fBlue() >= zThreshold.fBlue())
									{
										totDepth += tmp.Depth();
										totCount++;
									}
								}
								totDepth /= totCount;
								
								opaqueValue.SetDepth( totDepth );
							}
							// l "min"
						}
						else
							opaqueValue.SetDepth( opaqueDepths[0] );
					}
				}
				else
				{
					if( (opaqueValue.m_flags & SqImageSample.Flag_Valid ) != 0)
					{
						samplecount++;
					}
				}
			}
		}
		else
		{
			samplecount = m_OpaqueSampleCount;
		}
	}
	
	/** w肳ꂽTvCfbNX̂߂̕W{f[^𓾂ĂB
	 * @param KvȃTv|Cg̃CfbNXB
	 * @return W{f[^̎QƁB
	 */
	public final SqSampleData SampleData( int index )
	{
//		assert( index < m_XSamples*m_YSamples );
		if( index < m_XSamples*m_YSamples )
			return ( m_Samples.get( index ) );
		else
			return new SqSampleData();
	}
	
	/** iɂdofItZbg܂ރTṽCfbNX𓾂ĂB
	 * @param 킩ȂoEfBO{bNX̍܂B
	 * @return BBƌĂ΂dofItZbgɊ܂܂sample ̃CfbNXB
	 */
	public	int GetDofOffsetIndex(int i)
	{
		return m_DofOffsetIndices.get(i).intValue();
	}
	
	/** 
	 * jbg`coordjbg~̒1ɕϊĂB
	 * dofTvʒu𔭐ۂɁAgpĂ܂B
	 */
	public static void ProjectToCircle(CqVector2D pos)
	{
		float r = pos.Magnitude();
		if( r == 0.0 )
			return;
		
		float adj = (float)Math.max((float)Math.abs(pos.x), (float)Math.abs(pos.y)) / r;
		pos.x(pos.x * adj);
		pos.y(pos.y * adj);
	}
	
	//---Himawari add start ----
	/**
	 * ʎqO̐F݂Ă
	 * SqImageSampleɐݒ肷
	 * @param col
	 */
	public void setfColor(CqColor col){
		m_Data.setFColor(col);
	}
	
	/**
	 * ʎqO̐F擾
	 * @return ʎqO̐FCqColor
	 */
	public CqColor getFColor(){
		return m_Data.getFColor();
	}
	//---Himawari add end   ----
	
	private int	m_XSamples;							///< ̃Tvi[
	private int	m_YSamples;							///< ̃Tvi[
	private STLVector<STLVector<SqImageSample> > m_aValues = new STLVector<STLVector<SqImageSample>>(2,SqImageSample.class);	///< Vector  vectorłBFTv|Cg̃f[^
	private STLVector<SqImageSample> m_OpaqueValues = new STLVector<SqImageSample>(SqImageSample.class);	///< sȃTv̂߂̃Tv_f[^Vector@(one per sample position, no need for list).
	private STLVector<SqSampleData> m_Samples = new STLVector<SqSampleData>(SqSampleData.class);	///< Tv VectorBSẴTv̈ʒuAԁAʊE[xItZbg̏ȂǂB
	private STLVector<Integer> m_DofOffsetIndices = new STLVector<Integer>(Integer.class);	///< A mapping from dof bounding-box index to the sample that contains a dof offset in that bb.
	private SqImageSample	m_Data = new SqImageSample();
	
	private int	m_OpaqueSampleCount;				///< LȕsȃTv̐B
	private boolean	m_AnySampleUsesSampleList;		///< ASẴTvTvXggꂽA̑ΏƓIȕsȒlƂTrueԂB
	
	private float m_MaxDepth;						///< IN[WJOŎgBׂẴTvsNZ̐[x̏B
	private float m_MinDepth;						///< IN[WJOŎgBׂẴTvsNZ̐[x̉B
	private int m_OcclusionBoxId;					///< ̉fJo[CqOcclusionBox
	private boolean m_NeedsZUpdate;					///< ŏő̐[x̒lXVB
	
}
