// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import static net.cellcomputing.himawari.library.EqCSGNodeType.CSGNodeType_Difference;

/**
 * 
 * Intersection CSG node.
 *	Creates an difference between the first child surfaces and all other children.<br>
 *  ŏ̎qƑׂ̂Ă̎q̕\ʂ̈Ⴂ쐬܂B
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqCSGNodeDifference extends CqCSGTreeNode {

	
	/** default constructer */
	public CqCSGNodeDifference(){
		super();
    }
	
	/** destructer */
	public void destruct()
	{}
	
	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#NodeType()
	 */
	@Override
	public EqCSGNodeType NodeType() {
		
		EqCSGNodeType type = new EqCSGNodeType();
		type.setValue( CSGNodeType_Difference );
		return type;
	
	}

	/* (non-Javadoc)
	 * @see net.cellcomputing.himawari.library.CqCSGTreeNode#EvaluateState(java.util.Vector)
	 */
	@Override
	public boolean EvaluateState( boolean[] abChildStates) {
		
		// Work out the new state
		if ( abChildStates[ 0 ] )
	    {
			for( int i = 1; i < abChildStates.length; i++ )
			{
				if ( abChildStates[ i ] )
					return  false;
			}
			return true;
	    }
	    return false;
	    
	}

}
