// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

import static net.cellcomputing.himawari.library.Float_h.*;
/**
 * CqBound̓oEfBO{bNX̏ȗA邽߂ɎgpB
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqBound {
	
	/**
	 * RXgN^FɂďB
	 * 
	 * @param pBounds@float[6]̔z
	 */
	public CqBound( float[] pBounds )
	{
		if ( pBounds != null)
		{
			m_vecMin.x = pBounds[ 0 ] ;	
			m_vecMin.y = pBounds[ 2 ] ;
			m_vecMin.z = pBounds[ 4 ] ;
			
			m_vecMax.x = pBounds[ 1 ] ;
			m_vecMax.y = pBounds[ 3 ] ;	
			m_vecMax.z = pBounds[ 5 ] ;
		}
	}
	
	/**
	 * RXgN^FȂƂ͈ȉ̂悤ɏB<br>
	 * Min-FLT_MAX肻Arɏ邽߂ł悢B
	 */
	public CqBound()
	{
		m_vecMin.x = FLT_MAX ;
		m_vecMin.y = FLT_MAX ;
		m_vecMin.z = FLT_MAX ;
		m_vecMax.x = -FLT_MAX ;	
		m_vecMax.y = -FLT_MAX ;
		m_vecMax.z = -FLT_MAX ;
	}
	
	/**
	 * RXgN^FɂďB
	 * @param XMin ŏl̒l̂W
	 * @param YMin ŏl̒l̂W
	 * @param ZMin ŏl̒l̂W
	 * @param XMax ől̒l̂W
	 * @param YMax ől̒l̂W
	 * @param ZMax ől̒l̂W
	 */
	public    CqBound( float XMin , float YMin , float ZMin  , float XMax , float YMax , float ZMax )
	{
		m_vecMin.x = XMin ;
		m_vecMin.y = YMin ;
		m_vecMin.z = ZMin ;
		m_vecMax.x = XMax ;
		m_vecMax.y = YMax ;
		m_vecMax.z = ZMax ;
	}
	
	/**
	 * RXgN^FɂďB
	 * @param vecMin@ŏlVector3D̒l
	 * @param vecMax@őlVector3D̒l
	 */
	public CqBound( final CqVector3D vecMin, final CqVector3D vecMax )
	{
		m_vecMin.assignment( vecMin );
		m_vecMax.assignment( vecMax );
	}
	
//	---------------------------------------------------------------------
	
	/**
	 * Rs[RXgN^
	 * @param From@Rs[l
	 */
	public CqBound( final CqBound From )
	{
		this.m_vecMax.assignment( From.m_vecMax );
		this.m_vecMin.assignment( From.m_vecMin );
	}
	
	/**
	 * fXgN^<br>
	 * Ȃ
	 * 
	 * 
	 */
	public void destract()
	{}
	
//	public final CqVector3D	vecMin()
//	{
//	return ( m_vecMin );
//	}
	
	/**
	 * oϐ m_vecMiñQb^[
	 * @return@oϐ m_vecMin
	 */
	public    CqVector3D	vecMin()
	{
		return ( m_vecMin );
	}
	
//	public    const	CqVector3D&	vecMax() const
//	{
//	return ( m_vecMax );
//	}
	/**
	 * oϐ m_vecMax̃Qb^[
	 * @return@oϐ m_vecMax
	 */
	public    CqVector3D	vecMax()
	{
		return ( m_vecMax );
	}
	
	/**
	 * m_vecMinm_vecMaxł̃xNg߂B
	 *  
	 * @return@CqVector3DŎlpxNg
	 */
	public	CqVector3D vecCross()
	{
		return( m_vecMax.sub( m_vecMin ) );
	}
	
	/**
	 * oEfBO{bNX̑傫߂B
	 * @return@float^ŃoEfBO{bNX̑傫
	 */
	public	float	Volume()
	{
		return (float)Math.sqrt( Volume2() );
	}
	
	/**
	 * oEfBO{bNX̑傫߂邽߂ɎgB
	 * @return@float^ŃoEfBO{bNX̑傫2
	 */
	public	float Volume2()
	{
		return( vecCross().Magnitude2() );
	}
	
//	---------------------------------------------------------------------
	
	/**
	 *@BoundmB 
	 * 
	 * @param From@
	 * @return@gԂB
	 */
	public    CqBound	assignment( final CqBound From )
	{
		m_vecMin.assignment( From.m_vecMin );
		m_vecMax.assignment( From.m_vecMax );
		
		return ( this );
	}
	
	
	/**
	 * oEh̒lw肳ꂽ}gbNXɂĕϊB
	 * 
	 * @param matTransform@ϊ邽߂̃}gbNXQƂCqMatrix
	 */
	public    void		Transform( final CqMatrix matTransform )
	{
		// Transform the cuboid points.
		CqVector3D[]	avecCuboid = new CqVector3D[ 8 ];
		avecCuboid[ 0 ] = m_vecMin;
		avecCuboid[ 1 ] = new CqVector3D( m_vecMax.x, m_vecMin.y, m_vecMin.z );
		avecCuboid[ 2 ] = new CqVector3D( m_vecMin.x, m_vecMax.y, m_vecMin.z );
		avecCuboid[ 3 ] = new CqVector3D( m_vecMin.x, m_vecMin.y, m_vecMax.z );
		avecCuboid[ 4 ] = new CqVector3D( m_vecMax.x, m_vecMax.y, m_vecMin.z );
		avecCuboid[ 5 ] = new CqVector3D( m_vecMin.x, m_vecMax.y, m_vecMax.z );
		avecCuboid[ 6 ] = new CqVector3D( m_vecMax.x, m_vecMin.y, m_vecMax.z );
		avecCuboid[ 7 ] = m_vecMax;
		
		m_vecMin = new CqVector3D( FLT_MAX, FLT_MAX, FLT_MAX );
		m_vecMax = new CqVector3D( -FLT_MAX, -FLT_MAX, -FLT_MAX );
		
		int i;
		for ( i = 0; i < 8; i++ )
		{
			avecCuboid[ i ].assignment( matTransform.multiply( avecCuboid[ i ] ) );
			if ( avecCuboid[ i ].x < m_vecMin.x ) m_vecMin.x = avecCuboid[ i ].x ;
			if ( avecCuboid[ i ].y < m_vecMin.y ) m_vecMin.y = avecCuboid[ i ].y ;
			if ( avecCuboid[ i ].z < m_vecMin.z ) m_vecMin.z = avecCuboid[ i ].z ;
			
			if ( avecCuboid[ i ].x > m_vecMax.x ) m_vecMax.x = avecCuboid[ i ].x ;
			if ( avecCuboid[ i ].y > m_vecMax.y ) m_vecMax.y = avecCuboid[ i ].y ;
			if ( avecCuboid[ i ].z > m_vecMax.z ) m_vecMax.z = avecCuboid[ i ].z ;
		}
	}
	
	/**
	 * w肳ꂽoEhƌ݂̃oEhB̗̈܂ސVȃoEh쐬^[B
	 * 
	 * @param bound@Bound̒ǉCqBound
	 * @return@CqBound
	 */
	public    CqBound		Combine( final CqBound bound )
	{
		CqBound Result = new CqBound();
		
		Result.m_vecMax.x = Math.max( m_vecMax.x, bound.m_vecMax.x );
		Result.m_vecMax.y = Math.max( m_vecMax.y, bound.m_vecMax.y );
		Result.m_vecMax.z = Math.max( m_vecMax.z, bound.m_vecMax.z );
		
		Result.m_vecMin.x = Math.min( m_vecMin.x, bound.m_vecMin.x );
		Result.m_vecMin.y = Math.min( m_vecMin.y, bound.m_vecMin.y );
		Result.m_vecMin.z = Math.min( m_vecMin.z, bound.m_vecMin.z );
		
		return ( Result );
	}
	
	
	/**
	 * ݂̃oEh̃oEhƔrāAgB
	 * 
	 * @param bound@Bound̒ǉCqBound
	 * @return@gƂ̎gԂ
	 */
	public    CqBound	Encapsulate( final CqBound bound )
	{
		m_vecMax.x = Math.max( m_vecMax.x, bound.m_vecMax.x );
		m_vecMax.y = Math.max( m_vecMax.y, bound.m_vecMax.y );
		m_vecMax.z = Math.max( m_vecMax.z, bound.m_vecMax.z );
		
		m_vecMin.x = Math.min( m_vecMin.x, bound.m_vecMin.x );
		m_vecMin.y = Math.min( m_vecMin.y, bound.m_vecMin.y );
		m_vecMin.z = Math.min( m_vecMin.z, bound.m_vecMin.z );
		
		return( this );
	}
	
	/**
	 * ݂̃oEhCqVector3DƔrāAgB
	 * 
	 * @param v g邽߂̓_̃f[^
	 * @return@gƂ̎gԂ
	 */
	public    CqBound	Encapsulate( final CqVector3D v )
	{
		m_vecMax.x = Math.max( m_vecMax.x, v.x );
		m_vecMax.y = Math.max( m_vecMax.y, v.y );
		m_vecMax.z = Math.max( m_vecMax.z, v.z );
		
		m_vecMin.x = Math.min( m_vecMin.x, v.x );
		m_vecMin.y = Math.min( m_vecMin.y, v.y );
		m_vecMin.z = Math.min( m_vecMin.z, v.z );
		
		return( this );
	}
	
	/**
	 * ݂̃oEhCqVecto2DƔrāAgB
	 * @param v@g邽߂̓_̃f[^
	 * @return@gƂ̎gԂ
	 */
	public    CqBound	Encapsulate( final CqVector2D v )
	{
		m_vecMax.x = Math.max( m_vecMax.x, v.x );
		m_vecMax.y = Math.max( m_vecMax.y, v.y );
		
		m_vecMin.x = Math.min( m_vecMin.x, v.x );
		m_vecMin.y = Math.min( m_vecMin.y, v.y );
		
		return( this );
	}
	
	/**
	 * Ŏw肳ꂽCqVector3D̓_oEh̒ɂ邩𔻒肷B
	 * @param v@ΏۂƂȂCqVector3D̓_̃f[^
	 * @return@ɂ邩ǂԂB
	 */
	public    boolean	Contains3D( final CqVector3D v )
	{
		if ( ( v.x >= m_vecMin.x && v.x <= m_vecMax.x ) &&
				( v.y >= m_vecMin.y && v.y <= m_vecMax.y ) &&
				( v.z >= m_vecMin.z && v.z <= m_vecMax.z ) )
			return ( true );
		else
			return ( false );
	}
	/**
	 * Ŏw肳ꂽCqVector2D̓_oEh̒ɂ邩𔻒肷B
	 * @param v@ΏۂƂȂCqVector2D̓_̃f[^
	 * @return@ɂ邩ǂԂB
	 */
	public    boolean	Contains2D( final CqVector2D v ) 
	{
		if ( ( v.x < m_vecMin.x || v.x > m_vecMax.x ) ||
				( v.y < m_vecMin.y || v.y > m_vecMax.y ) )
			return ( false );
		else
			return ( true );
	}
	
//	----------------------------------------------------------------------
//	/** Outputs a bound to an output stream.
//	* o̓Xg[ɃoEho͂܂B
//	* param Stream Stream to output the matrix to.
//	* \param Bound The bound to output.
//	* \return The new state of Stream.
//	*/
//	public    friend std::ostream &operator<<( std::ostream &Stream, const CqBound &Bound );
//	{
//	CqVector3D min = Bound.vecMin();
//	CqVector3D max = Bound.vecMax();
//	CqVector3D cross = Bound.vecCross();
//	
//	Stream << min << "-->" << max << "  |  Cross: " << cross << std::ends;
//	return ( Stream );
//	}
	
	/**
	 * o̓Xg[ɃoEho͂܂B
	 * 
	 * 
	 * @return@VXg[ԂB
	 */
	public String toString()
	{
		CqVector3D min = this.vecMin();
		CqVector3D max = this.vecMax();
		CqVector3D cross = this.vecCross();
		String ret = new String(min.toString() + "-->" + max.toString() + "  |  Cross: " + cross.toString() );
		
		return ret;
	}
	
	
	
	
	private    CqVector3D	m_vecMin = new CqVector3D();
	private    CqVector3D	m_vecMax = new CqVector3D();
}
