/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.display;

import static net.cellcomputing.himawari.library.RiGlobal.QGetRenderContext;

import java.awt.image.BufferedImage;

import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;

/**
 * @author NTT DATA Corporation
 * ̋ǗNX
 */
public strictfp class ZFileImage extends ImageData<float[][]> {
	
	/**
	 * RXgN^
	 * 2006/11/10 offsetpύX
	 */
	protected ZFileImage(int offset){
		super(offset);			// 2006/11/10 offsetpύX
	}
	/**
	 * Zframebufferp̃C[Wf[^
	 */
	private BufferedImage zImage;
	
	/**
	 * zframebufferppixelf[^TCY
	 */
	public final int DATA_SIZE = 3;
	/**
	 * ő̐[x
	 */
	private float max_depth = RiGlobal.RI_FLOATMIN;
	
	/**
	 * ŏ̐[x
	 */
	private float min_depth = RiGlobal.RI_FLOATMAX;
	
	private final float[] whiteData = {255,255,255};
	private final float[] blackData = {0,0,0};
	
	/**
	 * RGB̂ǂ̐Fŉe\邩𔻒f
	 * 
	 */
	public final int Z_COLOR = 2;
	
	/**
	 * BucketpixelColor擾A
	 * imageDataɊi[B
	 */
	public void setBucket(IqBucket pBucket) {
		if( (pBucket.Width() == 0) || (pBucket.Height() == 0) )
			return;
		int	xmin = pBucket.XOrigin();
		int	ymin = pBucket.YOrigin();
		int	xmaxplus1 = xmin + pBucket.Width();
		int	ymaxplus1 = ymin + pBucket.Height();
		
		// If completely outside the crop rectangle, don't bother sending.
		//ʂ̃G[
		if( xmaxplus1 <= QGetRenderContext().pImage().CropWindowXMin() ||
			ymaxplus1 <= QGetRenderContext().pImage().CropWindowYMin() ||
			xmin > QGetRenderContext().pImage().CropWindowXMax() ||
			ymin > QGetRenderContext().pImage().CropWindowYMax() )
			return;
		//--܂
		
		float depth;
		
		for ( int y = ymin; y < ymaxplus1; y++ )
		{
			for ( int x = xmin; x < xmaxplus1; x++ )
			{
				//`͈͂ǂ̃`FbNs
				//ʂ̃G[
				if(x < QGetRenderContext().pImage().CropWindowXMin() || y < QGetRenderContext().pImage().CropWindowYMin() ||
					x >= QGetRenderContext().pImage().CropWindowXMax() || y >= QGetRenderContext().pImage().CropWindowYMax())
					continue;
				//--܂
				depth = pBucket.Depth(x,y);
				imageData[y][x] = depth;

				//--ZFrameBufferp
				if(depth != RiGlobal.RI_FLOATMAX){
					if(depth > max_depth){
						max_depth = depth;
					}else if(min_depth > depth){
						min_depth =depth;
					}
					
					raster.setPixel(x - QGetRenderContext().pImage().CropWindowXMin() , y - QGetRenderContext().pImage().CropWindowYMin(), whiteData);
					
				}else{
					raster.setPixel(x - QGetRenderContext().pImage().CropWindowXMin() , y - QGetRenderContext().pImage().CropWindowYMin(), blackData);
				}
			
			}
		}
	}

	/**
	 * ŏ[xԂ֐
	 * @return ŏ[x
	 */
	public float getMinDepth(){
		return min_depth;
	}
	
	/**
	 * ő[xԂ֐
	 * @return ő[x
	 */
	public float getMaxDepth(){
		return max_depth;
	}

	/**
	 * [xԂ
	 * @return [x񂪊i[Ăz
	 */
	public float[][] getImage() {
		return imageData;
	}
	
	/**
	 * ZImageIuWFNgԂ
	 * @return
	 */
	public BufferedImage getZImage(){
		return zImage;
	}
	
	/** 
	 * tB[h̏sB
	 * setBucketsOɕKĂ΂KvB
	 */
	public void init() {
		super.init();
		imageData = new float[height][width];

		zImage = new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);				//image쐬
		raster = zImage.getRaster();
		this.dataSize = DATA_SIZE;			//pixel̃f[^TCY擾
		pixelData = new float[DATA_SIZE];	
	}
	

}
