/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import java.util.ArrayList;

/**
 * IvV̑sNX
 * @author NTT DATA Corporation
 */
strictfp abstract class OptionHandler {
	/**
	 * IvV̗p@bZ[W
	 */
	public String usage;
	/**
	 * IvV̓͏
	 */
	public int separator;
	/**
	 * IvV̏ڍ׃p[^
	 */
	public int count;
	/**
	 * l[IvV
	 */
	public ArrayList<String> aliases = new ArrayList<String>();

	/**
	 * l^RXgN^
	 * @param usage_in	p@bZ[W
	 */
	public OptionHandler(String usage_in)
	{
		this(usage_in, -1, -1);
	}
	
	/**
	 * l^RXgN^
	 * @param usage_in	p@bZ[W
	 * @param separator_in	IvV͏
	 */
	public OptionHandler(String usage_in,int separator_in)
	{
		this(usage_in, separator_in, -1);
	}
	
	/**
	 * lO^RXgN^
	 * @param usage_in	p@bZ[W
	 * @param separator_in	IvV͏
	 * @param count_in	ڍ׃p[^̐
	 */
	public OptionHandler(String usage_in,int separator_in, int count_in)
	{
		usage = usage_in;
		separator = separator_in;
		count = count_in;
		return ;
	}
	
	/**
	 *@fXgN^ 
	 */
	public void destruct()
	{
//		fXgN^
	}
	
	/**
	 * IvṼp[^̗L̔B<br>
	 * Ap[^boolean^̏ꍇ̂FlagHandlerNX<br>
	 * I[o[ChB
	 * @return@true
	 */
	public boolean takesarg()
	{
//		This is the@same thing as saying it returns false if the option is a flag.
//		(The implementation in the base class returns true, so we
//		only have to override it for FlagHandler.)
//		IvVp[^𔺂ꍇAtrueԂB
//		lɁAIvṼp[^boolean^̏ꍇfalseԂB(FlagHandlerNXŃI[o[Ch)
		
		return true;
	}

	/** 
	 * IvV̔ےԂ𔻒B@(FlagHandlerNXŃI[o[Ch)<br>
	 * (F@-noFoo ̂悤"no"ꍇtrue)
	 * @return@false
	 */
	public boolean allownegation() 
	{
//		 Returns true if we can stick "no" in front of the option.
//	     This will be false for everything except flag, and might be
//	     true or false for flag.
//	    (The implementation in the base class returns false, so we
//	     only have to override it for FlagHandler.)
//		 IvV̑O"no"邱ƂłꍇAtrue
//		 ܂AIvVp[^boolean^ȊO͑SfalseԂB
//		 IvVp[^boolean^̏ꍇ́Atrue / false@ǂ肤B(FlagHandlerNXQ)
		return false;
	}
	
	/**
	 * ȂB<br>
	 * hNXQƁB
	 */
	public void reset()
	{
	}
	
	/**
	 * IvV̓͌`ԁAyт̗L𔻒fB
	 * @param	arg	IvV̏ڍ׃p[^
	 * @param	prefix	IvV
	 * @return	""
	 * @return	prefix + ":" + ret
	 */
//	This is a wrapper for handlearg() which first splits up the
//	 argument according to "separator".  As an additional, unrelated
//	 function, it also will append "prefix" to any non-empty error message.
	
//	ǉĂ֌WȂ@\FG[bZ[WɁiꂪłj̓IvV}B
	public String handleargsplit(String arg, String prefix)
	{
		//p[^̏ꍇ
		if (separator < 0) 
		{
			String ret = handlearg(arg);
			if( ret.length() == 0 )
				return "";
			return prefix + ": " + ret;
		}
		
		for (int i = 0; i < arg.length(); i++) 
		{
			int newi = arg.indexOf(separator, i);
			if (newi < 0)
				newi = arg.length();
			String ret = handlearg(arg.substring(i, newi - i));
			if (ret.length() != 0) 
				return prefix + ": " + ret;
			i = newi;
		}
		return "";
	}
//	Okay, this is the point in the file where it starts getting
//	pretty repetitive.  I'm sure there's a better way I could've
//	done this...   

	/**
	 * ͂ꂽIvV̗L𔻒fB
	 * IvV̏ڍ׃p[^oB<br>
	 *@͂ȂBhNXQƁB
	 * @param arg	
	 * @return	ɑ΂郁bZ[W
	 */
//	 Takes an argument and sticks it somewhere.  Returns the empty
//	 string on success, or an error message on failure.  If
//	 takesarg() is false, then arg is either "no" or the empty string.
	abstract protected String handlearg(String arg);
//	 parseInt()/parseFloat() ɈnAԂl󕶎ȂΗLAG[bZ[WȂΖB<br>
//	 Atakesarg()falseȂ΁A""no"󕶎̂ǂ炩łB<br>

}
