/* Simple argument-parsing class
 * Copyright (C) 2001 Patrick E. Pelletier <ppelleti@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.argparse;

import java.util.ArrayList;
import java.util.HashMap;
import net.cellcomputing.himawari.accessory.Pair;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;


/**
 * IvVɊւf[^ǗE񋟂NX
 * @author NTT DATA Corporation
 */
strictfp class ArgParseInternalData 
{
	public boolean allowOneCharOptionsToBeCombined;
	public boolean allowUnrecognizedOptions;
	public String errmsg;
	public STLVector<String> leftovers = new STLVector<String>( String.class );
	public HashMap<String, OptionHandler> options = new HashMap<String, OptionHandler>();
	public HashMap<String, String> aliases = new HashMap<String, String>();
	public ArrayList<Pair<Integer , String>> usage = new ArrayList<Pair<Integer, String>>();

	/**
	 * XgɃIvVǉB
	 * @param name	IvV
	 * @param oh	IvV̏ڍ
	 */
	public void addOption(String name, OptionHandler oh)
	{
		if(options.get(name) != null){
	        /* Okay, they registered the same option name twice.
	         * We don't have a good way to handle this error.
	         * We could throw an exception, or we could just
	         * ignore it.  I'm going to pick the latter. */
			//IvV2o^ꍇA邱Ƃɂ
			oh.destruct();
		} 
		else {
			options.put(name, oh);
			Pair<Integer,String> tmp = new Pair<Integer, String>(-1, name);
		    usage.add(tmp);
		}
	}
	
	
	/**
	 *	IvVf[^񋟂B (GCAX@\Ή)
	 * @param name	IvV
	 * @param no	"no"̗L
	 * @return	foundoption, oh, null
	 */
	public OptionHandler findOption(String name, p_boolean no)
	{
		String foundalias = aliases.get(name);	
	    String newname = name;
	    
	    if (foundalias != null){
	    	newname = foundalias;
	    }
	    
	    no.value = false;
	    OptionHandler foundoption = options.get(newname);
	    
	    if (foundoption != null){
	        return foundoption;
	    }

//	    if (newname.substring(0, 2).equals("no")) {
	    if( newname.startsWith("no") ){
	    	foundoption = options.get(newname.substring(2));
	    	
	        if (foundoption != null) {        
	        	OptionHandler oh = foundoption;
	        	
	            if (oh.allownegation()) {
	                no.value = true;
	                return oh;
	            }
	        }
	    }
	    return null;
	}
}
