/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.accessory;

import java.io.Serializable;

/**
 * 
 * valarrayNX
 * 
 * @author NTT DATA Corporation
 */
public strictfp class Valarray implements Serializable {

	private static final long serialVersionUID = 22387720686191143L;
	
	private float[] array;

	
	
	public Valarray() {
		array = new float[0];
	}
	
	public Valarray( int size ){
		array = new float[size];
	}
	
	public Valarray( float def,int size ){
		array = new float[size];
		for( int i=0; i<size; i++ ){
			array[i] = def;
		}
	}
	
	public Valarray( Valarray from ){
		array = new float[ from.array.length ];
		for( int i=0; i<array.length; i++ ){
			array[i] = from.array[i];
		}
	}
	
	public int size(){
		return array.length;
	}
	
	public void resize( int size, float def ){
		array = new float[size];
		for( int i=0; i<size; i++ ){
			array[i] = def;
		}
	}
	
	public void resize( int size ){
		array = new float[size];
	}
	
	public float valueAt( int index ){
		assert( index < array.length );
		
		return array[index];
	}
	
	public void setValueAt( int index, float val ){
		assert( index < array.length );
		
		array[index] = val;
	}
	
	
	public void assignment( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] = val.array[i];
		}
	}
	
	public void assignment( float val ){
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] = val;
		}
	}
	
	public void assignAdd( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] += val.array[i];
		}
	}
	
	public void assignAdd( float val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] += val;
		}
	}
	
	public void assignSub( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] -= val.array[i];
		}
	}
	
	public void assignSub( float val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] -= val;
		}
	}
	
	public void assignMul( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] *= val.array[i];
		}
	}
	
	public void assignMul( float val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] *= val;
		}
	}
	
	public void assignDiv( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] /= val.array[i];
		}
	}
	
	public void assignDiv( float val ){
		
		int size = array.length;
		for( int i=0; i<size; i++ ){
			this.array[i] /= val;
		}
	}
	
	public Valarray add( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] + val.array[i];
		}
		
		return ret;
	}
	
	public Valarray add( float val ){
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] + val;
		}
		
		return ret;
	}
	
	public Valarray sub( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] - val.array[i];
		}
		
		return ret;
	}
	
	public Valarray sub( float val ){
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] - val;
		}
		
		return ret;
	}
	
	public Valarray mul( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] * val.array[i];
		}
		
		return ret;
	}
	
	public Valarray mul( float val ){
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] * val;
		}
		
		return ret;
	}
	
	public Valarray div( Valarray val ){
		assert( this.size() == val.size() );
		
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] / val.array[i];
		}
		
		return ret;
	}
	
	public Valarray div( float val ){
		int size = array.length;
		
		Valarray ret = new Valarray( size );
		for( int i=0; i<size; i++ ){
			ret.array[i] = this.array[i] / val;
		}
		
		return ret;
	}
	
	
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		
		String str = "[";
		for( int i=0; i<array.length-1; i++ )		str = str.concat(String.valueOf(array[i])+", ");
		str = str.concat(String.valueOf(array[array.length-1])+"]");
		
		return str;
	}
	
	
	
}
