/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.parser;

import java.util.HashMap;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.parser.Parser;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class Global {
    public static STLVector<Integer> FrameList = new STLVector<Integer>(Integer.class);
    public static HashMap<Integer, Object> LightMap = new HashMap();
    public static HashMap<String, Object> LightMapString = new HashMap();
    public static HashMap<Integer, Object> ObjectMap = new HashMap();
    public static HashMap<String, Object> ObjectMapString = new HashMap();
    private static HashMap<String, EqVariableType> TypeMap = new HashMap();
    private static HashMap<String, Integer> ValueMap = new HashMap();
    private static HashMap<String, Boolean> TipMap = new HashMap();
    static /* synthetic */ Class class$0;

    public static void StandardDeclarations() {
        int i = 0;
        while (RendermanInterface.StandardParameters[i][0] != null) {
            String name = RendermanInterface.StandardParameters[i][0];
            String type = RendermanInterface.StandardParameters[i][1];
            Parser.ParserDeclare(name, type);
            ++i;
        }
    }

    public static boolean IsFrameSkipped(int number) {
        if (FrameList.size() == 0) {
            return false;
        }
        if (FrameList.size() <= number) {
            return true;
        }
        return (Integer)FrameList.get(number) == 0;
    }

    public static void ClearFrames() {
        FrameList.clear();
    }

    public static int AppendFrames(String frames) {
        int n = 0;
        int length = frames.length();
        p_int endptr = new p_int();
        int nptr = 0;
        while (n < length) {
            int f1 = Global.strtol(frames.substring(nptr), endptr);
            if (endptr.value != 0) {
                n += endptr.value;
                if (endptr.value < length && frames.charAt(endptr.value) == '-') {
                    nptr = endptr.value + 1;
                    ++n;
                    int f2 = Global.strtol(frames.substring(nptr), endptr);
                    if (endptr.value == 0) continue;
                    n += endptr.value;
                    if (FrameList.size() <= Math.max(f1, f2)) {
                        FrameList.resize(Math.max(f1, f2) + 1);
                    }
                    int start = Math.min(f1, f2);
                    int end = Math.max(f1, f2);
                    if (start < 0) {
                        HimawariLogger logger = HimawariLogger.getLogger();
                        logger.error("Invalid frame number " + start + " was specified. \n");
                        continue;
                    }
                    int i = start;
                    while (i <= end) {
                        FrameList.set(i, 1);
                        ++i;
                    }
                    nptr = endptr.value;
                    continue;
                }
                if (f1 < 0) {
                    HimawariLogger logger = HimawariLogger.getLogger();
                    logger.error("Invalid frame number " + f1 + " was specified. \n");
                    FrameList.resize(1);
                    continue;
                }
                if (FrameList.size() <= f1) {
                    FrameList.resize(f1 + 1);
                }
                FrameList.set(f1, 1);
                nptr += endptr.value;
                continue;
            }
            if (frames.charAt(nptr + endptr.value) == ',') {
                ++n;
                ++nptr;
                continue;
            }
            return -1;
        }
        return 0;
    }

    private static int strtol(String str, p_int endpos) {
        int length;
        int ret = 0;
        String p = str.trim();
        String ch = "";
        int end_index = length = p.length();
        int start_index = 0;
        boolean sign_found = false;
        int i = 0;
        while (i < length) {
            ch = p.substring(i, i + 1);
            if (ch.matches("[0-9]") || !sign_found && ch.equals("-")) {
                if (!sign_found) {
                    sign_found = true;
                    start_index = i;
                }
            } else {
                if (!sign_found) break;
                end_index = i;
                break;
            }
            ++i;
        }
        try {
            ret = Integer.parseInt(p.substring(start_index, end_index));
            endpos.value = start_index + end_index;
            int sp_index = str.indexOf(32);
            if (sp_index != -1 && sp_index < end_index) {
                endpos.value += sp_index + 1;
            }
            return ret;
        }
        catch (NumberFormatException e) {
            endpos.value = 0;
            return 0;
        }
    }

    public static void DeclareLightHandle(int ID, Object Handle) throws Exception {
        if (Handle == null) {
            throw new Exception("NULL Light Handle");
        }
        LightMap.put(ID, Handle);
    }

    public static Object LookupLightHandle(int ID) throws Exception {
        Object handler = LightMap.get(ID);
        if (handler == null) {
            throw new Exception("Undeclared Light ID");
        }
        return handler;
    }

    public static void DeclareLightHandleString(String ID, Object Handle) throws Exception {
        if (Handle == null) {
            throw new Exception("NULL Light Handle");
        }
        LightMapString.put(ID, Handle);
    }

    public static Object LookupLightHandleString(String ID) throws Exception {
        Object handler = LightMapString.get(ID);
        if (handler == null) {
            throw new Exception("Undeclared Light name");
        }
        return handler;
    }

    public static void DeclareObjectHandle(int ID, Object Handle) throws Exception {
        if (Handle == null) {
            throw new Exception("NULL Object Handle");
        }
        ObjectMap.put(ID, Handle);
    }

    public static Object LookupObjectHandle(int ID) throws Exception {
        Object handler = ObjectMap.get(ID);
        if (handler == null) {
            throw new Exception("Undeclared Object ID");
        }
        return handler;
    }

    public static void DeclareObjectHandleString(String ID, Object Handle) throws Exception {
        if (Handle == null) {
            throw new Exception("NULL Object Handle");
        }
        ObjectMapString.put(ID, Handle);
    }

    public static Object LookupObjectHandleString(String ID) throws Exception {
        Object handler = ObjectMapString.get(ID);
        if (handler == null) {
            throw new Exception("Undeclared Object name");
        }
        return handler;
    }

    public static EqVariableType DeclareParameterType(String Name, String Type2) {
        if (Name == null || Name.length() == 0) {
            HimawariLogger.getLogger().error("Cannot Declare Unnamed Type\n");
        }
        EqVariableType type = Parser.ParseParameterType(Type2);
        if (Global.DeclareParameterValue(Name) <= 0) {
            return new EqVariableType(0);
        }
        if (type.getValue() != 0) {
            TypeMap.put(Name, type);
        }
        return type;
    }

    public static EqVariableType LookupParameterType(String name) {
        if (name == null || name.length() == 0) {
            HimawariLogger.getLogger().error("Cannot Lookup Unnamed Type\n");
            return new EqVariableType(0);
        }
        EqVariableType type = TypeMap.get(name);
        if (type != null) {
            return type;
        }
        return Parser.ParseParameterType(name);
    }

    public static int DeclareParameterValue(String Name) {
        int size = Parser.getParameterSize();
        if (size > 0) {
            ValueMap.put(Name, size);
            Global.DeclareParameterTip(Name);
        }
        return size;
    }

    public static int LookupParameterValue(String name) {
        if (name == null || name.length() == 0) {
            HimawariLogger.getLogger().error("Cannot Lookup Unnamed Value\n");
            return -1;
        }
        Integer value = ValueMap.get(name);
        if (value != null) {
            return value;
        }
        return Parser.getParameterSize();
    }

    private static void DeclareParameterTip(String Name) {
        TipMap.put(Name, Parser.getParameterTip());
    }

    public static boolean LookupParameterTip(String name) {
        Boolean tip = TipMap.get(name);
        if (tip != null) {
            return tip;
        }
        return Parser.getParameterTip();
    }

    public static void CleanupDeclarations() {
        Global.ClearDeclarations();
    }

    private static void ClearDeclarations() {
        TypeMap.clear();
    }

    public static String GetFilterFunction(String type) {
        if (type.equals("box")) {
            return "RiBoxFilter";
        }
        if (type.equals("gaussian")) {
            return "RiGaussianFilter";
        }
        if (type.equals("triangle")) {
            return "RiTriangleFilter";
        }
        if (type.equals("catmull-rom")) {
            return "RiCatmullRomFilter";
        }
        if (type.equals("sinc")) {
            return "RiSincFilter";
        }
        if (type.equals("bessel")) {
            return "RiBesselFilter";
        }
        if (type.equals("disk")) {
            return "RiDiskFilter";
        }
        return "RiBoxFilter";
    }
}

