/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqColor {
    public float m_fRed;
    public float m_fGreen;
    public float m_fBlue;
    private static final float UNDEFINED = -1.0f;
    private static final float Small_Value = 1.0E-7f;
    private static final CqMatrix matRGBtoYIQ1 = new CqMatrix(0.299f, 0.587f, 0.114f, 0.0f, 0.596f, -0.274f, -0.322f, 0.0f, 0.212f, -0.523f, 0.311f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    private static final CqMatrix matRGBtoYIQ2 = new CqMatrix(1.0f, 0.956f, 0.621f, 0.0f, 1.0f, -0.272f, -0.647f, 0.0f, 1.0f, -1.105f, 1.702f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);

    public CqColor() {
        this.m_fRed = 0.0f;
        this.m_fGreen = 0.0f;
        this.m_fBlue = 0.0f;
    }

    public CqColor(float fRed, float fGreen, float fBlue) {
        this.m_fRed = fRed;
        this.m_fGreen = fGreen;
        this.m_fBlue = fBlue;
    }

    public CqColor(float f) {
        this.m_fRed = f;
        this.m_fGreen = f;
        this.m_fBlue = f;
    }

    public CqColor(CqVector3D From) {
        this.m_fRed = From.x;
        this.m_fGreen = From.y;
        this.m_fBlue = From.z;
    }

    public CqColor(float[] From) {
        this.m_fRed = From[0];
        this.m_fGreen = From[1];
        this.m_fBlue = From[2];
    }

    public CqColor(CqColor From) {
        this.m_fRed = From.m_fRed;
        this.m_fGreen = From.m_fGreen;
        this.m_fBlue = From.m_fBlue;
    }

    public float fRed() {
        return this.m_fRed;
    }

    public float fGreen() {
        return this.m_fGreen;
    }

    public float fBlue() {
        return this.m_fBlue;
    }

    public void SetfRed(float fRed) {
        this.m_fRed = fRed;
    }

    public void SetfGreen(float fGreen) {
        this.m_fGreen = fGreen;
    }

    public void SetfBlue(float fBlue) {
        this.m_fBlue = fBlue;
    }

    public void GetColorRGB(p_float pfRed, p_float pfGreen, p_float pfBlue) {
        pfRed.value = this.m_fRed;
        pfGreen.value = this.m_fGreen;
        pfBlue.value = this.m_fBlue;
    }

    public void SetColorRGB(float fRed, float fGreen, float fBlue) {
        this.m_fRed = fRed;
        this.m_fGreen = fGreen;
        this.m_fBlue = fBlue;
    }

    public void Clamp() {
        if ((double)this.m_fRed > 1.0) {
            this.m_fRed = 1.0f;
        }
        if ((double)this.m_fGreen > 1.0) {
            this.m_fGreen = 1.0f;
        }
        if ((double)this.m_fBlue > 1.0) {
            this.m_fBlue = 1.0f;
        }
        if ((double)this.m_fRed < 0.0) {
            this.m_fRed = 0.0f;
        }
        if ((double)this.m_fGreen < 0.0) {
            this.m_fGreen = 0.0f;
        }
        if ((double)this.m_fBlue < 0.0) {
            this.m_fBlue = 0.0f;
        }
    }

    public CqColor rgbtohsv() {
        float R = this.m_fRed;
        float G = this.m_fGreen;
        float B = this.m_fBlue;
        float H = -1.0f;
        float max = Math.max(this.m_fRed, this.m_fGreen);
        max = Math.max(max, this.m_fBlue);
        float min = Math.min(this.m_fRed, this.m_fGreen);
        min = Math.min(min, this.m_fBlue);
        float diff = max - min;
        float V = max;
        float S = max != 0.0f ? diff / max : 0.0f;
        if (S == 0.0f) {
            H = -1.0f;
        } else {
            float r_dist = (max - R) / diff;
            float g_dist = (max - G) / diff;
            float b_dist = (max - B) / diff;
            if (R == max) {
                H = b_dist - g_dist;
            } else if (G == max) {
                H = 2.0f + r_dist - b_dist;
            } else if (B == max) {
                H = 4.0f + g_dist - r_dist;
            }
            H *= 60.0f;
            if (H < 0.0f) {
                H += 360.0f;
            }
        }
        return new CqColor(H / 360.0f, S, V);
    }

    public CqColor rgbtohsl() {
        float H = -1.0f;
        float S = 0.0f;
        float R = this.m_fRed;
        float G = this.m_fGreen;
        float B = this.m_fBlue;
        float max = Math.max(R, G);
        max = Math.max(max, B);
        float min = Math.min(R, G);
        min = Math.min(min, B);
        float diff = max - min;
        float L = (max + min) / 2.0f;
        if (Math.abs(diff) <= 1.0E-7f) {
            L = 0.0f;
            H = -1.0f;
        } else {
            S = L < 0.5f ? diff / (max + min) : diff / (2.0f - max - min);
            float r_dist = (max - R) / diff;
            float g_dist = (max - G) / diff;
            float b_dist = (max - B) / diff;
            if (R == max) {
                H = b_dist - g_dist;
            } else if (G == max) {
                H = 2.0f + r_dist - b_dist;
            } else if (B == max) {
                H = 4.0f + g_dist - r_dist;
            }
            H *= 60.0f;
            if (H < 0.0f) {
                H += 360.0f;
            }
        }
        return new CqColor(H / 360.0f, S, L);
    }

    public CqColor rgbtoXYZ() {
        CqColor c = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return c;
    }

    public CqColor rgbtoxyY() {
        CqColor c = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return c;
    }

    public CqColor rgbtoYIQ() {
        CqColor c = new CqColor(matRGBtoYIQ1.multiply(new CqVector3D(this.m_fRed, this.m_fGreen, this.m_fBlue)));
        return c;
    }

    public CqColor hsvtorgb() {
        float H = this.m_fRed * 360.0f;
        float S = this.m_fGreen;
        float V = this.m_fBlue;
        float R = 0.0f;
        float G = 0.0f;
        float B = 0.0f;
        if ((double)S == 0.0) {
            assert (H < 0.0f);
            G = B = V;
            R = B;
        } else {
            if (H == 360.0f) {
                H = 0.0f;
            }
            int i = (int)Math.floor(H /= 60.0f);
            float f = H - (float)i;
            float p = V * (1.0f - S);
            float q = V * (1.0f - S * f);
            float t = V * (1.0f - S * (1.0f - f));
            switch (i) {
                case 0: {
                    R = V;
                    G = t;
                    B = p;
                    break;
                }
                case 1: {
                    R = q;
                    G = V;
                    B = p;
                    break;
                }
                case 2: {
                    R = p;
                    G = V;
                    B = t;
                    break;
                }
                case 3: {
                    R = p;
                    G = q;
                    B = V;
                    break;
                }
                case 4: {
                    R = t;
                    G = p;
                    B = V;
                    break;
                }
                case 5: {
                    R = V;
                    G = p;
                    B = q;
                }
            }
        }
        return new CqColor(R, G, B);
    }

    public CqColor hsltorgb() {
        float R;
        float G;
        float B;
        float H = this.m_fRed * 360.0f;
        float S = this.m_fGreen;
        float L = this.m_fBlue;
        float m2 = (double)L <= 0.5 ? L * (1.0f + S) : L + S - L * S;
        float m1 = 2.0f * L - m2;
        if (S == 0.0f) {
            assert (this.m_fRed < 0.0f);
            G = B = L;
            R = B;
        } else {
            R = CqColor.HSLValue(m1, m2, H + 120.0f);
            G = CqColor.HSLValue(m1, m2, H);
            B = CqColor.HSLValue(m1, m2, H - 120.0f);
        }
        return new CqColor(R, G, B);
    }

    public CqColor XYZtorgb() {
        CqColor c = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return c;
    }

    public CqColor xyYtorgb() {
        CqColor c = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return c;
    }

    public CqColor YIQtorgb() {
        CqColor c = new CqColor(matRGBtoYIQ2.multiply(new CqVector3D(this.m_fRed, this.m_fGreen, this.m_fBlue)));
        return c;
    }

    private static float HSLValue(float n1, float n2, float hue) {
        if (hue > 360.0f) {
            hue -= 360.0f;
        } else if (hue < 0.0f) {
            hue += 360.0f;
        }
        float Value = hue < 60.0f ? n1 + (n2 - n1) * hue / 60.0f : (hue < 180.0f ? n2 : (hue < 240.0f ? n1 + (n2 - n1) * (240.0f - hue) / 60.0f : n1));
        return Value;
    }

    public float valueAt(int i) {
        if (i == 0) {
            return this.m_fRed;
        }
        if (i == 1) {
            return this.m_fGreen;
        }
        return this.m_fBlue;
    }

    public void setValueAt(int i, float col) {
        if (i == 0) {
            this.m_fRed = col;
        } else if (i == 1) {
            this.m_fGreen = col;
        } else {
            this.m_fBlue = col;
        }
    }

    public CqColor assignment(float r, float g, float b) {
        this.m_fRed = r;
        this.m_fGreen = g;
        this.m_fBlue = b;
        return this;
    }

    public CqColor assignment(CqVector3D From) {
        this.m_fRed = From.x;
        this.m_fGreen = From.y;
        this.m_fBlue = From.z;
        return this;
    }

    public CqColor assignment(CqColor From) {
        this.m_fRed = From.m_fRed;
        this.m_fGreen = From.m_fGreen;
        this.m_fBlue = From.m_fBlue;
        return this;
    }

    public CqColor assignAdd(CqColor colFrom) {
        this.m_fRed += colFrom.m_fRed;
        this.m_fGreen += colFrom.m_fGreen;
        this.m_fBlue += colFrom.m_fBlue;
        return this;
    }

    public CqColor assignSub(CqColor colFrom) {
        this.m_fRed -= colFrom.m_fRed;
        this.m_fGreen -= colFrom.m_fGreen;
        this.m_fBlue -= colFrom.m_fBlue;
        return this;
    }

    public CqColor assignMul(CqColor colFrom) {
        this.m_fRed *= colFrom.m_fRed;
        this.m_fGreen *= colFrom.m_fGreen;
        this.m_fBlue *= colFrom.m_fBlue;
        return this;
    }

    public CqColor assignDiv(CqColor colFrom) {
        this.m_fRed /= colFrom.m_fRed;
        this.m_fGreen /= colFrom.m_fGreen;
        this.m_fBlue /= colFrom.m_fBlue;
        return this;
    }

    public CqColor assignAdd(float fScale) {
        this.m_fRed += fScale;
        this.m_fGreen += fScale;
        this.m_fBlue += fScale;
        return this;
    }

    public CqColor assignSub(float fScale) {
        this.m_fRed -= fScale;
        this.m_fGreen -= fScale;
        this.m_fBlue -= fScale;
        return this;
    }

    public CqColor assignMul(float fScale) {
        this.m_fRed *= fScale;
        this.m_fGreen *= fScale;
        this.m_fBlue *= fScale;
        return this;
    }

    public CqColor assignDiv(float fScale) {
        this.m_fRed /= fScale;
        this.m_fGreen /= fScale;
        this.m_fBlue /= fScale;
        return this;
    }

    public boolean equals(CqColor colCmp) {
        return this.m_fRed == colCmp.m_fRed && this.m_fGreen == colCmp.m_fGreen && this.m_fBlue == colCmp.m_fBlue;
    }

    public boolean ge(CqColor colCmp) {
        return this.m_fRed >= colCmp.m_fRed && this.m_fGreen >= colCmp.m_fGreen && this.m_fBlue >= colCmp.m_fBlue;
    }

    public boolean le(CqColor colCmp) {
        return this.m_fRed <= colCmp.m_fRed && this.m_fGreen <= colCmp.m_fGreen && this.m_fBlue <= colCmp.m_fBlue;
    }

    public boolean gt(CqColor colCmp) {
        return this.m_fRed > colCmp.m_fRed && this.m_fGreen > colCmp.m_fGreen && this.m_fBlue > colCmp.m_fBlue;
    }

    public boolean lt(CqColor colCmp) {
        return this.m_fRed < colCmp.m_fRed && this.m_fGreen < colCmp.m_fGreen && this.m_fBlue < colCmp.m_fBlue;
    }

    public CqColor add(float f) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignAdd(f);
    }

    public CqColor sub(float f) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignSub(f);
    }

    public CqColor subInv(float f) {
        CqColor r = new CqColor(f, f, f);
        return r.assignSub(this);
    }

    public CqColor mul(float f) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignMul(f);
    }

    public CqColor div(float f) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignDiv(f);
    }

    public CqColor divInv(float f) {
        CqColor r = new CqColor(f, f, f);
        return r.assignDiv(this);
    }

    public CqColor add(CqColor b) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignAdd(b);
    }

    public CqColor sub(CqColor b) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignSub(b);
    }

    public CqColor mul(CqColor b) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignMul(b);
    }

    public CqColor div(CqColor b) {
        CqColor r = new CqColor(this.m_fRed, this.m_fGreen, this.m_fBlue);
        return r.assignDiv(b);
    }

    public CqColor negate() {
        return new CqColor(-this.m_fRed, -this.m_fGreen, -this.m_fBlue);
    }

    public String toString() {
        return "( red:" + this.m_fRed + " green:" + this.m_fGreen + " blue:" + this.m_fBlue + " )";
    }
}

