/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.cache.RiCacheBase;

public strictfp class RiCurvesCache
extends RiCacheBase {
    private String m_type;
    private int m_ncurves;
    private int[] m_nvertices;
    private String m_wrap;

    public RiCurvesCache(String type, int ncurves, int[] nvertices, String wrap, int count, String[] tokens, Object[] values) {
        this.m_type = new String(type);
        this.m_ncurves = ncurves;
        int __nvertices_length = ncurves;
        this.m_nvertices = new int[__nvertices_length];
        int __nvertices_index = 0;
        while (__nvertices_index < __nvertices_length) {
            this.m_nvertices[__nvertices_index] = nvertices[__nvertices_index];
            ++__nvertices_index;
        }
        this.m_wrap = new String(wrap);
        int constant_size = 1;
        int uniform_size = 1;
        int varying_size = 1;
        int vertex_size = 1;
        int facevarying_size = 1;
        uniform_size = ncurves;
        varying_size = 0;
        int __i = 0;
        while (__i < __nvertices_length) {
            if (type.compareTo("cubic") == 0) {
                int step = RiGlobal.QGetRenderContext().pattrCurrent().GetIntegerAttribute("System", "BasisStep")[0];
                varying_size = wrap.compareTo("periodic") == 0 ? (varying_size += nvertices[__i] / step) : (varying_size += (nvertices[__i] - 4) / step + 1);
            } else {
                varying_size = wrap.compareTo("periodic") == 0 ? (varying_size += nvertices[__i]) : (varying_size += nvertices[__i] - 1);
            }
            ++varying_size;
            ++__i;
        }
        vertex_size = 0;
        __i = 0;
        while (__i < ncurves) {
            vertex_size += nvertices[__i];
            ++__i;
        }
        this.CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
    }

    public void destruct() {
        super.destruct();
    }

    public void ReCall() {
        RendermanInterface.RiCurvesV(this.m_type, this.m_ncurves, this.m_nvertices, this.m_wrap, this.m_count, this.m_tokens, this.m_values);
    }
}

