/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqTrimCurve {
    protected STLVector<p_float> m_aKnots = new STLVector<p_float>(p_float.class);
    protected int m_Order;
    protected int m_cVerts;
    protected STLVector<CqVector3D> m_aVerts = new STLVector<CqVector3D>(CqVector3D.class);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CqTrimCurve() {
    }

    public CqTrimCurve(CqTrimCurve From) {
        this.assignment(From);
    }

    public void assignment(CqTrimCurve From) {
        this.m_aKnots.resize(From.cKnots());
        this.m_aVerts.resize(From.cVerts());
        int i = 0;
        while (i < From.cKnots()) {
            ((p_float)this.m_aKnots.get((int)i)).value = ((p_float)From.m_aKnots.get((int)i)).value;
            ++i;
        }
        i = 0;
        while (i < From.cVerts()) {
            ((CqVector3D)this.m_aVerts.get(i)).assignment((CqVector3D)From.m_aVerts.get(i));
            ++i;
        }
        this.m_cVerts = From.m_cVerts;
        this.m_Order = From.m_Order;
    }

    public void destract() {
    }

    public int Order() {
        return this.m_Order;
    }

    public int Degree() {
        return this.m_Order - 1;
    }

    public int cVerts() {
        return this.m_cVerts;
    }

    public int cKnots() {
        return this.m_cVerts + this.m_Order;
    }

    public STLVector<p_float> aKnots() {
        return this.m_aKnots;
    }

    public CqVector3D CP(int u) {
        return (CqVector3D)this.m_aVerts.get(u);
    }

    public void Init(int Order, int cVerts) {
        int cKnots = cVerts + Order;
        this.m_aKnots.resize(cKnots);
        this.m_aVerts.resize(cVerts);
        this.m_Order = Order;
        this.m_cVerts = cVerts;
    }

    public int FindSpan(float u) {
        if (u >= ((p_float)this.m_aKnots.get((int)this.m_cVerts)).value) {
            return this.m_cVerts - 1;
        }
        if (u <= ((p_float)this.m_aKnots.get((int)this.Degree())).value) {
            return this.Degree();
        }
        int low = 0;
        int high = this.m_cVerts + 1;
        int mid = (low + high) / 2;
        while (u < ((p_float)this.m_aKnots.get((int)mid)).value || u >= ((p_float)this.m_aKnots.get((int)(mid + 1))).value) {
            if (u < ((p_float)this.m_aKnots.get((int)mid)).value) {
                high = mid;
            } else {
                low = mid;
            }
            mid = (low + high) / 2;
        }
        return mid;
    }

    public void BasisFunctions(float u, int span, float[] BasisVals) {
        BasisVals[0] = 1.0f;
        int r = 2;
        while (r <= this.m_Order) {
            int i = span - r + 1;
            BasisVals[r - 1] = 0.0f;
            int s = r - 2;
            while (s >= 0) {
                double omega = ++i < 0 ? 0.0 : (double)((u - ((p_float)this.m_aKnots.get((int)i)).value) / (((p_float)this.m_aKnots.get((int)(i + r - 1))).value - ((p_float)this.m_aKnots.get((int)i)).value));
                BasisVals[s + 1] = (float)((double)BasisVals[s + 1] + (1.0 - omega) * (double)BasisVals[s]);
                BasisVals[s] = (float)(omega * (double)BasisVals[s]);
                --s;
            }
            ++r;
        }
    }

    public CqVector2D Evaluate(float u) {
        float[] basis = new float[this.m_Order];
        CqVector3D r = new CqVector3D(0.0f, 0.0f, 0.0f);
        int span = this.FindSpan(u);
        int first = span - this.m_Order + 1;
        this.BasisFunctions(u, span, basis);
        int j = 0;
        while (j < this.m_Order) {
            int rj = this.m_Order - 1 - j;
            float tmp = basis[rj];
            CqVector3D cp = this.CP(j + first);
            r.x += cp.x * tmp;
            r.y += cp.y * tmp;
            r.z += cp.z * tmp;
            ++j;
        }
        return new CqVector2D(r.x / r.z, r.y / r.z);
    }

    public int InsertKnot(float u, int r) {
        CqTrimCurve nS = new CqTrimCurve(this);
        int k = this.m_aKnots.size() - 1;
        int s = 0;
        int p = this.Degree();
        if (u < ((p_float)this.m_aKnots.get((int)this.Degree())).value || u > ((p_float)this.m_aKnots.get((int)this.m_cVerts)).value) {
            return 0;
        }
        int size = this.m_aKnots.size();
        int i = 0;
        while (i < size) {
            if (((p_float)this.m_aKnots.get((int)i)).value > u) {
                k = i - 1;
                break;
            }
            ++i;
        }
        if (u <= ((p_float)this.m_aKnots.get((int)k)).value) {
            s = 1;
            i = k;
            while (i > 0) {
                if (((p_float)this.m_aKnots.get((int)i)).value <= ((p_float)this.m_aKnots.get((int)(i - 1))).value) {
                    ++s;
                    --i;
                    continue;
                }
                break;
            }
        } else {
            s = 0;
        }
        if (r + s > p + 1) {
            r = p + 1 - s;
        }
        if (r <= 0) {
            return 0;
        }
        nS.Init(this.m_Order, this.m_cVerts + r);
        i = 0;
        while (i <= k) {
            ((p_float)nS.m_aKnots.get((int)i)).value = ((p_float)this.m_aKnots.get((int)i)).value;
            ++i;
        }
        i = 1;
        while (i <= r) {
            ((p_float)nS.m_aKnots.get((int)(k + i))).value = u;
            ++i;
        }
        size = this.m_aKnots.size();
        i = k + 1;
        while (i < size) {
            ((p_float)nS.m_aKnots.get((int)(i + r))).value = ((p_float)this.m_aKnots.get((int)i)).value;
            ++i;
        }
        CqVector3D[] R = new CqVector3D[p + 1];
        i = 0;
        while (i <= k - p) {
            nS.CP(i).assignment(this.CP(i));
            ++i;
        }
        size = this.m_cVerts;
        i = k - s;
        while (i < size) {
            nS.CP(i + r).assignment(this.CP(i));
            ++i;
        }
        i = 0;
        while (i <= p - s) {
            R[i] = this.CP(k - p + i);
            ++i;
        }
        int L = 0;
        int j = 1;
        while (j <= r) {
            L = k - p + j;
            int limit = p - j - s;
            i = 0;
            while (i <= limit) {
                int i1 = i + 1;
                float alpha = (u - ((p_float)this.m_aKnots.get((int)(L + i))).value) / (((p_float)this.m_aKnots.get((int)(k + i1))).value - ((p_float)this.m_aKnots.get((int)(L + i))).value);
                R[i] = new CqVector3D((float)((double)(alpha * R[i1].x) + (1.0 - (double)alpha) * (double)R[i].x), (float)((double)(alpha * R[i1].y) + (1.0 - (double)alpha) * (double)R[i].y), (float)((double)(alpha * R[i1].z) + (1.0 - (double)alpha) * (double)R[i].z));
                ++i;
            }
            nS.CP(L).assignment(R[0]);
            if (p - j - s > 0) {
                nS.CP(k + r - j - s).assignment(R[p - j - s]);
            }
            ++j;
        }
        i = L + 1;
        while (i < k - s) {
            nS.CP(i).assignment(R[i - L]);
            ++i;
        }
        this.assignment(nS);
        return r;
    }

    public void Clamp() {
        int n1 = this.InsertKnot(((p_float)this.m_aKnots.get((int)this.Degree())).value, this.Degree());
        int n2 = this.InsertKnot(((p_float)this.m_aKnots.get((int)this.m_cVerts)).value, this.Degree());
        if (n1 != 0 || n2 != 0) {
            CqTrimCurve nS = new CqTrimCurve(this);
            this.m_aKnots.resize(this.m_aKnots.size() - n1 - n2);
            this.m_aVerts.resize(this.m_cVerts - n1 - n2);
            this.m_cVerts -= n1 + n2;
            int size = nS.m_aKnots.size() - n2;
            int i = n1;
            while (i < size) {
                ((p_float)this.m_aKnots.get((int)(i - n1))).value = ((p_float)nS.m_aKnots.get((int)i)).value;
                ++i;
            }
            size = nS.m_cVerts - n2;
            i = n1;
            while (i < size) {
                this.CP(i - n1).assignment(nS.CP(i));
                ++i;
            }
        }
    }
}

