/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.DisplayNotFoundException;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.CqAttributes;
import net.cellcomputing.himawari.library.CqImageBuffer;
import net.cellcomputing.himawari.library.CqInlineParse;
import net.cellcomputing.himawari.library.CqMainModeBlock;
import net.cellcomputing.himawari.library.CqModeBlock;
import net.cellcomputing.himawari.library.CqObjectInstance;
import net.cellcomputing.himawari.library.CqOptions;
import net.cellcomputing.himawari.library.CqRiFile;
import net.cellcomputing.himawari.library.CqShaderKey;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqTextureMap;
import net.cellcomputing.himawari.library.CqTransform;
import net.cellcomputing.himawari.library.EqRenderMode;
import net.cellcomputing.himawari.library.EqShaderType;
import net.cellcomputing.himawari.library.EqVariableClass;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqDDManager;
import net.cellcomputing.himawari.library.IqRaytrace;
import net.cellcomputing.himawari.library.IqRenderer;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqTextureMap;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqCoordSys;
import net.cellcomputing.himawari.library.SqParameterDeclaration;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.main.Globalmain;
import net.cellcomputing.himawari.shaderexecenv.GlobalShaderExecEnv;
import net.cellcomputing.himawari.shadervm.CqShaderVM;
import net.cellcomputing.himawari.util.CellCipher;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqRenderer
implements IqRenderer {
    private CqModeBlock m_pconCurrent;
    private CqStats m_Stats = new CqStats();
    private CqAttributes m_pAttrDefault;
    private CqTransform m_pTransDefault;
    private CqImageBuffer m_pImageBuffer = null;
    private IqDDManager m_pDDManager;
    private EqRenderMode m_Mode = new EqRenderMode();
    private HashMap<Long, IqShader> m_Shaders = new HashMap();
    private CqTransform m_pTransCamera;
    private CqTransform m_pTransDefObj;
    private boolean m_fWorldBegin;
    private STLVector<SqParameterDeclaration> m_Symbols = new STLVector<SqParameterDeclaration>(SqParameterDeclaration.class);
    private float m_DofMultiplier;
    private float m_OneOverFocalDistance;
    private boolean m_UsingDepthOfField;
    private CqVector2D m_DepthOfFieldScale = new CqVector2D();
    private int awhich = 0;
    private int bwhich = 0;
    private HashMap<String, SqOutputDataEntry> m_OutputDataEntries = new HashMap();
    private int m_OutputDataOffset;
    private int m_OutputDataTotalSize;
    private CqOptions m_pOptDefault = new CqOptions();
    private int m_FrameNo;
    private STLVector<CqObjectInstance> m_ObjectInstances = new STLVector<CqObjectInstance>(CqObjectInstance.class);
    private boolean m_bObjectOpen;
    private Method m_pErrorHandler;
    private Method m_pProgressHandler;
    private Method m_pPreRenderFunction;
    private Method m_pPreWorldFunction;
    private IqRaytrace m_pRaytracer;
    public STLVector<SqCoordSys> m_aCoordSystems = new STLVector<SqCoordSys>(SqCoordSys.class);
    private HimawariLogger logger = HimawariLogger.getLogger();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public CqRenderer() {
        this.m_Mode.setValue(0);
        this.m_OutputDataOffset = 9;
        this.m_OutputDataTotalSize = 9;
        this.m_FrameNo = 0;
        this.m_bObjectOpen = false;
        try {
            this.m_pErrorHandler = RendermanInterface.class.getMethod("RiErrorPrint", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Exception e) {
            HimawariLogger.outputException(e);
        }
        this.m_pProgressHandler = null;
        this.m_pPreRenderFunction = null;
        this.m_pPreWorldFunction = null;
        this.m_pRaytracer = null;
        this.m_pImageBuffer = new CqImageBuffer();
        this.m_pOptDefault = new CqOptions();
        this.m_pAttrDefault = new CqAttributes();
        this.m_pAttrDefault.AddRef();
        this.m_pTransDefault = new CqTransform();
        this.m_pTransCamera = new CqTransform();
        this.m_pTransDefObj = new CqTransform();
        this.m_fWorldBegin = false;
        this.m_aCoordSystems.resize(6);
        SqCoordSys[] SqCoordSystmp = new SqCoordSys[]{new SqCoordSys(), new SqCoordSys(), new SqCoordSys(), new SqCoordSys(), new SqCoordSys(), new SqCoordSys()};
        SqCoordSystmp[0].m_strName = "__camera__";
        SqCoordSystmp[1].m_strName = "__current__";
        SqCoordSystmp[2].m_strName = "world";
        SqCoordSystmp[3].m_strName = "screen";
        SqCoordSystmp[4].m_strName = "NDC";
        SqCoordSystmp[5].m_strName = "raster";
        SqCoordSystmp[0].m_hash = "__camera__".hashCode();
        SqCoordSystmp[1].m_hash = "__current__".hashCode();
        SqCoordSystmp[2].m_hash = "world".hashCode();
        SqCoordSystmp[3].m_hash = "screen".hashCode();
        SqCoordSystmp[4].m_hash = "NDC".hashCode();
        SqCoordSystmp[5].m_hash = "raster".hashCode();
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[0], 0);
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[1], 1);
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[2], 2);
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[3], 3);
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[4], 4);
        this.m_aCoordSystems.setElementAt(SqCoordSystmp[5], 5);
        this.m_pDDManager = RiGlobal.CreateDisplayDriverManager();
        this.m_pDDManager.Initialise();
        this.m_pRaytracer = RiGlobal.CreateRaytracer();
        this.m_pRaytracer.Initialise();
        this.m_UsingDepthOfField = false;
    }

    @Override
    public void destruct() {
        if (this.m_pImageBuffer != null) {
            this.m_pImageBuffer.Release();
            this.m_pImageBuffer = null;
        }
        this.FlushShaders();
        CqShaderVM.ShutdownShaderEngine();
        this.m_pDDManager.Shutdown();
        this.m_pDDManager = null;
        if (this.m_pOptDefault != null) {
            this.m_pOptDefault = null;
        }
        if (this.m_pAttrDefault != null) {
            this.m_pAttrDefault.Release();
            this.m_pAttrDefault = null;
        }
        if (this.m_pRaytracer != null) {
            this.m_pRaytracer = null;
        }
        this.m_ObjectInstances.clear();
        this.m_ObjectInstances = null;
    }

    public CqModeBlock BeginMainModeBlock() {
        if (this.m_pconCurrent == null) {
            this.m_pconCurrent = new CqMainModeBlock(this.m_pconCurrent);
            return this.m_pconCurrent;
        }
        return null;
    }

    public CqModeBlock BeginFrameModeBlock() {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginFrameModeBlock();
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginWorldModeBlock() {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginWorldModeBlock();
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginAttributeModeBlock() {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginAttributeModeBlock();
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginTransformModeBlock() {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginTransformModeBlock();
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginSolidModeBlock(String type) {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginSolidModeBlock(type);
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginObjectModeBlock() {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginObjectModeBlock();
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public CqModeBlock BeginMotionModeBlock(int N, float[] times) {
        if (this.m_pconCurrent != null) {
            CqModeBlock pconNew = this.m_pconCurrent.BeginMotionModeBlock(N, times);
            if (pconNew != null) {
                this.m_pconCurrent = pconNew;
                return pconNew;
            }
            return null;
        }
        return null;
    }

    public void EndMainModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 1) {
            this.m_pconCurrent.EndMainModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndFrameModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 2) {
            this.m_pconCurrent.EndFrameModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndWorldModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 3) {
            this.m_pconCurrent.EndWorldModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndAttributeModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 4) {
            this.m_pconCurrent.EndAttributeModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndTransformModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 5) {
            this.m_pconCurrent.pconParent().m_pattrCurrent = this.m_pconCurrent.m_pattrCurrent;
            this.m_pconCurrent.EndTransformModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndSolidModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 6) {
            this.m_pconCurrent.EndSolidModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndObjectModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 7) {
            this.m_pconCurrent.EndObjectModeBlock();
            this.m_pconCurrent = this.m_pconCurrent.pconParent();
        }
    }

    public void EndMotionModeBlock() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 8) {
            CqModeBlock pconParent = this.m_pconCurrent.pconParent();
            pconParent.m_pattrCurrent = this.m_pconCurrent.m_pattrCurrent;
            pconParent.m_ptransCurrent = this.m_pconCurrent.m_ptransCurrent;
            this.m_pconCurrent.EndMotionModeBlock();
            this.m_pconCurrent = pconParent;
        }
    }

    public CqOptions optCurrent() {
        if (this.m_pconCurrent != null) {
            return this.m_pconCurrent.optCurrent();
        }
        assert (this.m_pOptDefault != null);
        return this.m_pOptDefault;
    }

    public CqAttributes pattrCurrent() {
        if (this.m_pconCurrent != null) {
            return this.m_pconCurrent.pattrCurrent();
        }
        return this.m_pAttrDefault;
    }

    public CqAttributes pattrWriteCurrent() {
        if (this.m_pconCurrent != null) {
            return this.m_pconCurrent.pattrWriteCurrent();
        }
        return this.m_pAttrDefault;
    }

    public CqTransform ptransCurrent() {
        if (this.m_pconCurrent != null) {
            return this.m_pconCurrent.ptransCurrent();
        }
        return this.m_pTransDefault;
    }

    public void ptransSetTime(CqMatrix matTrans) {
        if (this.m_pconCurrent == null) {
            throw null;
        }
        CqTransform.Set set = null;
        CqTransform newTrans = new CqTransform(this.m_pconCurrent.ptransCurrent(), this.Time(), matTrans, set);
        this.m_pconCurrent.ptransSetCurrent(newTrans);
    }

    public void ptransSetCurrentTime(CqMatrix matTrans) {
        if (this.m_pconCurrent == null) {
            throw null;
        }
        CqTransform.SetCurrent setCurrent = null;
        CqTransform newTrans = new CqTransform(this.m_pconCurrent.ptransCurrent(), this.Time(), matTrans, setCurrent);
        this.m_pconCurrent.ptransSetCurrent(newTrans);
    }

    public void ptransConcatCurrentTime(CqMatrix matTrans) {
        if (this.m_pconCurrent == null) {
            throw null;
        }
        CqTransform.ConcatCurrent concatcurrent = null;
        CqTransform newTrans = new CqTransform(this.m_pconCurrent.ptransCurrent(), this.Time(), matTrans, concatcurrent);
        this.m_pconCurrent.ptransSetCurrent(newTrans);
    }

    @Override
    public float Time() {
        if (this.m_pconCurrent != null && this.m_pconCurrent.Type().getValue() == 8) {
            return this.m_pconCurrent.Time();
        }
        return RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionWriteIndex((String)"System", (String)"Shutter", (int)0).value;
    }

    public void AdvanceTime() {
        if (this.m_pconCurrent != null) {
            this.m_pconCurrent.AdvanceTime();
        }
    }

    @Override
    public int bucketCount() {
        return this.pImage().cXBuckets() * this.pImage().cYBuckets();
    }

    public CqModeBlock pconCurrent(CqModeBlock pcon) {
        CqModeBlock prev = this.m_pconCurrent;
        this.m_pconCurrent = pcon;
        return prev;
    }

    public CqModeBlock pconCurrent() {
        return this.m_pconCurrent;
    }

    public CqImageBuffer pImage() {
        return this.m_pImageBuffer;
    }

    public void SetImage(CqImageBuffer pImage) {
        this.m_pImageBuffer = pImage;
    }

    @Override
    public CqMatrix matSpaceToSpace(String strFrom, String strTo, CqMatrix matShaderToWorld, CqMatrix matObjectToWorld, float time) {
        CqMatrix matB;
        CqMatrix matA;
        CqMatrix matResult = new CqMatrix();
        long fhash = strFrom.hashCode();
        long thash = strTo.hashCode();
        if (fhash == RiGlobal.ohash) {
            matA = matObjectToWorld;
        } else if (fhash == RiGlobal.shash) {
            matA = matShaderToWorld;
        } else if (fhash == RiGlobal.chash || fhash == RiGlobal.cuhash) {
            matA = this.m_pTransCamera.matObjectToWorld(time).Inverse();
        } else {
            matA = new CqMatrix();
            this.WhichMatToWorld(matA, fhash);
        }
        if (thash == RiGlobal.ohash) {
            matB = matObjectToWorld.Inverse();
        } else if (thash == RiGlobal.shash) {
            matB = matShaderToWorld.Inverse();
        } else if (thash == RiGlobal.chash || thash == RiGlobal.cuhash) {
            matB = this.m_pTransCamera.matObjectToWorld(time);
        } else {
            matB = new CqMatrix();
            this.WhichMatWorldTo(matB, thash);
        }
        matResult.assignment(matB.multiply(matA));
        return matResult;
    }

    @Override
    public CqMatrix matVSpaceToSpace(String strFrom, String strTo, CqMatrix matShaderToWorld, CqMatrix matObjectToWorld, float time) {
        CqMatrix matB;
        CqMatrix matA;
        CqMatrix matResult = new CqMatrix();
        long fhash = strFrom.hashCode();
        long thash = strTo.hashCode();
        if (fhash == RiGlobal.ohash) {
            matA = matObjectToWorld;
        } else if (fhash == RiGlobal.shash) {
            matA = matShaderToWorld;
        } else if (fhash == RiGlobal.chash || fhash == RiGlobal.cuhash) {
            matA = this.m_pTransCamera.matObjectToWorld(time).Inverse();
        } else {
            matA = new CqMatrix();
            this.WhichMatToWorld(matA, fhash);
        }
        if (thash == RiGlobal.ohash) {
            matB = matObjectToWorld.Inverse();
        } else if (thash == RiGlobal.shash) {
            matB = matShaderToWorld.Inverse();
        } else if (thash == RiGlobal.chash || thash == RiGlobal.cuhash) {
            matB = this.m_pTransCamera.matObjectToWorld(time);
        } else {
            matB = new CqMatrix();
            this.WhichMatWorldTo(matB, thash);
        }
        matResult = matB.multiply(matA);
        if (RiGlobal.oldkey[0].equals(matResult)) {
            return RiGlobal.oldresult[0];
        }
        RiGlobal.oldkey[0] = matResult;
        matResult.m_aaElement[2][3] = 0.0f;
        matResult.m_aaElement[1][3] = 0.0f;
        matResult.m_aaElement[0][3] = 0.0f;
        matResult.m_aaElement[3][2] = 0.0f;
        matResult.m_aaElement[3][1] = 0.0f;
        matResult.m_aaElement[3][0] = 0.0f;
        matResult.m_aaElement[3][3] = 1.0f;
        RiGlobal.oldresult[0] = matResult;
        return matResult;
    }

    @Override
    public CqMatrix matNSpaceToSpace(String strFrom, String strTo, CqMatrix matShaderToWorld, CqMatrix matObjectToWorld, float time) {
        CqMatrix matB;
        CqMatrix matA;
        CqMatrix matResult = new CqMatrix();
        long fhash = strFrom.hashCode();
        long thash = strTo.hashCode();
        if (fhash == RiGlobal.ohash) {
            matA = matObjectToWorld;
        } else if (fhash == RiGlobal.shash) {
            matA = matShaderToWorld;
        } else if (fhash == RiGlobal.chash || fhash == RiGlobal.cuhash) {
            matA = this.m_pTransCamera.matObjectToWorld(time).Inverse();
        } else {
            matA = new CqMatrix();
            this.WhichMatToWorld(matA, fhash);
        }
        if (thash == RiGlobal.ohash) {
            matB = matObjectToWorld.Inverse();
        } else if (thash == RiGlobal.shash) {
            matB = matShaderToWorld.Inverse();
        } else if (thash == RiGlobal.chash || thash == RiGlobal.cuhash) {
            matB = this.m_pTransCamera.matObjectToWorld(time);
        } else {
            matB = new CqMatrix();
            this.WhichMatWorldTo(matB, thash);
        }
        matResult = matB.multiply(matA);
        if (RiGlobal.oldkey[1].equals(matResult)) {
            return RiGlobal.oldresult[1];
        }
        RiGlobal.oldkey[1] = matResult;
        matResult.m_aaElement[2][3] = 0.0f;
        matResult.m_aaElement[1][3] = 0.0f;
        matResult.m_aaElement[0][3] = 0.0f;
        matResult.m_aaElement[3][2] = 0.0f;
        matResult.m_aaElement[3][1] = 0.0f;
        matResult.m_aaElement[3][0] = 0.0f;
        matResult.m_aaElement[3][3] = 1.0f;
        RiGlobal.oldresult[1] = matResult = matResult.Inverse().Transpose();
        return matResult;
    }

    @Override
    public float[] GetFloatOption(String strName, String strParam) {
        return this.optCurrent().GetFloatOption(strName, strParam);
    }

    @Override
    public int[] GetIntegerOption(String strName, String strParam) {
        return this.optCurrent().GetIntegerOption(strName, strParam);
    }

    @Override
    public String[] GetStringOption(String strName, String strParam) {
        return this.optCurrent().GetStringOption(strName, strParam);
    }

    @Override
    public CqVector3D[] GetPointOption(String strName, String strParam) {
        return this.optCurrent().GetPointOption(strName, strParam);
    }

    @Override
    public CqColor[] GetColorOption(String strName, String strParam) {
        return this.optCurrent().GetColorOption(strName, strParam);
    }

    @Override
    public p_float[] GetFloatOptionWrite(String strName, String strParam) {
        return this.optCurrent().GetFloatOptionWrite(strName, strParam);
    }

    @Override
    public p_int[] GetIntegerOptionWrite(String strName, String strParam) {
        return this.optCurrent().GetIntegerOptionWrite(strName, strParam);
    }

    @Override
    public p_String[] GetStringOptionWrite(String strName, String strParam) {
        return this.optCurrent().GetStringOptionWrite(strName, strParam);
    }

    @Override
    public CqVector3D[] GetPointOptionWrite(String strName, String strParam) {
        return this.optCurrent().GetPointOptionWrite(strName, strParam);
    }

    @Override
    public CqColor[] GetColorOptionWrite(String strName, String strParam) {
        return this.optCurrent().GetColorOptionWrite(strName, strParam);
    }

    @Override
    public void PrintString(String str) {
        System.out.print(str);
    }

    @Override
    public IqTextureMap GetTextureMap(String strFileName) {
        return CqTextureMap.GetTextureMap(strFileName);
    }

    @Override
    public IqTextureMap GetEnvironmentMap(String strFileName) {
        return CqTextureMap.GetEnvironmentMap(strFileName);
    }

    @Override
    public IqTextureMap GetShadowMap(String strFileName) {
        return CqTextureMap.GetShadowMap(strFileName);
    }

    @Override
    public IqTextureMap GetLatLongMap(String strFileName) {
        return CqTextureMap.GetLatLongMap(strFileName);
    }

    @Override
    public boolean GetBasisMatrix(CqMatrix matBasis, String name) {
        float[][] basis = new float[4][4];
        if (RendermanInterface.BasisFromName(basis, name)) {
            matBasis.assignment(basis);
            return true;
        }
        return false;
    }

    public CqMatrix matCurrent(float time) {
        return this.pconCurrent().matCurrent(time);
    }

    public boolean SetCoordSystem(String strName, CqMatrix matToWorld) {
        long hash = strName.hashCode();
        int i = 0;
        while (i < this.m_aCoordSystems.size()) {
            if (((SqCoordSys)this.m_aCoordSystems.get((int)i)).m_hash == hash) {
                ((SqCoordSys)this.m_aCoordSystems.get((int)i)).m_matToWorld = matToWorld;
                ((SqCoordSys)this.m_aCoordSystems.get((int)i)).m_matWorldTo = matToWorld.Inverse();
                return true;
            }
            ++i;
        }
        this.m_aCoordSystems.add(new SqCoordSys(strName, matToWorld, matToWorld.Inverse()));
        return false;
    }

    public void Initialise() {
        this.ClearSymbolTable();
        this.FlushShaders();
        this.m_aCoordSystems.setSize(6);
        this.m_OutputDataEntries.clear();
        this.m_OutputDataOffset = 9;
        this.m_OutputDataTotalSize = 9;
    }

    public void RenderWorld() {
        if (this.pImage() == null) {
            this.SetImage(new CqImageBuffer());
        }
        this.m_pDDManager.OpenDisplays();
        this.pImage().RenderImage();
        this.m_pDDManager.CloseDisplays();
    }

    public void AddDisplayRequest(String name, String type, String mode, int modeID, int dataOffset, int dataSize, HashMap<String, Object> mapOfArguments) {
        try {
            this.m_pDDManager.AddDisplay(name, type, mode, modeID, dataOffset, dataSize, mapOfArguments);
        }
        catch (DisplayNotFoundException dnfe) {
            HimawariLogger.outputException(dnfe);
            this.logger.error(dnfe.getMessage());
        }
    }

    public void ClearDisplayRequests() {
        this.m_pDDManager.ClearDisplays();
    }

    public IqDDManager pDDmanager() {
        return this.m_pDDManager;
    }

    public void Quit() {
        if (this.m_pImageBuffer != null) {
            this.m_pImageBuffer.Quit();
        }
    }

    public void UpdateStatus() {
    }

    public CqStats Stats() {
        return this.m_Stats;
    }

    public SqParameterDeclaration FindParameterDecl(String strDecl) throws XqException {
        CqInlineParse parser = new CqInlineParse();
        String __strDecl = strDecl;
        parser.parse(__strDecl);
        if (parser.isInline()) {
            SqParameterDeclaration Decl = new SqParameterDeclaration();
            Decl.m_strName = parser.getIdentifier();
            Decl.m_Count = parser.getQuantity();
            Decl.m_Type = parser.getType();
            Decl.m_Class = parser.GetClass();
            Decl.m_strSpace = "";
            switch (Decl.m_Class.getValue()) {
                case 1: {
                    if (Decl.m_Count > 1) {
                        Decl.m_pCreate = RiGlobal.gVariableCreateFuncsConstantArray[Decl.m_Type.getValue()];
                        break;
                    }
                    Decl.m_pCreate = RiGlobal.gVariableCreateFuncsConstant[Decl.m_Type.getValue()];
                    break;
                }
                case 2: {
                    if (Decl.m_Count > 1) {
                        Decl.m_pCreate = RiGlobal.gVariableCreateFuncsUniformArray[Decl.m_Type.getValue()];
                        break;
                    }
                    Decl.m_pCreate = RiGlobal.gVariableCreateFuncsUniform[Decl.m_Type.getValue()];
                    break;
                }
                case 3: {
                    if (Decl.m_Count > 1) {
                        Decl.m_pCreate = RiGlobal.gVariableCreateFuncsVaryingArray[Decl.m_Type.getValue()];
                        break;
                    }
                    Decl.m_pCreate = RiGlobal.gVariableCreateFuncsVarying[Decl.m_Type.getValue()];
                    break;
                }
                case 4: {
                    if (Decl.m_Count > 1) {
                        Decl.m_pCreate = RiGlobal.gVariableCreateFuncsVertexArray[Decl.m_Type.getValue()];
                        break;
                    }
                    Decl.m_pCreate = RiGlobal.gVariableCreateFuncsVertex[Decl.m_Type.getValue()];
                    break;
                }
                case 5: {
                    if (Decl.m_Count > 1) {
                        Decl.m_pCreate = RiGlobal.gVariableCreateFuncsFaceVaryingArray[Decl.m_Type.getValue()];
                        break;
                    }
                    Decl.m_pCreate = RiGlobal.gVariableCreateFuncsFaceVarying[Decl.m_Type.getValue()];
                    break;
                }
            }
            return Decl;
        }
        long hash = strDecl.hashCode();
        for (SqParameterDeclaration spd : this.m_Symbols) {
            long hash2 = spd.m_strName.hashCode();
            if (hash != hash2) continue;
            return spd;
        }
        return new SqParameterDeclaration("", new EqVariableType(0), new EqVariableClass(0), 0, null, "");
    }

    public void AddParameterDecl(String strName, String strType) {
        SqParameterDeclaration Decl;
        String strDecl = strType;
        strDecl = String.valueOf(strDecl) + " ";
        strDecl = String.valueOf(strDecl) + strName;
        try {
            Decl = this.FindParameterDecl(strDecl);
        }
        catch (XqException e) {
            this.logger.error(String.valueOf(e.strReason()) + "\n");
            return;
        }
        this.m_Symbols.add(0, Decl);
    }

    public void ClearSymbolTable() {
        this.m_Symbols.clear();
    }

    public IqShader CreateShader(String strName, EqShaderType type) {
        CqShaderKey key = new CqShaderKey(strName, type);
        if (this.m_Shaders.get(key.getkey()) != null) {
            return this.m_Shaders.get(key.getkey()).Clone();
        }
        String strFilename = strName;
        CqRiFile SLXFile = new CqRiFile(strFilename = String.valueOf(strFilename) + ".slx", "shader");
        if (SLXFile.IsValid()) {
            CqShaderVM pRet;
            CqShaderVM pShader = pRet = new CqShaderVM();
            String[] poptDSOPath = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("searchpath", "dsolibs");
            this.logger.info("DSO lib path set to \"" + poptDSOPath + "\"\n");
            String strRealName = SLXFile.strRealName();
            try {
                InputStreamReader fr = Globalmain.g_enc_flag.value ? CellCipher.getReader(strRealName) : new FileReader(strRealName);
                StreamTokenizer SLXst = new StreamTokenizer(new BufferedReader(fr));
                this.logger.info("Loading shader \"" + strName + "\" from file \"" + strRealName + "\"\n");
                pShader.SetstrName(strName);
                pShader.LoadProgram(SLXst);
                ((Reader)fr).close();
                SLXFile.Close();
                if (pShader.Type().getValue() != type.getValue()) {
                    String typeName = "unkown";
                    int i = 0;
                    while (i < GlobalShaderExecEnv.gShaderTypeNames.length) {
                        if (GlobalShaderExecEnv.gShaderTypeNames[i].type.getValue() == type.getValue()) {
                            typeName = GlobalShaderExecEnv.gShaderTypeNames[i].name;
                        }
                        ++i;
                    }
                    this.logger.error("Shader Type Mismatch [" + strName + "] ExpectedType[" + typeName + "] \n");
                    return null;
                }
            }
            catch (FileNotFoundException e) {
                HimawariLogger.outputException(e);
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
            this.m_Shaders.put(key.getkey(), pRet);
            return pRet.Clone();
        }
        if (strName.compareTo("null") != 0 && strName.compareTo("_def_") != 0) {
            String strError = new String("Shader \"" + strName + "\" not found\n");
            this.logger.error(strError);
        }
        if (type.getValue() == 0) {
            CqShaderVM pRet;
            CqShaderVM pShader = pRet = new CqShaderVM();
            pShader.SetstrName("null");
            pShader.DefaultSurface();
            this.m_Shaders.put(key.getkey(), pRet);
            return pRet.Clone();
        }
        return null;
    }

    void FlushShaders() {
        this.m_Shaders.clear();
    }

    public void SetmatScreen(CqMatrix mat) {
        ((SqCoordSys)this.m_aCoordSystems.get((int)3)).m_matWorldTo = mat;
    }

    public void SetmatNDC(CqMatrix mat) {
        ((SqCoordSys)this.m_aCoordSystems.get((int)4)).m_matWorldTo = mat;
    }

    public void SetmatRaster(CqMatrix mat) {
        ((SqCoordSys)this.m_aCoordSystems.get((int)5)).m_matWorldTo = mat;
    }

    public void SetCameraTransform(CqTransform ptrans) {
        this.m_pTransCamera = ptrans;
    }

    public CqTransform GetCameraTransform() {
        return this.m_pTransCamera;
    }

    public void SetDefObjTransform(CqTransform ptrans) {
        this.m_pTransDefObj = ptrans;
    }

    public CqTransform GetDefObjTransform() {
        return this.m_pTransDefObj;
    }

    public void SetDepthOfFieldData(float fstop, float focalLength, float focalDistance) {
        boolean bl = this.m_UsingDepthOfField = fstop < Float.MAX_VALUE;
        if (fstop < Float.MAX_VALUE) {
            float lensDiameter = focalLength / fstop;
            this.m_DofMultiplier = (float)(0.5 * (double)lensDiameter * (double)focalDistance / (double)(focalDistance + lensDiameter));
            this.m_OneOverFocalDistance = (float)(1.0 / (double)focalDistance);
        }
    }

    public boolean UsingDepthOfField() {
        return this.m_UsingDepthOfField;
    }

    public void SetDepthOfFieldScale(float x, float y) {
        this.m_DepthOfFieldScale.x(x);
        this.m_DepthOfFieldScale.y(y);
    }

    public CqVector2D GetCircleOfConfusion(float depth) {
        assert (this.m_UsingDepthOfField);
        float c = this.m_DofMultiplier * Math.abs(1.0f / depth - this.m_OneOverFocalDistance);
        return this.m_DepthOfFieldScale.mul(c);
    }

    public void GetCircleOfConfusion(float depth, CqVector2D vec2) {
        assert (this.m_UsingDepthOfField);
        float c = this.m_DofMultiplier * Math.abs(1.0f / depth - this.m_OneOverFocalDistance);
        vec2.x = this.m_DepthOfFieldScale.x * c;
        vec2.y = this.m_DepthOfFieldScale.y * c;
    }

    public IqShader getDefaultSurfaceShader() {
        CqShaderVM pRet;
        CqShaderKey key = new CqShaderKey("_def_", new EqShaderType(0));
        IqShader pMapCheck = this.CreateShader("_def_", new EqShaderType(0));
        if (pMapCheck != null) {
            return pMapCheck;
        }
        CqShaderVM pShader = pRet = new CqShaderVM();
        pShader.SetstrName("_def_");
        pShader.DefaultSurface();
        pShader.matCurrent().assignment(this.matCurrent(this.Time()));
        pShader.PrepareDefArgs();
        this.m_Shaders.put(key.getkey(), pRet);
        return pRet.Clone();
    }

    @Override
    public int RegisterOutputData(String name) throws XqException {
        SqParameterDeclaration Decl;
        int offset = this.OutputDataIndex(name);
        if (offset != -1) {
            return offset;
        }
        try {
            Decl = this.FindParameterDecl(name);
        }
        catch (XqException e) {
            HimawariLogger.outputException(e);
            return -1;
        }
        if (Decl.m_Type.getValue() != 0) {
            if (Decl.m_Count != 1) {
                throw new XqException("Error: Cannot use array as an output type");
            }
            SqOutputDataEntry DataEntry = new SqOutputDataEntry();
            int NumSamples = 0;
            switch (Decl.m_Type.getValue()) {
                case 1: 
                case 2: {
                    NumSamples = 1;
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    NumSamples = 3;
                    break;
                }
                case 5: {
                    NumSamples = 3;
                    break;
                }
                case 11: {
                    NumSamples = 16;
                    break;
                }
                case 4: {
                    throw new XqException("Error: String not valid as an output type");
                }
            }
            DataEntry.m_Offset = this.m_OutputDataOffset;
            DataEntry.m_NumSamples = NumSamples;
            DataEntry.m_Type = Decl.m_Type.getValue();
            this.m_OutputDataOffset += NumSamples;
            this.m_OutputDataTotalSize += NumSamples;
            this.m_OutputDataEntries.put(Decl.m_strName, DataEntry);
            return DataEntry.m_Offset;
        }
        return -1;
    }

    @Override
    public int OutputDataIndex(String name) {
        SqOutputDataEntry entry;
        SqParameterDeclaration Decl = new SqParameterDeclaration();
        try {
            Decl = this.FindParameterDecl(name);
        }
        catch (XqException e) {
            HimawariLogger.outputException(e);
            return -1;
        }
        if (Decl.m_Type.getValue() != 0 && (entry = this.m_OutputDataEntries.get(Decl.m_strName)) != null) {
            return entry.m_Offset;
        }
        return -1;
    }

    @Override
    public int OutputDataSamples(String name) {
        SqOutputDataEntry entry;
        SqParameterDeclaration Decl = new SqParameterDeclaration();
        try {
            Decl = this.FindParameterDecl(name);
        }
        catch (XqException e) {
            HimawariLogger.outputException(e);
            return -1;
        }
        if (Decl.m_Type.getValue() != 0 && (entry = this.m_OutputDataEntries.get(Decl.m_strName)) != null) {
            return entry.m_NumSamples;
        }
        return 0;
    }

    @Override
    public int OutputDataType(String name) {
        SqOutputDataEntry entry;
        SqParameterDeclaration Decl = new SqParameterDeclaration();
        try {
            Decl = this.FindParameterDecl(name);
        }
        catch (XqException e) {
            HimawariLogger.outputException(e);
            return -1;
        }
        if (Decl.m_Type.getValue() != 0 && (entry = this.m_OutputDataEntries.get(Decl.m_strName)) != null) {
            return entry.m_Type;
        }
        return 0;
    }

    public HashMap<String, SqOutputDataEntry> GetMapOfOutputDataEntries() {
        return this.m_OutputDataEntries;
    }

    public int GetOutputDataTotalSize() {
        return this.m_OutputDataTotalSize;
    }

    @Override
    public void SetCurrentFrame(int FrameNo) {
        this.m_FrameNo = FrameNo;
    }

    @Override
    public int CurrentFrame() {
        return this.m_FrameNo;
    }

    @Override
    public CqObjectInstance pCurrentObject() {
        if (this.m_bObjectOpen) {
            return (CqObjectInstance)this.m_ObjectInstances.get(this.m_ObjectInstances.size() - 1);
        }
        return null;
    }

    public CqObjectInstance OpenNewObjectInstance() {
        assert (!this.m_bObjectOpen);
        this.m_bObjectOpen = true;
        CqObjectInstance pNew = new CqObjectInstance();
        this.m_ObjectInstances.add(pNew);
        return pNew;
    }

    public void InstantiateObject(CqObjectInstance handle) {
        if (this.m_ObjectInstances.indexOf(handle) != -1) {
            handle.RecallInstance();
        }
    }

    public void CloseObjectInstance() {
        this.m_bObjectOpen = false;
    }

    public Method pErrorHandler() {
        return this.m_pErrorHandler;
    }

    public void SetpErrorHandler(Method perrorhandler) {
        this.m_pErrorHandler = perrorhandler;
    }

    public Method pProgressHandler() {
        return this.m_pProgressHandler;
    }

    public void SetpProgressHandler(Method pprogresshandler) {
        this.m_pProgressHandler = pprogresshandler;
    }

    public Method pPreRenderFunction() {
        return this.m_pPreRenderFunction;
    }

    public void SetpPreRenderFunction(Method pfunction) {
        this.m_pPreRenderFunction = pfunction;
    }

    public Method pPreWorldFunction() {
        return this.m_pPreWorldFunction;
    }

    public void SetpPreWorldFunction(Method pfunction) {
        this.m_pPreWorldFunction = pfunction;
    }

    public IqRaytrace pRaytracer() {
        return this.m_pRaytracer;
    }

    public boolean IsWorldBegin() {
        return this.m_fWorldBegin;
    }

    public void SetWorldBegin() {
        this.m_fWorldBegin = true;
    }

    public void SetWorldBegin(boolean begin) {
        this.m_fWorldBegin = begin;
    }

    private void WhichMatToWorld(CqMatrix matA, long thash) {
        int size;
        int tmp = this.awhich;
        while (this.awhich >= 0) {
            if (((SqCoordSys)this.m_aCoordSystems.get((int)this.awhich)).m_hash == thash) {
                matA.assignment(((SqCoordSys)this.m_aCoordSystems.get((int)this.awhich)).m_matToWorld);
                return;
            }
            --this.awhich;
        }
        this.awhich = size = this.m_aCoordSystems.size() - 1;
        while (this.awhich > tmp) {
            if (((SqCoordSys)this.m_aCoordSystems.get((int)this.awhich)).m_hash == thash) {
                matA.assignment(((SqCoordSys)this.m_aCoordSystems.get((int)this.awhich)).m_matToWorld);
                break;
            }
            --this.awhich;
        }
    }

    private void WhichMatWorldTo(CqMatrix matB, long thash) {
        int size;
        int tmp = this.bwhich;
        while (this.bwhich >= 0) {
            if (((SqCoordSys)this.m_aCoordSystems.get((int)this.bwhich)).m_hash == thash) {
                matB.assignment(((SqCoordSys)this.m_aCoordSystems.get((int)this.bwhich)).m_matWorldTo);
                return;
            }
            --this.bwhich;
        }
        this.bwhich = size = this.m_aCoordSystems.size() - 1;
        while (this.bwhich > tmp) {
            if (((SqCoordSys)this.m_aCoordSystems.get((int)this.bwhich)).m_hash == thash) {
                matB.assignment(((SqCoordSys)this.m_aCoordSystems.get((int)this.bwhich)).m_matWorldTo);
                break;
            }
            --this.bwhich;
        }
    }

    public strictfp class SqOutputDataEntry {
        int m_Offset;
        int m_NumSamples;
        int m_Type;
    }
}

