/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.Method;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.exception.XqException;
import net.cellcomputing.himawari.library.CqImagersource;
import net.cellcomputing.himawari.library.CqNamedParameterList;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTyped;
import net.cellcomputing.himawari.library.CqParameterTypedUniform;
import net.cellcomputing.himawari.library.CqParameterTypedUniformArray;
import net.cellcomputing.himawari.library.EqShaderType;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.RendermanInterface;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqParameterDeclaration;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqOptions {
    private STLVector<CqNamedParameterList> m_aOptions = new STLVector<CqNamedParameterList>(CqNamedParameterList.class);
    private Method m_funcFilter;
    private CqImagersource m_pshadImager;
    private boolean m_bFrameAspectRatioCalled;
    private boolean m_bScreenWindowCalled;
    private boolean m_bFormatCalled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public CqOptions() {
        try {
            this.m_funcFilter = RendermanInterface.class.getMethod("RiGaussianFilter", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (SecurityException e) {
            this.m_funcFilter = null;
        }
        catch (NoSuchMethodException e) {
            this.m_funcFilter = null;
        }
        this.m_pshadImager = null;
        this.m_bFrameAspectRatioCalled = false;
        this.m_bScreenWindowCalled = false;
        this.m_bFormatCalled = false;
        this.InitialiseDefaultOptions();
    }

    public CqOptions(CqOptions From) {
        this.assignment(From);
    }

    public void destruct() {
        this.DeleteImager();
    }

    public void AddOption(CqNamedParameterList pOption) {
        this.m_aOptions.add(pOption);
    }

    public void ClearOptions() {
        this.m_aOptions.clear();
        this.InitialiseDefaultOptions();
    }

    public void InitialiseDefaultOptions() {
        CqNamedParameterList pdefopts = new CqNamedParameterList("System");
        CqParameterTypedUniform<p_float, p_float> pPixelVariance = new CqParameterTypedUniform<p_float, p_float>("PixelVariance", new EqVariableType(1), p_float.class, p_float.class);
        pPixelVariance.pValue_get((int)0, (int)0).value = 1.0f;
        pdefopts.AddParameter(pPixelVariance);
        CqParameterTypedUniformArray<p_int, p_float> pPixelSamples = new CqParameterTypedUniformArray<p_int, p_float>("PixelSamples", 2, new EqVariableType(2), p_int.class, p_float.class);
        pPixelSamples.pValue_get((int)0, (int)0).value = 2;
        pPixelSamples.pValue_get((int)0, (int)1).value = 2;
        pdefopts.AddParameter(pPixelSamples);
        CqParameterTypedUniformArray<p_float, p_float> pFilterWidth = new CqParameterTypedUniformArray<p_float, p_float>("FilterWidth", 2, new EqVariableType(1), p_float.class, p_float.class);
        pFilterWidth.pValue_get((int)0, (int)0).value = 2.0f;
        pFilterWidth.pValue_get((int)0, (int)1).value = 2.0f;
        pdefopts.AddParameter(pFilterWidth);
        CqParameterTypedUniformArray<p_float, p_float> pExposure = new CqParameterTypedUniformArray<p_float, p_float>("Exposure", 2, new EqVariableType(1), p_float.class, p_float.class);
        pExposure.pValue_get((int)0, (int)0).value = 1.0f;
        pExposure.pValue_get((int)0, (int)1).value = 1.0f;
        pdefopts.AddParameter(pExposure);
        CqParameterTypedUniform<p_String, p_String> pImager = new CqParameterTypedUniform<p_String, p_String>("Imager", new EqVariableType(4), p_String.class, p_String.class);
        pImager.pValue_get((int)0, (int)0).value = "null";
        pdefopts.AddParameter(pImager);
        CqParameterTypedUniform<p_String, p_String> pDisplayType = new CqParameterTypedUniform<p_String, p_String>("DisplayType", new EqVariableType(4), p_String.class, p_String.class);
        pDisplayType.pValue_get((int)0, (int)0).value = "file";
        pdefopts.AddParameter(pDisplayType);
        CqParameterTypedUniform<p_String, p_String> pDisplayName = new CqParameterTypedUniform<p_String, p_String>("DisplayName", new EqVariableType(4), p_String.class, p_String.class);
        pDisplayName.pValue_get((int)0, (int)0).value = "aqsis.tif";
        pdefopts.AddParameter(pDisplayName);
        CqParameterTypedUniform<p_int, p_float> pDisplayMode = new CqParameterTypedUniform<p_int, p_float>("DisplayMode", new EqVariableType(2), p_int.class, p_float.class);
        pDisplayMode.pValue_get((int)0, (int)0).value = 1;
        pdefopts.AddParameter(pDisplayMode);
        CqParameterTypedUniform<p_String, p_String> pHider = new CqParameterTypedUniform<p_String, p_String>("Hider", new EqVariableType(4), p_String.class, p_String.class);
        pHider.pValue_get((int)0, (int)0).value = "hidden";
        pdefopts.AddParameter(pHider);
        CqParameterTypedUniform<p_int, p_float> pColorSamples = new CqParameterTypedUniform<p_int, p_float>("ColorSamples", new EqVariableType(2), p_int.class, p_float.class);
        pColorSamples.pValue_get((int)0, (int)0).value = 3;
        pdefopts.AddParameter(pColorSamples);
        CqParameterTypedUniform<p_float, p_float> pRelativeDetail = new CqParameterTypedUniform<p_float, p_float>("RelativeDetail", new EqVariableType(1), p_float.class, p_float.class);
        pRelativeDetail.pValue_get((int)0, (int)0).value = 1.0f;
        pdefopts.AddParameter(pRelativeDetail);
        CqParameterTypedUniformArray<p_int, p_float> pResolution = new CqParameterTypedUniformArray<p_int, p_float>("Resolution", 2, new EqVariableType(2), p_int.class, p_float.class);
        pResolution.pValue_get((int)0, (int)0).value = 640;
        pResolution.pValue_get((int)0, (int)1).value = 480;
        pdefopts.AddParameter(pResolution);
        CqParameterTypedUniform<p_float, p_float> pPixelAspectRatio = new CqParameterTypedUniform<p_float, p_float>("PixelAspectRatio", new EqVariableType(1), p_float.class, p_float.class);
        pPixelAspectRatio.pValue_get((int)0, (int)0).value = 1.0f;
        pdefopts.AddParameter(pPixelAspectRatio);
        CqParameterTypedUniformArray<p_float, p_float> pCropWindow = new CqParameterTypedUniformArray<p_float, p_float>("CropWindow", 4, new EqVariableType(1), p_float.class, p_float.class);
        pCropWindow.pValue_get((int)0, (int)0).value = 0.0f;
        pCropWindow.pValue_get((int)0, (int)1).value = 1.0f;
        pCropWindow.pValue_get((int)0, (int)2).value = 0.0f;
        pCropWindow.pValue_get((int)0, (int)3).value = 1.0f;
        pdefopts.AddParameter(pCropWindow);
        CqParameterTypedUniform<p_float, p_float> pFrameAspectRatio = new CqParameterTypedUniform<p_float, p_float>("FrameAspectRatio", new EqVariableType(1), p_float.class, p_float.class);
        pFrameAspectRatio.pValue_get((int)0, (int)0).value = 1.3333334f;
        pdefopts.AddParameter(pFrameAspectRatio);
        CqParameterTypedUniformArray<p_float, p_float> pScreenWindow = new CqParameterTypedUniformArray<p_float, p_float>("ScreenWindow", 4, new EqVariableType(1), p_float.class, p_float.class);
        pScreenWindow.pValue_get((int)0, (int)0).value = -1.3333334f;
        pScreenWindow.pValue_get((int)0, (int)1).value = 1.3333334f;
        pScreenWindow.pValue_get((int)0, (int)2).value = 1.0f;
        pScreenWindow.pValue_get((int)0, (int)3).value = -1.0f;
        pdefopts.AddParameter(pScreenWindow);
        CqParameterTypedUniform<p_int, p_float> pProjection = new CqParameterTypedUniform<p_int, p_float>("Projection", new EqVariableType(2), p_int.class, p_float.class);
        pProjection.pValue_get((int)0, (int)0).value = 0;
        pdefopts.AddParameter(pProjection);
        CqParameterTypedUniformArray<p_float, p_float> pClipping = new CqParameterTypedUniformArray<p_float, p_float>("Clipping", 2, new EqVariableType(1), p_float.class, p_float.class);
        pClipping.pValue_get((int)0, (int)0).value = 1.1920929E-7f;
        pClipping.pValue_get((int)0, (int)1).value = Float.MAX_VALUE;
        pdefopts.AddParameter(pClipping);
        CqParameterTypedUniformArray<p_float, p_float> pDepthOfField = new CqParameterTypedUniformArray<p_float, p_float>("DepthOfField", 3, new EqVariableType(1), p_float.class, p_float.class);
        pDepthOfField.pValue_get((int)0, (int)0).value = Float.MAX_VALUE;
        pDepthOfField.pValue_get((int)0, (int)1).value = Float.MAX_VALUE;
        pDepthOfField.pValue_get((int)0, (int)2).value = Float.MAX_VALUE;
        pdefopts.AddParameter(pDepthOfField);
        CqParameterTypedUniformArray<p_float, p_float> pShutter = new CqParameterTypedUniformArray<p_float, p_float>("Shutter", 2, new EqVariableType(1), p_float.class, p_float.class);
        pShutter.pValue_get((int)0, (int)0).value = 0.0f;
        pShutter.pValue_get((int)0, (int)1).value = 1.0f;
        pdefopts.AddParameter(pShutter);
        CqParameterTypedUniform<p_float, p_float> pFOV = new CqParameterTypedUniform<p_float, p_float>("FOV", new EqVariableType(1), p_float.class, p_float.class);
        pFOV.pValue_get((int)0, (int)0).value = 90.0f;
        pdefopts.AddParameter(pFOV);
        CqParameterTypedUniform<p_float, p_float> pSqrtGridSize = new CqParameterTypedUniform<p_float, p_float>("SqrtGridSize", new EqVariableType(1), p_float.class, p_float.class);
        pSqrtGridSize.pValue_get((int)0, (int)0).value = 16.0f;
        pdefopts.AddParameter(pSqrtGridSize);
        this.AddOption(pdefopts);
        pdefopts = new CqNamedParameterList("Quantize");
        CqParameterTypedUniformArray<p_float, p_float> pColor = new CqParameterTypedUniformArray<p_float, p_float>("Color", 4, new EqVariableType(1), p_float.class, p_float.class);
        pColor.pValue_get((int)0, (int)0).value = 255.0f;
        pColor.pValue_get((int)0, (int)1).value = 0.0f;
        pColor.pValue_get((int)0, (int)2).value = 255.0f;
        pColor.pValue_get((int)0, (int)3).value = 0.5f;
        pdefopts.AddParameter(pColor);
        CqParameterTypedUniformArray<p_float, p_float> pDepth = new CqParameterTypedUniformArray<p_float, p_float>("Depth", 4, new EqVariableType(1), p_float.class, p_float.class);
        pDepth.pValue_get((int)0, (int)0).value = 0.0f;
        pDepth.pValue_get((int)0, (int)1).value = 0.0f;
        pDepth.pValue_get((int)0, (int)2).value = 0.0f;
        pDepth.pValue_get((int)0, (int)3).value = 0.0f;
        pdefopts.AddParameter(pDepth);
        this.AddOption(pdefopts);
    }

    public CqNamedParameterList pOption(String strName) {
        long hash = strName.hashCode();
        for (CqNamedParameterList i : this.m_aOptions) {
            if (i.hash() != hash) continue;
            return i;
        }
        CqNamedParameterList retval = null;
        return retval;
    }

    public CqNamedParameterList pOptionWrite(String strName) {
        long hash = strName.hashCode();
        int i = 0;
        while (i < this.m_aOptions.size()) {
            CqNamedParameterList plist = (CqNamedParameterList)this.m_aOptions.get(i);
            if (plist.hash() == hash) {
                return plist;
            }
            ++i;
        }
        this.m_aOptions.add(new CqNamedParameterList(strName));
        return (CqNamedParameterList)this.m_aOptions.lastElement();
    }

    public CqParameter pParameter(String strName, String strParam) {
        CqParameter pParam;
        CqNamedParameterList pList = this.pOption(strName);
        if (pList != null && (pParam = pList.pParameter(strParam)) != null) {
            return pParam;
        }
        return null;
    }

    public CqParameter pParameterWrite(String strName, String strParam) {
        CqParameter pParam;
        CqNamedParameterList pList = this.pOptionWrite(strName);
        if (pList != null && (pParam = pList.pParameter(strParam)) != null) {
            return pParam;
        }
        return null;
    }

    public final p_float GetFloatOptionIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            return (p_float)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public final p_int GetIntegerOptionIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            return (p_int)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public final p_String GetStringOptionIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            return (p_String)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public final CqVector3D GetPointOptionIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            return (CqVector3D)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public final CqColor GetColorOptionIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            return (CqColor)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public p_float GetFloatOptionWriteIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            return (p_float)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public p_int GetIntegerOptionWriteIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            return (p_int)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public p_String GetStringOptionWriteIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            return (p_String)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public CqVector3D GetPointOptionWriteIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            return (CqVector3D)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public CqColor GetColorOptionWriteIndex(String strName, String strParam, int index) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            return (CqColor)((CqParameterTyped)pParam).pValue_get(0, index);
        }
        return null;
    }

    public final float[] GetFloatOption(String strName, String strParam) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            Object[] pTemp = ((CqParameterTyped)pParam).pValue();
            float[] ret = new float[pTemp.length];
            int i = 0;
            while (i < pTemp.length) {
                ret[i] = ((p_float)pTemp[i]).value;
                ++i;
            }
            return ret;
        }
        return null;
    }

    public final int[] GetIntegerOption(String strName, String strParam) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            Object[] pTemp = ((CqParameterTyped)pParam).pValue();
            int[] ret = new int[pTemp.length];
            int i = 0;
            while (i < pTemp.length) {
                ret[i] = ((p_int)pTemp[i]).value;
                ++i;
            }
            return ret;
        }
        return null;
    }

    public final String[] GetStringOption(String strName, String strParam) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            String[] ret = new String[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = ((p_String)pvalue[i]).value;
                ++i;
            }
            return ret;
        }
        return null;
    }

    public final CqVector3D[] GetPointOption(String strName, String strParam) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            CqVector3D[] ret = new CqVector3D[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (CqVector3D)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public final CqColor[] GetColorOption(String strName, String strParam) {
        CqParameter pParam = this.pParameter(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            CqColor[] ret = new CqColor[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (CqColor)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public p_float[] GetFloatOptionWrite(String strName, String strParam) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            p_float[] ret = new p_float[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (p_float)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public p_int[] GetIntegerOptionWrite(String strName, String strParam) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            p_int[] ret = new p_int[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (p_int)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public p_String[] GetStringOptionWrite(String strName, String strParam) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            p_String[] ret = new p_String[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (p_String)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public CqVector3D[] GetPointOptionWrite(String strName, String strParam) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            CqVector3D[] ret = new CqVector3D[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (CqVector3D)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public CqColor[] GetColorOptionWrite(String strName, String strParam) {
        CqParameter pParam = this.pParameterWrite(strName, strParam);
        if (pParam != null) {
            Object[] pvalue = ((CqParameterTyped)pParam).pValue();
            CqColor[] ret = new CqColor[pvalue.length];
            int i = 0;
            while (i < pvalue.length) {
                ret[i] = (CqColor)pvalue[i];
                ++i;
            }
            return ret;
        }
        return null;
    }

    public void InitialiseCamera() {
        CqMatrix matCameraToScreen = new CqMatrix();
        CqMatrix matScreenToNDC = new CqMatrix();
        CqMatrix matNDCToRaster = new CqMatrix();
        int proj = this.GetIntegerOptionIndex((String)"System", (String)"Projection", (int)0).value;
        switch (proj) {
            case 0: {
                CqMatrix Trl = new CqMatrix(1.0f, 1.0f, -1.0f);
                float l = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)0).value;
                float r = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)1).value;
                float t = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)2).value;
                float b = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)3).value;
                float n = this.GetFloatOptionIndex((String)"System", (String)"Clipping", (int)0).value;
                float f = this.GetFloatOptionIndex((String)"System", (String)"Clipping", (int)1).value;
                matCameraToScreen.Identity();
                matCameraToScreen.SetfIdentity(false);
                matCameraToScreen.m_aaElement[0][0] = 2.0f / (r - l);
                matCameraToScreen.m_aaElement[3][0] = -(r + l) / (r - l);
                matCameraToScreen.m_aaElement[1][1] = 2.0f / (t - b);
                matCameraToScreen.m_aaElement[3][1] = -(t + b) / (t - b);
                matCameraToScreen.m_aaElement[2][2] = -2.0f / (f - n);
                matCameraToScreen.m_aaElement[3][2] = -(f + n) / (f - n);
                matCameraToScreen.m_aaElement[2][3] = 0.0f;
                matCameraToScreen.m_aaElement[3][3] = 1.0f;
                matCameraToScreen.assignMul(Trl);
                float FrameX = (double)this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value >= 1.0 ? (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value : (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value * this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value / this.GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value;
                float FrameY = (double)this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value < 1.0 ? (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value : (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value * this.GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value / this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value;
                matScreenToNDC.Identity();
                matNDCToRaster.Identity();
                CqMatrix T = new CqMatrix();
                T.Translate(1.0f, 1.0f, 0.0f);
                CqMatrix S = new CqMatrix(0.5f, 0.5f, 0.0f);
                CqMatrix S2 = new CqMatrix(FrameX, FrameY, 0.0f);
                CqMatrix S3 = new CqMatrix(1.0f, -1.0f, 1.0f);
                matScreenToNDC = S.multiply(T).multiply(S3);
                matNDCToRaster = S2;
                break;
            }
            case 1: {
                float a;
                float fov = this.GetFloatOptionIndex((String)"System", (String)"Clipping", (int)0).value * (float)Math.tan(Math.toRadians(this.GetFloatOptionIndex((String)"System", (String)"FOV", (int)0).value / 2.0f));
                float l = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)0).value * fov;
                float r = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)1).value * fov;
                float t = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)2).value * fov;
                float b = this.GetFloatOptionIndex((String)"System", (String)"ScreenWindow", (int)3).value * fov;
                float n = this.GetFloatOptionIndex((String)"System", (String)"Clipping", (int)0).value;
                float f = this.GetFloatOptionIndex((String)"System", (String)"Clipping", (int)1).value;
                matCameraToScreen.Identity();
                matCameraToScreen.SetfIdentity(false);
                matCameraToScreen.m_aaElement[0][0] = 2.0f * n / (r - l);
                matCameraToScreen.m_aaElement[2][0] = (r + l) / (r - l);
                matCameraToScreen.m_aaElement[1][1] = 2.0f * n / (t - b);
                matCameraToScreen.m_aaElement[2][1] = (t + b) / (t - b);
                matCameraToScreen.m_aaElement[2][2] = a = f / (f - n);
                matCameraToScreen.m_aaElement[3][2] = -n * a;
                matCameraToScreen.m_aaElement[2][3] = 1.0f;
                matCameraToScreen.m_aaElement[3][3] = 0.0f;
                float FrameX = (double)this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value >= 1.0 ? (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value : (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value * this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value / this.GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value;
                float FrameY = (double)this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value < 1.0 ? (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value : (float)this.GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value * this.GetFloatOptionIndex((String)"System", (String)"PixelAspectRatio", (int)0).value / this.GetFloatOptionIndex((String)"System", (String)"FrameAspectRatio", (int)0).value;
                matScreenToNDC.Identity();
                matNDCToRaster.Identity();
                CqMatrix T = new CqMatrix();
                T.Translate(1.0f, 1.0f, 0.0f);
                CqMatrix S = new CqMatrix(0.5f, 0.5f, 1.0f);
                CqMatrix S2 = new CqMatrix(FrameX, FrameY, 1.0f);
                CqMatrix S3 = new CqMatrix(1.0f, -1.0f, 1.0f);
                matScreenToNDC = S.multiply(T).multiply(S3);
                matNDCToRaster = S2;
            }
        }
        CqMatrix matWorldToCamera = new CqMatrix(RiGlobal.QGetRenderContext().matSpaceToSpace("world", "camera", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time()));
        RiGlobal.QGetRenderContext().SetmatScreen(matCameraToScreen.multiply(matWorldToCamera));
        RiGlobal.QGetRenderContext().SetmatNDC(matScreenToNDC.multiply(matCameraToScreen.multiply(matWorldToCamera)));
        RiGlobal.QGetRenderContext().SetmatRaster(matNDCToRaster.multiply(matScreenToNDC.multiply(matCameraToScreen.multiply(matWorldToCamera))));
        CqMatrix dofm = RiGlobal.QGetRenderContext().matVSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        CqVector3D dofe = new CqVector3D(1.0f, 1.0f, -1.0f);
        CqVector3D dofc = new CqVector3D(0.0f, 0.0f, -1.0f);
        dofe = dofm.multiply(dofe);
        dofc = dofm.multiply(dofc);
        RiGlobal.QGetRenderContext().SetDepthOfFieldScale(Math.abs(dofe.x - dofc.x), Math.abs(dofe.y - dofc.y));
    }

    public void CallFormat() {
        this.m_bFormatCalled = true;
    }

    public void CallScreenWindow() {
        this.m_bScreenWindowCalled = true;
    }

    public void CallFrameAspectRatio() {
        this.m_bFrameAspectRatioCalled = true;
    }

    public boolean FormatCalled() {
        return this.m_bFormatCalled;
    }

    public boolean ScreenWindowCalled() {
        return this.m_bScreenWindowCalled;
    }

    public boolean FrameAspectRatioCalled() {
        return this.m_bFrameAspectRatioCalled;
    }

    public Method funcFilter() {
        return this.m_funcFilter;
    }

    public void SetfuncFilter(Method fValue) {
        this.m_funcFilter = fValue;
    }

    public void LoadImager(String strName) {
        this.DeleteImager();
        IqShader pShader = RiGlobal.QGetRenderContext().CreateShader(strName, new EqShaderType(5));
        if (pShader == null) {
            return;
        }
        this.m_pshadImager = new CqImagersource(pShader, true);
        this.m_pshadImager.pShader().PrepareDefArgs();
    }

    public void DeleteImager() {
        if (this.m_pshadImager != null) {
            this.m_pshadImager = null;
        }
    }

    public void SetValueImager(String token, Object value) {
        if (this.m_pshadImager != null) {
            SqParameterDeclaration Decl;
            try {
                Decl = RiGlobal.QGetRenderContext().FindParameterDecl(token);
            }
            catch (XqException e) {
                HimawariLogger logger = HimawariLogger.getLogger();
                logger.error(String.valueOf(e.strReason()) + "\n");
                return;
            }
            this.m_pshadImager.pShader().SetArgument(Decl.m_strName, Decl.m_Type, Decl.m_strSpace, value);
        }
    }

    public CqImagersource pshadImager() {
        return this.m_pshadImager;
    }

    public void InitialiseColorImager(IqBucket pBucket) {
        if (this.m_pshadImager != null) {
            this.m_pshadImager.Initialise(pBucket);
        }
    }

    public CqColor GetColorImager(float x, float y) {
        CqColor result = new CqColor(0.0f, 0.0f, 0.0f);
        if (this.m_pshadImager != null) {
            result = this.m_pshadImager.Color(x, y);
        }
        return result;
    }

    public float GetAlphaImager(float x, float y) {
        float result = 1.0f;
        if (this.m_pshadImager != null) {
            result = this.m_pshadImager.Alpha(x, y);
        }
        return result;
    }

    public CqColor GetOpacityImager(float x, float y) {
        CqColor result = new CqColor(RiGlobal.gColWhite);
        if (this.m_pshadImager != null) {
            result = this.m_pshadImager.Opacity(x, y);
        }
        return result;
    }

    public CqOptions assignment(CqOptions From) {
        this.m_bFrameAspectRatioCalled = From.m_bFrameAspectRatioCalled;
        this.m_bScreenWindowCalled = From.m_bScreenWindowCalled;
        this.m_bFormatCalled = From.m_bFormatCalled;
        this.m_funcFilter = From.m_funcFilter;
        this.m_pshadImager = From.m_pshadImager;
        this.DeleteImager();
        this.m_aOptions.setSize(From.m_aOptions.size());
        int i = From.m_aOptions.size();
        while (i-- > 0) {
            this.m_aOptions.set(i, (CqNamedParameterList)From.m_aOptions.get(i));
        }
        return this;
    }
}

