/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.IqKDTreeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqKDTree<T> {
    private STLVector<T> m_aLeaves;
    private IqKDTreeData<T> m_pDataInterface;
    private int m_Dim;

    public CqKDTree(IqKDTreeData<T> pDataInterface, Class<? extends T> cls) {
        this.m_pDataInterface = pDataInterface;
        this.m_Dim = 0;
        this.m_aLeaves = new STLVector<T>(cls);
    }

    public void Subdivide(CqKDTree<T> side1, CqKDTree<T> side2) {
        this.m_pDataInterface.SortElements(this.m_aLeaves, this.m_Dim);
        int median = (int)((float)this.aLeaves().size() / 2.0f);
        side1.aLeaves().removeAllElements();
        side1.aLeaves().addAll(this.aLeaves().subList(0, median));
        side2.aLeaves().removeAllElements();
        side2.aLeaves().addAll(this.aLeaves().subList(median, this.aLeaves().size()));
        side1.m_Dim = (this.m_Dim + 1) % this.m_pDataInterface.Dimensions();
        side2.m_Dim = (this.m_Dim + 1) % this.m_pDataInterface.Dimensions();
    }

    public STLVector<T> aLeaves() {
        return this.m_aLeaves;
    }

    public CqKDTree<T> assignment(CqKDTree<T> From) {
        this.m_aLeaves = From.m_aLeaves;
        this.m_pDataInterface = From.m_pDataInterface;
        this.m_Dim = From.m_Dim;
        return this;
    }
}

