/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqAttributes;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqShaderExecEnv;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.shaderexecenv.CqShaderExecEnv;

public strictfp class CqImagersource {
    private IqShader m_pShader;
    private CqAttributes m_pAttributes;
    private int m_uGridRes;
    private int m_uXOrigin;
    private int m_uYOrigin;
    private IqShaderExecEnv m_pShaderExecEnv;

    public CqImagersource(IqShader pShader, boolean fActive) {
        this.m_pShader = pShader;
        this.m_pAttributes = null;
        this.m_pShaderExecEnv = new CqShaderExecEnv();
        this.m_pAttributes = RiGlobal.QGetRenderContext().pattrCurrent();
        this.m_pAttributes.AddRef();
    }

    public CqImagersource(IqShader pShader) {
        this(pShader, true);
    }

    public void destruct() {
        if (this.m_pAttributes != null) {
            this.m_pAttributes.Release();
        }
        this.m_pAttributes = null;
    }

    public IqShader pShader() {
        return this.m_pShader;
    }

    public void Initialise(IqBucket pBucket) {
        int y;
        RiGlobal.QGetRenderContext().Stats().ImagerTimer().Start();
        int uGridRes = pBucket.Width();
        int vGridRes = pBucket.Height();
        int x = pBucket.XOrigin();
        this.m_uYOrigin = y = pBucket.YOrigin();
        this.m_uXOrigin = x;
        this.m_uGridRes = uGridRes;
        int mode = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value;
        float shuttertime = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)0).value;
        float components = (mode & 1) != 0 ? 3 : 0;
        components = (mode & 4) != 0 ? 1.0f : (components += (float)((mode & 2) != 0 ? 1 : 0));
        int Uses = 15122688;
        this.m_pShaderExecEnv.Initialise(uGridRes, vGridRes, null, null, this.m_pShader, Uses);
        this.P().Initialise(uGridRes, vGridRes);
        this.Ci().Initialise(uGridRes, vGridRes);
        this.Oi().Initialise(uGridRes, vGridRes);
        this.alpha().Initialise(uGridRes, vGridRes);
        this.s().Initialise(uGridRes, vGridRes);
        this.t().Initialise(uGridRes, vGridRes);
        this.ncomps().SetFloat(components);
        this.time().SetFloat(shuttertime);
        this.m_pShader.Initialise(uGridRes, vGridRes, this.m_pShaderExecEnv);
        int j = 0;
        while (j < vGridRes) {
            int i = 0;
            while (i < uGridRes) {
                int off = j * (uGridRes + 1) + i;
                this.P().SetPoint(new CqVector3D((float)x + (float)i, (float)y + (float)j, 0.0f), off);
                this.Ci().SetColor(pBucket.Color(x + i, y + j), off);
                CqColor opa = pBucket.Opacity(x + i, y + j);
                this.Oi().SetColor(opa, off);
                float avopa = (opa.fRed() + opa.fGreen() + opa.fBlue()) / 3.0f;
                this.alpha().SetFloat(pBucket.Coverage(x + i, y + j) * avopa, off);
                this.s().SetFloat((float)(x + i) + 0.5f, off);
                this.t().SetFloat((float)(y + j) + 0.5f, off);
                ++i;
            }
            ++j;
        }
        if (this.m_pShader != null) {
            this.m_pShader.Evaluate(this.m_pShaderExecEnv);
            this.alpha().SetFloat(1.0f);
        }
        RiGlobal.QGetRenderContext().Stats().ImagerTimer().Stop();
    }

    public int uGridRes() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.uGridRes();
    }

    public int vGridRes() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.vGridRes();
    }

    public int GridSize() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.GridSize();
    }

    public CqMatrix matObjectToWorld() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.matObjectToWorld();
    }

    public IqShaderData Cs() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Cs();
    }

    public IqShaderData Os() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Os();
    }

    public IqShaderData Ng() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Ng();
    }

    public IqShaderData du() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.du();
    }

    public IqShaderData dv() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.dv();
    }

    public IqShaderData L() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.L();
    }

    public IqShaderData Cl() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Cl();
    }

    public IqShaderData Ol() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Ol();
    }

    public IqShaderData P() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.P();
    }

    public IqShaderData dPdu() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.dPdu();
    }

    public IqShaderData dPdv() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.dPdv();
    }

    public IqShaderData N() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.N();
    }

    public IqShaderData u() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.u();
    }

    public IqShaderData v() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.v();
    }

    public IqShaderData s() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.s();
    }

    public IqShaderData t() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.t();
    }

    public IqShaderData I() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.I();
    }

    public IqShaderData Ci() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Ci();
    }

    public IqShaderData Oi() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Oi();
    }

    public IqShaderData Ps() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Ps();
    }

    public IqShaderData E() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.E();
    }

    public IqShaderData ncomps() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.ncomps();
    }

    public IqShaderData time() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.time();
    }

    public IqShaderData alpha() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.alpha();
    }

    public IqShaderData Ns() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.Ns();
    }

    public CqColor Color(float x, float y) {
        CqColor result = new CqColor(RiGlobal.gColBlack);
        int index = (int)((y - (float)this.m_uYOrigin) * (float)(this.m_uGridRes + 1) + x - (float)this.m_uXOrigin);
        if ((int)this.Ci().Size() >= index) {
            this.Ci().GetColor(result, index);
        }
        return result;
    }

    public CqColor Opacity(float x, float y) {
        CqColor result = new CqColor(RiGlobal.gColWhite);
        int index = (int)((y - (float)this.m_uYOrigin) * (float)(this.m_uGridRes + 1) + x - (float)this.m_uXOrigin);
        if ((int)this.Oi().Size() >= index) {
            this.Oi().GetColor(result, index);
        }
        return result;
    }

    public float Alpha(float x, float y) {
        p_float result = new p_float();
        this.alpha().GetFloat(result);
        return result.value;
    }
}

