/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.library.CqTextureMap;
import net.cellcomputing.himawari.library.CqTextureMapBuffer;
import net.cellcomputing.himawari.library.EqMapType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqEnvironmentMap
extends CqTextureMap {
    private CqMatrix m_matWorldToScreen;
    public static final int max_no = 30;
    public static final int pz = 1;
    public static final int px = 2;
    public static final int py = 4;
    public static final int nx = 8;
    public static final int ny = 16;
    public static final int nz = 32;
    public static final int edge01 = 3;
    public static final int edge02 = 5;
    public static final int edge03 = 9;
    public static final int edge04 = 17;
    public static final int edge12 = 6;
    public static final int edge23 = 12;
    public static final int edge34 = 24;
    public static final int edge41 = 18;
    public static final int edge51 = 34;
    public static final int edge52 = 36;
    public static final int edge53 = 40;
    public static final int edge54 = 48;
    static CqVector3D[] cube = new CqVector3D[30];
    static int cube_no;
    static float[][] uv;

    static {
        uv = new float[30][2];
        int i = 0;
        while (i < 30) {
            CqEnvironmentMap.cube[i] = new CqVector3D();
            ++i;
        }
    }

    static void get_face_intersection(CqVector3D normal, CqVector3D pt, p_int face) {
        float t;
        CqVector3D n = new CqVector3D(normal);
        if (n.z < 0.0f) {
            t = -0.5f / n.z;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if ((double)Math.abs(pt.x) < 0.5 && (double)Math.abs(pt.y) < 0.5) {
                face.value = 32;
                return;
            }
        } else if (n.z > 0.0f) {
            t = 0.5f / n.z;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if (Math.abs(pt.x) < 0.5f && Math.abs(pt.y) < 0.5f) {
                face.value = 1;
                return;
            }
        }
        if (n.y < 0.0f) {
            t = -0.5f / n.y;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if (Math.abs(pt.x) < 0.5f && Math.abs(pt.z) < 0.5f) {
                face.value = 16;
                return;
            }
        } else if (n.y > 0.0f) {
            t = 0.5f / n.y;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if (Math.abs(pt.x) < 0.5f && Math.abs(pt.z) < 0.5f) {
                face.value = 4;
                return;
            }
        }
        if (n.x < 0.0f) {
            t = -0.5f / n.x;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if (Math.abs(pt.y) < 0.5f && Math.abs(pt.z) < 0.5f) {
                face.value = 8;
                return;
            }
        } else if (n.x > 0.0f) {
            t = 0.5f / n.x;
            pt.x(n.x * t);
            pt.y(n.y * t);
            pt.z(n.z * t);
            if (Math.abs(pt.y) < 0.5f && Math.abs(pt.z) < 0.5f) {
                face.value = 2;
                return;
            }
        }
    }

    static void get_edge_intersection(CqVector3D n1, CqVector3D n2, int edge, CqVector3D pt) {
        float a = n1.y * n2.z - n1.z * n2.y;
        float b = n1.z * n2.x - n1.x * n2.z;
        float c = n1.x * n2.y - n1.y * n2.x;
        float z0 = 0.0f;
        float y0 = 0.0f;
        float x0 = 0.0f;
        float h = 0.0f;
        float g = 0.0f;
        float f = 0.0f;
        switch (edge) {
            case 3: {
                z0 = 0.5f;
                x0 = 0.5f;
                g = 1.0f;
                break;
            }
            case 5: {
                z0 = 0.5f;
                y0 = 0.5f;
                f = 1.0f;
                break;
            }
            case 9: {
                x0 = -0.5f;
                z0 = 0.5f;
                g = 1.0f;
                break;
            }
            case 17: {
                y0 = -0.5f;
                z0 = 0.5f;
                f = 1.0f;
                break;
            }
            case 6: {
                y0 = 0.5f;
                x0 = 0.5f;
                h = 1.0f;
                break;
            }
            case 12: {
                x0 = -0.5f;
                y0 = 0.5f;
                h = 1.0f;
                break;
            }
            case 24: {
                y0 = -0.5f;
                x0 = -0.5f;
                h = 1.0f;
                break;
            }
            case 18: {
                x0 = 0.5f;
                y0 = -0.5f;
                h = 1.0f;
                break;
            }
            case 34: {
                x0 = 0.5f;
                z0 = -0.5f;
                g = 1.0f;
                break;
            }
            case 36: {
                y0 = 0.5f;
                z0 = -0.5f;
                f = 1.0f;
                break;
            }
            case 40: {
                z0 = -0.5f;
                x0 = -0.5f;
                g = 1.0f;
                break;
            }
            case 48: {
                z0 = -0.5f;
                y0 = -0.5f;
                f = 1.0f;
            }
        }
        float denom = a * f + b * g + c * h;
        float t = -(a * x0 + b * y0 + c * z0) / denom;
        pt.x(x0 + f * t);
        pt.y(y0 + g * t);
        pt.z(z0 + h * t);
    }

    static void project(int face) {
        switch (face) {
            case 1: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = CqEnvironmentMap.cube[i].x + 0.5f;
                    CqEnvironmentMap.uv[i][1] = -CqEnvironmentMap.cube[i].y + 0.5f;
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = -CqEnvironmentMap.cube[i].z + 0.5f;
                    CqEnvironmentMap.uv[i][1] = -CqEnvironmentMap.cube[i].y + 0.5f;
                    ++i;
                }
                break;
            }
            case 4: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = CqEnvironmentMap.cube[i].x + 0.5f;
                    CqEnvironmentMap.uv[i][1] = CqEnvironmentMap.cube[i].z + 0.5f;
                    ++i;
                }
                break;
            }
            case 8: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = CqEnvironmentMap.cube[i].z + 0.5f;
                    CqEnvironmentMap.uv[i][1] = -CqEnvironmentMap.cube[i].y + 0.5f;
                    ++i;
                }
                break;
            }
            case 16: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = CqEnvironmentMap.cube[i].x + 0.5f;
                    CqEnvironmentMap.uv[i][1] = -CqEnvironmentMap.cube[i].z + 0.5f;
                    ++i;
                }
                break;
            }
            case 32: {
                int i = 0;
                while (i < cube_no) {
                    CqEnvironmentMap.uv[i][0] = -CqEnvironmentMap.cube[i].x + 0.5f;
                    CqEnvironmentMap.uv[i][1] = -CqEnvironmentMap.cube[i].y + 0.5f;
                    ++i;
                }
                break;
            }
        }
    }

    public CqEnvironmentMap(String strName) {
        super(strName);
    }

    public void destruct() {
        super.destruct();
    }

    public EqMapType Type() {
        return this.IsValid() ? new EqMapType(2) : new EqMapType(0);
    }

    public void SampleMap(CqVector3D R1, CqVector3D swidth, CqVector3D twidth, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
        this.CriticalMeasure();
        if (this.m_pImage != null) {
            if (this.Type().getValue() != 5) {
                CqVector3D R2 = new CqVector3D();
                CqVector3D R3 = new CqVector3D();
                CqVector3D R4 = new CqVector3D();
                R2.assignment(R1.add(swidth));
                R3.assignment(R1.add(twidth));
                R4.assignment(R1.add(swidth).add(twidth));
                this.SampleMap(R1, R2, R3, R4, val);
            } else if (this.Type().getValue() == 5) {
                CqVector3D V = new CqVector3D();
                V.assignment(R1);
                V.Unit();
                float sswidth = swidth.Magnitude();
                float stwidth = twidth.Magnitude();
                float ss1 = (float)(Math.atan2(V.y, V.x) / 6.2831854820251465);
                float tt1 = (float)(Math.acos(-V.z) / 3.1415927410125732);
                this.SampleMap(ss1 += 0.5f, tt1, sswidth, stwidth, val);
            }
        }
    }

    public void SampleMap(CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Start();
        if (this.m_pImage != null) {
            CqVector3D last_R = new CqVector3D();
            CqVector3D R = new CqVector3D();
            CqVector3D pt = new CqVector3D();
            p_int last_face = new p_int();
            p_int current_face = new p_int();
            CqVector3D[] vertex_list = new CqVector3D[]{R1, R2, R3, R4};
            val.resize(this.m_SamplesPerPixel);
            vertex_list[0].Unit();
            vertex_list[1].Unit();
            vertex_list[2].Unit();
            vertex_list[3].Unit();
            cube_no = 0;
            int projection_bit = 0;
            float total_area = 0.0f;
            last_R.assignment(vertex_list[3]);
            CqEnvironmentMap.get_face_intersection(last_R, cube[cube_no], last_face);
            ++cube_no;
            projection_bit |= last_face.value;
            int i = 0;
            while (i < 4) {
                R.assignment(vertex_list[i]);
                CqEnvironmentMap.get_face_intersection(R, pt, current_face);
                if (current_face.value != last_face.value) {
                    int edge = current_face.value | last_face.value;
                    CqEnvironmentMap.get_edge_intersection(last_R, R, edge, cube[cube_no]);
                    ++cube_no;
                    projection_bit |= current_face.value;
                }
                cube[cube_no].assignment(pt);
                ++cube_no;
                last_face.value = current_face.value;
                last_R.assignment(R);
                ++i;
            }
            Valarray run_val = new Valarray();
            run_val.resize(this.m_SamplesPerPixel);
            run_val.assignment(0.0f);
            val.assignment(0.0f);
            float facewidth = 0.33333334f;
            float faceheight = 0.5f;
            i = 0;
            int project_face = 1;
            while (i < 6) {
                if ((project_face & projection_bit) != 0) {
                    float t2;
                    float s2;
                    CqEnvironmentMap.project(project_face);
                    float s1 = s2 = uv[0][0];
                    float t1 = t2 = uv[0][1];
                    float texture_area = 0.0f;
                    int j = 1;
                    while (j < cube_no) {
                        if (uv[j][0] < s1) {
                            s1 = uv[j][0];
                        }
                        if (uv[j][1] < t1) {
                            t1 = uv[j][1];
                        }
                        if (uv[j][0] > s2) {
                            s2 = uv[j][0];
                        }
                        if (uv[j][1] > t2) {
                            t2 = uv[j][1];
                        }
                        ++j;
                    }
                    texture_area = (s2 - s1) * (t2 - t1);
                    if ((double)texture_area <= 0.0) {
                        texture_area = 1.0f;
                    }
                    s1 = PublicFunctions.CLAMP(s1, 0.0f, 1.0f);
                    s2 = PublicFunctions.CLAMP(s2, 0.0f, 1.0f);
                    t1 = PublicFunctions.CLAMP(t1, 0.0f, 1.0f);
                    t2 = PublicFunctions.CLAMP(t2, 0.0f, 1.0f);
                    s1 = s1 * facewidth + facewidth * (float)(i % 3);
                    s2 = s2 * facewidth + facewidth * (float)(i % 3);
                    t1 = t1 * faceheight + faceheight * (float)(i / 3);
                    t2 = t2 * faceheight + faceheight * (float)(i / 3);
                    this.GetSample(s1, t1, s2, t2, run_val);
                    val.assignAdd(run_val.mul(texture_area));
                    total_area += texture_area;
                }
                ++i;
                project_face += project_face;
            }
            val.assignDiv(total_area);
        }
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Stop();
    }

    public CqMatrix GetMatrix(int which, int index) {
        return this.m_matWorldToScreen;
    }

    public void ImageFilterVal2(CqTextureMapBuffer pData, int x, int y, int directory, int m_xres, int m_yres, float[] accum) {
        Method pFilter = this.m_FilterFunc;
        int delta = 1 << directory;
        float div = 0.0f;
        float mul = 0.0f;
        int xdelta = (int)Math.max(Math.floor(this.m_swidth) * (double)(delta / 2), 1.0);
        int ydelta = (int)Math.max(Math.floor(this.m_twidth) * (double)(delta / 2), 1.0);
        int xdelta2 = xdelta * 2;
        int ydelta2 = ydelta * 2;
        float fx = (float)x / (float)(m_xres - 1);
        float fy = (float)y / (float)(m_yres - 1);
        int i = 0;
        while (i < accum.length) {
            accum[i] = 0.0f;
            ++i;
        }
        if (directory != 0) {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum[isample] = 0.0f;
                ++isample;
            }
            int j = -ydelta;
            while (j <= ydelta) {
                i = -xdelta;
                while (i <= xdelta) {
                    try {
                        mul = ((Float)pFilter.invoke(null, Float.valueOf(i), Float.valueOf(j), Float.valueOf(xdelta2), Float.valueOf(ydelta2))).floatValue();
                    }
                    catch (IllegalArgumentException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (IllegalAccessException e) {
                        HimawariLogger.outputException(e);
                    }
                    catch (InvocationTargetException e) {
                        HimawariLogger.outputException(e);
                    }
                    if ((double)mul != 0.0) {
                        int ypos = (int)(fy * (float)this.m_YRes - 1.0f) + j;
                        int xpos = (int)(fx * (float)this.m_XRes - 1.0f) + i;
                        if (ypos >= 0 && xpos >= 0) {
                            float targetX = fx * (float)this.m_XRes - 1.0f;
                            float targetY = fy * (float)this.m_YRes - 1.0f;
                            if (!(targetX <= (float)(this.m_XRes / 3L - 1L) && (long)xpos > this.m_XRes / 3L - 1L || targetX > (float)(this.m_XRes / 3L - 1L) && (long)xpos <= this.m_XRes / 3L - 1L || targetX <= (float)(this.m_XRes * 2L / 3L - 1L) && (long)xpos > this.m_XRes * 2L / 3L - 1L || targetX > (float)(this.m_XRes * 2L / 3L - 1L) && (long)xpos <= this.m_XRes * 2L / 3L - 1L || targetY <= (float)(this.m_YRes / 2L - 1L) && (long)ypos > this.m_YRes / 2L - 1L || targetY > (float)(this.m_YRes / 2L - 1L) && (long)ypos <= this.m_YRes / 2L - 1L || (long)ypos > this.m_YRes - 1L || (long)xpos > this.m_XRes - 1L)) {
                                isample = 0;
                                while (isample < this.SamplesPerPixel()) {
                                    accum[isample] = pData.GetValue(xpos, ypos, isample) * mul + accum[isample];
                                    ++isample;
                                }
                                div += mul;
                            }
                        }
                    }
                    ++i;
                }
                ++j;
            }
            isample = 0;
            while (isample < this.SamplesPerPixel()) {
                if (div != 0.0f) {
                    accum[isample] = accum[isample] / div;
                }
                ++isample;
            }
        } else {
            int isample = 0;
            while (isample < this.SamplesPerPixel()) {
                accum[isample] = pData.GetValue(x, y, isample);
                ++isample;
            }
        }
    }
}

