/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqBound {
    private CqVector3D m_vecMin = new CqVector3D();
    private CqVector3D m_vecMax = new CqVector3D();

    public CqBound(float[] pBounds) {
        if (pBounds != null) {
            this.m_vecMin.x = pBounds[0];
            this.m_vecMin.y = pBounds[2];
            this.m_vecMin.z = pBounds[4];
            this.m_vecMax.x = pBounds[1];
            this.m_vecMax.y = pBounds[3];
            this.m_vecMax.z = pBounds[5];
        }
    }

    public CqBound() {
        this.m_vecMin.x = Float.MAX_VALUE;
        this.m_vecMin.y = Float.MAX_VALUE;
        this.m_vecMin.z = Float.MAX_VALUE;
        this.m_vecMax.x = -3.4028235E38f;
        this.m_vecMax.y = -3.4028235E38f;
        this.m_vecMax.z = -3.4028235E38f;
    }

    public CqBound(float XMin, float YMin, float ZMin, float XMax, float YMax, float ZMax) {
        this.m_vecMin.x = XMin;
        this.m_vecMin.y = YMin;
        this.m_vecMin.z = ZMin;
        this.m_vecMax.x = XMax;
        this.m_vecMax.y = YMax;
        this.m_vecMax.z = ZMax;
    }

    public CqBound(CqVector3D vecMin, CqVector3D vecMax) {
        this.m_vecMin.assignment(vecMin);
        this.m_vecMax.assignment(vecMax);
    }

    public CqBound(CqBound From) {
        this.m_vecMax.assignment(From.m_vecMax);
        this.m_vecMin.assignment(From.m_vecMin);
    }

    public void destract() {
    }

    public CqVector3D vecMin() {
        return this.m_vecMin;
    }

    public CqVector3D vecMax() {
        return this.m_vecMax;
    }

    public CqVector3D vecCross() {
        return this.m_vecMax.sub(this.m_vecMin);
    }

    public float Volume() {
        return (float)Math.sqrt(this.Volume2());
    }

    public float Volume2() {
        return this.vecCross().Magnitude2();
    }

    public CqBound assignment(CqBound From) {
        this.m_vecMin.assignment(From.m_vecMin);
        this.m_vecMax.assignment(From.m_vecMax);
        return this;
    }

    public void Transform(CqMatrix matTransform) {
        CqVector3D[] avecCuboid = new CqVector3D[]{this.m_vecMin, new CqVector3D(this.m_vecMax.x, this.m_vecMin.y, this.m_vecMin.z), new CqVector3D(this.m_vecMin.x, this.m_vecMax.y, this.m_vecMin.z), new CqVector3D(this.m_vecMin.x, this.m_vecMin.y, this.m_vecMax.z), new CqVector3D(this.m_vecMax.x, this.m_vecMax.y, this.m_vecMin.z), new CqVector3D(this.m_vecMin.x, this.m_vecMax.y, this.m_vecMax.z), new CqVector3D(this.m_vecMax.x, this.m_vecMin.y, this.m_vecMax.z), this.m_vecMax};
        this.m_vecMin = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.m_vecMax = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int i = 0;
        while (i < 8) {
            avecCuboid[i].assignment(matTransform.multiply(avecCuboid[i]));
            if (avecCuboid[i].x < this.m_vecMin.x) {
                this.m_vecMin.x = avecCuboid[i].x;
            }
            if (avecCuboid[i].y < this.m_vecMin.y) {
                this.m_vecMin.y = avecCuboid[i].y;
            }
            if (avecCuboid[i].z < this.m_vecMin.z) {
                this.m_vecMin.z = avecCuboid[i].z;
            }
            if (avecCuboid[i].x > this.m_vecMax.x) {
                this.m_vecMax.x = avecCuboid[i].x;
            }
            if (avecCuboid[i].y > this.m_vecMax.y) {
                this.m_vecMax.y = avecCuboid[i].y;
            }
            if (avecCuboid[i].z > this.m_vecMax.z) {
                this.m_vecMax.z = avecCuboid[i].z;
            }
            ++i;
        }
    }

    public CqBound Combine(CqBound bound) {
        CqBound Result = new CqBound();
        Result.m_vecMax.x = Math.max(this.m_vecMax.x, bound.m_vecMax.x);
        Result.m_vecMax.y = Math.max(this.m_vecMax.y, bound.m_vecMax.y);
        Result.m_vecMax.z = Math.max(this.m_vecMax.z, bound.m_vecMax.z);
        Result.m_vecMin.x = Math.min(this.m_vecMin.x, bound.m_vecMin.x);
        Result.m_vecMin.y = Math.min(this.m_vecMin.y, bound.m_vecMin.y);
        Result.m_vecMin.z = Math.min(this.m_vecMin.z, bound.m_vecMin.z);
        return Result;
    }

    public CqBound Encapsulate(CqBound bound) {
        this.m_vecMax.x = Math.max(this.m_vecMax.x, bound.m_vecMax.x);
        this.m_vecMax.y = Math.max(this.m_vecMax.y, bound.m_vecMax.y);
        this.m_vecMax.z = Math.max(this.m_vecMax.z, bound.m_vecMax.z);
        this.m_vecMin.x = Math.min(this.m_vecMin.x, bound.m_vecMin.x);
        this.m_vecMin.y = Math.min(this.m_vecMin.y, bound.m_vecMin.y);
        this.m_vecMin.z = Math.min(this.m_vecMin.z, bound.m_vecMin.z);
        return this;
    }

    public CqBound Encapsulate(CqVector3D v) {
        this.m_vecMax.x = Math.max(this.m_vecMax.x, v.x);
        this.m_vecMax.y = Math.max(this.m_vecMax.y, v.y);
        this.m_vecMax.z = Math.max(this.m_vecMax.z, v.z);
        this.m_vecMin.x = Math.min(this.m_vecMin.x, v.x);
        this.m_vecMin.y = Math.min(this.m_vecMin.y, v.y);
        this.m_vecMin.z = Math.min(this.m_vecMin.z, v.z);
        return this;
    }

    public CqBound Encapsulate(CqVector2D v) {
        this.m_vecMax.x = Math.max(this.m_vecMax.x, v.x);
        this.m_vecMax.y = Math.max(this.m_vecMax.y, v.y);
        this.m_vecMin.x = Math.min(this.m_vecMin.x, v.x);
        this.m_vecMin.y = Math.min(this.m_vecMin.y, v.y);
        return this;
    }

    public boolean Contains3D(CqVector3D v) {
        return v.x >= this.m_vecMin.x && v.x <= this.m_vecMax.x && v.y >= this.m_vecMin.y && v.y <= this.m_vecMax.y && v.z >= this.m_vecMin.z && v.z <= this.m_vecMax.z;
    }

    public boolean Contains2D(CqVector2D v) {
        return !(v.x < this.m_vecMin.x || v.x > this.m_vecMax.x || v.y < this.m_vecMin.y) && !(v.y > this.m_vecMax.y);
    }

    public String toString() {
        CqVector3D min = this.vecMin();
        CqVector3D max = this.vecMax();
        CqVector3D cross = this.vecCross();
        String ret = new String(String.valueOf(min.toString()) + "-->" + max.toString() + "  |  Cross: " + cross.toString());
        return ret;
    }
}

