/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.argparse;

import java.util.ArrayList;
import java.util.Collections;
import net.cellcomputing.himawari.accessory.Pair;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_double;
import net.cellcomputing.himawari.accessory.primitive.p_int;
import net.cellcomputing.himawari.argparse.ArgParseInternalData;
import net.cellcomputing.himawari.argparse.CompareByLength;
import net.cellcomputing.himawari.argparse.FlagHandler;
import net.cellcomputing.himawari.argparse.FloatHandler;
import net.cellcomputing.himawari.argparse.FloatsHandler;
import net.cellcomputing.himawari.argparse.IntHandler;
import net.cellcomputing.himawari.argparse.IntsHandler;
import net.cellcomputing.himawari.argparse.OptionHandler;
import net.cellcomputing.himawari.argparse.StringHandler;
import net.cellcomputing.himawari.argparse.StringsHandler;
import net.cellcomputing.himawari.exception.XqException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ArgParse {
    public static int SEP_NONE = -1;
    public static int SEP_ARGV = -2;
    private ArgParseInternalData d = new ArgParseInternalData();

    public ArgParse() {
        this.d.allowOneCharOptionsToBeCombined = false;
        this.d.allowUnrecognizedOptions = false;
    }

    public void destruct() {
        this.d.options.clear();
        this.d.options = null;
    }

    public void allowOneCharOptionsToBeCombined() {
        this.d.allowOneCharOptionsToBeCombined = true;
    }

    public void allowUnrecognizedOptions() {
        this.d.allowUnrecognizedOptions = true;
    }

    public void argFlag(String name, String usage, p_boolean value) {
        this.argFlag(name, usage, value, true);
    }

    public void argFlag(String name, String usage, p_boolean value, boolean allow_negation) {
        this.d.addOption(name, new FlagHandler(usage, value, allow_negation));
    }

    public void argInt(String name, String usage, p_int value) {
        this.d.addOption(name, new IntHandler(usage, value));
    }

    public void argInts(String name, String usage, STLVector<Integer> values) {
        this.argInts(name, usage, values, SEP_NONE, -1);
    }

    public void argInts(String name, String usage, STLVector<Integer> values, int separator) {
        this.argInts(name, usage, values, separator, -1);
    }

    public void argInts(String name, String usage, STLVector<Integer> values, int separator, int count) {
        this.d.addOption(name, new IntsHandler(usage, values, separator, count));
    }

    public void argFloat(String name, String usage, p_double value) {
        this.d.addOption(name, new FloatHandler(usage, value));
    }

    public void argFloats(String name, String usage, STLVector<Double> values) {
        this.argFloats(name, usage, values, SEP_NONE, -1);
    }

    public void argFloats(String name, String usage, STLVector<Double> values, int separator) {
        this.argFloats(name, usage, values, separator, -1);
    }

    public void argFloats(String name, String usage, STLVector<Double> values, int separator, int count) {
        this.d.addOption(name, new FloatsHandler(usage, values, separator, count));
    }

    public void argString(String name, String usage, p_String value) {
        this.d.addOption(name, new StringHandler(usage, value));
    }

    public void argStrings(String name, String usage, STLVector<String> values) {
        this.argStrings(name, usage, values, SEP_NONE, -1);
    }

    public void argStrings(String name, String usage, STLVector<String> values, int separator) {
        this.argStrings(name, usage, values, separator, -1);
    }

    public void argStrings(String name, String usage, STLVector<String> values, int separator, int count) {
        this.d.addOption(name, new StringsHandler(usage, values, separator, count));
    }

    public void alias(String realname, String aliasname) {
        if (this.d.aliases.get(aliasname) == null) {
            this.d.aliases.put(aliasname, realname);
            OptionHandler e = this.d.options.get(realname);
            if (e != null) {
                e.aliases.add(aliasname);
            }
        }
    }

    public void usageHeader(String text) {
        this.usageHeader(text, 25);
    }

    public void usageHeader(String text, int indent) {
        Pair<Integer, String> tmppair = new Pair<Integer, String>(indent, text);
        this.d.usage.add(tmppair);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean parse(int argc, String[] argv) {
        OptionHandler argeater = null;
        OptionHandler oneshotargeater = null;
        boolean endofoptions = false;
        String eatername = "";
        this.d.leftovers.clear();
        for (OptionHandler value : this.d.options.values()) {
            value.reset();
        }
        this.d.errmsg = "";
        try {
            try {
                int i = 0;
                while (i < argc) {
                    block24: {
                        OptionHandler oh;
                        p_boolean no;
                        int l;
                        int point;
                        String rest;
                        block29: {
                            block30: {
                                p_boolean no2;
                                block28: {
                                    block27: {
                                        block26: {
                                            block25: {
                                                if (this.d.errmsg.length() > 0) return this.d.errmsg.length() == 0;
                                                if (!endofoptions) break block25;
                                                this.d.leftovers.add(argv[i]);
                                                break block24;
                                            }
                                            if (oneshotargeater == null) break block26;
                                            this.d.errmsg = oneshotargeater.handleargsplit(argv[i], eatername);
                                            oneshotargeater = null;
                                            break block24;
                                        }
                                        if (argv[i].charAt(0) == '-' && argv[i].length() > 1 || argeater != null && argeater.count <= 0 && argeater.count != -1) break block27;
                                        if (argeater == null) {
                                            this.d.leftovers.add(argv[i]);
                                            break block24;
                                        } else {
                                            this.d.errmsg = argeater.handleargsplit(argv[i], eatername);
                                        }
                                        break block24;
                                    }
                                    argeater = null;
                                    rest = argv[i].substring(1);
                                    point = 0;
                                    point = 0;
                                    if (!rest.startsWith("-") || rest.length() > ++point) break block28;
                                    endofoptions = true;
                                    break block24;
                                }
                                int ndashes = point + 1;
                                l = 0;
                                while (l < rest.length() && rest.charAt(l) != ':' && rest.charAt(l) != '=') {
                                    ++l;
                                }
                                if (this.d.allowOneCharOptionsToBeCombined && ndashes == 1 && l > 1) {
                                    int j = 0;
                                    while (j < l - 1) {
                                        p_boolean no3;
                                        String onechar = String.valueOf(rest.charAt(j));
                                        OptionHandler oh2 = this.d.findOption(onechar, no3 = new p_boolean());
                                        if (oh2 == null) {
                                            this.d.errmsg = String.valueOf(argv[i]) + ": '" + onechar + "' is an unrecognized option";
                                            throw new XqException();
                                        }
                                        if (oh2.takesarg()) {
                                            this.d.errmsg = String.valueOf(argv[i]) + ": '" + onechar + "' requires an argument";
                                            throw new XqException();
                                        }
                                        this.d.errmsg = oh2.handleargsplit(no3.value ? "no" : "", argv[i]);
                                        if (this.d.errmsg.length() > 0) {
                                            throw new XqException();
                                        }
                                        ++j;
                                    }
                                    point += l - 1;
                                    l = 1;
                                }
                                no = new p_boolean();
                                String option_name = rest.substring(point, l + point > rest.length() ? rest.length() : l + point);
                                oh = this.d.findOption(option_name, no);
                                if (oh != null) break block29;
                                String onechar = rest.substring(point, 1 + point > rest.length() ? rest.length() : 1 + point);
                                oh = this.d.findOption(onechar, no2 = new p_boolean());
                                if (oh == null || !oh.takesarg()) break block30;
                                l = 0;
                                break block29;
                            }
                            if (this.d.allowUnrecognizedOptions) {
                                this.d.leftovers.add(argv[i]);
                                break block24;
                            } else {
                                this.d.errmsg = String.valueOf(argv[i]) + ": unrecognized option";
                                return this.d.errmsg.length() == 0;
                            }
                        }
                        if (oh.takesarg()) {
                            if (l < rest.length()) {
                                this.d.errmsg = oh.handleargsplit(rest.substring(point + l + 1), argv[i]);
                            } else if (oh.separator != SEP_ARGV) {
                                oneshotargeater = oh;
                            }
                            if (oh.separator == SEP_ARGV) {
                                argeater = oh;
                            }
                            eatername = argv[i];
                        } else {
                            this.d.errmsg = l < rest.length() ? String.valueOf(argv[i]) + ": doesn't take an argument" : oh.handleargsplit(no.value ? "no" : "", argv[i]);
                        }
                    }
                    ++i;
                }
                return this.d.errmsg.length() == 0;
            }
            catch (XqException xqException) {}
            return this.d.errmsg.length() == 0;
        }
        finally {
            if (this.d.errmsg.length() == 0 && oneshotargeater != null) {
                this.d.errmsg = "missing an argument at end of command line";
            }
        }
    }

    public String errmsg() {
        return this.d.errmsg;
    }

    public String usagemsg() {
        String ret = new String();
        int indent = 25;
        for (Pair<Integer, String> e : this.d.usage) {
            if ((Integer)e.first >= 0) {
                indent = (Integer)e.first;
                ret = String.valueOf(ret) + (String)e.second;
                ret = String.valueOf(ret) + '\n';
                continue;
            }
            OptionHandler foundoption = this.d.options.get(e.second);
            if (foundoption == null) continue;
            OptionHandler oh = foundoption;
            ArrayList<String> names = oh.aliases;
            names.add((String)e.second);
            Collections.sort(names, new CompareByLength());
            boolean first = true;
            String line = "  ";
            int it = names.size();
            int k = 0;
            while (k < it) {
                if (first) {
                    if (this.d.allowOneCharOptionsToBeCombined && it != 1) {
                        line = String.valueOf(line) + "    ";
                    }
                } else {
                    line = String.valueOf(line) + ", ";
                }
                first = false;
                if (this.d.allowOneCharOptionsToBeCombined && it != 1) {
                    line = String.valueOf(line) + '-';
                }
                line = String.valueOf(line) + '-';
                line = String.valueOf(line) + names.get(k);
                ++k;
            }
            int it2 = oh.usage.length();
            int k2 = 0;
            while (k2 < it2) {
                if (oh.usage.charAt(k2) == '\n') {
                    ret = String.valueOf(ret) + line;
                    ret = String.valueOf(ret) + '\n';
                    line = "";
                } else if (oh.usage.charAt(k2) == '\t') {
                    int spaces = indent - line.length();
                    if (spaces < 1) {
                        ret = String.valueOf(ret) + line;
                        ret = String.valueOf(ret) + '\n';
                        line = "";
                        spaces = indent;
                    }
                    int n = 0;
                    while (n < spaces) {
                        line = String.valueOf(line) + " ";
                        ++n;
                    }
                } else {
                    line = String.valueOf(line) + oh.usage.charAt(k2);
                }
                ++k2;
            }
            ret = String.valueOf(ret) + line;
            ret = String.valueOf(ret) + '\n';
        }
        return ret;
    }

    public STLVector<String> leftovers() {
        return this.d.leftovers;
    }
}

