/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.shaderexecenv;

import java.util.HashMap;
import net.cellcomputing.himawari.accessory.primitive.p_String;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.EqShaderType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.shaderexecenv.BakingChannel;
import net.cellcomputing.himawari.shadervm.shader_types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class GlobalShaderExecEnv {
    public static final long dhash = "Data".hashCode();
    public static final long ihash = "Init".hashCode();
    public static final long cohash = "Code".hashCode();
    public static final long sehash = "segment".hashCode();
    public static final long phash = "param".hashCode();
    public static final long vhash = "varying".hashCode();
    public static final long uhash = "uniform".hashCode();
    public static final long ushash = "USES".hashCode();
    public static final long ehash = "external".hashCode();
    public static final long ouhash = "output".hashCode();
    public static shader_types[] gShaderTypeNames = new shader_types[]{new shader_types("surface", new EqShaderType(0), 0L), new shader_types("lightsource", new EqShaderType(1), 0L), new shader_types("volume", new EqShaderType(2), 0L), new shader_types("displacement", new EqShaderType(3), 0L), new shader_types("transformation", new EqShaderType(4), 0L), new shader_types("imager", new EqShaderType(5), 0L)};
    public static int gcShaderTypeNames = gShaderTypeNames.length;
    public static final String[] gVariableTypeNames = new String[]{"invalid", "float", "integer", "point", "string", "color", "triple", "hpoint", "normal", "vector", "void", "matrix", "sixteentuple"};
    public static final int gcVariableTypeNames = gVariableTypeNames.length;
    public static final String[] gVariableClassNames = new String[]{"invalid", "constant", "uniform", "varying", "vertex", "facevarying"};
    public static final int gcVariableClassNames = gVariableClassNames.length;
    public static final String[] gVariableNames = new String[]{"Cs", "Os", "Ng", "du", "dv", "L", "Cl", "Ol", "P", "dPdu", "dPdv", "N", "u", "v", "s", "t", "I", "Ci", "Oi", "Ps", "E", "ncomps", "time", "alpha", "Ns"};
    public static final long[] gVariableTokens = new long[]{gVariableNames[0].hashCode(), gVariableNames[1].hashCode(), gVariableNames[2].hashCode(), gVariableNames[3].hashCode(), gVariableNames[4].hashCode(), gVariableNames[5].hashCode(), gVariableNames[6].hashCode(), gVariableNames[7].hashCode(), gVariableNames[8].hashCode(), gVariableNames[9].hashCode(), gVariableNames[10].hashCode(), gVariableNames[11].hashCode(), gVariableNames[12].hashCode(), gVariableNames[13].hashCode(), gVariableNames[14].hashCode(), gVariableNames[15].hashCode(), gVariableNames[16].hashCode(), gVariableNames[17].hashCode(), gVariableNames[18].hashCode(), gVariableNames[19].hashCode(), gVariableNames[20].hashCode(), gVariableNames[21].hashCode(), gVariableNames[22].hashCode(), gVariableNames[23].hashCode(), gVariableNames[24].hashCode()};
    public static final int gDefUses = 473444;
    public static final int gDefLightUses = 17301792;

    public static final String SO_sprintf(String str, int cParams, IqShaderData[] apParams, int varyingindex) {
        String strRes = "";
        String strTrans = str;
        int i = 0;
        int ivar = 0;
        while (i < strTrans.length()) {
            switch (strTrans.charAt(i)) {
                case '%': {
                    switch (strTrans.charAt(++i)) {
                        case 'f': {
                            p_float f = new p_float();
                            apParams[ivar++].GetFloat(f, varyingindex);
                            String strVal = String.format("%f", Float.valueOf(f.value));
                            strRes = String.valueOf(strRes) + strVal;
                            break;
                        }
                        case 'p': {
                            CqVector3D vec = new CqVector3D();
                            apParams[ivar++].GetPoint(vec, varyingindex);
                            String strVal = String.format("%f,%f,%f", Float.valueOf(vec.x), Float.valueOf(vec.y), Float.valueOf(vec.z));
                            strRes = String.valueOf(strRes) + strVal;
                            break;
                        }
                        case 'c': {
                            CqColor col = new CqColor();
                            apParams[ivar++].GetColor(col, varyingindex);
                            String strVal = String.format("%f,%f,%f", Float.valueOf(col.fRed()), Float.valueOf(col.fGreen()), Float.valueOf(col.fBlue()));
                            strRes = String.valueOf(strRes) + strVal;
                            break;
                        }
                        case 'm': {
                            CqMatrix mat = new CqMatrix();
                            apParams[ivar++].GetMatrix(mat, varyingindex);
                            String strVal = String.format("%f,%f,%f,%f\n%f,%f,%f,%f\n%f,%f,%f,%f\n%f,%f,%f,%f", Float.valueOf(mat.m_aaElement[0][0]), Float.valueOf(mat.m_aaElement[0][1]), Float.valueOf(mat.m_aaElement[0][2]), Float.valueOf(mat.m_aaElement[0][3]), Float.valueOf(mat.m_aaElement[1][0]), Float.valueOf(mat.m_aaElement[1][1]), Float.valueOf(mat.m_aaElement[1][2]), Float.valueOf(mat.m_aaElement[1][3]), Float.valueOf(mat.m_aaElement[2][0]), Float.valueOf(mat.m_aaElement[2][1]), Float.valueOf(mat.m_aaElement[2][2]), Float.valueOf(mat.m_aaElement[2][3]), Float.valueOf(mat.m_aaElement[3][0]), Float.valueOf(mat.m_aaElement[3][1]), Float.valueOf(mat.m_aaElement[3][2]), Float.valueOf(mat.m_aaElement[3][3]));
                            strRes = String.valueOf(strRes) + strVal;
                            break;
                        }
                        case 's': {
                            p_String stra = new p_String();
                            apParams[ivar++].GetString(stra, varyingindex);
                            strRes = String.valueOf(strRes) + stra.value;
                            break;
                        }
                        default: {
                            strRes = String.valueOf(strRes) + strTrans.charAt(i);
                        }
                    }
                    ++i;
                    break;
                }
                default: {
                    strRes = String.valueOf(strRes) + strTrans.charAt(i);
                    ++i;
                }
            }
        }
        return strRes;
    }

    public static final HashMap<String, BakingChannel> bake_init() {
        HashMap<String, BakingChannel> bd = new HashMap<String, BakingChannel>();
        return bd;
    }

    public static final void bake_done(HashMap<String, BakingChannel> bd) {
        for (BakingChannel bc : bd.values()) {
            bc.destruct();
        }
    }

    public static final void bake(HashMap<String, BakingChannel> bd, String name, float s, float t, int elsize, float[] data) {
        BakingChannel found = bd.get(name);
        if (found == null) {
            bd.put(name, new BakingChannel());
            BakingChannel bc = found = bd.get(name);
            bc.init(name, elsize);
            bc.moredata(s, t, data);
        } else {
            BakingChannel bc = found;
            bc.moredata(s, t, data);
        }
    }

    public static final int bake_f(HashMap<String, BakingChannel> bd, String name, float s, float t, float f) {
        float[] bakedata = new float[]{f};
        GlobalShaderExecEnv.bake(bd, name, s, t, 1, bakedata);
        return 0;
    }

    public static final int bake_3(HashMap<String, BakingChannel> bd, String name, float s, float t, float[] bakedata) {
        GlobalShaderExecEnv.bake(bd, name, s, t, 3, bakedata);
        return 0;
    }
}

