/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.library.types.CqVector3D;

public strictfp class CqVector4D {
    private static final long serialVersionUID = -739144048439837317L;
    public float x;
    public float y;
    public float z;
    public float w;

    public CqVector4D() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 1.0f;
    }

    public CqVector4D(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public CqVector4D(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = From.z;
        this.w = 1.0f;
    }

    public CqVector4D(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
        this.w = array[3];
    }

    public CqVector4D(CqVector4D v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public void z(float z) {
        this.z = z;
    }

    public void h(float h) {
        this.w = h;
    }

    public float Magnitude2() {
        if (this.w == 1.0f) {
            return this.x * this.x + this.y * this.y + this.z * this.z;
        }
        return (this.x * this.x + this.y * this.y + this.z * this.z) / (this.w * this.w);
    }

    public float Magnitude() {
        return (float)Math.sqrt(this.Magnitude2());
    }

    public void Unit() {
        this.w = this.Magnitude();
    }

    public void Homogenize() {
        if ((double)this.w != 1.0) {
            this.x /= this.w;
            this.y /= this.w;
            this.z /= this.w;
            this.w = 1.0f;
        }
    }

    public float valueAt(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        return this.w;
    }

    public CqVector4D assignment(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = From.z;
        this.w = 1.0f;
        return this;
    }

    public CqVector4D assignment(float a_x, float a_y, float a_z) {
        this.x = a_x;
        this.y = a_y;
        this.z = a_z;
        this.w = 1.0f;
        return this;
    }

    public CqVector4D assignment(CqVector4D From) {
        this.x = From.x;
        this.y = From.y;
        this.z = From.z;
        this.w = From.w;
        return this;
    }

    public CqVector4D assignment(float a_x, float a_y, float a_z, float a_w) {
        this.x = a_x;
        this.y = a_y;
        this.z = a_z;
        this.w = a_w;
        return this;
    }

    public CqVector4D assignAdd(CqVector4D From) {
        float Hom = this.w / From.w;
        this.x += From.x * Hom;
        this.y += From.y * Hom;
        this.z += From.z * Hom;
        return this;
    }

    public CqVector4D assignSub(CqVector4D From) {
        float Hom = this.w / From.w;
        this.x -= From.x * Hom;
        this.y -= From.y * Hom;
        this.z -= From.z * Hom;
        return this;
    }

    public CqVector4D assignMod(CqVector4D From) {
        CqVector4D A = new CqVector4D(this);
        CqVector4D B = new CqVector4D(From);
        A.Homogenize();
        B.Homogenize();
        this.x = A.y * B.z - A.z * B.y;
        this.y = A.z * B.x - A.x * B.z;
        this.z = A.x * B.y - A.y * B.x;
        return this;
    }

    public CqVector4D assignMul(float Scale) {
        this.x *= Scale;
        this.y *= Scale;
        this.z *= Scale;
        return this;
    }

    public CqVector4D assignDiv(float Scale) {
        this.w *= Scale;
        return this;
    }

    public boolean equals(CqVector4D Cmp) {
        return this.x == Cmp.x && this.y == Cmp.y && this.z == Cmp.z && this.w == Cmp.w;
    }

    public boolean ge(CqVector4D Cmp) {
        float Hom = this.w / Cmp.w;
        return this.x >= Cmp.x * Hom && this.y >= Cmp.y * Hom && this.z >= Cmp.z * Hom;
    }

    public boolean le(CqVector4D Cmp) {
        float Hom = this.w / Cmp.w;
        return this.x <= Cmp.x * Hom && this.y <= Cmp.y * Hom && this.z <= Cmp.z * Hom;
    }

    public boolean gt(CqVector4D Cmp) {
        float Hom = this.w / Cmp.w;
        return this.x > Cmp.x * Hom && this.y > Cmp.y * Hom && this.z > Cmp.z * Hom;
    }

    public boolean lt(CqVector4D Cmp) {
        float Hom = this.w / Cmp.w;
        return this.x < Cmp.x * Hom && this.y < Cmp.y * Hom && this.z < Cmp.z * Hom;
    }

    public CqVector4D mul(float f) {
        CqVector4D r = new CqVector4D(this);
        return r.assignMul(f);
    }

    public CqVector4D div(float f) {
        CqVector4D r = new CqVector4D(this);
        return r.assignDiv(f);
    }

    public CqVector4D divInv(float f) {
        CqVector4D r = new CqVector4D(this);
        return r.assignDiv(f);
    }

    public CqVector4D add(CqVector4D b) {
        CqVector4D r = new CqVector4D(this);
        return r.assignAdd(b);
    }

    public CqVector4D sub(CqVector4D b) {
        CqVector4D r = new CqVector4D(this);
        return r.assignSub(b);
    }

    public float mul(CqVector4D b) {
        CqVector4D A = new CqVector4D(this);
        CqVector4D B = new CqVector4D(b);
        A.Homogenize();
        B.Homogenize();
        return A.x * B.x + A.y * B.y + A.z * B.z;
    }

    public CqVector4D mod(CqVector4D b) {
        CqVector4D Temp = new CqVector4D(this);
        Temp.assignMod(b);
        return Temp;
    }
}

