/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library.types;

import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.CqVector4D;

public strictfp class CqVector2D {
    private static final long serialVersionUID = -3755250159902223025L;
    public float x;
    public float y;

    public CqVector2D() {
    }

    public CqVector2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public CqVector2D(CqVector2D From) {
        this.x = From.x;
        this.y = From.y;
    }

    public CqVector2D(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
    }

    public CqVector2D(CqVector4D From) {
        this.x = From.x / From.w;
        this.y = From.y / From.w;
    }

    public void x(float x) {
        this.x = x;
    }

    public void y(float y) {
        this.y = y;
    }

    public float Magnitude() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float Magnitude2() {
        return this.x * this.x + this.y * this.y;
    }

    public void Unit() {
        float Mag = this.Magnitude();
        this.x /= Mag;
        this.y /= Mag;
    }

    public CqVector2D assignment(CqVector2D From) {
        this.x = From.x;
        this.y = From.y;
        return this;
    }

    public CqVector2D assignment(CqVector3D From) {
        this.x = From.x;
        this.y = From.y;
        return this;
    }

    public CqVector2D assignment(CqVector4D From) {
        if (From.w != 1.0f) {
            this.x = From.x / From.w;
            this.y = From.y / From.w;
        } else {
            this.x = From.x;
            this.y = From.y;
        }
        return this;
    }

    public CqVector2D add(float f) {
        return new CqVector2D(this.x + f, this.y + f);
    }

    public CqVector2D add(CqVector2D b) {
        CqVector2D r = new CqVector2D(this.x, this.y);
        return r.assignAdd(b);
    }

    public CqVector2D sub(float f) {
        return new CqVector2D(this.x - f, this.y - f);
    }

    public CqVector2D sub(CqVector2D b) {
        CqVector2D r = new CqVector2D(this.x, this.y);
        return r.assignSub(b);
    }

    public CqVector2D subInv(float f) {
        return new CqVector2D(f - this.x, f - this.y);
    }

    public CqVector2D mul(float f) {
        return new CqVector2D(this.x * f, this.y * f);
    }

    public float mul(CqVector2D v) {
        return v.x * this.x + v.y * this.y;
    }

    public CqVector2D div(float f) {
        return new CqVector2D(this.x / f, this.y / f);
    }

    public CqVector2D divInv(float f) {
        return new CqVector2D(f / this.x, f / this.y);
    }

    public CqVector2D div(CqVector2D v) {
        return new CqVector2D(this.x / v.x, this.y / v.y);
    }

    public boolean equals(CqVector2D Cmp) {
        return this.x == Cmp.x && this.y == Cmp.y;
    }

    public CqVector2D assignAdd(float f) {
        this.x += f;
        this.y += f;
        return this;
    }

    public CqVector2D assignAdd(float x, float y) {
        this.x += x;
        this.y += y;
        return this;
    }

    public CqVector2D assignAdd(CqVector2D v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    }

    public CqVector2D assignSub(float f) {
        this.x -= f;
        this.y -= f;
        return this;
    }

    public CqVector2D assignSub(CqVector2D v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    }

    public CqVector2D assignMul(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public CqVector2D assignMul(CqVector2D v) {
        this.x *= v.x;
        this.y *= v.y;
        return this;
    }

    public CqVector2D assignDiv(float f) {
        this.x /= f;
        this.y /= f;
        return this;
    }

    public CqVector2D assignDiv(CqVector2D v) {
        this.x /= v.x;
        this.y /= v.y;
        return this;
    }
}

