/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqParameter;
import net.cellcomputing.himawari.library.CqParameterTypedVarying;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.CqSurfacePatchBicubic;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqSurfacePatchMeshBicubic
extends CqSurface {
    protected int m_uPatches;
    protected int m_vPatches;
    protected int m_nu;
    protected int m_nv;
    protected boolean m_uPeriodic;
    protected boolean m_vPeriodic;
    static /* synthetic */ Class class$0;

    public CqSurfacePatchMeshBicubic(int nu, int nv) {
        this(nu, nv, false, false);
    }

    public CqSurfacePatchMeshBicubic(int nu, int nv, boolean uPeriodic) {
        this(nu, nv, uPeriodic, false);
    }

    public CqSurfacePatchMeshBicubic(int nu, int nv, boolean uPeriodic, boolean vPeriodic) {
        this.m_nu = nu;
        this.m_nv = nv;
        this.m_uPeriodic = uPeriodic;
        this.m_vPeriodic = vPeriodic;
        int uStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[0];
        int vStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[1];
        this.m_uPatches = uPeriodic ? nu / uStep : (nu - 4) / uStep + 1;
        this.m_vPatches = vPeriodic ? nv / vStep : (nv - 4) / vStep + 1;
    }

    public CqSurfacePatchMeshBicubic(CqSurfacePatchMeshBicubic From) {
        super(From);
        this.assignment(From);
    }

    @Override
    public void destruct() {
    }

    public CqSurfacePatchMeshBicubic assignment(CqSurfacePatchMeshBicubic From) {
        super.assignment(From);
        this.m_uPatches = From.m_uPatches;
        this.m_vPatches = From.m_vPatches;
        this.m_nu = From.m_nu;
        this.m_nv = From.m_nv;
        this.m_uPeriodic = From.m_uPeriodic;
        this.m_vPeriodic = From.m_vPeriodic;
        return this;
    }

    @Override
    public void SetDefaultPrimitiveVariables(boolean bUseDef_st) {
    }

    @Override
    public CqBound Bound() {
        assert (this.P() != null);
        CqVector3D vecA = new CqVector3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        CqVector3D vecB = new CqVector3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int i = 0;
        while (i < this.P().Size()) {
            CqVector3D vecV = new CqVector3D(this.P().pValue_get(i, 0));
            if (vecV.x < vecA.x) {
                vecA.x(vecV.x);
            }
            if (vecV.y < vecA.y) {
                vecA.y(vecV.y);
            }
            if (vecV.x > vecB.x) {
                vecB.x(vecV.x);
            }
            if (vecV.y > vecB.y) {
                vecB.y(vecV.y);
            }
            if (vecV.z < vecA.z) {
                vecA.z(vecV.z);
            }
            if (vecV.z > vecB.z) {
                vecB.z(vecV.z);
            }
            ++i;
        }
        CqBound B = new CqBound();
        B.vecMin().assignment(vecA);
        B.vecMax().assignment(vecB);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqMicroPolyGridBase Dice() {
        return null;
    }

    public final int PatchCoord(int v, int u) {
        return v % this.m_nv * this.m_nu + u % this.m_nu;
    }

    public final int PatchCorner(int v, int u, int nvaryingu, int nvaryingv) {
        return v % nvaryingv * nvaryingu + u % nvaryingu;
    }

    @Override
    public int Split(STLVector<CqBasicSurface> aSplits) {
        int cSplits = 0;
        int iP = 0;
        int uStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[0];
        int vStep = this.pAttributes().GetIntegerAttribute("System", "BasisStep")[1];
        int nvaryingu = this.m_uPeriodic ? this.m_uPatches : this.m_uPatches + 1;
        int nvaryingv = this.m_vPeriodic ? this.m_vPatches : this.m_vPatches + 1;
        int MyUses = this.Uses();
        float[] pTC = this.pAttributes().GetFloatAttribute("System", "TextureCoordinates");
        CqVector2D st1 = new CqVector2D(pTC[0], pTC[1]);
        CqVector2D st2 = new CqVector2D(pTC[2], pTC[3]);
        CqVector2D st3 = new CqVector2D(pTC[4], pTC[5]);
        CqVector2D st4 = new CqVector2D(pTC[6], pTC[7]);
        int i = 0;
        while (i < this.m_vPatches) {
            int vRow = i * vStep;
            float v0 = 1.0f / (float)this.m_vPatches * (float)i;
            float v1 = 1.0f / (float)this.m_vPatches * (float)(i + 1);
            int j = 0;
            while (j < this.m_uPatches) {
                int uCol = j * uStep;
                CqSurfacePatchBicubic pSurface = new CqSurfacePatchBicubic();
                pSurface.SetSurfaceParameters(this);
                int iTa = this.PatchCorner(i, j, nvaryingu, nvaryingv);
                int iTb = this.PatchCorner(i, j + 1, nvaryingu, nvaryingv);
                int iTc = this.PatchCorner(i + 1, j, nvaryingu, nvaryingv);
                int iTd = this.PatchCorner(i + 1, j + 1, nvaryingu, nvaryingv);
                float u0 = 1.0f / (float)this.m_uPatches * (float)j;
                float u1 = 1.0f / (float)this.m_uPatches * (float)(j + 1);
                for (CqParameter iUP : this.aUserParams()) {
                    CqParameter pNewUP;
                    if (iUP.Class().getValue() == 3) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSurface.cVarying());
                        pNewUP.SetValue(iUP, 0, iTa);
                        pNewUP.SetValue(iUP, 1, iTb);
                        pNewUP.SetValue(iUP, 2, iTc);
                        pNewUP.SetValue(iUP, 3, iTd);
                        pSurface.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 4) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.Clear();
                        pNewUP.SetSize(pSurface.cVertex());
                        int v = 0;
                        while (v < 4) {
                            iP = this.PatchCoord(vRow + v, uCol);
                            pNewUP.SetValue(iUP, v * 4, iP);
                            iP = this.PatchCoord(vRow + v, uCol + 1);
                            pNewUP.SetValue(iUP, v * 4 + 1, iP);
                            iP = this.PatchCoord(vRow + v, uCol + 2);
                            pNewUP.SetValue(iUP, v * 4 + 2, iP);
                            iP = this.PatchCoord(vRow + v, uCol + 3);
                            pNewUP.SetValue(iUP, v * 4 + 3, iP);
                            ++v;
                        }
                        pSurface.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() == 2) {
                        pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                        pNewUP.SetSize(pSurface.cUniform());
                        pNewUP.SetValue(iUP, 0, j);
                        pSurface.AddPrimitiveVariable(pNewUP);
                        continue;
                    }
                    if (iUP.Class().getValue() != 1) continue;
                    pNewUP = iUP.CloneType(iUP.strName(), iUP.Count());
                    pNewUP.SetSize(1);
                    pNewUP.SetValue(iUP, 0, 0);
                    pSurface.AddPrimitiveVariable(pNewUP);
                }
                if (RiGlobal.USES(MyUses, 12) && !this.bHasVar(12)) {
                    pSurface.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("u", new EqVariableType(1), p_float.class, p_float.class));
                    pSurface.u().SetSize(4);
                    pSurface.u().pValue_get((int)0, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)0.0f), new p_float((float)1.0f), (float)u0, (float)v0, p_float.class).value;
                    pSurface.u().pValue_get((int)1, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)0.0f), new p_float((float)1.0f), (float)u1, (float)v0, p_float.class).value;
                    pSurface.u().pValue_get((int)2, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)0.0f), new p_float((float)1.0f), (float)u0, (float)v1, p_float.class).value;
                    pSurface.u().pValue_get((int)3, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)0.0f), new p_float((float)1.0f), (float)u1, (float)v1, p_float.class).value;
                }
                if (RiGlobal.USES(MyUses, 13) && !this.bHasVar(13)) {
                    pSurface.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("v", new EqVariableType(1), p_float.class, p_float.class));
                    pSurface.v().SetSize(4);
                    pSurface.v().pValue_get((int)0, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)1.0f), (float)u0, (float)v0, p_float.class).value;
                    pSurface.v().pValue_get((int)1, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)1.0f), (float)u1, (float)v0, p_float.class).value;
                    pSurface.v().pValue_get((int)2, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)1.0f), (float)u0, (float)v1, p_float.class).value;
                    pSurface.v().pValue_get((int)3, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)0.0f), new p_float((float)0.0f), new p_float((float)1.0f), new p_float((float)1.0f), (float)u1, (float)v1, p_float.class).value;
                }
                if (RiGlobal.USES(MyUses, 14) && !this.bHasVar(14)) {
                    pSurface.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("s", new EqVariableType(1), p_float.class, p_float.class));
                    pSurface.s().SetSize(4);
                    pSurface.s().pValue_get((int)0, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.x), new p_float((float)st2.x), new p_float((float)st3.x), new p_float((float)st4.x), (float)u0, (float)v0, p_float.class).value;
                    pSurface.s().pValue_get((int)1, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.x), new p_float((float)st2.x), new p_float((float)st3.x), new p_float((float)st4.x), (float)u1, (float)v0, p_float.class).value;
                    pSurface.s().pValue_get((int)2, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.x), new p_float((float)st2.x), new p_float((float)st3.x), new p_float((float)st4.x), (float)u0, (float)v1, p_float.class).value;
                    pSurface.s().pValue_get((int)3, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.x), new p_float((float)st2.x), new p_float((float)st3.x), new p_float((float)st4.x), (float)u1, (float)v1, p_float.class).value;
                }
                if (RiGlobal.USES(MyUses, 15) && !this.bHasVar(15)) {
                    pSurface.AddPrimitiveVariable(new CqParameterTypedVarying<p_float, p_float>("t", new EqVariableType(1), p_float.class, p_float.class));
                    pSurface.t().SetSize(4);
                    pSurface.t().pValue_get((int)0, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.y), new p_float((float)st2.y), new p_float((float)st3.y), new p_float((float)st4.y), (float)u0, (float)v0, p_float.class).value;
                    pSurface.t().pValue_get((int)1, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.y), new p_float((float)st2.y), new p_float((float)st3.y), new p_float((float)st4.y), (float)u1, (float)v0, p_float.class).value;
                    pSurface.t().pValue_get((int)2, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.y), new p_float((float)st2.y), new p_float((float)st3.y), new p_float((float)st4.y), (float)u0, (float)v1, p_float.class).value;
                    pSurface.t().pValue_get((int)3, (int)0).value = RiGlobal.BilinearEvaluate(new p_float((float)st1.y), new p_float((float)st2.y), new p_float((float)st3.y), new p_float((float)st4.y), (float)u1, (float)v1, p_float.class).value;
                }
                aSplits.add(pSurface);
                ++cSplits;
                ++j;
            }
            ++i;
        }
        return cSplits;
    }

    @Override
    public boolean Diceable() {
        return false;
    }

    @Override
    public boolean IsMotionBlurMatch(CqBasicSurface pSurf) {
        return false;
    }

    @Override
    public int cUniform() {
        return this.m_uPatches * this.m_vPatches;
    }

    @Override
    public int cVarying() {
        return (this.m_uPeriodic ? this.m_uPatches : this.m_uPatches + 1) * (this.m_vPeriodic ? this.m_vPatches : this.m_vPatches + 1);
    }

    @Override
    public int cVertex() {
        return this.m_nu * this.m_nv;
    }

    @Override
    public int cFaceVarying() {
        return 1;
    }

    @Override
    public CqVector3D SurfaceParametersAtVertex(int index) {
        CqVector3D vec = new CqVector3D(0.0f, 0.0f, 0.0f);
        float u = index % this.m_nu;
        float v = (float)index / (float)this.m_nu;
        vec.x(u /= (float)(this.m_nu - 1));
        vec.y(v /= (float)(this.m_nv - 1));
        return vec;
    }
}

