/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqRiFile;
import net.cellcomputing.himawari.library.CqShadowMapBuffer;
import net.cellcomputing.himawari.library.CqTextureMap;
import net.cellcomputing.himawari.library.CqTextureMapBuffer;
import net.cellcomputing.himawari.library.EqMapType;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqRandom;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.util.HimawariLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqShadowMap
extends CqTextureMap {
    static final int NumSamples = 16;
    static final int MinSamples = 3;
    static int m_rand_index = -1;
    static float[] m_aRand_no = new float[256];
    float m_bias;
    float m_bias0;
    float m_bias1;
    ArrayList<CqMatrix> m_WorldToCameraMatrices = new ArrayList();
    ArrayList<CqMatrix> m_WorldToScreenMatrices = new ArrayList();
    ArrayList<CqMatrix> m_ITTCameraToLightMatrices = new ArrayList();
    int m_NumberOfMaps;
    static CqRandom rand;
    static CqRandom random;

    static {
        random = new CqRandom(42);
    }

    public CqShadowMap(String strName) {
        super(strName);
        rand = new CqRandom();
        if (m_rand_index < 0) {
            int i = 0;
            while (i < 256) {
                CqShadowMap.m_aRand_no[i] = rand.RandomFloat(2.0f) - 1.0f;
                ++i;
            }
            m_rand_index = 0;
        }
    }

    @Override
    public int NumPages() {
        return this.m_NumberOfMaps;
    }

    @Override
    public void PrepareSampleOptions(HashMap<String, IqShaderData> paramMap) {
        super.PrepareSampleOptions(paramMap);
        this.m_bias = 0.0f;
        this.m_bias0 = 0.0f;
        this.m_bias1 = 0.0f;
        p_float temp_float = new p_float();
        if (!paramMap.isEmpty() && paramMap.containsKey("bias")) {
            paramMap.get("bias").GetFloat(temp_float);
            this.m_bias = temp_float.value;
        } else {
            float[] poptBias = RiGlobal.QGetRenderContextI().GetFloatOption("shadow", "bias0");
            if (poptBias != null) {
                this.m_bias0 = poptBias[0];
            }
            if ((poptBias = RiGlobal.QGetRenderContextI().GetFloatOption("shadow", "bias1")) != null) {
                this.m_bias1 = poptBias[0];
            }
            if ((poptBias = RiGlobal.QGetRenderContextI().GetFloatOption("shadow", "bias")) != null) {
                this.m_bias = poptBias[0];
            }
        }
    }

    @Override
    public void destruct() {
        super.destruct();
    }

    @Override
    public EqMapType Type() {
        return this.IsValid() ? new EqMapType(4) : new EqMapType(0);
    }

    public CqMatrix matWorldToCamera(int index) {
        assert (index < this.m_WorldToCameraMatrices.size());
        return this.m_WorldToCameraMatrices.get(index);
    }

    public void ReadMatrices() {
        CqMatrix matWToC = new CqMatrix();
        CqMatrix matWToS = new CqMatrix();
        RandomAccessFile file = null;
        this.m_NumberOfMaps = 0;
        CqMatrix matCToW = new CqMatrix(RiGlobal.QGetRenderContextI().matSpaceToSpace("camera", "world", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContextI().Time()));
        CqRiFile fileImage = new CqRiFile(this.m_strName, "texture");
        if (!fileImage.IsValid()) {
            HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
            return;
        }
        String strRealName = fileImage.strRealName();
        fileImage.Close();
        try {
            try {
                String str;
                file = new RandomAccessFile(strRealName, "r");
                while ((str = file.readLine()) != null) {
                    float temp_f;
                    int j;
                    if (str.equals("SHADOW_CAMERA_POINT")) {
                        matWToC = new CqMatrix();
                        int i = 0;
                        while (i < 4) {
                            j = 0;
                            while (j < 4) {
                                matWToC.m_aaElement[i][j] = temp_f = file.readFloat();
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (str.equals("SHADOW_SCREEN_POINT")) {
                        matWToS = new CqMatrix();
                        int i = 0;
                        while (i < 4) {
                            j = 0;
                            while (j < 4) {
                                matWToS.m_aaElement[i][j] = temp_f = file.readFloat();
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!str.equals("END_SHADOW_HEADER")) continue;
                    matWToC.SetfIdentity(false);
                    matWToS.SetfIdentity(false);
                    matWToC.assignMul(matCToW);
                    matWToS.assignMul(matCToW);
                    CqMatrix matITTCToL = new CqMatrix(matWToC);
                    matITTCToL.m_aaElement[3][0] = 0.0f;
                    matITTCToL.m_aaElement[3][1] = 0.0f;
                    matITTCToL.m_aaElement[3][2] = 0.0f;
                    matITTCToL.m_aaElement[0][3] = 0.0f;
                    matITTCToL.m_aaElement[1][3] = 0.0f;
                    matITTCToL.m_aaElement[2][3] = 0.0f;
                    matITTCToL.m_aaElement[3][3] = 1.0f;
                    matITTCToL.Inverse();
                    matITTCToL.Transpose();
                    this.m_WorldToCameraMatrices.add(matWToC);
                    this.m_WorldToScreenMatrices.add(matWToS);
                    this.m_ITTCameraToLightMatrices.add(matITTCToL);
                    ++this.m_NumberOfMaps;
                    file.skipBytes((int)(this.m_YRes * this.m_XRes * 4L));
                }
            }
            catch (FileNotFoundException e) {
                HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
            }
        }
    }

    public CqMatrix matWorldToCamera() {
        return this.matWorldToCamera(0);
    }

    public CqMatrix matWorldToScreen(int index) {
        assert (index < this.m_WorldToScreenMatrices.size());
        return this.m_WorldToScreenMatrices.get(index);
    }

    public CqMatrix matWorldToScreen() {
        return this.matWorldToScreen(0);
    }

    public void AllocateMap(int XRes, int YRes) {
        for (CqTextureMapBuffer s : this.m_apSegments) {
            s.destruct();
        }
        this.m_XRes = XRes;
        this.m_YRes = YRes;
        this.m_apSegments.add(this.CreateBuffer(0L, 0L, this.m_XRes, this.m_YRes, 1));
    }

    public void SaveZFile() {
    }

    public void LoadZFile() {
    }

    public void SaveShadowMap(String strShadowName, boolean append) {
    }

    public void SaveShadowMap(String strShadowName) {
        this.SaveShadowMap(strShadowName, false);
    }

    @Override
    public void SampleMap(CqVector3D vecPoint, CqVector3D swidth, CqVector3D twidth, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
        if (this.m_XRes != 0L) {
            this.SampleMap(vecPoint, vecPoint, vecPoint, vecPoint, val, index, average_depth, shadow_depth);
        } else {
            val.resize(1);
            val.setValueAt(0, 0.0f);
        }
    }

    @Override
    public void SampleMap(CqVector3D R1, CqVector3D R2, CqVector3D R3, CqVector3D R4, Valarray val, int index, p_float average_depth, p_float shadow_depth) {
        int nt;
        int ns;
        float tmin;
        float smax;
        float smin;
        this.CriticalMeasure();
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Start();
        val.resize(1);
        val.setValueAt(0, 0.0f);
        CqVector3D vecR1l = new CqVector3D();
        CqVector3D vecR1m = new CqVector3D();
        CqVector3D vecR2m = new CqVector3D();
        CqVector3D vecR3m = new CqVector3D();
        CqVector3D vecR4m = new CqVector3D();
        if (!(this.m_bias > 0.0f)) {
            if (this.m_bias1 >= this.m_bias0) {
                this.m_bias = random.RandomFloat(this.m_bias1 - this.m_bias0) + this.m_bias0;
                if (this.m_bias > this.m_bias1) {
                    this.m_bias = this.m_bias1;
                }
            } else {
                this.m_bias = random.RandomFloat(this.m_bias0 - this.m_bias1) + this.m_bias1;
                if (this.m_bias > this.m_bias0) {
                    this.m_bias = this.m_bias0;
                }
            }
        }
        CqVector3D vecBias = new CqVector3D(0.0f, 0.0f, this.m_bias);
        CqMatrix matCameraToLight = new CqMatrix(this.matWorldToCamera(index));
        CqMatrix matCameraToMap = new CqMatrix(this.matWorldToScreen(index));
        R1.assignSub(vecBias);
        R2.assignSub(vecBias);
        R3.assignSub(vecBias);
        R4.assignSub(vecBias);
        vecR1l.assignment(matCameraToLight.multiply(R1.add(R2).add(R3).add(R4).mul(0.25f)));
        float z = vecR1l.z;
        vecR1m.assignment(matCameraToMap.multiply(R1));
        vecR2m.assignment(matCameraToMap.multiply(R2));
        vecR3m.assignment(matCameraToMap.multiply(R3));
        vecR4m.assignment(matCameraToMap.multiply(R4));
        float sbo2 = this.m_sblur * (float)(this.m_XRes - 1L) * 0.5f;
        float tbo2 = this.m_tblur * (float)(this.m_YRes - 1L) * 0.5f;
        float xro2 = (float)(this.m_XRes - 1L) * 0.5f;
        float yro2 = (float)(this.m_YRes - 1L) * 0.5f;
        float s1 = vecR1m.x * xro2 + xro2 - this.m_pswidth / 2.0f;
        float t1 = (float)this.m_YRes - (vecR1m.y * yro2 + yro2) - 1.0f - this.m_ptwidth / 2.0f;
        float s2 = vecR2m.x * xro2 + xro2 + this.m_pswidth / 2.0f;
        float t2 = (float)this.m_YRes - (vecR2m.y * yro2 + yro2) - 1.0f + this.m_ptwidth / 2.0f;
        float s3 = vecR3m.x * xro2 + xro2 + this.m_pswidth / 2.0f;
        float t3 = (float)this.m_YRes - (vecR3m.y * yro2 + yro2) - 1.0f - this.m_ptwidth / 2.0f;
        float s4 = vecR4m.x * xro2 + xro2 - this.m_pswidth / 2.0f;
        float t4 = (float)this.m_YRes - (vecR4m.y * yro2 + yro2) - 1.0f + this.m_ptwidth / 2.0f;
        float f = s1 < s2 ? s1 : (s2 < s3 ? s2 : (smin = s3 < s4 ? s3 : s4));
        float f2 = s1 > s2 ? s1 : (s2 > s3 ? s2 : (smax = s3 > s4 ? s3 : s4));
        float f3 = t1 < t2 ? t1 : (t2 < t3 ? t2 : (tmin = t3 < t4 ? t3 : t4));
        float tmax = t1 > t2 ? t1 : (t2 > t3 ? t2 : (t3 > t4 ? t3 : t4));
        long lu = (int)Math.floor(smin);
        long hu = (int)Math.ceil(smax);
        long lv = (int)Math.floor(tmin);
        long hv = (int)Math.ceil(tmax);
        if ((lu -= (long)((int)sbo2)) >= this.m_XRes || (hu += (long)((int)sbo2)) < 0L || (lv -= (long)((int)tbo2)) >= this.m_YRes || (hv += (long)((int)tbo2)) < 0L) {
            return;
        }
        lu = Math.max(0L, lu);
        lv = Math.max(0L, lv);
        hu = Math.min(this.m_XRes - 1L, hu);
        hv = Math.min(this.m_YRes - 1L, hv);
        float sres = hu - lu;
        float tres = hv - lv;
        if (this.m_samples > 0.0f) {
            nt = ns = (int)Math.ceil(Math.sqrt(this.m_samples));
        } else if ((double)(sres * tres) * 4.0 < 16.0) {
            ns = (int)((double)sres * 2.0 + 0.5);
            ns = ns < 3 ? 3 : (ns > 16 ? 16 : ns);
            nt = (int)((double)tres * 2.0 + 0.5);
            nt = nt < 3 ? 3 : (nt > 16 ? 16 : nt);
        } else {
            nt = (int)(Math.sqrt(tres * 16.0f / sres) + 0.5);
            nt = nt < 3 ? 3 : (nt > 16 ? 16 : nt);
            ns = (int)(16.0f / (float)nt + 0.5f);
            ns = ns < 3 ? 3 : (ns > 16 ? 16 : ns);
        }
        float ds = sres / (float)ns;
        float dt = tres / (float)nt;
        float js = ds * 0.5f;
        float jt = dt * 0.5f;
        int inshadow = 0;
        float avz = 0.0f;
        float sample_z = 0.0f;
        float s = lu;
        CqTextureMapBuffer pTMBa = null;
        int i = 0;
        while (i < ns) {
            float t = lv;
            int j = 0;
            while (j < nt) {
                m_rand_index = m_rand_index + 1 & 0xFF;
                int iu = (int)(s + m_aRand_no[m_rand_index] * js);
                m_rand_index = m_rand_index + 1 & 0xFF;
                int iv = (int)(t + m_aRand_no[m_rand_index] * jt);
                if (iu >= 0 && (long)iu <= this.m_XRes && iv >= 0 && (long)iv <= this.m_YRes) {
                    if (pTMBa == null || !pTMBa.IsValid(iu, iv, index)) {
                        pTMBa = this.GetBuffer(iu, iv, index);
                    }
                    if (pTMBa != null && pTMBa.pVoidBufferData() != null) {
                        float mapz = pTMBa.GetValue(iu = (int)((long)iu - pTMBa.sOrigin()), iv = (int)((long)iv - pTMBa.tOrigin()), 0);
                        if (z > mapz) {
                            ++inshadow;
                            sample_z = z - mapz;
                        }
                        avz += mapz;
                    }
                    t += dt;
                }
                ++j;
            }
            s += ds;
            ++i;
        }
        if (average_depth != null) {
            average_depth.value = avz /= (float)(ns * nt);
        }
        if (shadow_depth != null) {
            shadow_depth.value = sample_z /= (float)(ns * nt);
        }
        val.setValueAt(0, (float)inshadow / (float)(ns * nt));
        RiGlobal.QGetRenderContext().Stats().TextureMapTimer().Stop();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CqTextureMapBuffer GetBuffer(long s, long t, int directory, boolean fProt) {
        block27: {
            RiGlobal.QGetRenderContext().Stats().IncTextureMisses(4);
            if (this.m_apSegments.size() > 0 && ((CqTextureMapBuffer)this.m_apSegments.getFirst()).IsValid(s, t, directory)) {
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 4);
                return (CqTextureMapBuffer)this.m_apSegments.getFirst();
            }
            for (CqTextureMapBuffer i : this.m_apSegments) {
                if (!i.IsValid(s, t, directory)) continue;
                RiGlobal.QGetRenderContext().Stats().IncTextureHits(1, 4);
                pbuffer = i;
                this.m_apSegments.remove(i);
                this.m_apSegments.addFirst(pbuffer);
                return pbuffer;
            }
            pTMB = null;
            tsx = this.m_XRes;
            tsy = this.m_YRes;
            ox = s / tsx * tsx;
            oy = t / tsy * tsy;
            fileImage = new CqRiFile(this.m_strName, "texture");
            if (!fileImage.IsValid()) {
                HimawariLogger.getLogger().error("Cannot open texture file \"" + this.m_strName + "\"\n");
                return null;
            }
            strRealName = fileImage.strRealName();
            fileImage.Close();
            pTMB = this.CreateBuffer(ox, oy, tsx, tsy, directory, fProt);
            pdata = (Float[])pTMB.pVoidBufferData();
            count = 0;
            file = null;
            directory_count = 0;
            try {
                block28: {
                    file = new RandomAccessFile(strRealName, "r");
                    directory_count = 0;
                    break block28;
                    while (!str.equals("END_SHADOW_HEADER")) lbl-1000:
                    // 2 sources

                    {
                        ** while ((str = file.readLine()) == null)
lbl36:
                        // 1 sources

                    }
lbl37:
                    // 2 sources

                    if (!str.equals("END_SHADOW_HEADER")) {
                        HimawariLogger.getLogger().error("File invalid:" + this.m_strName + "\n");
                        var33_21 = null;
                        return var33_21;
                    }
                    ++directory_count;
                }
                if (directory_count < directory) ** GOTO lbl-1000
                ** while ((str = file.readLine()) != null)
lbl-1000:
                // 1 sources

                {
                    if (str.equals("END_SHADOW_HEADER")) break;
                    continue;
                }
lbl47:
                // 2 sources

                if (str.equals("END_SHADOW_HEADER")) ** GOTO lbl-1000
                HimawariLogger.getLogger().error("File invalid:" + this.m_strName + "\n");
                var33_22 = null;
                return var33_22;
            }
            catch (FileNotFoundException e) {
                HimawariLogger.outputException(e);
                break block27;
            }
            catch (IOException e) {
                HimawariLogger.outputException(e);
                break block27;
            }
lbl-1000:
            // 1 sources

            {
                buf = ByteBuffer.allocate(8192);
                max = this.m_XRes * this.m_YRes;
                read = 0L;
                channel = file.getChannel();
                while (read < max) {
                    tmpread = channel.read(buf);
                    buf.flip();
                    fbuf = buf.asFloatBuffer();
                    tmpread = count;
                    while (fbuf.position() < fbuf.limit()) {
                        pdata[count] = Float.valueOf(fbuf.get());
                        ++count;
                    }
                    tmpread = (long)count - tmpread;
                    read += tmpread;
                    buf.clear();
                }
                this.m_apSegments.addFirst(pTMB);
                break block27;
            }
            {
                finally {
                    try {
                        if (file != null) {
                            file.close();
                        }
                    }
                    catch (IOException e) {
                        HimawariLogger.outputException(e);
                    }
                }
            }
        }
        return pTMB;
    }

    @Override
    public CqTextureMapBuffer CreateBuffer(long xorigin, long yorigin, long width, long height, int directory, boolean fProt) {
        CqShadowMapBuffer pRes = new CqShadowMapBuffer();
        pRes.Init(xorigin, yorigin, width, height, this.m_SamplesPerPixel, directory, fProt);
        return pRes;
    }

    @Override
    public CqMatrix GetMatrix(int which, int index) {
        if (which == 0) {
            return this.matWorldToCamera(index);
        }
        if (which == 1) {
            return this.matWorldToScreen(index);
        }
        if (which == 2) {
            return this.m_ITTCameraToLightMatrices.get(index);
        }
        return this.matWorldToCamera(index);
    }
}

