/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqBucket;
import net.cellcomputing.himawari.library.CqImagePixel;
import net.cellcomputing.himawari.library.types.CqVector3D;

strictfp class CqOcclusionBox {
    protected int m_MinX = 0;
    protected int m_MinY = 0;
    protected int m_MaxX = 0;
    protected int m_MaxY = 0;
    protected float m_MinZ = Float.MAX_VALUE;
    protected float m_MaxZ = Float.MAX_VALUE;
    protected int m_Id = -1;
    protected static CqBucket m_Bucket;
    protected static CqOcclusionBox[] m_Hierarchy;
    protected static int m_HierarchyLevels;
    protected static int m_TotalBoxes;
    protected static int[] m_LevelStartId;
    protected boolean m_NeedsUpdating = false;

    public static void CreateHierarchy(int bucketXSize, int bucketYSize, int XFWidth, int YFWidth) {
        assert (m_Hierarchy == null);
        assert (m_LevelStartId == null);
        int xdivisions = (int)(StrictMath.log10(bucketXSize + XFWidth) / StrictMath.log10(2.0));
        int ydivisions = (int)(StrictMath.log10(bucketYSize + YFWidth) / StrictMath.log10(2.0));
        m_HierarchyLevels = StrictMath.min(xdivisions, ydivisions);
        m_LevelStartId = new int[m_HierarchyLevels + 1];
        CqOcclusionBox.m_LevelStartId[0] = 0;
        int numBoxes = 1;
        int i = 1;
        while (i < m_HierarchyLevels) {
            CqOcclusionBox.m_LevelStartId[i] = numBoxes;
            numBoxes = numBoxes * 4 + 1;
            ++i;
        }
        CqOcclusionBox.m_LevelStartId[CqOcclusionBox.m_HierarchyLevels] = numBoxes;
        m_TotalBoxes = numBoxes;
        m_Hierarchy = new CqOcclusionBox[numBoxes];
        i = 0;
        while (i < numBoxes) {
            CqOcclusionBox.m_Hierarchy[i] = new CqOcclusionBox();
            CqOcclusionBox.m_Hierarchy[i].m_Id = i;
            ++i;
        }
    }

    public static void DeleteHierarchy() {
        assert (m_Hierarchy != null);
        assert (m_LevelStartId != null);
        m_Hierarchy = null;
        m_LevelStartId = null;
    }

    public static void SetupHierarchy(CqBucket bucket, int xMin, int yMin, int xMax, int yMax) {
        assert (bucket != null);
        m_Bucket = bucket;
        m_Hierarchy[0].SetBounds(xMin, yMin, xMax, yMax);
        m_Hierarchy[0].SetupChildren();
        m_Hierarchy[0].Clear();
    }

    public static void Update() {
        CqOcclusionBox.UpdateLevel(m_HierarchyLevels - 1);
    }

    public static boolean CanCull(CqBound bound) {
        return m_Hierarchy[0].IsCullable(bound);
    }

    public static void MarkForUpdate(int id) {
        assert (id >= 0 && id < m_TotalBoxes);
        m_Hierarchy[id].MarkForUpdate();
    }

    protected CqOcclusionBox() {
    }

    protected void SetupChildren() {
        int firstChildId = this.m_Id * 4 + 1;
        if (firstChildId >= m_TotalBoxes) {
            int j = this.m_MinY;
            while (j < this.m_MaxY) {
                int i = this.m_MinX;
                while (i < this.m_MaxX) {
                    int pie = CqBucket.ImageElement(i, j);
                    CqBucket.aieImage(pie).SetOcclusionBoxId(this.m_Id);
                    ++i;
                }
                ++j;
            }
        } else {
            int midX = (this.m_MaxX - this.m_MinX) / 2 + this.m_MinX;
            int midY = (this.m_MaxY - this.m_MinY) / 2 + this.m_MinY;
            m_Hierarchy[firstChildId].SetBounds(this.m_MinX, this.m_MinY, midX, midY);
            m_Hierarchy[firstChildId + 1].SetBounds(midX, this.m_MinY, this.m_MaxX, midY);
            m_Hierarchy[firstChildId + 2].SetBounds(this.m_MinX, midY, midX, this.m_MaxY);
            m_Hierarchy[firstChildId + 3].SetBounds(midX, midY, this.m_MaxX, this.m_MaxY);
            m_Hierarchy[firstChildId].SetupChildren();
            m_Hierarchy[firstChildId + 1].SetupChildren();
            m_Hierarchy[firstChildId + 2].SetupChildren();
            m_Hierarchy[firstChildId + 3].SetupChildren();
        }
    }

    protected static void UpdateLevel(int level) {
        assert (level < m_HierarchyLevels && level >= 0);
        int firstBox = m_LevelStartId[level];
        int lastBox = m_LevelStartId[level + 1] - 1;
        boolean updateNextLevel = false;
        int i = firstBox;
        while (i <= lastBox) {
            if (m_Hierarchy[i].NeedsUpdating() && m_Hierarchy[i].UpdateZValues()) {
                m_Hierarchy[i / 4].MarkForUpdate();
                updateNextLevel = true;
            }
            ++i;
        }
        if (updateNextLevel && level > 0) {
            CqOcclusionBox.UpdateLevel(level - 1);
        }
    }

    protected boolean UpdateZValues() {
        boolean madeUpdate = false;
        float currentMaxZ = -3.4028235E38f;
        float currentMinZ = this.m_MinZ;
        int firstChildId = this.m_Id * 4 + 1;
        if (firstChildId >= m_TotalBoxes) {
            int j = this.m_MinY;
            while (j < this.m_MaxY) {
                int i = this.m_MinX;
                while (i < this.m_MaxX) {
                    int pie = CqBucket.ImageElement(i, j);
                    CqImagePixel img = CqBucket.aieImage(pie);
                    if (img.NeedsZUpdating()) {
                        img.UpdateZValues();
                    }
                    if (img.MaxDepth() > currentMaxZ) {
                        currentMaxZ = img.MaxDepth();
                    }
                    if (img.MinDepth() < currentMinZ) {
                        currentMinZ = img.MinDepth();
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < 4) {
                if (CqOcclusionBox.m_Hierarchy[firstChildId + i].m_MaxZ > currentMaxZ) {
                    currentMaxZ = CqOcclusionBox.m_Hierarchy[firstChildId + i].m_MaxZ;
                }
                if (CqOcclusionBox.m_Hierarchy[firstChildId + i].m_MinZ < currentMinZ) {
                    currentMinZ = CqOcclusionBox.m_Hierarchy[firstChildId + i].m_MinZ;
                }
                ++i;
            }
        }
        if (currentMaxZ < this.m_MaxZ) {
            this.m_MaxZ = currentMaxZ;
            madeUpdate = true;
        }
        if (currentMinZ < this.m_MinZ) {
            this.m_MinZ = currentMinZ;
            madeUpdate = true;
        }
        this.m_NeedsUpdating = false;
        return madeUpdate;
    }

    protected void Clear() {
        this.m_MinZ = Float.MAX_VALUE;
        this.m_MaxZ = Float.MAX_VALUE;
        this.m_NeedsUpdating = false;
        int firstChildId = this.m_Id * 4 + 1;
        if (firstChildId >= m_TotalBoxes) {
            return;
        }
        int i = 0;
        while (i < 4) {
            m_Hierarchy[firstChildId + i].Clear();
            ++i;
        }
    }

    protected void SetBounds(int x0, int y0, int x1, int y1) {
        this.m_MinX = x0;
        this.m_MinY = y0;
        this.m_MaxX = x1;
        this.m_MaxY = y1;
    }

    protected boolean Overlaps(CqBound bound) {
        boolean retval = true;
        if (!(bound.vecMin().x <= (float)this.m_MaxX && bound.vecMin().y <= (float)this.m_MaxY && bound.vecMax().x >= (float)this.m_MinX && bound.vecMax().y >= (float)this.m_MinY)) {
            retval = false;
        }
        return retval;
    }

    protected boolean IsCullable(CqBound bound) {
        CqVector3D vecMin = bound.vecMin();
        CqVector3D vecMax = bound.vecMax();
        float zVal = vecMin.z;
        if (zVal > this.m_MaxZ) {
            return true;
        }
        if (zVal < this.m_MinZ) {
            return false;
        }
        int firstChildId = this.m_Id * 4 + 1;
        if (firstChildId >= m_TotalBoxes) {
            int x0 = StrictMath.max(this.m_MinX, (int)vecMin.x);
            int y0 = StrictMath.max(this.m_MinY, (int)vecMin.y);
            int x1 = StrictMath.min(this.m_MaxX, (int)vecMax.x);
            int y1 = StrictMath.min(this.m_MaxY, (int)vecMax.y);
            int j = y0;
            while (j < y1) {
                int i = x0;
                while (i < x1) {
                    if (zVal < m_Bucket.MaxDepth(i, j)) {
                        return false;
                    }
                    ++i;
                }
                ++j;
            }
        } else {
            int i = 0;
            while (i < 4) {
                if (m_Hierarchy[firstChildId + i].Overlaps(bound) && !m_Hierarchy[firstChildId + i].IsCullable(bound)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean NeedsUpdating() {
        return this.m_NeedsUpdating;
    }

    protected void MarkForUpdate() {
        this.m_NeedsUpdating = true;
    }
}

