/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.library.CqAttributeModeBlock;
import net.cellcomputing.himawari.library.CqAttributes;
import net.cellcomputing.himawari.library.CqCSGTreeNode;
import net.cellcomputing.himawari.library.CqFrameModeBlock;
import net.cellcomputing.himawari.library.CqLightsource;
import net.cellcomputing.himawari.library.CqMainModeBlock;
import net.cellcomputing.himawari.library.CqMotionModeBlock;
import net.cellcomputing.himawari.library.CqObjectModeBlock;
import net.cellcomputing.himawari.library.CqOptions;
import net.cellcomputing.himawari.library.CqSolidModeBlock;
import net.cellcomputing.himawari.library.CqTransform;
import net.cellcomputing.himawari.library.CqTransformModeBlock;
import net.cellcomputing.himawari.library.CqWorldModeBlock;
import net.cellcomputing.himawari.library.EqModeBlock;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqModeBlock {
    public CqAttributes m_pattrCurrent;
    public CqTransform m_ptransCurrent;
    private CqModeBlock m_pconParent;
    private EqModeBlock m_modetype = new EqModeBlock();
    private HimawariLogger logger = HimawariLogger.getLogger();

    public CqModeBlock() {
    }

    public CqModeBlock(CqModeBlock pconParent) {
        this.m_pattrCurrent = null;
        this.m_ptransCurrent = null;
        this.m_pconParent = pconParent;
        this.m_modetype.setValue(0);
    }

    public CqModeBlock(CqModeBlock pconParent, int modetype) {
        this.m_pattrCurrent = null;
        this.m_ptransCurrent = null;
        this.m_pconParent = pconParent;
        this.m_modetype.setValue(modetype);
    }

    public void destruct() {
    }

    public CqModeBlock BeginMainModeBlock() {
        return new CqMainModeBlock(this);
    }

    public CqModeBlock BeginFrameModeBlock() {
        return new CqFrameModeBlock(this);
    }

    public CqModeBlock BeginWorldModeBlock() {
        return new CqWorldModeBlock(this);
    }

    public CqModeBlock BeginAttributeModeBlock() {
        return new CqAttributeModeBlock(this);
    }

    public CqModeBlock BeginTransformModeBlock() {
        return new CqTransformModeBlock(this);
    }

    public CqModeBlock BeginSolidModeBlock(String type) {
        return new CqSolidModeBlock(type, this);
    }

    public CqModeBlock BeginObjectModeBlock() {
        return new CqObjectModeBlock(this);
    }

    public CqModeBlock BeginMotionModeBlock(int N, float[] times) {
        return new CqMotionModeBlock(N, times, this);
    }

    public void EndMainModeBlock() {
        this.logInvalidNesting();
    }

    public void EndFrameModeBlock() {
        this.logInvalidNesting();
    }

    public void EndWorldModeBlock() {
        this.logInvalidNesting();
    }

    public void EndAttributeModeBlock() {
        this.logInvalidNesting();
    }

    public void EndTransformModeBlock() {
        this.logInvalidNesting();
    }

    public void EndSolidModeBlock() {
        this.logInvalidNesting();
    }

    public void EndObjectModeBlock() {
        this.logInvalidNesting();
    }

    public void EndMotionModeBlock() {
        this.logInvalidNesting();
    }

    public CqOptions optCurrent() {
        return null;
    }

    public CqAttributes pattrCurrent() {
        return this.m_pattrCurrent;
    }

    public final CqAttributes pattrCurrent(CqAttributes newattrs) {
        CqAttributes prev = this.m_pattrCurrent;
        this.m_pattrCurrent = newattrs;
        return prev;
    }

    public CqAttributes pattrWriteCurrent() {
        this.m_pattrCurrent = this.m_pattrCurrent.Write();
        return this.m_pattrCurrent;
    }

    public CqTransform ptransCurrent() {
        return this.m_ptransCurrent;
    }

    public CqTransform ptransSetCurrent(CqTransform NewTrans) {
        CqTransform prev = this.m_ptransCurrent;
        this.m_ptransCurrent = NewTrans;
        return prev;
    }

    public float Time() {
        return 0.0f;
    }

    public void AdvanceTime() {
    }

    public int TimeIndex() {
        return 0;
    }

    public boolean fMotionBlock() {
        return false;
    }

    public CqModeBlock pconParent() {
        return this.m_pconParent;
    }

    public EqModeBlock Type() {
        return this.m_modetype;
    }

    public CqMatrix matCurrent(float time) {
        return this.ptransCurrent().matObjectToWorld(time);
    }

    public void AddContextLightSource(CqLightsource pLS) {
        if (this.pconParent() != null) {
            this.pconParent().AddContextLightSource(pLS);
        }
    }

    public boolean isSolid() {
        return this.pconParent() != null ? this.pconParent().isSolid() : false;
    }

    public CqCSGTreeNode pCSGNode() {
        return this.pconParent() != null ? this.pconParent().pCSGNode() : null;
    }

    public void logInvalidNesting() {
        this.logger.critical("Invalid context nesting");
    }
}

