/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.util.HashMap;
import java.util.Set;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqCSGTreeNode;
import net.cellcomputing.himawari.library.CqImageBuffer;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqMicroPolygon;
import net.cellcomputing.himawari.library.CqMicroPolygonMotion;
import net.cellcomputing.himawari.library.CqRenderer;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.CqSurface;
import net.cellcomputing.himawari.library.IqAttributes;
import net.cellcomputing.himawari.library.IqShader;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.IqShaderExecEnv;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqBitVector;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.shaderexecenv.CqShaderExecEnv;

public class CqMicroPolyGrid
extends CqMicroPolyGridBase {
    private boolean m_bShadingNormals = false;
    private boolean m_bGeometricNormals = false;
    private CqSurface m_pSurface;
    private CqCSGTreeNode m_pCSGNode;
    private CqBitVector m_CulledPolys = new CqBitVector();
    private STLVector<IqShaderData> m_apShaderOutputVariables = new STLVector<IqShaderData>(IqShaderData.class);
    protected IqShaderExecEnv m_pShaderExecEnv;
    static CqVector3D vecE = new CqVector3D(0.0f, 0.0f, 0.0f);
    static CqVector3D Defvec = new CqVector3D(0.0f, 0.0f, 0.0f);
    static /* synthetic */ Class class$0;

    public CqMicroPolyGrid() {
        CqStats.STATS_INC(28);
    }

    public CqMicroPolyGrid(int cu, int cv, CqSurface pSurface) {
        this.m_pShaderExecEnv = new CqShaderExecEnv();
        CqStats.STATS_INC(24);
        CqStats.STATS_INC(26);
        CqStats.STATS_INC(28);
        int cGRD = CqStats.STATS_GETI(26);
        int cPeak = CqStats.STATS_GETI(27);
        CqStats.STATS_SETI(27, cGRD > cPeak ? cGRD : cPeak);
        this.Initialise(cu, cv, pSurface);
    }

    public void destruct() {
        assert (this.RefCount() <= 0);
        CqStats.STATS_INC(29);
        CqStats.STATS_DEC(26);
        for (IqShaderData outputVar : this.m_apShaderOutputVariables) {
            outputVar.destruct();
        }
        this.m_apShaderOutputVariables.clear();
    }

    public void CalcNormals() {
        if (this.pVar(8) == null || this.pVar(11) == null) {
            return;
        }
        boolean CSO = this.pSurface().pTransform().GetHandedness(this.pSurface().pTransform().Time(0));
        boolean O = this.pAttributes().GetIntegerAttribute("System", "Orientation")[0] != 0;
        CqVector3D[] vecMP = new CqVector3D[4];
        CqVector3D vecN = new CqVector3D();
        CqVector3D vecFailsafeN = new CqVector3D();
        STLArray<CqVector3D> pP = this.pVar(8).GetPointPtr_2();
        IqShaderData pNg = this.pVar(2);
        int ur = this.uGridRes();
        int vr = this.vGridRes();
        vecFailsafeN.exterior(pP.get(ur).sub(pP.get(0)), pP.get(vr * (ur + 1) + ur).sub(pP.get(0)));
        boolean triangle = false;
        if (pP.get(ur).equals(pP.get(vr * (ur + 1) + ur))) {
            triangle = true;
            vecFailsafeN = pP.get(ur).sub(pP.get(0)).mod(pP.get(vr * (ur + 1)).sub(pP.get(0)));
        }
        vecFailsafeN.Unit();
        int igrid = 0;
        int iv = 0;
        while (iv < vr) {
            int iu = 0;
            while (iu < ur) {
                vecMP[0] = pP.get(igrid);
                vecMP[1] = pP.get(igrid + 1);
                vecMP[2] = pP.get(igrid + ur + 2);
                vecMP[3] = pP.get(igrid + ur + 1);
                int a = 0;
                int b = 1;
                int c = 2;
                int d = 3;
                CqVector3D vecBA = vecMP[b].sub(vecMP[a]);
                CqVector3D vecCA = vecMP[c].sub(vecMP[a]);
                float bma = vecBA.Magnitude();
                float cma = vecCA.Magnitude();
                if (bma < 1.1920929E-7f) {
                    b = 3;
                    vecBA = vecMP[b].sub(vecMP[a]);
                    bma = vecBA.Magnitude();
                }
                if (triangle && iu == ur - 1) {
                    vecCA = vecMP[d].sub(vecMP[a]);
                }
                if (bma > 1.1920929E-7f && cma > 1.1920929E-7f && !vecBA.equals(vecCA)) {
                    vecN.exterior(vecBA, vecCA);
                    vecN.Unit();
                    vecN = O == CSO ? vecN : vecN.negative();
                } else {
                    vecN = vecFailsafeN;
                }
                pNg.SetNormal(vecN, igrid);
                ++igrid;
                if (iv == vr - 1) {
                    CqVector3D vecNN = new CqVector3D(vecN);
                    if (vr > 2) {
                        CqVector3D vecNm1 = new CqVector3D();
                        CqVector3D vecNm2 = new CqVector3D();
                        pNg.GetNormal(vecNm1, (vr - 1) * (ur + 1) + iu);
                        pNg.GetNormal(vecNm2, (vr - 2) * (ur + 1) + iu);
                        vecNN = vecNm1.sub(vecNm2).add(vecN);
                    }
                    pNg.SetNormal(vecNN, vr * (ur + 1) + iu);
                }
                ++iu;
            }
            CqVector3D vecNN = new CqVector3D(vecN);
            if (igrid > 2) {
                CqVector3D vecNm1 = new CqVector3D();
                CqVector3D vecNm2 = new CqVector3D();
                pNg.GetNormal(vecNm1, igrid - 1);
                pNg.GetNormal(vecNm2, igrid - 2);
                vecNN = vecNm1.sub(vecNm2).add(vecN);
            }
            pNg.SetNormal(vecNN, igrid);
            ++igrid;
            ++iv;
        }
        CqVector3D vecNN = new CqVector3D(vecN);
        if (vr > 2 && ur > 2) {
            CqVector3D vecNm1 = new CqVector3D();
            CqVector3D vecNm2 = new CqVector3D();
            pNg.GetNormal(vecNm1, (vr - 1) * (ur - 1) - 1);
            pNg.GetNormal(vecNm2, (vr - 2) * (ur - 2) - 1);
            vecNN = vecNm1.sub(vecNm2).add(vecN);
        }
        pNg.SetNormal(vecNN, (vr + 1) * (ur + 1) - 1);
    }

    public void SetbShadingNormals(boolean f) {
        this.m_bShadingNormals = f;
    }

    public void SetbGeometricNormals(boolean f) {
        this.m_bGeometricNormals = f;
    }

    public boolean bShadingNormals() {
        return this.m_bShadingNormals;
    }

    public boolean bGeometricNormals() {
        return this.m_bGeometricNormals;
    }

    public CqBitVector CulledPolys() {
        return this.m_CulledPolys;
    }

    public void Initialise(int cu, int cv, CqSurface pSurface) {
        int lUses = -1;
        if (pSurface != null) {
            lUses = pSurface.Uses();
            this.m_pSurface = pSurface;
            this.m_pCSGNode = pSurface.pCSGNode();
        }
        this.m_pShaderExecEnv.Initialise(cu, cv, pSurface.pAttributes(), pSurface.pTransform(), pSurface.pAttributes().pshadSurface(RiGlobal.QGetRenderContext().Time()), lUses |= RiGlobal.QGetRenderContext().pDDmanager().Uses());
        IqShader pshadSurface = pSurface.pAttributes().pshadSurface(RiGlobal.QGetRenderContext().Time());
        IqShader pshadDisplacement = pSurface.pAttributes().pshadDisplacement(RiGlobal.QGetRenderContext().Time());
        IqShader pshadAtmosphere = pSurface.pAttributes().pshadAtmosphere(RiGlobal.QGetRenderContext().Time());
        if (pshadSurface != null) {
            pshadSurface.Initialise(cu, cv, this.m_pShaderExecEnv);
        }
        if (pshadDisplacement != null) {
            pshadDisplacement.Initialise(cu, cv, this.m_pShaderExecEnv);
        }
        if (pshadAtmosphere != null) {
            pshadAtmosphere.Initialise(cu, cv, this.m_pShaderExecEnv);
        }
        this.m_CulledPolys.SetSize((cu + 1) * (cv + 1));
        this.m_CulledPolys.SetAll(false);
        int size = (cu + 1) * (cv + 1);
        CqStats.STATS_INC(30 + (int)PublicFunctions.CLAMP(CqStats.log2(size) - 2, 0.0f, 7.0f));
    }

    public void DeleteVariables(boolean all) {
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Cs") || all) {
            this.m_pShaderExecEnv.DeleteVariable(0);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Os") || all) {
            this.m_pShaderExecEnv.DeleteVariable(1);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("du") || all) {
            this.m_pShaderExecEnv.DeleteVariable(3);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("dv") || all) {
            this.m_pShaderExecEnv.DeleteVariable(4);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("L") || all) {
            this.m_pShaderExecEnv.DeleteVariable(5);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Cl") || all) {
            this.m_pShaderExecEnv.DeleteVariable(6);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ol") || all) {
            this.m_pShaderExecEnv.DeleteVariable(7);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("dPdu") || all) {
            this.m_pShaderExecEnv.DeleteVariable(9);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("dPdv") || all) {
            this.m_pShaderExecEnv.DeleteVariable(10);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("s") || all) {
            this.m_pShaderExecEnv.DeleteVariable(14);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("t") || all) {
            this.m_pShaderExecEnv.DeleteVariable(15);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("I") || all) {
            this.m_pShaderExecEnv.DeleteVariable(16);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ps") || all) {
            this.m_pShaderExecEnv.DeleteVariable(19);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("E") || all) {
            this.m_pShaderExecEnv.DeleteVariable(20);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("ncomps") || all) {
            this.m_pShaderExecEnv.DeleteVariable(21);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("time") || all) {
            this.m_pShaderExecEnv.DeleteVariable(22);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("alpha") || all) {
            this.m_pShaderExecEnv.DeleteVariable(23);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("N") || all) {
            this.m_pShaderExecEnv.DeleteVariable(11);
        }
        if (all) {
            this.m_pShaderExecEnv.DeleteVariable(12);
        }
        if (all) {
            this.m_pShaderExecEnv.DeleteVariable(13);
        }
        if (all) {
            this.m_pShaderExecEnv.DeleteVariable(8);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ng") || all) {
            this.m_pShaderExecEnv.DeleteVariable(2);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ci") || all) {
            this.m_pShaderExecEnv.DeleteVariable(17);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Oi") || all) {
            this.m_pShaderExecEnv.DeleteVariable(18);
        }
        if (!RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ns") || all) {
            this.m_pShaderExecEnv.DeleteVariable(24);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void Split(CqImageBuffer pImage, long xmin, long xmax, long ymin, long ymax) {
        if (this.pVar(8) == null) {
            return;
        }
        cu = this.uGridRes();
        cv = this.vGridRes();
        RiGlobal.QGetRenderContext().Stats().MakeProject().Start();
        matCameraToRaster = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time());
        matCameraToObject0 = RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "object", new CqMatrix(), this.pSurface().pTransform().matObjectToWorld(this.pSurface().pTransform().Time(0)), RiGlobal.QGetRenderContext().Time());
        pP = this.pVar(8).GetPointPtr_2();
        aaPtimes = new CqVector3D[this.pSurface().pTransform().cTimes()][];
        tTime = this.pSurface().pTransform().cTimes();
        gsmin1 = this.GridSize() - 1;
        iTime = 1;
        while (iTime < tTime) {
            matObjectToCameraT = RiGlobal.QGetRenderContext().matSpaceToSpace("object", "camera", new CqMatrix(), this.pSurface().pTransform().matObjectToWorld(this.pSurface().pTransform().Time(iTime)), RiGlobal.QGetRenderContext().Time());
            if (aaPtimes[iTime] == null || aaPtimes[iTime].length < gsmin1 + 1) {
                aaPtimes[iTime] = new CqVector3D[gsmin1 + 1];
            }
            ii = 0;
            while (ii < aaPtimes[iTime].length) {
                aaPtimes[iTime][ii] = new CqVector3D();
                ++ii;
            }
            i = gsmin1;
            while (i >= 0) {
                Point = new CqVector3D(pP.get(i));
                Point.assignment(matCameraToObject0.multiply(Point));
                Point.assignment(matObjectToCameraT.multiply(Point));
                zdepth = Point.z;
                aaPtimes[iTime][i].assignment(matCameraToRaster.multiply(Point));
                aaPtimes[iTime][i].z = zdepth;
                --i;
            }
            sl = new CqMicroPolyGridBase.SqTriangleSplitLine(this);
            v0 = aaPtimes[iTime][0];
            v1 = aaPtimes[iTime][cu];
            v2 = aaPtimes[iTime][cv * (cu + 1)];
            if ((v1.x - v0.x) * (v2.y - v0.y) - (v1.y - v0.y) * (v2.x - v0.x) >= 0.0f) {
                sl.m_TriangleSplitPoint1.assignment(v1);
                sl.m_TriangleSplitPoint2.assignment(v2);
            } else {
                sl.m_TriangleSplitPoint1.assignment(v2);
                sl.m_TriangleSplitPoint2.assignment(v1);
            }
            this.m_TriangleSplitLine.AddTimeSlot(this.pSurface().pTransform().Time(iTime), sl);
            ++iTime;
        }
        i = gsmin1;
        while (i >= 0) {
            if (aaPtimes[0] == null || aaPtimes[0].length < gsmin1 + 1) {
                aaPtimes[0] = new CqVector3D[gsmin1 + 1];
                ii = 0;
                while (ii < aaPtimes[0].length) {
                    aaPtimes[0][ii] = new CqVector3D();
                    ++ii;
                }
            }
            zdepth = pP.get((int)i).z;
            aaPtimes[0][i].assignment(matCameraToRaster.multiply(pP.get(i)));
            aaPtimes[0][i].z = zdepth;
            pP.get(i).assignment(aaPtimes[0][i]);
            --i;
        }
        sl = new CqMicroPolyGridBase.SqTriangleSplitLine(this);
        vec0 = aaPtimes[0][0];
        vec1 = aaPtimes[0][cu];
        vec2 = aaPtimes[0][cv * (cu + 1)];
        if ((vec1.x - vec0.x) * (vec2.y - vec0.y) - (vec1.y - vec0.y) * (vec2.x - vec0.x) >= 0.0f) {
            sl.m_TriangleSplitPoint1.assignment(vec1);
            sl.m_TriangleSplitPoint2.assignment(vec2);
        } else {
            sl.m_TriangleSplitPoint1.assignment(vec2);
            sl.m_TriangleSplitPoint2.assignment(vec1);
        }
        this.m_TriangleSplitLine.AddTimeSlot(this.pSurface().pTransform().Time(0), sl);
        RiGlobal.QGetRenderContext().Stats().MakeProject().Stop();
        pattrTrimSense = this.pAttributes().GetStringAttribute("trimcurve", "sense");
        strTrimSense = "inside";
        if (pattrTrimSense != null) {
            strTrimSense = pattrTrimSense[0];
        }
        bOutside = strTrimSense.equals("outside");
        bCanBeTrimmed = this.pSurface().bCanBeTrimmed() != false && this.pVar(12) != null && this.pVar(13) != null;
        this.AddRef();
        iv = 0;
        while (iv < cv) {
            iu = 0;
            while (iu < cu) {
                block27: {
                    block26: {
                        iIndex = iv * (cu + 1) + iu;
                        if (!this.m_CulledPolys.Value(iIndex)) break block26;
                        CqStats.STATS_INC(50);
                        break block27;
                    }
                    fTrimmed = false;
                    if (!bCanBeTrimmed) ** GOTO lbl137
                    u1 = new p_float();
                    this.pVar(12).GetFloat(u1, iIndex);
                    v1 = new p_float();
                    this.pVar(13).GetFloat(v1, iIndex);
                    u2 = new p_float();
                    this.pVar(12).GetFloat(u2, iIndex + 1);
                    v2 = new p_float();
                    this.pVar(13).GetFloat(v2, iIndex + 1);
                    u3 = new p_float();
                    this.pVar(12).GetFloat(u3, iIndex + cu + 2);
                    v3 = new p_float();
                    this.pVar(13).GetFloat(v3, iIndex + cu + 2);
                    u4 = new p_float();
                    this.pVar(12).GetFloat(u4, iIndex + cu + 1);
                    v4 = new p_float();
                    this.pVar(13).GetFloat(v4, iIndex + cu + 1);
                    vecA = new CqVector2D(u1.value, v1.value);
                    vecB = new CqVector2D(u2.value, v2.value);
                    vecC = new CqVector2D(u3.value, v3.value);
                    vecD = new CqVector2D(u4.value, v4.value);
                    fTrimA = this.pSurface().bIsPointTrimmed(vecA);
                    fTrimB = this.pSurface().bIsPointTrimmed(vecB);
                    fTrimC = this.pSurface().bIsPointTrimmed(vecC);
                    fTrimD = this.pSurface().bIsPointTrimmed(vecD);
                    if (bOutside) {
                        fTrimA = fTrimA == false;
                        fTrimB = fTrimB == false;
                        fTrimC = fTrimC == false;
                        v0 = fTrimD = fTrimD == false;
                    }
                    if (fTrimA && fTrimB && fTrimC && fTrimD && !this.pSurface().bIsLineIntersecting(vecA, vecB) && !this.pSurface().bIsLineIntersecting(vecB, vecC) && !this.pSurface().bIsLineIntersecting(vecC, vecD) && !this.pSurface().bIsLineIntersecting(vecD, vecA)) {
                        CqStats.STATS_INC(53);
                    } else {
                        if (fTrimA || fTrimB || fTrimC || fTrimD) {
                            fTrimmed = true;
                        }
lbl137:
                        // 4 sources

                        if (tTime > 1) {
                            pNew = new CqMicroPolygonMotion();
                            pNew.SetGrid(this);
                            pNew.SetIndex(iIndex);
                            if (fTrimmed) {
                                pNew.MarkTrimmed();
                            }
                            iTime = 0;
                            while (iTime < tTime) {
                                pNew.AppendKey(aaPtimes[iTime][iIndex], aaPtimes[iTime][iIndex + 1], aaPtimes[iTime][iIndex + cu + 2], aaPtimes[iTime][iIndex + cu + 1], this.pSurface().pTransform().Time(iTime));
                                ++iTime;
                            }
                            pImage.AddMPG(pNew);
                        } else {
                            pNew = new CqMicroPolygon();
                            pNew.SetGrid(this);
                            pNew.SetIndex(iIndex);
                            if (fTrimmed) {
                                pNew.MarkTrimmed();
                            }
                            pNew.Initialise();
                            pNew.CalculateTotalBound();
                            pImage.AddMPG(pNew);
                        }
                        area = 0.0f;
                        area += aaPtimes[0][iIndex].x * aaPtimes[0][iIndex + 1].y - aaPtimes[0][iIndex].y * aaPtimes[0][iIndex + 1].x;
                        area += aaPtimes[0][iIndex + 1].x * aaPtimes[0][iIndex + cu + 2].y - aaPtimes[0][iIndex + 1].y * aaPtimes[0][iIndex + cu + 2].x;
                        area += aaPtimes[0][iIndex + cu + 2].x * aaPtimes[0][iIndex + cu + 1].y - aaPtimes[0][iIndex + cu + 2].y * aaPtimes[0][iIndex + cu + 1].x;
                        area += aaPtimes[0][iIndex + cu + 1].x * aaPtimes[0][iIndex].y - aaPtimes[0][iIndex + cu + 1].y * aaPtimes[0][iIndex].x;
                        area *= 0.5f;
                        area = Math.abs(area);
                        CqStats.STATS_SETF(1, CqStats.STATS_GETF(1) + area);
                        if (area < CqStats.STATS_GETF(2)) {
                            CqStats.STATS_SETF(2, area);
                        }
                        if (area > CqStats.STATS_GETF(3)) {
                            CqStats.STATS_SETF(3, area);
                        }
                    }
                }
                ++iu;
            }
            ++iv;
        }
        this.Release();
    }

    public void Shade() {
        if (this.pVar(8) == null || this.pVar(16) == null) {
            return;
        }
        CqStats theStats = RiGlobal.QGetRenderContext().Stats();
        IqShader pshadSurface = this.pSurface().pAttributes().pshadSurface(RiGlobal.QGetRenderContext().Time());
        IqShader pshadDisplacement = this.pSurface().pAttributes().pshadDisplacement(RiGlobal.QGetRenderContext().Time());
        IqShader pshadAtmosphere = this.pSurface().pAttributes().pshadAtmosphere(RiGlobal.QGetRenderContext().Time());
        int lUses = this.pSurface().Uses();
        int gs = this.GridSize();
        int uRes = this.uGridRes();
        int vRes = this.vGridRes();
        int gsmin1 = gs - 1;
        long cCulled = 0L;
        STLArray<CqVector3D> pP = this.pVar(8).GetPointPtr_2();
        STLArray<CqColor> pOs = null;
        if (RiGlobal.USES(lUses, 1)) {
            pOs = this.pVar(1).GetColorPtr_2();
        }
        STLArray<CqColor> pCs = null;
        if (RiGlobal.USES(lUses, 0)) {
            pCs = this.pVar(0).GetColorPtr_2();
        }
        IqShaderData pI = this.pVar(16);
        STLArray<CqVector3D> pN = null;
        if (RiGlobal.USES(lUses, 11)) {
            pN = this.pVar(11).GetNormalPtr_2();
        }
        if (!this.bGeometricNormals() && RiGlobal.USES(lUses, 2)) {
            this.CalcNormals();
        }
        if (!this.bShadingNormals() && RiGlobal.USES(lUses, 11) && this.pVar(2) != null && this.pVar(11) != null) {
            this.pVar(11).SetValueFromVariable(this.pVar(2));
        }
        if (RiGlobal.USES(lUses, 20)) {
            this.pVar(20).SetVector(vecE);
        }
        boolean bdpu = RiGlobal.USES(lUses, 9);
        boolean bdpv = RiGlobal.USES(lUses, 10);
        IqShaderData pSDP = this.pVar(8);
        int proj = RiGlobal.QGetRenderContext().GetIntegerOption("System", "Projection")[0];
        int i = gsmin1;
        while (i >= 0) {
            p_float v2;
            p_float v1;
            if (RiGlobal.USES(lUses, 3)) {
                v1 = new p_float();
                v2 = new p_float();
                int GridX = i % (uRes + 1);
                if (GridX < uRes) {
                    this.pVar(12).GetValue(v1, i + 1);
                    this.pVar(12).GetValue(v2, i);
                    this.pVar(3).SetFloat(1.0f);
                } else {
                    this.pVar(12).GetValue(v1, i);
                    this.pVar(12).GetValue(v2, i - 1);
                    this.pVar(3).SetFloat(1.0f);
                }
            }
            if (RiGlobal.USES(lUses, 4)) {
                v1 = new p_float();
                v2 = new p_float();
                int GridY = i / (uRes + 1);
                if (GridY < vRes) {
                    this.pVar(13).GetValue(v1, i + uRes + 1);
                    this.pVar(13).GetValue(v2, i);
                    this.pVar(4).SetFloat(1.0f);
                } else {
                    this.pVar(13).GetValue(v1, i);
                    this.pVar(13).GetValue(v2, i - (uRes + 1));
                    this.pVar(4).SetFloat(1.0f);
                }
            }
            switch (proj) {
                case 0: {
                    pI.SetVector(new CqVector3D(0.0f, 0.0f, 1.0f), i);
                    break;
                }
                default: {
                    pI.SetVector(pP.get(i), i);
                }
            }
            --i;
        }
        if (bdpu || bdpv) {
            i = gsmin1;
            while (i >= 0) {
                if (bdpu) {
                    this.pVar(9).SetVector(RiGlobal.SO_DuType_CqVector3D(pSDP, i, this.m_pShaderExecEnv, Defvec), i);
                }
                if (bdpv) {
                    this.pVar(10).SetVector(RiGlobal.SO_DvType_CqVector3D(pSDP, i, this.m_pShaderExecEnv, Defvec), i);
                }
                --i;
            }
        }
        if (RiGlobal.USES(lUses, 17)) {
            this.pVar(17).SetColor(RiGlobal.gColBlack);
        }
        if (RiGlobal.USES(lUses, 18)) {
            this.pVar(18).SetColor(RiGlobal.gColWhite);
        }
        cCulled = 0L;
        if (RiGlobal.USES(lUses, 1) && (RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value & 4) != 0) {
            theStats.OcclusionCullTimer().Start();
            i = gsmin1;
            while (i >= 0) {
                if (pOs.elementAt(i).equals(RiGlobal.gColWhite)) break;
                ++cCulled;
                this.m_CulledPolys.SetValue(i, true);
                --i;
            }
            theStats.OcclusionCullTimer().Stop();
            if (cCulled == (long)gs) {
                this.m_fCulled = true;
                CqStats.STATS_INC(25);
                this.DeleteVariables(true);
                return;
            }
        }
        cCulled = 0L;
        if (RiGlobal.USES(lUses, 1) && (RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value & 1) != 0) {
            theStats.OcclusionCullTimer().Start();
            i = gsmin1;
            while (i >= 0) {
                if (!pOs.elementAt(i).equals(RiGlobal.gColBlack)) break;
                ++cCulled;
                this.m_CulledPolys.SetValue(i, true);
                --i;
            }
            theStats.OcclusionCullTimer().Stop();
            if (cCulled == (long)gs) {
                this.m_fCulled = true;
                CqStats.STATS_INC(25);
                this.DeleteVariables(true);
                return;
            }
        }
        if (pshadDisplacement != null) {
            theStats.DisplacementTimer().Start();
            pshadDisplacement.Evaluate(this.m_pShaderExecEnv);
            theStats.DisplacementTimer().Stop();
        }
        cCulled = 0L;
        if (this.pAttributes().GetIntegerAttribute("System", "Sides")[0] == 1 && this.m_pCSGNode == null) {
            theStats.OcclusionCullTimer().Start();
            i = gsmin1;
            while (i >= 0) {
                if (pN.elementAt(i).mul(pP.elementAt(i)) >= 0.0f) {
                    ++cCulled;
                    this.m_CulledPolys.SetValue(i, true);
                }
                --i;
            }
            theStats.OcclusionCullTimer().Stop();
            if (cCulled == (long)gs) {
                this.m_fCulled = true;
                CqStats.STATS_INC(25);
                this.DeleteVariables(true);
                return;
            }
        }
        theStats.SurfaceTimer().Start();
        if (pshadSurface != null) {
            this.m_pShaderExecEnv.SetCurrentSurface(this.pSurface());
            pshadSurface.Evaluate(this.m_pShaderExecEnv);
        }
        theStats.SurfaceTimer().Stop();
        cCulled = 0L;
        if (RiGlobal.USES(lUses, 1) && (RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value & 1) != 0) {
            theStats.OcclusionCullTimer().Start();
            i = gsmin1;
            while (i >= 0) {
                if (!pOs.elementAt(i).equals(RiGlobal.gColBlack)) break;
                ++cCulled;
                this.m_CulledPolys.SetValue(i, true);
                --i;
            }
            theStats.OcclusionCullTimer().Stop();
            if (cCulled == (long)gs) {
                this.m_fCulled = true;
                CqStats.STATS_INC(25);
                this.DeleteVariables(true);
                return;
            }
        }
        if (pshadAtmosphere != null) {
            theStats.AtmosphereTimer().Start();
            pshadAtmosphere.Evaluate(this.m_pShaderExecEnv);
            theStats.AtmosphereTimer().Stop();
        }
        this.DeleteVariables(false);
        int size = this.GridSize();
        CqStats.STATS_INC(38 + (int)PublicFunctions.CLAMP(CqStats.log2(size) - 2, 0.0f, 7.0f));
    }

    public void TransferOutputVariables() {
        IqShader pShader = this.pAttributes().pshadSurface(RiGlobal.QGetRenderContext().Time());
        HashMap<String, CqRenderer.SqOutputDataEntry> outputVars = RiGlobal.QGetRenderContext().GetMapOfOutputDataEntries();
        Set<String> outputVar = outputVars.keySet();
        for (String value : outputVar) {
            IqShaderData outputData = pShader.FindArgument(value);
            if (outputData == null) continue;
            IqShaderData newOutputData = outputData.Clone();
            this.m_apShaderOutputVariables.add(newOutputData);
        }
    }

    public CqSurface pSurface() {
        return this.m_pSurface;
    }

    public final IqAttributes pAttributes() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.pAttributes();
    }

    public CqCSGTreeNode pCSGNode() {
        return this.m_pCSGNode;
    }

    public int uGridRes() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.uGridRes();
    }

    public int vGridRes() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.vGridRes();
    }

    public int GridSize() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.GridSize();
    }

    public final CqMatrix matObjectToWorld() {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.matObjectToWorld();
    }

    public IqShaderData pVar(int index) {
        assert (this.m_pShaderExecEnv != null);
        return this.m_pShaderExecEnv.pVar(index);
    }

    public IqShaderData FindStandardVar(String pname) {
        IqShaderData pVar = null;
        pVar = this.m_pShaderExecEnv.FindStandardVar(pname);
        if (pVar == null) {
            for (IqShaderData outputVar : this.m_apShaderOutputVariables) {
                if (!outputVar.strName().equals(pname)) continue;
                pVar = outputVar;
                break;
            }
        }
        return pVar;
    }
}

