/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqBucket;
import net.cellcomputing.himawari.library.CqHitTestCache;
import net.cellcomputing.himawari.library.CqMicroPolyGridBase;
import net.cellcomputing.himawari.library.CqMicroPolygon;
import net.cellcomputing.himawari.library.CqOcclusionBox;
import net.cellcomputing.himawari.library.CqRenderer;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.IqShaderData;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.SqImageSample;
import net.cellcomputing.himawari.library.SqSampleData;
import net.cellcomputing.himawari.library.types.CqColor;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector2D;
import net.cellcomputing.himawari.library.types.CqVector3D;
import net.cellcomputing.himawari.library.types.PublicFunctions;
import net.cellcomputing.himawari.util.HimawariLogger;

public strictfp class CqImageBuffer {
    public static int bucketmodulo = -1;
    private static SqImageSample localImageVal = null;
    private boolean m_fQuit = false;
    private boolean m_fDone = true;
    private int m_iXRes = 0;
    private int m_iYRes = 0;
    private int m_cXBuckets = 0;
    private int m_cYBuckets = 0;
    private int m_XBucketSize = 0;
    private int m_YBucketSize = 0;
    private int m_PixelXSamples = 0;
    private int m_PixelYSamples = 0;
    private float m_FilterXWidth = 0.0f;
    private float m_FilterYWidth = 0.0f;
    private int m_CropWindowXMin = 0;
    private int m_CropWindowYMin = 0;
    private int m_CropWindowXMax = 0;
    private int m_CropWindowYMax = 0;
    private float m_ClippingNear;
    private float m_ClippingFar;
    private int m_DisplayMode = 1;
    private STLVector<STLVector<CqBucket>> m_Buckets = new STLVector(2, CqBucket.class);
    private int m_CurrentBucketCol = 0;
    private int m_CurrentBucketRow = 0;
    private SqMpgSampleInfo m_CurrentMpgSampleInfo = new SqMpgSampleInfo();
    private SqGridInfo m_CurrentGridInfo = new SqGridInfo();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void destract() {
        this.DeleteImage();
    }

    public CqVector2D BucketPosition() {
        return this.BucketPosition(this.CurrentBucketCol(), this.CurrentBucketRow());
    }

    public CqVector2D BucketPosition(int x, int y) {
        CqVector2D vecA = new CqVector2D();
        vecA.x = x * this.XBucketSize();
        vecA.y = y * this.YBucketSize();
        return vecA;
    }

    public CqVector2D BucketSize() {
        return this.BucketSize(this.CurrentBucketCol(), this.CurrentBucketRow());
    }

    public CqVector2D BucketSize(int x, int y) {
        CqVector2D vecA = this.BucketPosition(x, y);
        vecA.x((float)this.m_iXRes - vecA.x);
        if (vecA.x > (float)this.m_XBucketSize) {
            vecA.x(this.m_XBucketSize);
        }
        vecA.y((float)this.m_iYRes - vecA.y);
        if (vecA.y > (float)this.m_YBucketSize) {
            vecA.y(this.m_YBucketSize);
        }
        return vecA;
    }

    public int iXRes() {
        return this.m_iXRes;
    }

    public int iYRes() {
        return this.m_iYRes;
    }

    public int CropWindowXMin() {
        return this.m_CropWindowXMin;
    }

    public int CropWindowYMin() {
        return this.m_CropWindowYMin;
    }

    public int CropWindowXMax() {
        return this.m_CropWindowXMax;
    }

    public int CropWindowYMax() {
        return this.m_CropWindowYMax;
    }

    public int cXBuckets() {
        return this.m_cXBuckets;
    }

    public int cYBuckets() {
        return this.m_cYBuckets;
    }

    public int XBucketSize() {
        return this.m_XBucketSize;
    }

    public int YBucketSize() {
        return this.m_YBucketSize;
    }

    public int PixelXSamples() {
        return this.m_PixelXSamples;
    }

    public int PixelYSamples() {
        return this.m_PixelYSamples;
    }

    public float FilterXWidth() {
        return this.m_FilterXWidth;
    }

    public float FilterYWidth() {
        return this.m_FilterYWidth;
    }

    public float ClippingNear() {
        return this.m_ClippingNear;
    }

    public float ClippingFar() {
        return this.m_ClippingFar;
    }

    public int DisplayMode() {
        return this.m_DisplayMode;
    }

    public int CurrentBucketCol() {
        return this.m_CurrentBucketCol;
    }

    public int CurrentBucketRow() {
        return this.m_CurrentBucketRow;
    }

    public boolean NextBucket() {
        ++this.m_CurrentBucketCol;
        if (this.m_CurrentBucketCol >= this.m_cXBuckets) {
            this.m_CurrentBucketCol = 0;
            ++this.m_CurrentBucketRow;
            if (this.m_CurrentBucketRow >= this.m_cYBuckets) {
                return false;
            }
        }
        return true;
    }

    public CqBucket CurrentBucket() {
        return (CqBucket)((STLVector)this.m_Buckets.get(this.m_CurrentBucketRow)).get(this.m_CurrentBucketCol);
    }

    public CqBucket Bucket(int x, int y) {
        return (CqBucket)((STLVector)this.m_Buckets.get(y)).get(x);
    }

    public void DeleteImage() {
        this.m_iXRes = 0;
        this.m_iYRes = 0;
    }

    public void SaveImage(String strName) {
    }

    public void PostSurface(CqBasicSurface pSurface) {
        CqStats.STATS_INC(3);
        CqBound Bound = new CqBound(pSurface.Bound());
        float db = 0.0f;
        String strCoordinateSystem = "object";
        float[] pattrDispclacementBound = pSurface.pAttributes().GetFloatAttribute("displacementbound", "sphere");
        String[] pattrCoordinateSystem = pSurface.pAttributes().GetStringAttribute("displacementbound", "coordinatesystem");
        if (pattrDispclacementBound != null) {
            db = pattrDispclacementBound[0];
        }
        if (pattrCoordinateSystem != null) {
            strCoordinateSystem = pattrCoordinateSystem[0];
        }
        if (db != 0.0f) {
            CqVector3D vecDB = new CqVector3D(db, 0.0f, 0.0f);
            CqMatrix matShaderToWorld = new CqMatrix();
            if (pSurface.pAttributes().pshadDisplacement(RiGlobal.QGetRenderContextI().Time()) != null) {
                matShaderToWorld.assignment(pSurface.pAttributes().pshadDisplacement(RiGlobal.QGetRenderContextI().Time()).matCurrent());
            } else if (pSurface.pAttributes().pshadSurface(RiGlobal.QGetRenderContextI().Time()) != null) {
                matShaderToWorld.assignment(pSurface.pAttributes().pshadSurface(RiGlobal.QGetRenderContextI().Time()).matCurrent());
            }
            vecDB.assignment(RiGlobal.QGetRenderContext().matVSpaceToSpace(strCoordinateSystem, "camera", matShaderToWorld, pSurface.pTransform().matObjectToWorld(pSurface.pTransform().Time(0)), RiGlobal.QGetRenderContextI().Time()).multiply(vecDB));
            db = vecDB.Magnitude();
            Bound.vecMax().assignAdd(db);
            Bound.vecMin().assignSub(db);
        }
        if (this.CullSurface(Bound, pSurface)) {
            CqStats.STATS_INC(6);
            return;
        }
        int XMinb = this.CurrentBucketCol();
        int YMinb = this.CurrentBucketRow();
        if (!pSurface.IsUndiceable()) {
            if (Bound.vecMin().x < 0.0f) {
                Bound.vecMin().x(0.0f);
            }
            if (Bound.vecMin().y < 0.0f) {
                Bound.vecMin().y(0.0f);
            }
            XMinb = (int)(Bound.vecMin().x / (float)this.XBucketSize());
            YMinb = (int)(Bound.vecMin().y / (float)this.YBucketSize());
            if (XMinb >= this.cXBuckets() || YMinb >= this.cYBuckets()) {
                return;
            }
            if (this.Bucket(XMinb = (int)PublicFunctions.CLAMP(XMinb, 0.0f, this.cXBuckets()), YMinb = (int)PublicFunctions.CLAMP(YMinb, 0.0f, this.cYBuckets())).IsProcessed()) {
                XMinb = this.CurrentBucketCol();
                YMinb = this.CurrentBucketRow();
            }
        }
        assert (!this.Bucket(XMinb, YMinb).IsProcessed());
        this.Bucket(XMinb, YMinb).AddGPrim(pSurface);
    }

    public boolean CullSurface(CqBound Bound, CqBasicSurface pSurface) {
        if (Bound.vecMin().z >= RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Clipping", (int)1).value || Bound.vecMax().z <= RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Clipping", (int)0).value) {
            return true;
        }
        if (Bound.vecMin().z <= 0.0f && Bound.vecMax().z > 1.1920929E-7f) {
            pSurface.ForceUndiceable();
            int MaxEyeSplits = 10;
            int[] poptEyeSplits = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "eyesplits");
            if (poptEyeSplits != null) {
                MaxEyeSplits = poptEyeSplits[0];
            }
            if (pSurface.EyeSplitCount() > MaxEyeSplits) {
                String objname = "unnamed";
                String[] pattrName = pSurface.pAttributes().GetStringAttribute("identifier", "name");
                if (pattrName != null) {
                    objname = pattrName[0];
                }
                HimawariLogger logger = HimawariLogger.getLogger();
                logger.warning("Max eyesplits for object \"" + objname + "\" exceeded\n");
                return true;
            }
            return false;
        }
        float minz = Bound.vecMin().z;
        float maxz = Bound.vecMax().z;
        Bound.Transform(RiGlobal.QGetRenderContext().matSpaceToSpace("camera", "raster", new CqMatrix(), new CqMatrix(), RiGlobal.QGetRenderContext().Time()));
        if (RiGlobal.QGetRenderContext().UsingDepthOfField()) {
            CqVector2D minZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(minz);
            CqVector2D maxZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(maxz);
            float cocX = Math.max(minZCoc.x, maxZCoc.x);
            float cocY = Math.max(minZCoc.y, maxZCoc.y);
            Bound.vecMin().x(Bound.vecMin().x - cocX);
            Bound.vecMin().y(Bound.vecMin().y - cocY);
            Bound.vecMax().x(Bound.vecMax().x + cocX);
            Bound.vecMax().y(Bound.vecMax().y + cocY);
        }
        Bound.vecMin().x(Bound.vecMin().x - this.m_FilterXWidth / 2.0f);
        Bound.vecMin().y(Bound.vecMin().y - this.m_FilterYWidth / 2.0f);
        Bound.vecMax().x(Bound.vecMax().x + this.m_FilterXWidth / 2.0f);
        Bound.vecMax().y(Bound.vecMax().y + this.m_FilterYWidth / 2.0f);
        if (Bound.vecMin().x > (float)this.CropWindowXMax() || Bound.vecMin().y > (float)this.CropWindowYMax() || Bound.vecMax().x < (float)this.CropWindowXMin() || Bound.vecMax().y < (float)this.CropWindowYMin()) {
            return true;
        }
        Bound.vecMin().z(minz);
        Bound.vecMax().z(maxz);
        pSurface.CacheRasterBound(Bound);
        return false;
    }

    public boolean OcclusionCullSurface(CqBasicSurface pSurface) {
        CqBound RasterBound = new CqBound(pSurface.GetCachedRasterBound());
        if (CqOcclusionBox.CanCull(RasterBound)) {
            int nextBucket = this.CurrentBucketCol() + 1;
            CqVector2D pos = this.BucketPosition(nextBucket, this.CurrentBucketRow());
            if (nextBucket < this.cXBuckets() && RasterBound.vecMax().x >= pos.x) {
                this.Bucket(nextBucket, this.CurrentBucketRow()).AddGPrim(pSurface);
                return true;
            }
            nextBucket = this.CurrentBucketRow() + 1;
            int nextBucketX = (int)RasterBound.vecMin().x / this.XBucketSize();
            nextBucketX = Math.max(nextBucketX, 0);
            pos = this.BucketPosition(nextBucketX, nextBucket);
            if (nextBucketX < this.cXBuckets() && nextBucket < this.cYBuckets() && RasterBound.vecMax().y >= pos.y) {
                this.Bucket(nextBucketX, nextBucket).AddGPrim(pSurface);
                return true;
            }
            String objname = "unnamed";
            String[] pattrName = pSurface.pAttributes().GetStringAttribute("identifier", "name");
            if (pattrName != null) {
                objname = pattrName[0];
            }
            HimawariLogger logger = HimawariLogger.getLogger();
            logger.info("GPrim: \"" + objname + "\" occlusion culled\n");
            CqStats.STATS_INC(6);
            return true;
        }
        return false;
    }

    public void AddMPG(CqMicroPolygon pmpgNew) {
        CqBound B = pmpgNew.GetTotalBound();
        pmpgNew.AddRef();
        if (B.vecMax().x < (float)this.m_CropWindowXMin - this.m_FilterXWidth / 2.0f || B.vecMax().y < (float)this.m_CropWindowYMin - this.m_FilterYWidth / 2.0f || B.vecMin().x > (float)this.m_CropWindowXMax + this.m_FilterXWidth / 2.0f || B.vecMin().y > (float)this.m_CropWindowYMax + this.m_FilterYWidth / 2.0f) {
            pmpgNew.Release();
            return;
        }
        B.vecMin().x(B.vecMin().x - this.m_FilterXWidth / 2.0f);
        B.vecMin().y(B.vecMin().y - this.m_FilterYWidth / 2.0f);
        B.vecMax().x(B.vecMax().x + this.m_FilterXWidth / 2.0f);
        B.vecMax().y(B.vecMax().y + this.m_FilterYWidth / 2.0f);
        int iXBa = (int)(B.vecMin().x / (float)this.m_XBucketSize);
        int iYBa = (int)(B.vecMin().y / (float)this.m_YBucketSize);
        int iXBb = (int)(B.vecMax().x / (float)this.m_XBucketSize);
        int iYBb = (int)(B.vecMax().y / (float)this.m_YBucketSize);
        if (iXBb < 0 || iYBb < 0 || iXBa >= this.m_cXBuckets || iYBa >= this.m_cYBuckets) {
            pmpgNew.Release();
            return;
        }
        if (iXBa < 0) {
            iXBa = 0;
        }
        if (iYBa < 0) {
            iYBa = 0;
        }
        if (this.Bucket(iXBa, iYBa).IsProcessed()) {
            this.PushMPGDown(pmpgNew, iXBa, iYBa);
            this.PushMPGForward(pmpgNew, iXBa, iYBa);
            pmpgNew.Release();
            return;
        }
        assert (!this.Bucket(iXBa, iYBa).IsProcessed());
        this.Bucket(iXBa, iYBa).AddMPG(pmpgNew);
        pmpgNew.AddRef();
        pmpgNew.Release();
    }

    public boolean PushMPGForward(CqMicroPolygon pmpg, int Col, int Row) {
        pmpg.MarkPushedForward();
        if (Col == this.cXBuckets() - 1) {
            return false;
        }
        int NextBucketForward = Col + 1;
        if (this.Bucket(NextBucketForward, Row).IsProcessed()) {
            return this.PushMPGForward(pmpg, NextBucketForward, Row);
        }
        CqVector2D BucketMin = this.BucketPosition(NextBucketForward, Row);
        CqVector2D BucketMax = BucketMin.add(this.BucketSize(NextBucketForward, Row));
        CqVector2D FilterWidth = new CqVector2D(this.m_FilterXWidth * 0.5f, this.m_FilterYWidth * 0.5f);
        BucketMin.assignSub(FilterWidth);
        BucketMax.assignAdd(FilterWidth);
        CqBound B = pmpg.GetTotalBound();
        CqVector3D vMin = B.vecMin();
        CqVector3D vMax = B.vecMax();
        if (vMin.x > BucketMax.x || vMin.y > BucketMax.y || vMax.x < BucketMin.x || vMax.y < BucketMin.y) {
            return false;
        }
        pmpg.AddRef();
        this.Bucket(NextBucketForward, Row).AddMPG(pmpg);
        return true;
    }

    public boolean PushMPGDown(CqMicroPolygon pmpg, int Col, int Row) {
        if (pmpg.IsPushedForward()) {
            return false;
        }
        if (Row == this.m_cYBuckets - 1) {
            return false;
        }
        int NextBucketDown = Row + 1;
        if (this.Bucket(Col, NextBucketDown).IsProcessed()) {
            if (this.PushMPGForward(pmpg, Col, NextBucketDown)) {
                return true;
            }
            return this.PushMPGDown(pmpg, Col, NextBucketDown);
        }
        CqVector2D BucketMin = this.BucketPosition(Col, NextBucketDown);
        CqVector2D BucketMax = BucketMin.add(this.BucketSize(Col, NextBucketDown));
        CqVector2D FilterWidth = new CqVector2D(this.m_FilterXWidth * 0.5f, this.m_FilterYWidth * 0.5f);
        BucketMin.assignSub(FilterWidth);
        BucketMax.assignAdd(FilterWidth);
        CqBound B = pmpg.GetTotalBound();
        CqVector3D vMin = B.vecMin();
        CqVector3D vMax = B.vecMax();
        if (vMin.x > BucketMax.x || vMin.y > BucketMax.y || vMax.x < BucketMin.x || vMax.y < BucketMin.y) {
            return false;
        }
        pmpg.AddRef();
        this.Bucket(Col, NextBucketDown).AddMPG(pmpg);
        if (this.PushMPGDown(pmpg, Col, NextBucketDown)) {
            CqStats.STATS_INC(64);
        }
        return true;
    }

    public void RenderMPGs(long xmin, long xmax, long ymin, long ymax) {
        CqMicroPolyGridBase pPrevGrid = null;
        for (CqMicroPolygon impg : this.CurrentBucket().aMPGs()) {
            CqMicroPolygon pMpg = impg;
            if (pMpg.pGrid() != pPrevGrid) {
                pPrevGrid = pMpg.pGrid();
                this.CacheGridInfo(pPrevGrid);
            }
            this.RenderMicroPoly(pMpg, xmin, xmax, ymin, ymax);
            if (this.PushMPGDown(pMpg, this.CurrentBucketCol(), this.CurrentBucketRow())) {
                CqStats.STATS_INC(63);
            }
            if (this.PushMPGForward(pMpg, this.CurrentBucketCol(), this.CurrentBucketRow())) {
                CqStats.STATS_INC(62);
            }
            pMpg.Release();
        }
        this.CurrentBucket().aMPGs().clear();
        if (!this.CurrentBucket().aGrids().isEmpty()) {
            Iterator iterator = this.CurrentBucket().aGrids().iterator();
            while (iterator.hasNext()) {
                CqMicroPolyGridBase igrid;
                CqMicroPolyGridBase pGrid = igrid = (CqMicroPolyGridBase)iterator.next();
                pGrid.Split(this, xmin, xmax, ymin, ymax);
                this.CacheGridInfo(pGrid);
                Iterator iterator2 = this.CurrentBucket().aMPGs().iterator();
                while (iterator2.hasNext()) {
                    CqMicroPolygon impg;
                    CqMicroPolygon pMpg = impg = (CqMicroPolygon)iterator2.next();
                    this.RenderMicroPoly(pMpg, xmin, xmax, ymin, ymax);
                    if (this.PushMPGDown(pMpg, this.CurrentBucketCol(), this.CurrentBucketRow())) {
                        CqStats.STATS_INC(63);
                    }
                    if (this.PushMPGForward(pMpg, this.CurrentBucketCol(), this.CurrentBucketRow())) {
                        CqStats.STATS_INC(62);
                    }
                    pMpg.Release();
                }
                this.CurrentBucket().aMPGs().clear();
            }
            this.CurrentBucket().aGrids().clear();
        }
    }

    public void RenderMicroPoly(CqMicroPolygon pMPG, long xmin, long xmax, long ymin, long ymax) {
        CqBound Bound = pMPG.GetTotalBound();
        if (Bound.vecMax().x < (float)xmin || Bound.vecMax().y < (float)ymin || Bound.vecMin().x > (float)xmax || Bound.vecMin().y > (float)ymax || Bound.vecMin().z > this.ClippingFar() || Bound.vecMax().z < this.ClippingNear()) {
            CqStats.STATS_INC(50);
            return;
        }
        this.m_CurrentMpgSampleInfo.m_Colour = RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Ci") ? pMPG.colColor() : new CqColor(RiGlobal.gColWhite);
        if (RiGlobal.QGetRenderContext().pDDmanager().fDisplayNeeds("Oi")) {
            this.m_CurrentMpgSampleInfo.m_Opacity = pMPG.colOpacity();
            this.m_CurrentMpgSampleInfo.m_Occludes = pMPG.colOpacity().ge(RiGlobal.gColWhite);
        } else {
            this.m_CurrentMpgSampleInfo.m_Opacity = new CqColor(RiGlobal.gColWhite);
            this.m_CurrentMpgSampleInfo.m_Occludes = true;
        }
        this.m_CurrentMpgSampleInfo.m_IsOpaque = this.m_CurrentMpgSampleInfo.m_Occludes && pMPG.pGrid().pCSGNode() == null && (this.DisplayMode() & 4) == 0 && !this.m_CurrentGridInfo.m_IsMatte;
        boolean UsingDof = RiGlobal.QGetRenderContext().UsingDepthOfField();
        boolean IsMoving = pMPG.IsMoving();
        if (IsMoving || UsingDof) {
            this.RenderMPG_MBOrDof(pMPG, xmin, xmax, ymin, ymax, IsMoving, UsingDof);
        } else {
            this.RenderMPG_Static(pMPG, xmin, xmax, ymin, ymax);
        }
    }

    public void RenderMPG_MBOrDof(CqMicroPolygon pMPG, long xmin, long xmax, long ymin, long ymax, boolean IsMoving, boolean UsingDof) {
        CqBucket Bucket = this.CurrentBucket();
        float[] LodBounds = this.m_CurrentGridInfo.m_LodBounds;
        boolean UsingLevelOfDetail = LodBounds[0] >= 0.0f;
        int sample_hits = 0;
        boolean cachedHitData = false;
        boolean mustDraw = !this.m_CurrentGridInfo.m_IsCullable;
        int iXSamples = this.PixelXSamples();
        int iYSamples = this.PixelYSamples();
        float opentime = this.m_CurrentGridInfo.m_ShutterOpenTime;
        float closetime = this.m_CurrentGridInfo.m_ShutterCloseTime;
        float timePerSample = 0.0f;
        if (IsMoving) {
            int numSamples = iXSamples * iYSamples;
            timePerSample = (float)numSamples / (closetime - opentime);
        }
        int bound_maxMB = pMPG.cSubBounds();
        int bound_maxMB_1 = bound_maxMB - 1;
        int bound_numMB = 0;
        while (bound_numMB < bound_maxMB) {
            int bound_maxDof;
            p_float time0 = new p_float();
            p_float time1 = new p_float();
            CqBound Bound = pMPG.SubBound(bound_numMB, time0);
            int indexT0 = 0;
            int indexT1 = 0;
            if (IsMoving) {
                if (bound_numMB != bound_maxMB_1) {
                    pMPG.SubBound(bound_numMB + 1, time1);
                } else {
                    time1.value = closetime;
                }
                indexT0 = (int)Math.floor((time0.value - opentime) * timePerSample);
                indexT1 = (int)Math.ceil((time1.value - opentime) * timePerSample);
            }
            float maxCocX = 0.0f;
            float maxCocY = 0.0f;
            float bminx = 0.0f;
            float bmaxx = 0.0f;
            float bminy = 0.0f;
            float bmaxy = 0.0f;
            float bminz = 0.0f;
            float bmaxz = 0.0f;
            float mpgbminx = 0.0f;
            float mpgbmaxx = 0.0f;
            float mpgbminy = 0.0f;
            float mpgbmaxy = 0.0f;
            if (UsingDof) {
                CqVector2D minZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(Bound.vecMin().z);
                CqVector2D maxZCoc = RiGlobal.QGetRenderContext().GetCircleOfConfusion(Bound.vecMax().z);
                maxCocX = Math.max(minZCoc.x, maxZCoc.x);
                maxCocY = Math.max(minZCoc.y, maxZCoc.y);
                mpgbminx = Bound.vecMin().x + maxCocX;
                mpgbmaxx = Bound.vecMax().x - maxCocX;
                mpgbminy = Bound.vecMin().y + maxCocY;
                mpgbmaxy = Bound.vecMax().y - maxCocY;
                bminz = Bound.vecMin().z;
                bmaxz = Bound.vecMax().z;
                bound_maxDof = CqBucket.NumDofBounds();
            } else {
                bminx = Bound.vecMin().x;
                bmaxx = Bound.vecMax().x;
                bminy = Bound.vecMin().y;
                bmaxy = Bound.vecMax().y;
                bminz = Bound.vecMin().z;
                bmaxz = Bound.vecMax().z;
                bound_maxDof = 1;
            }
            int bound_numDof = 0;
            while (bound_numDof < bound_maxDof) {
                if (UsingDof) {
                    CqBound DofBound = CqBucket.DofSubBound(bound_numDof);
                    float leftOffset = DofBound.vecMax().x * maxCocX;
                    float rightOffset = DofBound.vecMin().x * maxCocX;
                    float topOffset = DofBound.vecMax().y * maxCocY;
                    float bottomOffset = DofBound.vecMin().y * maxCocY;
                    bminx = mpgbminx - leftOffset;
                    bmaxx = mpgbmaxx - rightOffset;
                    bminy = mpgbminy - topOffset;
                    bmaxy = mpgbmaxy - bottomOffset;
                }
                if (!(bmaxx < (float)xmin || bmaxy < (float)ymin || bminx > (float)xmax || bminy > (float)ymax || bminz > this.ClippingFar() || bmaxz < this.ClippingNear())) {
                    int eX = (int)Math.ceil(bmaxx);
                    int eY = (int)Math.ceil(bmaxy);
                    if ((long)eX > xmax) {
                        eX = (int)xmax;
                    }
                    if ((long)eY > ymax) {
                        eY = (int)ymax;
                    }
                    int sX = (int)Math.floor(bminx);
                    int sY = (int)Math.floor(bminy);
                    if ((long)sY < ymin) {
                        sY = (int)ymin;
                    }
                    if ((long)sX < xmin) {
                        sX = (int)xmin;
                    }
                    int nextx = Bucket.RealWidth();
                    int pie = CqBucket.ImageElement(sX, sY);
                    int iY = sY;
                    while (iY < eY) {
                        int pie2 = pie;
                        pie += nextx;
                        int iX = sX;
                        while (iX < eX) {
                            if (mustDraw || bminz <= CqBucket.aieImage(pie2).MaxDepth()) {
                                int index = UsingDof ? CqBucket.aieImage(pie2).GetDofOffsetIndex(bound_numDof) : indexT0;
                                do {
                                    float LevelOfDetail;
                                    SqSampleData sampleData = CqBucket.aieImage(pie2).SampleData(index);
                                    CqVector2D vecP = sampleData.m_Position;
                                    float time = sampleData.m_Time;
                                    ++index;
                                    CqStats.IncI(264);
                                    if (IsMoving && (time < time0.value || time > time1.value)) continue;
                                    if (UsingDof) {
                                        float LevelOfDetail2;
                                        CqBound DofBound = new CqBound(bminx, bminy, bminz, bmaxx, bmaxy, bmaxz);
                                        if (!DofBound.Contains2D(vecP) || UsingLevelOfDetail && (LodBounds[0] > (LevelOfDetail2 = sampleData.m_DetailLevel) || LevelOfDetail2 >= LodBounds[1])) continue;
                                        CqStats.IncI(265);
                                        p_float D = new p_float();
                                        boolean SampleHit = pMPG.Sample(sampleData, D, time, UsingDof);
                                        if (!SampleHit) continue;
                                        ++sample_hits;
                                        this.StoreSample(pMPG, pie2, index - 1, D);
                                        continue;
                                    }
                                    if (!Bound.Contains2D(vecP) || UsingLevelOfDetail && (LodBounds[0] > (LevelOfDetail = sampleData.m_DetailLevel) || LevelOfDetail >= LodBounds[1])) continue;
                                    CqStats.IncI(265);
                                    p_float D = new p_float();
                                    CqHitTestCache hitTestCache = new CqHitTestCache();
                                    pMPG.CacheHitTestValues(hitTestCache);
                                    cachedHitData = true;
                                    boolean SampleHit = pMPG.Sample(sampleData, D, time, false);
                                    if (!SampleHit) continue;
                                    ++sample_hits;
                                    this.StoreSample(pMPG, pie2, index - 1, D);
                                } while (!UsingDof && index < indexT1);
                            }
                            ++iX;
                            ++pie2;
                        }
                        ++iY;
                    }
                }
                ++bound_numDof;
            }
            ++bound_numMB;
        }
    }

    public void RenderMPG_Static(CqMicroPolygon pMPG, long xmin, long xmax, long ymin, long ymax) {
        CqBucket Bucket = this.CurrentBucket();
        float[] LodBounds = this.m_CurrentGridInfo.m_LodBounds;
        boolean UsingLevelOfDetail = LodBounds[0] >= 0.0f;
        int sample_hits = 0;
        CqHitTestCache hitTestCache = null;
        boolean cachedHitData = false;
        boolean mustDraw = !this.m_CurrentGridInfo.m_IsCullable;
        CqBound Bound = pMPG.GetTotalBound();
        float bminx = Bound.vecMin().x;
        float bmaxx = Bound.vecMax().x;
        float bminy = Bound.vecMin().y;
        float bmaxy = Bound.vecMax().y;
        float bminz = Bound.vecMin().z;
        int eX = (int)Math.ceil(bmaxx);
        int eY = (int)Math.ceil(bmaxy);
        if ((long)eX > xmax) {
            eX = (int)xmax;
        }
        if ((long)eY > ymax) {
            eY = (int)ymax;
        }
        int sX = (int)Math.floor(bminx);
        int sY = (int)Math.floor(bminy);
        if ((long)sY < ymin) {
            sY = (int)ymin;
        }
        if ((long)sX < xmin) {
            sX = (int)xmin;
        }
        int iXSamples = this.PixelXSamples();
        int iYSamples = this.PixelYSamples();
        int im = bminx < (float)sX ? 0 : (int)Math.floor((bminx - (float)sX) * (float)iXSamples);
        int in = bminy < (float)sY ? 0 : (int)Math.floor((bminy - (float)sY) * (float)iYSamples);
        int em = bmaxx > (float)eX ? iXSamples : (int)Math.ceil((bmaxx - (float)(eX - 1)) * (float)iXSamples);
        int en = bmaxy > (float)eY ? iYSamples : (int)Math.ceil((bmaxy - (float)(eY - 1)) * (float)iYSamples);
        int nextx = Bucket.RealWidth();
        int pie = CqBucket.ImageElement(sX, sY);
        int iY = sY;
        while (iY < eY) {
            int pie2 = pie;
            pie += nextx;
            int iX = sX;
            while (iX < eX) {
                if (mustDraw || bminz <= CqBucket.aieImage(pie2).MaxDepth()) {
                    if (!cachedHitData) {
                        if (hitTestCache == null) {
                            hitTestCache = new CqHitTestCache();
                        }
                        pMPG.CacheHitTestValues(hitTestCache);
                        cachedHitData = true;
                    }
                    int n = iY == sY ? in : 0;
                    int end_n = iY == eY - 1 ? en : iYSamples;
                    int start_m = iX == sX ? im : 0;
                    int end_m = iX == eX - 1 ? em : iXSamples;
                    int index_start = n * iXSamples + start_m;
                    while (n < end_n) {
                        int index = index_start;
                        int m = start_m;
                        while (m < end_m) {
                            SqSampleData sampleData = CqBucket.aieImage(pie2).SampleData(index);
                            CqStats.IncI(264);
                            if (Bound.Contains2D(sampleData.m_Position)) {
                                float LevelOfDetail;
                                float time = 0.0f;
                                if (!UsingLevelOfDetail || !(LodBounds[0] > (LevelOfDetail = sampleData.m_DetailLevel)) && !(LevelOfDetail >= LodBounds[1])) {
                                    CqStats.IncI(265);
                                    p_float D = new p_float();
                                    boolean SampleHit = pMPG.Sample(sampleData, D, 0.0f, false);
                                    if (SampleHit) {
                                        ++sample_hits;
                                        this.StoreSample(pMPG, pie2, index, D);
                                    }
                                }
                            }
                            ++m;
                            ++index;
                        }
                        index_start += iXSamples;
                        ++n;
                    }
                }
                ++iX;
                ++pie2;
            }
            ++iY;
        }
    }

    public void RenderSurfaces(long xmin, long xmax, long ymin, long ymax) {
        boolean bIsEmpty = this.IsCurrentBucketEmpty();
        RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Start();
        this.RenderMPGs(xmin, xmax, ymin, ymax);
        RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Stop();
        RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Start();
        if (!bIsEmpty) {
            CqOcclusionBox.Update();
        }
        RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Stop();
        CqBucket Bucket = this.CurrentBucket();
        CqBasicSurface pSurface = Bucket.pTopSurface();
        while (pSurface != null) {
            if (this.m_fQuit) {
                return;
            }
            boolean fDiceable = false;
            RiGlobal.QGetRenderContext().Stats().DiceableTimer().Start();
            fDiceable = pSurface.Diceable();
            RiGlobal.QGetRenderContext().Stats().DiceableTimer().Stop();
            if (fDiceable) {
                if ((this.DisplayMode() & 4) == 0 && pSurface.pCSGNode() == null) {
                    RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Start();
                    boolean fCull = false;
                    if (!bIsEmpty && pSurface.fCachedBound()) {
                        fCull = this.OcclusionCullSurface(pSurface);
                    }
                    RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Stop();
                    if (fCull) {
                        Bucket.popSurface();
                        pSurface = Bucket.pTopSurface();
                        continue;
                    }
                }
                Bucket.popSurface();
                RiGlobal.QGetRenderContext().Stats().DicingTimer().Start();
                CqMicroPolyGridBase pGrid = pSurface.Dice();
                RiGlobal.QGetRenderContext().Stats().DicingTimer().Stop();
                if (pGrid != null) {
                    pGrid.AddRef();
                    pGrid.Shade();
                    pGrid.TransferOutputVariables();
                    if (!pGrid.vfCulled()) {
                        Bucket.AddGrid(pGrid);
                        RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Start();
                        this.RenderMPGs(xmin, xmax, ymin, ymax);
                        RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Stop();
                    }
                    pGrid.Release();
                }
            } else if (!pSurface.fDiscard()) {
                Bucket.popSurface();
                CqStats.STATS_DEC(3);
                RiGlobal.QGetRenderContext().Stats().SplitsTimer().Start();
                STLVector<CqBasicSurface> aSplits = new STLVector<CqBasicSurface>(CqBasicSurface.class);
                int cSplits = pSurface.Split(aSplits);
                int i = 0;
                while (i < cSplits) {
                    this.PostSurface((CqBasicSurface)aSplits.get(i));
                    ++i;
                }
                RiGlobal.QGetRenderContext().Stats().SplitsTimer().Stop();
            } else if (pSurface == Bucket.pTopSurface()) {
                Bucket.popSurface();
            }
            pSurface = Bucket.pTopSurface();
            RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Start();
            this.RenderMPGs(xmin, xmax, ymin, ymax);
            RiGlobal.QGetRenderContext().Stats().RenderMPGsTimer().Stop();
            RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Start();
            if (!bIsEmpty) {
                CqOcclusionBox.Update();
            }
            RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Stop();
        }
        if (this.m_fQuit) {
            return;
        }
        if (!bIsEmpty) {
            RiGlobal.QGetRenderContext().Stats().MakeCombine().Start();
            CqBucket.CombineElements();
            RiGlobal.QGetRenderContext().Stats().MakeCombine().Stop();
        }
        RiGlobal.QGetRenderContext().Stats().MakeFilterBucket().Start();
        boolean fImager = false;
        String[] systemOptions = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("System", "Imager");
        if (systemOptions != null && systemOptions[0].compareTo("null") != 0) {
            fImager = true;
        }
        if (fImager) {
            bIsEmpty = false;
        }
        Bucket.FilterBucket(bIsEmpty);
        if (!bIsEmpty) {
            Bucket.ExposeBucket();
            Bucket.QuantizeBucket();
        }
        RiGlobal.QGetRenderContext().Stats().MakeFilterBucket().Stop();
        this.BucketComplete();
        Bucket.destract();
        RiGlobal.QGetRenderContext().Stats().MakeDisplayBucket().Start();
        RiGlobal.QGetRenderContext().pDDmanager().DisplayBucket(this.CurrentBucket());
        RiGlobal.QGetRenderContext().Stats().MakeDisplayBucket().Stop();
    }

    public void RenderImage() {
        CqStats.STATS_SETF(2, Float.MAX_VALUE);
        CqStats.STATS_SETF(3, Float.MIN_NORMAL);
        if (bucketmodulo == -1) {
            bucketmodulo = this.m_cXBuckets;
            int[] poptModulo = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "bucketmodulo");
            if (poptModulo != null) {
                bucketmodulo = poptModulo[0];
            }
            if (bucketmodulo <= 0) {
                bucketmodulo = this.m_cXBuckets;
            }
        }
        this.m_fDone = false;
        CqVector2D bHalf = new CqVector2D((float)Math.floor(this.m_FilterXWidth / 2.0f), (float)Math.floor(this.m_FilterYWidth / 2.0f));
        CqOcclusionBox.CreateHierarchy(this.m_XBucketSize, this.m_YBucketSize, (int)this.m_FilterXWidth, (int)this.m_FilterYWidth);
        Method pProgressHandler = null;
        pProgressHandler = RiGlobal.QGetRenderContext().pProgressHandler();
        do {
            boolean bIsEmpty = this.IsCurrentBucketEmpty();
            RiGlobal.QGetRenderContext().Stats().Others().Start();
            CqVector2D bPos = this.BucketPosition();
            CqVector2D bSize = this.BucketSize();
            boolean fImager = false;
            String[] systemOptions = RiGlobal.QGetRenderContext().optCurrent().GetStringOption("System", "Imager");
            if (systemOptions != null && systemOptions[0].compareTo("null") != 0) {
                fImager = true;
            }
            if (fImager) {
                bIsEmpty = false;
            }
            CqBucket.InitialiseBucket((int)bPos.x, (int)bPos.y, (int)bSize.x, (int)bSize.y, true, bIsEmpty);
            CqBucket.InitialiseFilterValues();
            CqVector2D vecMin = bPos;
            CqVector2D vecMax = bPos.add(bSize);
            vecMin.assignSub(bHalf);
            vecMax.assignAdd(bHalf);
            long xmin = (long)vecMin.x;
            long ymin = (long)vecMin.y;
            long xmax = (long)vecMax.x;
            long ymax = (long)vecMax.y;
            if ((float)xmin < (float)this.CropWindowXMin() - this.m_FilterXWidth / 2.0f) {
                xmin = (long)((float)this.CropWindowXMin() - this.m_FilterXWidth / 2.0f);
            }
            if ((float)ymin < (float)this.CropWindowYMin() - this.m_FilterYWidth / 2.0f) {
                ymin = (long)((float)this.CropWindowYMin() - this.m_FilterYWidth / 2.0f);
            }
            if ((float)xmax > (float)this.CropWindowXMax() + this.m_FilterXWidth / 2.0f) {
                xmax = (long)((float)this.CropWindowXMax() + this.m_FilterXWidth / 2.0f);
            }
            if ((float)ymax > (float)this.CropWindowYMax() + this.m_FilterYWidth / 2.0f) {
                ymax = (long)((float)this.CropWindowYMax() + this.m_FilterYWidth / 2.0f);
            }
            RiGlobal.QGetRenderContext().Stats().Others().Stop();
            if (!bIsEmpty) {
                RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Start();
                CqOcclusionBox.SetupHierarchy(this.CurrentBucket(), (int)xmin, (int)ymin, (int)xmax, (int)ymax);
                RiGlobal.QGetRenderContext().Stats().OcclusionCullTimer().Stop();
            }
            int iBucket = this.CurrentBucketRow() * this.cXBuckets() + this.CurrentBucketCol();
            if (pProgressHandler != null) {
                float Complete = this.cXBuckets() * this.cYBuckets();
                Complete /= (float)iBucket;
                Complete = 100.0f / Complete;
                RiGlobal.QGetRenderContext().Stats().SetComplete(Complete);
                try {
                    pProgressHandler.invoke((Object)RiGlobal.QGetRenderContext(), Float.valueOf(Complete), RiGlobal.QGetRenderContext().CurrentFrame());
                }
                catch (Exception e) {
                    HimawariLogger.outputException(e);
                }
            }
            this.RenderSurfaces(xmin, xmax, ymin, ymax);
            if (this.m_fQuit) {
                this.m_fDone = true;
                return;
            }
            this.CurrentBucket().SetProcessed();
        } while (this.NextBucket());
        this.ImageComplete();
        CqBucket.ShutdownBucket();
        CqOcclusionBox.DeleteHierarchy();
        if (pProgressHandler != null) {
            try {
                pProgressHandler.invoke((Object)RiGlobal.QGetRenderContext(), Float.valueOf(100.0f), RiGlobal.QGetRenderContext().CurrentFrame());
            }
            catch (Exception e) {
                HimawariLogger.outputException(e);
            }
        }
        this.m_fDone = true;
    }

    /*
     * Unable to fully structure code
     */
    public void StoreSample(CqMicroPolygon pMPG, int pie2, int index, p_float D) {
        block15: {
            Occludes = this.m_CurrentMpgSampleInfo.m_Occludes;
            opaque = this.m_CurrentMpgSampleInfo.m_IsOpaque;
            currentOpaqueSample = CqBucket.aieImage(pie2).OpaqueValues(index);
            if (CqImageBuffer.localImageVal == null) {
                CqImageBuffer.localImageVal = new SqImageSample(RiGlobal.QGetRenderContext().GetOutputDataTotalSize());
            }
            ImageVal = opaque != false ? currentOpaqueSample : CqImageBuffer.localImageVal;
            aValues = CqBucket.aieImage(pie2).Values(index);
            itecount = 0;
            iteend = aValues.size();
            sample = null;
            if (itecount < iteend) {
                sample = (SqImageSample)aValues.get(itecount);
            }
            if (!opaque) ** GOTO lbl20
            if ((currentOpaqueSample.m_flags & 4) == 0 || !(currentOpaqueSample.Depth() <= D.value)) break block15;
            return;
            while (!(sample.Depth() >= D.value)) {
                if ((sample.m_flags & 1) != 0 && sample.m_pCSGNode == null && this.m_CurrentGridInfo.m_IsCullable) {
                    return;
                }
                sample = ++itecount < iteend ? (SqImageSample)aValues.get(itecount) : null;
lbl20:
                // 2 sources

                if (itecount < iteend) continue;
            }
        }
        ImageVal.SetDepth(D.value);
        CqStats.IncI(266);
        pMPG.MarkHit();
        val = ImageVal.m_Data;
        val.setValueAt(0, this.m_CurrentMpgSampleInfo.m_Colour.fRed());
        val.setValueAt(1, this.m_CurrentMpgSampleInfo.m_Colour.fGreen());
        val.setValueAt(2, this.m_CurrentMpgSampleInfo.m_Colour.fBlue());
        val.setValueAt(3, this.m_CurrentMpgSampleInfo.m_Opacity.fRed());
        val.setValueAt(4, this.m_CurrentMpgSampleInfo.m_Opacity.fGreen());
        val.setValueAt(5, this.m_CurrentMpgSampleInfo.m_Opacity.fBlue());
        val.setValueAt(6, D.value);
        if (this.m_CurrentGridInfo.m_UsesDataMap) {
            this.StoreExtraData(pMPG, val);
        }
        if (!opaque && itecount != iteend && sample.Depth() == ImageVal.Depth() && sample.m_pCSGNode == null) {
            sample.m_Data.assignment(sample.m_Data.add(val).mul(0.5f));
            return;
        }
        if ((this.DisplayMode() & 4) == 0 && Occludes) {
            CqOcclusionBox.MarkForUpdate(CqBucket.aieImage(pie2).OcclusionBoxId());
            CqBucket.aieImage(pie2).MarkForZUpdate();
        }
        ImageVal.m_pCSGNode = pMPG.pGrid().pCSGNode();
        ImageVal.m_flags = 0;
        if (Occludes) {
            ImageVal.m_flags |= 1;
        }
        if (this.m_CurrentGridInfo.m_IsMatte) {
            ImageVal.m_flags |= 2;
        }
        if (!opaque) {
            aValues.add(itecount, new SqImageSample(ImageVal));
            CqBucket.aieImage(pie2).SetUsesSampleList();
        } else {
            if ((ImageVal.m_flags & 4) == 0) {
                CqBucket.aieImage(pie2).IncOpaqueSampleCount();
            }
            ImageVal.m_flags |= 4;
        }
    }

    public void StoreExtraData(CqMicroPolygon pMPG, Valarray val) {
        HashMap<String, CqRenderer.SqOutputDataEntry> DataMap = RiGlobal.QGetRenderContext().GetMapOfOutputDataEntries();
        for (Map.Entry<String, CqRenderer.SqOutputDataEntry> entry : DataMap.entrySet()) {
            IqShaderData pData = pMPG.pGrid().FindStandardVar(entry.getKey());
            if (pData == null) continue;
            switch (pData.Type().getValue()) {
                case 1: 
                case 2: {
                    p_float f = new p_float();
                    pData.GetFloat(f, pMPG.GetIndex());
                    val.setValueAt(entry.getValue().m_Offset, f.value);
                    break;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    CqVector3D v = new CqVector3D();
                    pData.GetPoint(v, pMPG.GetIndex());
                    val.setValueAt(entry.getValue().m_Offset, v.x);
                    val.setValueAt(entry.getValue().m_Offset + 1, v.y);
                    val.setValueAt(entry.getValue().m_Offset + 2, v.z);
                    break;
                }
                case 5: {
                    CqColor c = new CqColor();
                    pData.GetColor(c, pMPG.GetIndex());
                    val.setValueAt(entry.getValue().m_Offset, c.fRed());
                    val.setValueAt(entry.getValue().m_Offset + 1, c.fGreen());
                    val.setValueAt(entry.getValue().m_Offset + 2, c.fBlue());
                    break;
                }
                case 11: {
                    CqMatrix m = new CqMatrix();
                    pData.GetMatrix(m, pMPG.GetIndex());
                    val.setValueAt(entry.getValue().m_Offset, m.m_aaElement[0][0]);
                    val.setValueAt(entry.getValue().m_Offset + 1, m.m_aaElement[0][1]);
                    val.setValueAt(entry.getValue().m_Offset + 2, m.m_aaElement[0][2]);
                    val.setValueAt(entry.getValue().m_Offset + 3, m.m_aaElement[0][3]);
                    val.setValueAt(entry.getValue().m_Offset + 4, m.m_aaElement[1][0]);
                    val.setValueAt(entry.getValue().m_Offset + 5, m.m_aaElement[1][1]);
                    val.setValueAt(entry.getValue().m_Offset + 6, m.m_aaElement[1][2]);
                    val.setValueAt(entry.getValue().m_Offset + 7, m.m_aaElement[1][3]);
                    val.setValueAt(entry.getValue().m_Offset + 8, m.m_aaElement[2][0]);
                    val.setValueAt(entry.getValue().m_Offset + 9, m.m_aaElement[2][1]);
                    val.setValueAt(entry.getValue().m_Offset + 10, m.m_aaElement[2][2]);
                    val.setValueAt(entry.getValue().m_Offset + 11, m.m_aaElement[2][3]);
                    val.setValueAt(entry.getValue().m_Offset + 12, m.m_aaElement[3][0]);
                    val.setValueAt(entry.getValue().m_Offset + 13, m.m_aaElement[3][1]);
                    val.setValueAt(entry.getValue().m_Offset + 14, m.m_aaElement[3][2]);
                    val.setValueAt(entry.getValue().m_Offset + 15, m.m_aaElement[3][3]);
                    break;
                }
            }
        }
    }

    public boolean fDone() {
        return this.m_fDone;
    }

    public void SetImage() {
        HimawariLogger logger = HimawariLogger.getLogger();
        this.DeleteImage();
        this.m_XBucketSize = 16;
        this.m_YBucketSize = 16;
        int[] poptBucketSize = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOption("limits", "bucketsize");
        if (poptBucketSize != null) {
            if (poptBucketSize[0] > 0) {
                this.m_XBucketSize = poptBucketSize[0];
            } else {
                logger.warning("X BucketSize under 0 cast to 16\n");
            }
            if (poptBucketSize[1] > 0) {
                this.m_YBucketSize = poptBucketSize[1];
            } else {
                logger.warning("Y BucketSize under 0 cast to 16\n");
            }
        }
        this.m_FilterXWidth = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"FilterWidth", (int)0).value;
        this.m_FilterYWidth = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"FilterWidth", (int)1).value;
        this.m_iXRes = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)0).value;
        this.m_iYRes = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"Resolution", (int)1).value;
        this.m_CropWindowXMin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.m_iXRes * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)0).value), 0.0f, this.m_iXRes);
        this.m_CropWindowXMax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.m_iXRes * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)1).value), 0.0f, this.m_iXRes);
        this.m_CropWindowYMin = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.m_iYRes * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)2).value), 0.0f, this.m_iYRes);
        this.m_CropWindowYMax = (int)PublicFunctions.CLAMP((float)Math.ceil((float)this.m_iYRes * RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"CropWindow", (int)3).value), 0.0f, this.m_iYRes);
        this.m_cXBuckets = this.m_iXRes / this.m_XBucketSize + 1;
        this.m_cYBuckets = this.m_iYRes / this.m_YBucketSize + 1;
        this.m_PixelXSamples = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)0).value;
        this.m_PixelYSamples = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"PixelSamples", (int)1).value;
        this.m_ClippingNear = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Clipping", (int)0).value;
        this.m_ClippingFar = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Clipping", (int)1).value;
        this.m_DisplayMode = RiGlobal.QGetRenderContext().optCurrent().GetIntegerOptionIndex((String)"System", (String)"DisplayMode", (int)0).value;
        CqBucket.SetImageBuffer(this);
        this.m_Buckets.setSize(this.m_cYBuckets);
        for (STLVector sTLVector : this.m_Buckets) {
            sTLVector.setSize(this.m_cXBuckets);
            for (CqBucket b : sTLVector) {
                b.SetProcessed(false);
            }
        }
        this.m_CurrentBucketRow = 0;
        this.m_CurrentBucketCol = 0;
    }

    public void Quit() {
        this.m_fQuit = true;
    }

    public void Release() {
    }

    public void BucketComplete() {
    }

    public void ImageComplete() {
    }

    public boolean IsCurrentBucketEmpty() {
        boolean retval = false;
        CqBucket Bucket = this.CurrentBucket();
        if (Bucket.pTopSurface() == null && Bucket.aGrids().isEmpty() && Bucket.aMPGs().isEmpty()) {
            retval = true;
        }
        return retval;
    }

    private void CacheGridInfo(CqMicroPolyGridBase pGrid) {
        this.m_CurrentGridInfo.m_IsMatte = pGrid.pAttributes().GetIntegerAttribute("System", "Matte")[0] == 1;
        this.m_CurrentGridInfo.m_IsCullable = (this.DisplayMode() & 4) == 0 && pGrid.pCSGNode() == null;
        this.m_CurrentGridInfo.m_UsesDataMap = !RiGlobal.QGetRenderContext().GetMapOfOutputDataEntries().isEmpty();
        this.m_CurrentGridInfo.m_ShadingRate = pGrid.pAttributes().GetFloatAttribute("System", "ShadingRate")[0];
        this.m_CurrentGridInfo.m_ShutterOpenTime = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)0).value;
        this.m_CurrentGridInfo.m_ShutterCloseTime = RiGlobal.QGetRenderContext().optCurrent().GetFloatOptionIndex((String)"System", (String)"Shutter", (int)1).value;
        this.m_CurrentGridInfo.m_LodBounds = pGrid.pAttributes().GetFloatAttribute("System", "LevelOfDetailBounds");
    }

    private strictfp class SqMpgSampleInfo {
        CqColor m_Colour;
        CqColor m_Opacity;
        boolean m_Occludes;
        boolean m_IsOpaque;

        SqMpgSampleInfo() {
        }
    }

    private strictfp class SqGridInfo {
        float m_ShadingRate;
        float m_ShutterOpenTime;
        float m_ShutterCloseTime;
        boolean m_IsMatte;
        boolean m_IsCullable;
        boolean m_UsesDataMap;
        float[] m_LodBounds;

        SqGridInfo() {
        }
    }
}

