/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.library.CqBasicSurface;
import net.cellcomputing.himawari.library.CqBound;
import net.cellcomputing.himawari.library.CqQuadric;
import net.cellcomputing.himawari.library.types.CqMatrix;
import net.cellcomputing.himawari.library.types.CqVector3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class CqCone
extends CqQuadric {
    private float m_Height;
    private float m_Radius;
    private float m_vMin;
    private float m_vMax;
    private float m_ThetaMin;
    private float m_ThetaMax;
    static /* synthetic */ Class class$0;

    public CqCone() {
        this(1.0f, 1.0f, 0.0f, 360.0f, 0.0f, 1.0f);
    }

    public CqCone(float height) {
        this(height, 1.0f, 0.0f, 360.0f, 0.0f, 1.0f);
    }

    public CqCone(float height, float radius) {
        this(height, radius, 0.0f, 360.0f, 0.0f, 1.0f);
    }

    public CqCone(float height, float radius, float thetamin) {
        this(height, radius, thetamin, 360.0f, 0.0f, 1.0f);
    }

    public CqCone(float height, float radius, float thetamin, float thetamax) {
        this(height, radius, thetamin, thetamax, 0.0f, 1.0f);
    }

    public CqCone(float height, float radius, float thetamin, float thetamax, float vmin) {
        this(height, radius, thetamin, thetamax, vmin, 1.0f);
    }

    public CqCone(float height, float radius, float thetamin, float thetamax, float vmin, float vmax) {
        this.m_Height = height;
        this.m_Radius = radius;
        this.m_vMin = vmin;
        this.m_vMax = vmax;
        this.m_ThetaMin = thetamin;
        this.m_ThetaMax = thetamax;
    }

    public CqCone(CqCone From) {
        this.assignment(From);
    }

    public void destrust() {
    }

    @Override
    public CqBound Bound() {
        float zmin = this.m_vMin * this.m_Height;
        float zmax = this.m_vMax * this.m_Height;
        STLVector<CqVector3D> curve = new STLVector<CqVector3D>(CqVector3D.class);
        CqVector3D vA = new CqVector3D(this.m_Radius, 0.0f, zmin);
        CqVector3D vB = new CqVector3D(0.0f, 0.0f, zmax);
        CqVector3D vC = new CqVector3D(0.0f, 0.0f, 0.0f);
        CqVector3D vD = new CqVector3D(0.0f, 0.0f, 1.0f);
        curve.add(vA);
        curve.add(vB);
        CqMatrix matRot = new CqMatrix((float)StrictMath.toRadians(this.m_ThetaMin), vD);
        for (CqVector3D i : curve) {
            i.assignment(matRot.multiply(i));
        }
        CqBound B = new CqBound(this.RevolveForBound(curve, vC, vD, (float)StrictMath.toRadians(this.m_ThetaMax - this.m_ThetaMin)));
        B.Transform(this.m_matTx);
        return this.AdjustBoundForTransformationMotion(B);
    }

    @Override
    public CqVector3D DicePoint(int u, int v) {
        float theta = (float)StrictMath.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float zmin = this.m_vMin * this.m_Height;
        float zmax = this.m_vMax * this.m_Height;
        float z = zmin + (float)v * (zmax - zmin) / (float)this.m_vDiceSize;
        float vv = this.m_vMin + (float)v * (this.m_vMax - this.m_vMin) / (float)this.m_vDiceSize;
        float r = (float)((double)this.m_Radius * (1.0 - (double)vv));
        return new CqVector3D((float)((double)r * StrictMath.cos(theta)), (float)((double)r * StrictMath.sin(theta)), z);
    }

    @Override
    public CqVector3D DicePoint(int u, int v, CqVector3D Normal) {
        float theta = (float)StrictMath.toRadians(this.m_ThetaMin + (float)u * (this.m_ThetaMax - this.m_ThetaMin) / (float)this.m_uDiceSize);
        float zmin = this.m_vMin * this.m_Height;
        float zmax = this.m_vMax * this.m_Height;
        float z = zmin + (float)v * (zmax - zmin) / (float)this.m_vDiceSize;
        float vv = this.m_vMin + (float)v * (this.m_vMax - this.m_vMin) / (float)this.m_vDiceSize;
        float r = (float)((double)this.m_Radius * (1.0 - (double)vv));
        float cos_theta = (float)StrictMath.cos(theta);
        float sin_theta = (float)StrictMath.sin(theta);
        float coneLength = (float)StrictMath.sqrt(this.m_Height * this.m_Height + this.m_Radius * this.m_Radius);
        float xN = this.m_Height / coneLength;
        Normal.x(xN * cos_theta);
        Normal.y(xN * sin_theta);
        Normal.z(this.m_Radius / coneLength);
        return new CqVector3D(r * cos_theta, r * sin_theta, z);
    }

    @Override
    public int PreSubdivide(STLVector<CqBasicSurface> aSplits, boolean u) {
        float vcent = (float)((double)(this.m_vMin + this.m_vMax) * 0.5);
        float arccent = (float)((double)(this.m_ThetaMin + this.m_ThetaMax) * 0.5);
        CqCone pNew1 = new CqCone(this);
        CqCone pNew2 = new CqCone(this);
        if (u) {
            pNew1.m_ThetaMax = arccent;
            pNew2.m_ThetaMin = arccent;
        } else {
            pNew1.m_vMax = vcent;
            pNew2.m_vMin = vcent;
        }
        aSplits.add(pNew1);
        aSplits.add(pNew2);
        return 2;
    }

    public CqCone assignment(CqCone From) {
        super.assignment(From);
        this.m_Height = From.m_Height;
        this.m_Radius = From.m_Radius;
        this.m_vMin = From.m_vMin;
        this.m_vMax = From.m_vMax;
        this.m_ThetaMin = From.m_ThetaMin;
        this.m_ThetaMax = From.m_ThetaMax;
        return this;
    }
}

