/*
 * Decompiled with CFR 0.152.
 */
package net.cellcomputing.himawari.display;

import java.awt.image.BufferedImage;
import net.cellcomputing.himawari.display.ImageData;
import net.cellcomputing.himawari.library.CqImageBuffer;
import net.cellcomputing.himawari.library.IqBucket;
import net.cellcomputing.himawari.library.RiGlobal;
import net.cellcomputing.himawari.library.types.CqColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class RGBAImageData
extends ImageData<BufferedImage> {
    private static final int DATA_SIZE = 4;

    protected RGBAImageData(int offset) {
        super(offset);
        this.dataSize = 4;
        this.pixelData = new float[4];
    }

    @Override
    public void setBucket(IqBucket pBucket) {
        if (pBucket.Width() == 0 || pBucket.Height() == 0) {
            return;
        }
        int xmin = pBucket.XOrigin();
        int ymin = pBucket.YOrigin();
        int xmaxplus1 = xmin + pBucket.Width();
        int ymaxplus1 = ymin + pBucket.Height();
        CqImageBuffer img = RiGlobal.QGetRenderContext().pImage();
        if (xmaxplus1 <= img.CropWindowXMin() || ymaxplus1 <= img.CropWindowYMin() || xmin > img.CropWindowXMax() || ymin > img.CropWindowYMax()) {
            return;
        }
        int y = ymin;
        while (y < ymaxplus1) {
            int x = xmin;
            while (x < xmaxplus1) {
                if (x >= img.CropWindowXMin() && y >= img.CropWindowYMin() && x < img.CropWindowXMax() && y < img.CropWindowYMax()) {
                    CqColor col = pBucket.Color(x, y);
                    this.pixelData[0] = col.fRed();
                    this.pixelData[1] = col.fGreen();
                    this.pixelData[2] = col.fBlue();
                    this.pixelData[3] = pBucket.Data(x, y).valueAt(8);
                    this.raster.setPixel(x - img.CropWindowXMin(), y - img.CropWindowYMin(), this.pixelData);
                }
                ++x;
            }
            ++y;
        }
    }

    @Override
    public BufferedImage getImage() {
        return (BufferedImage)this.imageData;
    }

    @Override
    public void init() {
        super.init();
        this.imageData = new BufferedImage(this.width, this.height, 2);
        this.raster = ((BufferedImage)this.imageData).getRaster();
    }
}

