/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;

import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public strictfp class CellCipher {
	
	private static String algo = "DES";
	private static String mode = "DES/CBC/PKCS5Padding";
	private static String key  = "dummykey";
	private static String iv   = "dummy-iv";
	
	private static String enc  = "UTF-8";
	
	
	/**
	 * kÍꂽt@Cɑ΂AWJXg[쐬
	 * 
	 * @param filename	kÍꂽt@C
	 * @return	ǂݍ݃Xg[
	 * @throws FileNotFoundException	t@C݂Ȃ
	 * @throws IOException	IOG[
	 */
	private static InputStream open( String filename ) throws FileNotFoundException, IOException
	{
		try {
			
			Cipher cipher = Cipher.getInstance(mode);
			
			//L[̐
			SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(enc), algo);
			
			//IV̐
			IvParameterSpec initVec = new IvParameterSpec( iv.getBytes( enc ) );
			
			//CipherCX^X̏
			cipher.init( Cipher.DECRYPT_MODE, sksSpec, initVec );
			
			/*** kÍXg[ił͉𓀕Xg[j̍쐬 ***/
			
			//t@CXg[
			FileInputStream fis = new FileInputStream(filename);
			
			//ÍXg[
			CipherInputStream cis = new CipherInputStream( fis, cipher );
			
			//kXg[
			try	{
				GZIPInputStream gis = new GZIPInputStream(cis);
				return gis;
			}
			catch( IOException e ){
				cis.close();
				return new FileInputStream(filename);
			}
			
		}catch (FileNotFoundException e){
			throw(e);
		}catch(IOException e){
			throw(e);
		} catch (NoSuchAlgorithmException e) {
			throw new IOException(e.getMessage());
		} catch (NoSuchPaddingException e) {
			throw new IOException(e.getMessage());
		} catch (InvalidKeyException e) {
			throw new IOException(e.getMessage());
		} catch (InvalidAlgorithmParameterException e) {
			throw new IOException(e.getMessage());
		}
	}
		
	/**
	 * kÍꂽt@Cɑ΂AWJXg[쐬AInputStreamReaderƂĕԂ
	 * 
	 * @param filename	kÍꂽt@C
	 * @return	InputStreamReader
	 * @throws FileNotFoundException	t@C݂Ȃ
	 * @throws IOException	IOG[
	 */
	public static InputStreamReader getReader( String filename ) throws FileNotFoundException, IOException
	{
		return new InputStreamReader( open(filename) );
	}
		
	
	/**
	 * kÍꂽt@Cɑ΂AWJXg[쐬AInputStreamƂĕԂ
	 * 
	 * @param filename	kÍꂽt@C
	 * @return	InputStream
	 * @throws FileNotFoundException	t@C݂Ȃ
	 * @throws IOException	IOG[
	 */
	public static InputStream getInputStream( String filename ) throws FileNotFoundException, IOException
	{
		return open(filename);
	}
}
