// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import java.lang.reflect.Method;

/**
 * 
 * p
 * 
 * @author NTT DATA Corporation
 */
public strictfp class UsProgramElement {
	public Method m_Command ;					///< Pointer to a function.
	public float	m_FloatVal;					///< Absolute float value.
	public String	m_pString = new String();	///< Absolute string value.
	public int	m_iVariable;					///< Shader variable index.
	public SqLabel	m_Label = new SqLabel();	///< Program label.
	public SqDSOExternalCall m_pExtCall ;		///< Call a DSO function

	/**
	 * RXgN^
	 */
	public UsProgramElement() {
		reset();
	}
	
	/**
	 * Rs[RXgN^
	 * @param from	Rs[
	 */
	public UsProgramElement( UsProgramElement from ) {
		this.assignment(from);
	}
	
    public void reset()
    {
    	m_Command	= null;
    	m_FloatVal	= 0;
    	m_pString	= "";
    	m_iVariable	= 0;
    	m_Label		= new SqLabel();
    	m_pExtCall	= null;
    }
  

    
	public void assignment(Method cmd) {
    	m_Command	= cmd;
    	m_FloatVal	= 0;
    	m_pString	= "";
    	m_iVariable	= 0;
    	m_Label		= new SqLabel();
    	m_pExtCall	= null;
	}
    
	public void assignment(float flt) {
	   	m_Command	= null;
    	m_FloatVal	= flt;
    	m_pString	= "";
    	m_iVariable	= (int)flt;
    	m_Label		= new SqLabel();
    	m_pExtCall	= null;
	}
	
	public void assignment(String str) {
		m_Command	= null;
		m_FloatVal	= 0;
		m_pString	= str;
		m_iVariable	= 0;
		m_Label		= new SqLabel();
		m_pExtCall	= null;
	}

	public void assignment(int inte) {
    	m_Command	= null;
    	m_FloatVal	= inte;
    	m_pString	= "";
    	m_iVariable	= inte;
    	m_Label		= new SqLabel();
    	m_pExtCall	= null;
	}

	public void assignment(SqLabel label) {
    	m_Command	= null;
    	m_FloatVal	= 0;
    	m_pString	= "";
    	m_iVariable	= 0;
    	m_Label		= label;
    	m_pExtCall	= null;
	}
	
	public void assignment(SqDSOExternalCall call) {
    	m_Command	= null;
    	m_FloatVal	= 0;
    	m_pString	= "";
    	m_iVariable	= 0;
    	m_Label		= new SqLabel();
    	m_pExtCall	= call;
	}

	public void assignment(UsProgramElement from ) {
		m_Command	= from.m_Command;
    	m_FloatVal	= from.m_FloatVal;
    	m_pString	= from.m_pString;
    	m_iVariable	= from.m_iVariable;
    	m_Label		= from.m_Label;
    	m_pExtCall	= from.m_pExtCall;
	}
	
    
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {

		String str = "";
		
		if( m_Command != null ){
			str += m_Command.toString();
		}
		else if( m_FloatVal != 0 ){
			str += m_FloatVal;
		}
		else if( m_pString != null ){
			str += m_pString;
		}
		else if( m_iVariable != 0 ){
			str += m_iVariable;
		}
		else if( m_Label != null ){
			str += "Address:" + m_Label.m_pAddress + " Offset:" + m_Label.m_Offset;
		}
		else if( m_pExtCall != null ){
			str += m_pExtCall.toString();
		}

		return str;
	}
    
}
