// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.shadervm;

import static net.cellcomputing.himawari.library.EqIntIndex.SHD_var_varying_float;
import net.cellcomputing.himawari.accessory.STLArray;
import net.cellcomputing.himawari.accessory.STLVector;
import net.cellcomputing.himawari.accessory.primitive.p_boolean;
import net.cellcomputing.himawari.accessory.primitive.p_float;
import net.cellcomputing.himawari.library.CqStats;
import net.cellcomputing.himawari.library.EqIntIndex;
import net.cellcomputing.himawari.library.EqVariableType;
import net.cellcomputing.himawari.library.IqShaderData;

/**
 *@CqShaderVariableVaryingNXFloatɓ
 *  NX
 * @author NTT DATA Corporation
 */
public strictfp class CqShaderVariableVaryingFloat extends CqShaderVariableVarying<p_float> {
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 */
	public CqShaderVariableVaryingFloat( )
	{
		super(new EqVariableType(EqVariableType.type_float));
		//Ϗ̂
		//m_aValue = new STLVector<p_float>(p_float.class);
		m_aValue = new STLArray<p_float>(p_float.class);
		m_aValue.resize( 1 );
		
		CqStats.STATS_INC( SHD_var_varying_float );
	}
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * 
	 * @param strName
	 * @param fParameter
	 */
	public CqShaderVariableVaryingFloat( final String strName, boolean fParameter)
	{
		super(strName,fParameter,new EqVariableType(EqVariableType.type_float));
		//Ϗ̂
		//m_aValue = new STLVector<p_float>(p_float.class);
		m_aValue = new STLArray<p_float>(p_float.class);
		m_aValue.resize( 1 );
		CqStats.STATS_INC( SHD_var_varying_float );
	}
	
	/**
	 * RXgN^B
	 * Vector̔z1ɃZbgāA
	 * vXVB
	 * @param strName
	 */
	public CqShaderVariableVaryingFloat( final String strName){
		this(strName,false);
	}
	
	/**
	 * Rs[RXgN^
	 * @param val
	 */
	public CqShaderVariableVaryingFloat(CqShaderVariableVaryingFloat val){
		super(val,new EqVariableType(EqVariableType.type_float));
		//m_aValue = new STLVector<p_float>(p_float.class);
		m_aValue = new STLArray<p_float>(p_float.class);
		m_aValue.resize( val.m_aValue.size() );
//		m_aValue.assign( val.m_aValue.begin(), val.m_aValue.begin() );
		//R[hɏC 2005/11/2 nttdata
		for(int i = 0; i < val.m_aValue.size(); i++)
			m_aValue.elementAt(i).value = val.m_aValue.elementAt(i).value;
		
//		m_aValue.clear();
	}
	
	/**
	 * u=vZq̃I[o[[h
	 * Vector̒lRs[
	 * @param From
	 */
	public void assignment(CqShaderVariableVarying From) {
//		m_aValue = From.m_aValue;
		m_aValue.resize(From.m_aValue.size());
		for(int i = 0; i < From.m_aValue.size();i++){
			m_aValue.elementAt(i).value = ((p_float)From.m_aValue.elementAt(i)).value;
		}
	}
	
	/**
	 * eNXŒ`ꂽ֐
	 * Vector̃TCY1ȏł
	 * w肳ꂽ擪̒lVector𖄂ߐsB
	 * Vector̃TCY0ȉł΁A
	 * lŖߐsB
	 * 
	 * ߐs(uGridRes+1) * (vGridRes)B
	 * 
	 * @param uGridRes
	 * @param vGridRes
	 */
	public void Initialise(int uGridRes, int vGridRes) {
		p_float Def = new p_float();
		if ( m_aValue.size() > 0 )
		   Def.value = m_aValue.elementAt( 0 ).value;

		if(Def.value == 0.0f)
		{
			m_aValue.resize( (( uGridRes + 1 ) * ( vGridRes + 1 )) );
		}
		else
		{
			m_aValue.assign( (( uGridRes + 1 ) * ( vGridRes + 1 )), Def );
		}

		CqStats.STATS_INC( EqIntIndex.SHD_Var_varying_init );		
	}
	
	/**
	 * w肳ꂽꏊShaderData̒l擾
	 * @param res 擾li[ϐ
	 * @param index 擾ꏊ
	 */
	public	void	GetFloat( p_float res, int index) 
	{
		//index0̎̏ǉ
		if(index >= m_aValue.size())
			return;
		res.value = m_aValue.elementAt( index ).value;
	}
	
	/**
	 * ShaderData̎Afloat̃|C^擾B
	 * 
	 * @param res ʂi[BgύXShaderData̒le󂯂
	 */
	public	void	GetFloatPtr( final STLVector<p_float> res ) 
	{
		//res = m_aValue[ 0 ];
		res.resize(m_aValue.size());
		for(int i=0;i < m_aValue.size();i++){
			res.setElementAt(m_aValue.elementAt(i),i);
		}
	}
	
	//nttdata 
	//public	STLVector<p_float> GetFloatPtr_2( ) 
	public	STLArray<p_float> GetFloatPtr_2( ) 
	{
		//res = m_aValue[ 0 ];
		return m_aValue;
	}
	
	/**
	 * ShaderData̎w肳ꂽꏊ̒lύXB
	 * 
	 * @param f ύXl
	 * @param index ύXꏊ
	 */
	public	void	SetFloat( final float f, int index )
	{
		m_aValue.elementAt( index ).value = f;
	}
	
	/**
	 * ShaderData̒lύXB
	 * Ŏw肳ꂽlVector𖄂ߐs
	 * @param f ύXl
	 */
	public	void	SetFloat( final float f )
	{
		m_aValue.assign( m_aValue.size(), new p_float(f) );
	}
	/** Copy the values from the passed variable into this, taking into account any class differences.
	 * Ŏw肳ꂽϐlARs[B
	 * Rs[̃TCY1ȉ̏ꍇ́A̒l
	 * Vector̒Rs[B
	 * 
	 * ARs[Vector̃TCYA1傫
	 * Vector̃TCY菬ꍇErrorƂȂB
	 * iC++͓ɃG[Ȃ)
	 * 
	 * @param pVal Rs[̕ϐBThe variable to copy from.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal )
	{
		int i;
		if ( pVal.Size() > 1 )
		{
			//nttdata 
//			STLVector<p_float>  pData = new STLVector<p_float>(p_float.class);
//			pVal.GetFloatPtr( pData );
			
			//STLVector<p_float>  pData ;
			STLArray<p_float>  pData ;
			pData = pVal.GetFloatPtr_2( );
			
			for ( i = 0; i < Size(); i++ )
				m_aValue.elementAt( i ).value = pData.elementAt( i ).value;
		}
		else
		{
			p_float temp = new p_float();
			pVal.GetFloat( temp );
			m_aValue.assign( m_aValue.size(), temp );
		}
	}
	/**
	 * indexŎw肳ꂽꏊ̒lA0łfalse
	 * ȊOȂtrue1Ɋi[B
	 * 
	 * @param res ʂi[ϐ
	 * @param index zԍ
	 */
	public void	GetBool( p_boolean res, int index) 
	{
		res.value = m_aValue.elementAt(index).value != 0.0f;
	}
	
	/**
	 * vector̗vfSĂɎw肳ꂽlB
	 * trueȂ1AfalseȂ0B
	 * @param val w肷l
	 */
	public void	SetBool( final boolean val )
	{
		if(val)
			m_aValue.assign( m_aValue.size(), new p_float(1) );
		else
			m_aValue.assign(m_aValue.size(),new p_float(0));
	}
	
	/**
	 * w肳ꂽVector̗vfɎw肳ꂽlB
	 * trueȂ1AfalseȂ0B
	 * @param val w肷l
	 * @param index w肷ʒu
	 */
	public void	SetBool( final boolean val, int index )
	{
		if(val)
			m_aValue.elementAt( index ).value = 1;
		else
			m_aValue.elementAt( index ).value = 0;   		
	}
	/** Set the all SIMD data assigned on a state vector, only indexes whose bit is set are modified.
	 * 
	 * Ŏw肳ꂽϐVector̎w肳ꂽꏊ̒l
	 * gVector̓ꏊɃRs[B
	 * 
	 * @param pVal Rs[̕ϐ The stack entry to assign.
	 * @param index Rs[ꏊ Integer SIMD index.
	 */
	public	void	SetValueFromVariable( final IqShaderData pVal, int index )
	{
		pVal.GetFloat( m_aValue.elementAt(index), index );
	}
	
	/**
	 * ƓlCX^XԂ
	 * 
	 * @return g̃Rs[
	 */
	public	IqShaderData Clone() 
	{
		CqShaderVariableVaryingFloat newVar = new CqShaderVariableVaryingFloat( this );
		newVar.SetSize( (int)Size() );
		newVar.SetValueFromVariable( this );
		return ( newVar );
	}
	
}
