/*
 Tokenizer.java
 Copyright (C) 2003 Gerardo Horvilleur Martinez

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

public strictfp class Tokenizer {

    private StreamTokenizer st;

    public int ttype;

    public double nval;

    public String sval;

    private boolean pushedBack;

    public Tokenizer(Reader reader) {
        st = new StreamTokenizer(reader);
    }

    public void commentChar(int ch) {
        st.commentChar(ch);
    }

    public void eolIsSignificant(boolean flag) {
        st.eolIsSignificant(flag);
    }

    public int lineno() {
        return st.lineno();
    }

    public void lowerCaseMode(boolean fl) {
        st.lowerCaseMode(fl);
    }

    public int nextToken() throws IOException {
        // This is a horrible hack. We should write our own tokenizer....
        if (!pushedBack) {
            ttype = st.nextToken();
            nval = st.nval;
            sval = st.sval;
        } else
            pushedBack = false;
        if (ttype == StreamTokenizer.TT_NUMBER) 
        {
            double value = st.nval;
            int nextToken = st.nextToken();
           
            if (nextToken == StreamTokenizer.TT_WORD
            		&& (st.sval.charAt(0) == 'e' || st.sval.charAt(0) == 'E')) 
            {
            	if( st.sval.length() == 1 )
            	{
            		st.nextToken();
            		if( (char)st.ttype == '+' ){
            			st.nextToken();
            			nval = value * Math.pow(10.0, st.nval );
            		}
            		else
            			st.pushBack();
            	}
            	else if( (Character.isDigit(st.sval.charAt(1)) || st.sval.charAt(1) == '-') )
            		nval = value * Math.pow( 10.0, Double.parseDouble( st.sval.substring(1) ) );
            	else 
            		st.pushBack();
            }
            else
            	st.pushBack();
    
//          ----------------------------------------------------------------
//            if (nextToken == StreamTokenizer.TT_WORD
//            		&& (st.sval.charAt(0) == 'e' || st.sval.charAt(0) == 'E')
//            		&& (Character.isDigit(st.sval.charAt(1)) || st.sval.charAt(1) == '-')) {
//            	double exp = Double.parseDouble(st.sval.substring(1));
//            	nval = value * Math.pow(10.0, exp);
//            } else
//            	st.pushBack();
//            -----------------------------------------------------------------
        }
        return ttype;
    }

    public void ordinaryChar(int ch) {
        st.ordinaryChar(ch);
    }

    public void ordinaryChars(int low, int hi) {
        st.ordinaryChars(low, hi);
    }

    public void parseNumbers() {
        st.parseNumbers();
    }

    public void pushBack() {
        pushedBack = true;
    }

    public void quoteChar(int ch) {
        st.quoteChar(ch);
    }

    public void resetSyntax() {
        st.resetSyntax();
    }

    public void slashSlashComments(boolean flag) {
        st.slashSlashComments(flag);
    }

    public void slashStarComments(boolean flag) {
        st.slashStarComments(flag);
    }

    public String toString() {
        return st.toString();
    }

    public void whitespaceChars(int low, int hi) {
        st.whitespaceChars(low, hi);
    }

    public void wordChars(int low, int hi) {
        st.wordChars(low, hi);
    }

}
