/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

/**
 * 
 * G}[NɂGXP[vKvƂȂBufferedReader
 * 
 * @author NTT DATA Corporation
 */
public strictfp class BufferedYenEscapeReader extends BufferedReader {
	
	//~}[NtO
	private boolean yenFlg = false;

	//X[p[NXƓ
	private static int defaultCharBufferSize = 8192;
	
	public BufferedYenEscapeReader(Reader in) {
		super(in, defaultCharBufferSize);
	}
	
	/* (non-Javadoc)
	 * @see java.io.BufferedReader#read()
	 */
	@Override
	public int read() throws IOException {
		
		int c;
		
		//POɓǂݍ񂾂̂~}[NAx~}[NԂB
		if( !yenFlg ) {
			c = super.read();
			yenFlg = ( c=='\\' );
		}
		else{
			c = '\\';
			yenFlg = false;
		}
		
		return c;
	}
	
}
