// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.types;

/**
 * 
 * iVF[_́jZmCYJvZNXB
 * 
 * @author NTT DATA Corporation
 */
public strictfp class CqCellNoise {
	
	//************************************************************************//
	//*** RXgN^̒`
	//************************************************************************//
	
	/**
	 * RXgN^
	 */
	public CqCellNoise(){}
	
	//************************************************************************//
	//*** \bh̒`
	//************************************************************************//
	
	/**
	 * Pfloat^ZmCY𔭐
	 * 
	 * @param u	mCY̎
	 * @return	ZmCY
	 */
	public float FCellNoise1( float u )
	{
	    if ( u < 0.0 ) u -= 1;
	    int i = m_PermuteTable[ ( (int)(u) ) & 0x7ff ];

	    return ( m_RandomTable[ i ] );
	}
	
	/**
	 * Qfloat^ZmCY𔭐
	 * 
	 * @param u	mCY̎
	 * @param v	mCY̎
	 * @return	ZmCY
	 */
	public float FCellNoise2( float u, float v )
	{
	    if ( u < 0.0 ) u -= 1;
	    int i = m_PermuteTable[ ( (int)(u) ) & 0x7ff ];

	    if ( v < 0.0 ) v -= 1;
	    i = m_PermuteTable[ i + (int)(v) & 0x7ff ];

	    return ( m_RandomTable[ i ] );
	}
	
	/**
	 * Rfloat^ZmCY𔭐
	 * 
	 * @param P	mCY̎ƂȂCqVector3DIuWFNg
	 * @return	ZmCY
	 */
	public float FCellNoise3( final CqVector3D P )
	{
	    float f = P.x;
	    if ( f < 0.0 ) f -= 1;
	    int i = m_PermuteTable[ ( (int)(f) ) & 0x7ff ];

	    f = P.y;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];

	    f = P.z;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];

	    return ( m_RandomTable[ i ] );
	}
	
	/**
	 * Sfloat^ZmCY𔭐
	 * 
	 * @param P	mCY̎ƂȂCqVector3DIuWFNg
	 * @param v	mCY̎
	 * @return	ZmCY
	 */
	public float FCellNoise4( final CqVector3D P, float v )
	{
	    float f = P.x;
	    if ( f < 0.0 ) f -= 1;
	    int i = m_PermuteTable[ ( (int)(f) ) & 0x7ff ];

	    f = P.y;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];

	    f = P.z;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];

	    f = v;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + ( (int)(f) ) & 0x7ff ];

	    return ( m_RandomTable[ i ] );
	}
	
	/**
	 * PCqVector3D^ZmCY𔭐
	 * 
	 * @param u	mCY̎
	 * @return	ZmCY
	 */
	public CqVector3D PCellNoise1( float u )
	{
	    if ( u < 0.0 ) u -= 1;
	    int i = m_PermuteTable[ ( (int)(u) ) & 0x7ff ];

	    CqVector3D result = new CqVector3D();
	    result.x = m_RandomTable[ i ];
	    i = m_PermuteTable[ m_PermuteTable[ i ] + i ];
	    result.y = m_RandomTable[ i ];
	    i = m_PermuteTable[ m_PermuteTable[ i ] + i ];
	    result.z = m_RandomTable[ i ];

	    return ( result );
	}
	
	/**
	 * QCqVector3D^ZmCY𔭐
	 * 
	 * @param u	mCY̎
	 * @param v	mCY̎
	 * @return	ZmCY
	 */
	public CqVector3D PCellNoise2( float u, float v )
	{
	    if ( u < 0.0 ) u -= 1;
	    int i = m_PermuteTable[ ( (int)(u) ) & 0x7ff ];

	    if ( v < 0.0 ) v -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(v) & 0x7ff ];

	    CqVector3D result = new CqVector3D();
	    result.x = m_RandomTable[ i ];
	    i = m_PermuteTable[ i ];
	    result.y = m_RandomTable[ i ];
	    i = m_PermuteTable[ i ];
	    result.z = m_RandomTable[ i ];

	    return ( result );
	}
	
	/**
	 * RCqVector3D^ZmCY𔭐
	 * 
	 * @param P	mCY̎ƂȂCqVector3DIuWFNg
	 * @return	ZmCY
	 */
	public CqVector3D PCellNoise3( final CqVector3D P )
	{
	    CqVector3D result = new CqVector3D();

	    float f = P.x;
	    if ( f < 0.0 ) f -= 1;
	    int i = m_PermuteTable[ (int)(f) & 0x7ff ];
	    result.x = m_RandomTable[ i ];

	    f = P.y;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];
	    result.y = m_RandomTable[ i ];

	    f = P.z;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];
	    result.z = m_RandomTable[ i ];

	    return ( result );
	}
	
	/**
	 * SCqVector3D^ZmCY𔭐
	 * 
	 * @param P	mCY̎ƂȂCqVector3DIuWFNg
	 * @param v	mCY̎
	 * @return	ZmCY
	 */
	public CqVector3D PCellNoise4( final CqVector3D P, float v )
	{
	    CqVector3D result = new CqVector3D();
	    float f = v;
	    if ( f < 0.0 ) f -= 1;
	    int i = m_PermuteTable[ (int)(f) & 0x7ff ];

	    f = P.x;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];
	    result.x = m_RandomTable[ i ];

	    f = P.y;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];
	    result.y = m_RandomTable[ i ];

	    f = P.z;
	    if ( f < 0.0 ) f -= 1;
	    i = m_PermuteTable[ m_PermuteTable[ i ] + (int)(f) & 0x7ff ];
	    result.z = m_RandomTable[ i ];

	    return ( new CqVector3D( 0, 0, 0 ) );// ⓚp0̃xNgԂĂ邪EEH nttdata
	}
	
	
	/**
	 * e[u <br>s
	 * static permutation table.
	 */
	private int[] m_PermuteTable = new int[  ]
	{
			672, 625, 458, 751, 272, 757, 218, 1247, 636, 557,
			402, 1403, 976, 635, 898, 255, 192, 985, 178, 91,
			1748, 1181, 298, 1481, 440, 523, 1574, 815, 248, 1291,
			246, 441, 948, 1171, 582, 189, 1184, 1273, 490, 23,
			344, 409, 1202, 411, 728, 215, 286, 55, 460, 927,
			1290, 675, 712, 1161, 414, 365, 104, 641, 106, 79,
			348, 325, 626, 501, 1052, 1327, 738, 1013, 1020, 715,
			538, 1069, 1732, 97, 962, 421, 376, 165, 830, 925,
			596, 193, 242, 901, 1672, 221, 454, 1675, 1200, 969,
			354, 329, 132, 77, 786, 979, 292, 789, 1810, 765,
			1504, 503, 726, 87, 1032, 1781, 226, 475, 24, 279,
			790, 99, 708, 9, 1058, 139, 520, 1381, 998, 429,
			1192, 707, 694, 341, 1408, 107, 678, 459, 780, 717,
			306, 1777, 912, 51, 1378, 1121, 1196, 1021, 846, 1361,
			96, 1325, 686, 663, 808, 1995, 886, 453, 736, 389,
			938, 229, 1852, 651, 58, 305, 812, 689, 142, 1555,
			1208, 1299, 362, 1341, 1804, 1449, 1814, 1203, 588, 309,
			986, 157, 1368, 343, 342, 101, 552, 595, 534, 1787,
			1444, 1677, 38, 491, 804, 41, 318, 131, 1120, 465,
			418, 629, 864, 431, 862, 1331, 1068, 239, 258, 1987,
			324, 225, 1966, 863, 1016, 1377, 958, 133, 1544, 413,
			1318, 5, 232, 1267, 1258, 779, 544, 31, 778, 75,
			1236, 547, 6, 169, 1772, 1155, 518, 831, 880, 631,
			2030, 1783, 1508, 1509, 814, 1459, 604, 1101, 1962, 397,
			1160, 293, 1230, 267, 484, 893, 394, 127, 1104, 105,
			1322, 1131, 1000, 17, 1586, 881, 1560, 1721, 670, 1007,
			1816, 1185, 1398, 513, 1384, 813, 262, 1659, 180, 891,
			26, 197, 1044, 1241, 1342, 347, 528, 1437, 514, 1737,
			724, 555, 838, 1071, 648, 1547, 270, 697, 1692, 1427,
			346, 59, 176, 1529, 1502, 1315, 204, 665, 110, 1467,
			1476, 471, 290, 311, 568, 1183, 326, 931, 0, 1417,
			598, 621, 860, 897, 230, 21, 296, 581, 1382, 1463,
			992, 245, 666, 1269, 868, 241, 1582, 1091, 256, 353,
			918, 677, 936, 767, 878, 1711, 1512, 449, 126, 1157,
			1396, 477, 446, 177, 68, 1225, 906, 585, 1992, 527,
			18, 249, 444, 1045, 2, 1983, 1520, 61, 954, 867,
			100, 179, 1282, 731, 1612, 535, 610, 137, 244, 265,
			442, 395, 1832, 163, 378, 171, 740, 39, 254, 597,
			640, 363, 1618, 1877, 816, 973, 806, 111, 896, 307,
			90, 1665, 1352, 1277, 78, 1617, 1600, 43, 1482, 1775,
			660, 1485, 118, 3, 464, 645, 130, 35, 968, 907,
			162, 175, 120, 945, 710, 1811, 356, 791, 1522, 187,
			12, 1705, 850, 1287, 1980, 565, 562, 1805, 480, 599,
			1082, 357, 1572, 851, 1662, 33, 468, 615, 1354, 747,
			488, 297, 1370, 387, 20, 983, 822, 1591, 924, 687,
			102, 89, 680, 495, 10, 1413, 360, 481, 1362, 1119,
			1260, 1633, 374, 1759, 676, 669, 558, 67, 1220, 1523,
			1326, 1035, 1972, 287, 526, 331, 820, 803, 510, 425,
			1084, 1411, 1858, 1087, 4, 2009, 462, 2039, 652, 1765,
			114, 217, 268, 1357, 466, 653, 656, 549, 398, 1837,
			1492, 251, 1374, 69, 1380, 361, 1434, 15, 240, 273,
			1498, 1981, 1540, 1977, 970, 1263, 784, 1441, 50, 769,
			1148, 1029, 914, 1915, 436, 1147, 1410, 1903, 1284, 1497,
			690, 603, 328, 27, 810, 7, 252, 811, 74, 1359,
			760, 49, 1666, 953, 1460, 1683, 1094, 315, 952, 1785,
			62, 1571, 856, 921, 422, 1723, 1240, 29, 798, 567,
			224, 233, 1802, 1187, 1968, 13, 618, 877, 492, 1651,
			66, 277, 48, 837, 1138, 1719, 1564, 2003, 150, 1525,
			80, 497, 1050, 1347, 1812, 609, 1194, 933, 888, 1023,
			1638, 1967, 1108, 705, 754, 195, 396, 733, 966, 433,
			136, 1681, 278, 841, 644, 783, 1298, 505, 1984, 1301,
			390, 1729, 1696, 317, 186, 1123, 752, 435, 202, 987,
			536, 93, 1302, 393, 1216, 71, 1570, 941, 796, 419,
			266, 209, 1356, 109, 1206, 853, 1920, 619, 1190, 399,
			1292, 1229, 782, 367, 1424, 563, 1890, 1921, 64, 1533,
			1526, 207, 184, 81, 1198, 2031, 1320, 1741, 994, 259,
			388, 2019, 542, 291, 1272, 1163, 570, 1619, 1324, 1201,
			654, 57, 1720, 1047, 874, 443, 196, 45, 506, 1543,
			1100, 821, 1658, 199, 28, 1735, 206, 613, 172, 121,
			250, 289, 216, 871, 550, 1003, 88, 553, 794, 643,
			1632, 1239, 930, 1847, 1144, 943, 1238, 345, 448, 445,
			770, 1669, 504, 737, 1178, 37, 1528, 95, 322, 2015,
			1684, 1841, 1830, 323, 108, 1779, 1770, 1231, 1056, 543,
			1938, 587, 364, 1059, 1610, 681, 384, 1667, 426, 1343,
			212, 1715, 2010, 569, 1616, 2021, 370, 473, 1116, 1613,
			1030, 909, 612, 805, 1742, 231, 996, 507, 1578, 1689,
			52, 617, 1958, 271, 1860, 529, 294, 887, 476, 213,
			1182, 181, 1252, 1697, 1910, 1025, 1896, 1285, 774, 161,
			692, 2025, 1262, 2033, 392, 151, 194, 859, 1040, 283,
			54, 401, 1900, 1067, 1350, 1615, 832, 1685, 70, 1209,
			472, 1939, 858, 571, 688, 183, 406, 1827, 716, 1887,
			622, 1979, 1988, 285, 802, 125, 1080, 489, 658, 201,
			36, 269, 1110, 1863, 1372, 1907, 742, 533, 1248, 1093,
			138, 1975, 1416, 1813, 430, 1695, 1316, 753, 470, 1603,
			768, 865, 122, 1221, 1448, 1279, 1390, 561, 2040, 961,
			638, 451, 1360, 989, 1266, 2001, 580, 1937, 94, 135,
			1664, 1039, 530, 761, 956, 1557, 1646, 1985, 340, 573,
			1466, 1379, 92, 691, 1794, 1243, 584, 219, 1122, 649,
			756, 141, 1730, 1197, 428, 1901, 890, 793, 280, 1545,
			766, 19, 164, 875, 1166, 655, 1328, 203, 330, 623,
			1944, 819, 602, 1627, 2032, 1789, 274, 149, 1768, 337,
			1994, 1137, 1172, 1997, 630, 515, 1680, 1189, 182, 749,
			1480, 1419, 674, 1875, 16, 47, 566, 313, 1644, 1303,
			2034, 699, 524, 301, 382, 1799, 1912, 1077, 1074, 455,
			432, 1991, 762, 869, 512, 377, 1834, 545, 72, 1127,
			2002, 1369, 1952, 103, 1882, 899, 532, 1495, 154, 889,
			368, 1199, 614, 2043, 1392, 701, 522, 1925, 872, 223,
			198, 639, 1332, 351, 2014, 993, 112, 1803, 1070, 579,
			2012, 2035, 1838, 1487, 1488, 799, 1038, 113, 40, 73,
			1022, 937, 1596, 1563, 1470, 1599, 516, 1971, 146, 825,
			1164, 1567, 1358, 729, 1224, 1869, 978, 1165, 372, 1061,
			910, 487, 2004, 763, 1886, 1945, 408, 873, 174, 147,
			84, 785, 494, 1143, 1376, 469, 1990, 115, 1296, 1953,
			1246, 1281, 1660, 1541, 1842, 159, 1752, 963, 438, 971,
			1796, 407, 1674, 1115, 840, 65, 758, 657, 336, 1323,
			30, 1871, 316, 1941, 2046, 119, 168, 185, 234, 827,
			1464, 439, 574, 485, 628, 1889, 2042, 1597, 412, 541,
			34, 381, 1700, 745, 478, 457, 732, 525, 1130, 521,
			128, 437, 578, 1309, 560, 1349, 1042, 2041, 496, 335,
			1594, 1951, 592, 1009, 302, 1859, 1712, 2013, 1706, 1477,
			1400, 1535, 1650, 817, 200, 1217, 1702, 995, 416, 1461,
			1478, 427, 940, 1387, 1614, 205, 1156, 1295, 1474, 1017,
			1580, 211, 902, 667, 1676, 829, 1002, 1635, 1264, 947,
			714, 1, 1048, 1097, 590, 905, 1728, 1833, 214, 1453,
			1308, 295, 1338, 1049, 1868, 1801, 1242, 275, 420, 839,
			158, 911, 1668, 1935, 1294, 879, 116, 1075, 650, 1883,
			576, 123, 2038, 405, 696, 593, 946, 1393, 1412, 391,
			1506, 771, 124, 1445, 1054, 1005, 1784, 1451, 1046, 661,
			1836, 303, 82, 247, 508, 1559, 1386, 955, 1916, 1345,
			1018, 1993, 352, 1333, 1430, 711, 540, 1673, 718, 1125,
			684, 633, 338, 801, 1312, 1383, 1062, 1625, 600, 173,
			1306, 1111, 332, 1751, 1442, 1145, 1656, 117, 1750, 1149,
			960, 957, 926, 447, 664, 479, 1690, 895, 60, 607,
			834, 1249, 1072, 781, 238, 1141, 620, 1589, 950, 1743,
			452, 1055, 314, 369, 876, 1771, 818, 1193, 1064, 1819,
			586, 1855, 1012, 2037, 1090, 1081, 1532, 1823, 358, 1867,
			1628, 263, 1542, 1421, 1124, 1317, 190, 743, 260, 1019,
			134, 627, 1484, 1129, 1714, 403, 928, 1041, 1686, 1399,
			988, 725, 1694, 371, 1764, 2045, 474, 1537, 1908, 1797,
			1286, 415, 44, 1219, 1774, 1227, 140, 1099, 502, 1371,
			1552, 321, 410, 913, 2024, 1579, 1862, 721, 1344, 463,
			1974, 375, 984, 1931, 642, 1687, 1964, 695, 1790, 741,
			1228, 1083, 166, 1853, 1568, 155, 210, 637, 380, 1001,
			1170, 713, 1652, 11, 1634, 777, 1884, 693, 1254, 1565,
			1760, 1605, 350, 1235, 1928, 591, 486, 417, 1828, 1265,
			982, 261, 1280, 919, 634, 1733, 1960, 1791, 882, 1073,
			836, 1473, 1150, 1251, 1872, 1717, 1778, 683, 1092, 1643,
			606, 461, 1004, 1551, 42, 1691, 276, 467, 1114, 923,
			456, 1085, 334, 1891, 1336, 1637, 310, 1415, 1096, 1353,
			22, 1961, 208, 1795, 1854, 1709, 320, 551, 1402, 1305,
			220, 227, 386, 531, 1800, 1095, 1678, 1167, 1840, 1297,
			842, 1135, 1892, 823, 1930, 1245, 1880, 379, 1086, 83,
			1268, 849, 934, 1649, 8, 647, 1034, 1027, 828, 1701,
			1142, 1261, 2028, 1707, 1186, 917, 1232, 559, 1078, 1373,
			744, 1815, 942, 2011, 32, 1601, 894, 1443, 288, 243,
			1762, 967, 944, 1929, 1274, 1319, 1024, 1959, 1414, 1057,
			76, 1639, 1914, 1881, 908, 499, 366, 1367, 156, 2007,
			1366, 1401, 2036, 373, 1158, 1405, 1904, 1213, 222, 703,
			236, 735, 1026, 1151, 1844, 1919, 1510, 1505, 776, 1037,
			2006, 1397, 2020, 1845, 1562, 1999, 2000, 1311, 1550, 1493,
			1212, 2027, 1534, 795, 400, 1693, 1982, 577, 1028, 1583,
			1734, 1337, 160, 1313, 1870, 333, 1736, 519, 974, 1065,
			884, 1573, 1422, 999, 624, 1275, 1210, 883, 920, 167,
			1970, 659, 792, 143, 1006, 1655, 1888, 981, 1106, 153,
			1932, 951, 1758, 1793, 2008, 319, 1518, 671, 1956, 1475,
			46, 1483, 608, 1355, 1894, 129, 1060, 63, 1270, 1169,
			308, 1835, 1234, 977, 144, 719, 682, 1713, 1948, 1933,
			746, 1943, 1976, 253, 450, 997, 1140, 1339, 866, 759,
			1468, 1271, 546, 1447, 1152, 1257, 990, 1389, 1244, 1767,
			1642, 1033, 1428, 949, 498, 1821, 148, 1177, 1554, 1491,
			1008, 847, 1622, 673, 852, 1521, 1866, 517, 1500, 1175,
			1798, 1989, 1300, 2047, 282, 1329, 1756, 191, 434, 1507,
			1688, 1973, 1010, 939, 1452, 1899, 698, 1259, 56, 1807,
			1986, 1947, 424, 723, 1782, 1179, 904, 861, 1514, 1375,
			1776, 1893, 1226, 1671, 1588, 1609, 1102, 1923, 300, 709,
			2026, 1965, 1820, 807, 1850, 1561, 1864, 483, 1754, 787,
			932, 1351, 1630, 1423, 2016, 1553, 1806, 53, 1940, 1079,
			1162, 1501, 1088, 1471, 706, 339, 1876, 1105, 1458, 1905,
			1924, 903, 2018, 1283, 1188, 1957, 1566, 1517, 1604, 1963,
			1558, 1173, 1704, 1489, 594, 1629, 1364, 601, 1946, 349,
			1592, 1857, 1846, 1699, 1548, 25, 1942, 1223, 1640, 355,
			1214, 1575, 700, 1385, 1918, 679, 1824, 1895, 1746, 1587,
			284, 755, 1818, 1623, 844, 281, 1954, 1657, 964, 1107,
			1310, 1661, 228, 1469, 1438, 959, 1176, 991, 1334, 1407,
			572, 1153, 1346, 1761, 1584, 1293, 750, 1653, 1132, 1391,
			1462, 1873, 312, 2029, 826, 1749, 1388, 237, 1330, 1051,
			1576, 1949, 1098, 833, 1524, 1839, 1602, 1593, 2044, 1569,
			870, 589, 304, 775, 1426, 1321, 1636, 1829, 702, 1255,
			772, 1531, 646, 1139, 1996, 235, 1902, 915, 1440, 85,
			1250, 1911, 1076, 1237, 86, 1851, 1472, 1207, 482, 1499,
			1168, 575, 170, 1769, 556, 1731, 730, 1739, 1648, 1611,
			1014, 385, 188, 1455, 922, 1425, 500, 1581, 1490, 1233,
			1856, 975, 1922, 1969, 1496, 327, 1154, 1753, 564, 509,
			1450, 1253, 1740, 1595, 1418, 1015, 1036, 1527, 722, 1703,
			892, 1513, 1682, 1645, 1936, 2023, 1118, 1289, 1432, 1205,
			1766, 727, 972, 1433, 1822, 1747, 1556, 1103, 854, 929,
			1792, 1621, 1494, 773, 1716, 1431, 1278, 511, 1204, 257,
			1394, 1585, 1348, 1211, 1950, 1763, 764, 1519, 1710, 1195,
			1788, 1133, 98, 1515, 1516, 145, 554, 797, 788, 1053,
			1626, 1435, 1128, 1117, 1218, 1631, 1848, 1439, 1698, 1927,
			1608, 1865, 1066, 1861, 720, 965, 1606, 359, 900, 1063,
			14, 1817, 1180, 739, 1826, 1043, 916, 1607, 1530, 1679,
			404, 1809, 1174, 1365, 1708, 1335, 1126, 1757, 548, 1727,
			1598, 1897, 1780, 835, 1446, 843, 1112, 1159, 1546, 1539,
			1340, 1503, 1654, 1773, 616, 685, 1726, 1429, 1744, 1745,
			1590, 1885, 1256, 857, 1454, 605, 824, 539, 1406, 1955,
			800, 1109, 734, 1479, 1456, 611, 1786, 1831, 1536, 1641,
			1926, 935, 264, 809, 662, 1843, 1420, 1011, 1906, 1879,
			668, 537, 1878, 1913, 1808, 1363, 1670, 1917, 1436, 1725,
			1738, 1215, 748, 1755, 1538, 1663, 848, 1409, 2022, 2017,
			1288, 1549, 1314, 1909, 704, 1647, 1718, 299, 1404, 423,
			1998, 2005, 1724, 493, 1222, 1307, 152, 855, 1898, 1089,
			632, 1457, 1874, 1849, 980, 1825, 1978, 845, 1620, 1031,
			1486, 1577, 1276, 383, 1934, 1511, 1136, 1191, 1722, 1395,
			1624, 885, 1134, 583, 1304, 1113, 1146, 1465,
			
			672, 625, 458, 751, 272, 757, 218, 1247, 636, 557,
			402, 1403, 976, 635, 898, 255, 192, 985, 178, 91,
			1748, 1181, 298, 1481, 440, 523, 1574, 815, 248, 1291,
			246, 441, 948, 1171, 582, 189, 1184, 1273, 490, 23,
			344, 409, 1202, 411, 728, 215, 286, 55, 460, 927,
			1290, 675, 712, 1161, 414, 365, 104, 641, 106, 79,
			348, 325, 626, 501, 1052, 1327, 738, 1013, 1020, 715,
			538, 1069, 1732, 97, 962, 421, 376, 165, 830, 925,
			596, 193, 242, 901, 1672, 221, 454, 1675, 1200, 969,
			354, 329, 132, 77, 786, 979, 292, 789, 1810, 765,
			1504, 503, 726, 87, 1032, 1781, 226, 475, 24, 279,
			790, 99, 708, 9, 1058, 139, 520, 1381, 998, 429,
			1192, 707, 694, 341, 1408, 107, 678, 459, 780, 717,
			306, 1777, 912, 51, 1378, 1121, 1196, 1021, 846, 1361,
			96, 1325, 686, 663, 808, 1995, 886, 453, 736, 389,
			938, 229, 1852, 651, 58, 305, 812, 689, 142, 1555,
			1208, 1299, 362, 1341, 1804, 1449, 1814, 1203, 588, 309,
			986, 157, 1368, 343, 342, 101, 552, 595, 534, 1787,
			1444, 1677, 38, 491, 804, 41, 318, 131, 1120, 465,
			418, 629, 864, 431, 862, 1331, 1068, 239, 258, 1987,
			324, 225, 1966, 863, 1016, 1377, 958, 133, 1544, 413,
			1318, 5, 232, 1267, 1258, 779, 544, 31, 778, 75,
			1236, 547, 6, 169, 1772, 1155, 518, 831, 880, 631,
			2030, 1783, 1508, 1509, 814, 1459, 604, 1101, 1962, 397,
			1160, 293, 1230, 267, 484, 893, 394, 127, 1104, 105,
			1322, 1131, 1000, 17, 1586, 881, 1560, 1721, 670, 1007,
			1816, 1185, 1398, 513, 1384, 813, 262, 1659, 180, 891,
			26, 197, 1044, 1241, 1342, 347, 528, 1437, 514, 1737,
			724, 555, 838, 1071, 648, 1547, 270, 697, 1692, 1427,
			346, 59, 176, 1529, 1502, 1315, 204, 665, 110, 1467,
			1476, 471, 290, 311, 568, 1183, 326, 931, 0, 1417,
			598, 621, 860, 897, 230, 21, 296, 581, 1382, 1463,
			992, 245, 666, 1269, 868, 241, 1582, 1091, 256, 353,
			918, 677, 936, 767, 878, 1711, 1512, 449, 126, 1157,
			1396, 477, 446, 177, 68, 1225, 906, 585, 1992, 527,
			18, 249, 444, 1045, 2, 1983, 1520, 61, 954, 867,
			100, 179, 1282, 731, 1612, 535, 610, 137, 244, 265,
			442, 395, 1832, 163, 378, 171, 740, 39, 254, 597,
			640, 363, 1618, 1877, 816, 973, 806, 111, 896, 307,
			90, 1665, 1352, 1277, 78, 1617, 1600, 43, 1482, 1775,
			660, 1485, 118, 3, 464, 645, 130, 35, 968, 907,
			162, 175, 120, 945, 710, 1811, 356, 791, 1522, 187,
			12, 1705, 850, 1287, 1980, 565, 562, 1805, 480, 599,
			1082, 357, 1572, 851, 1662, 33, 468, 615, 1354, 747,
			488, 297, 1370, 387, 20, 983, 822, 1591, 924, 687,
			102, 89, 680, 495, 10, 1413, 360, 481, 1362, 1119,
			1260, 1633, 374, 1759, 676, 669, 558, 67, 1220, 1523,
			1326, 1035, 1972, 287, 526, 331, 820, 803, 510, 425,
			1084, 1411, 1858, 1087, 4, 2009, 462, 2039, 652, 1765,
			114, 217, 268, 1357, 466, 653, 656, 549, 398, 1837,
			1492, 251, 1374, 69, 1380, 361, 1434, 15, 240, 273,
			1498, 1981, 1540, 1977, 970, 1263, 784, 1441, 50, 769,
			1148, 1029, 914, 1915, 436, 1147, 1410, 1903, 1284, 1497,
			690, 603, 328, 27, 810, 7, 252, 811, 74, 1359,
			760, 49, 1666, 953, 1460, 1683, 1094, 315, 952, 1785,
			62, 1571, 856, 921, 422, 1723, 1240, 29, 798, 567,
			224, 233, 1802, 1187, 1968, 13, 618, 877, 492, 1651,
			66, 277, 48, 837, 1138, 1719, 1564, 2003, 150, 1525,
			80, 497, 1050, 1347, 1812, 609, 1194, 933, 888, 1023,
			1638, 1967, 1108, 705, 754, 195, 396, 733, 966, 433,
			136, 1681, 278, 841, 644, 783, 1298, 505, 1984, 1301,
			390, 1729, 1696, 317, 186, 1123, 752, 435, 202, 987,
			536, 93, 1302, 393, 1216, 71, 1570, 941, 796, 419,
			266, 209, 1356, 109, 1206, 853, 1920, 619, 1190, 399,
			1292, 1229, 782, 367, 1424, 563, 1890, 1921, 64, 1533,
			1526, 207, 184, 81, 1198, 2031, 1320, 1741, 994, 259,
			388, 2019, 542, 291, 1272, 1163, 570, 1619, 1324, 1201,
			654, 57, 1720, 1047, 874, 443, 196, 45, 506, 1543,
			1100, 821, 1658, 199, 28, 1735, 206, 613, 172, 121,
			250, 289, 216, 871, 550, 1003, 88, 553, 794, 643,
			1632, 1239, 930, 1847, 1144, 943, 1238, 345, 448, 445,
			770, 1669, 504, 737, 1178, 37, 1528, 95, 322, 2015,
			1684, 1841, 1830, 323, 108, 1779, 1770, 1231, 1056, 543,
			1938, 587, 364, 1059, 1610, 681, 384, 1667, 426, 1343,
			212, 1715, 2010, 569, 1616, 2021, 370, 473, 1116, 1613,
			1030, 909, 612, 805, 1742, 231, 996, 507, 1578, 1689,
			52, 617, 1958, 271, 1860, 529, 294, 887, 476, 213,
			1182, 181, 1252, 1697, 1910, 1025, 1896, 1285, 774, 161,
			692, 2025, 1262, 2033, 392, 151, 194, 859, 1040, 283,
			54, 401, 1900, 1067, 1350, 1615, 832, 1685, 70, 1209,
			472, 1939, 858, 571, 688, 183, 406, 1827, 716, 1887,
			622, 1979, 1988, 285, 802, 125, 1080, 489, 658, 201,
			36, 269, 1110, 1863, 1372, 1907, 742, 533, 1248, 1093,
			138, 1975, 1416, 1813, 430, 1695, 1316, 753, 470, 1603,
			768, 865, 122, 1221, 1448, 1279, 1390, 561, 2040, 961,
			638, 451, 1360, 989, 1266, 2001, 580, 1937, 94, 135,
			1664, 1039, 530, 761, 956, 1557, 1646, 1985, 340, 573,
			1466, 1379, 92, 691, 1794, 1243, 584, 219, 1122, 649,
			756, 141, 1730, 1197, 428, 1901, 890, 793, 280, 1545,
			766, 19, 164, 875, 1166, 655, 1328, 203, 330, 623,
			1944, 819, 602, 1627, 2032, 1789, 274, 149, 1768, 337,
			1994, 1137, 1172, 1997, 630, 515, 1680, 1189, 182, 749,
			1480, 1419, 674, 1875, 16, 47, 566, 313, 1644, 1303,
			2034, 699, 524, 301, 382, 1799, 1912, 1077, 1074, 455,
			432, 1991, 762, 869, 512, 377, 1834, 545, 72, 1127,
			2002, 1369, 1952, 103, 1882, 899, 532, 1495, 154, 889,
			368, 1199, 614, 2043, 1392, 701, 522, 1925, 872, 223,
			198, 639, 1332, 351, 2014, 993, 112, 1803, 1070, 579,
			2012, 2035, 1838, 1487, 1488, 799, 1038, 113, 40, 73,
			1022, 937, 1596, 1563, 1470, 1599, 516, 1971, 146, 825,
			1164, 1567, 1358, 729, 1224, 1869, 978, 1165, 372, 1061,
			910, 487, 2004, 763, 1886, 1945, 408, 873, 174, 147,
			84, 785, 494, 1143, 1376, 469, 1990, 115, 1296, 1953,
			1246, 1281, 1660, 1541, 1842, 159, 1752, 963, 438, 971,
			1796, 407, 1674, 1115, 840, 65, 758, 657, 336, 1323,
			30, 1871, 316, 1941, 2046, 119, 168, 185, 234, 827,
			1464, 439, 574, 485, 628, 1889, 2042, 1597, 412, 541,
			34, 381, 1700, 745, 478, 457, 732, 525, 1130, 521,
			128, 437, 578, 1309, 560, 1349, 1042, 2041, 496, 335,
			1594, 1951, 592, 1009, 302, 1859, 1712, 2013, 1706, 1477,
			1400, 1535, 1650, 817, 200, 1217, 1702, 995, 416, 1461,
			1478, 427, 940, 1387, 1614, 205, 1156, 1295, 1474, 1017,
			1580, 211, 902, 667, 1676, 829, 1002, 1635, 1264, 947,
			714, 1, 1048, 1097, 590, 905, 1728, 1833, 214, 1453,
			1308, 295, 1338, 1049, 1868, 1801, 1242, 275, 420, 839,
			158, 911, 1668, 1935, 1294, 879, 116, 1075, 650, 1883,
			576, 123, 2038, 405, 696, 593, 946, 1393, 1412, 391,
			1506, 771, 124, 1445, 1054, 1005, 1784, 1451, 1046, 661,
			1836, 303, 82, 247, 508, 1559, 1386, 955, 1916, 1345,
			1018, 1993, 352, 1333, 1430, 711, 540, 1673, 718, 1125,
			684, 633, 338, 801, 1312, 1383, 1062, 1625, 600, 173,
			1306, 1111, 332, 1751, 1442, 1145, 1656, 117, 1750, 1149,
			960, 957, 926, 447, 664, 479, 1690, 895, 60, 607,
			834, 1249, 1072, 781, 238, 1141, 620, 1589, 950, 1743,
			452, 1055, 314, 369, 876, 1771, 818, 1193, 1064, 1819,
			586, 1855, 1012, 2037, 1090, 1081, 1532, 1823, 358, 1867,
			1628, 263, 1542, 1421, 1124, 1317, 190, 743, 260, 1019,
			134, 627, 1484, 1129, 1714, 403, 928, 1041, 1686, 1399,
			988, 725, 1694, 371, 1764, 2045, 474, 1537, 1908, 1797,
			1286, 415, 44, 1219, 1774, 1227, 140, 1099, 502, 1371,
			1552, 321, 410, 913, 2024, 1579, 1862, 721, 1344, 463,
			1974, 375, 984, 1931, 642, 1687, 1964, 695, 1790, 741,
			1228, 1083, 166, 1853, 1568, 155, 210, 637, 380, 1001,
			1170, 713, 1652, 11, 1634, 777, 1884, 693, 1254, 1565,
			1760, 1605, 350, 1235, 1928, 591, 486, 417, 1828, 1265,
			982, 261, 1280, 919, 634, 1733, 1960, 1791, 882, 1073,
			836, 1473, 1150, 1251, 1872, 1717, 1778, 683, 1092, 1643,
			606, 461, 1004, 1551, 42, 1691, 276, 467, 1114, 923,
			456, 1085, 334, 1891, 1336, 1637, 310, 1415, 1096, 1353,
			22, 1961, 208, 1795, 1854, 1709, 320, 551, 1402, 1305,
			220, 227, 386, 531, 1800, 1095, 1678, 1167, 1840, 1297,
			842, 1135, 1892, 823, 1930, 1245, 1880, 379, 1086, 83,
			1268, 849, 934, 1649, 8, 647, 1034, 1027, 828, 1701,
			1142, 1261, 2028, 1707, 1186, 917, 1232, 559, 1078, 1373,
			744, 1815, 942, 2011, 32, 1601, 894, 1443, 288, 243,
			1762, 967, 944, 1929, 1274, 1319, 1024, 1959, 1414, 1057,
			76, 1639, 1914, 1881, 908, 499, 366, 1367, 156, 2007,
			1366, 1401, 2036, 373, 1158, 1405, 1904, 1213, 222, 703,
			236, 735, 1026, 1151, 1844, 1919, 1510, 1505, 776, 1037,
			2006, 1397, 2020, 1845, 1562, 1999, 2000, 1311, 1550, 1493,
			1212, 2027, 1534, 795, 400, 1693, 1982, 577, 1028, 1583,
			1734, 1337, 160, 1313, 1870, 333, 1736, 519, 974, 1065,
			884, 1573, 1422, 999, 624, 1275, 1210, 883, 920, 167,
			1970, 659, 792, 143, 1006, 1655, 1888, 981, 1106, 153,
			1932, 951, 1758, 1793, 2008, 319, 1518, 671, 1956, 1475,
			46, 1483, 608, 1355, 1894, 129, 1060, 63, 1270, 1169,
			308, 1835, 1234, 977, 144, 719, 682, 1713, 1948, 1933,
			746, 1943, 1976, 253, 450, 997, 1140, 1339, 866, 759,
			1468, 1271, 546, 1447, 1152, 1257, 990, 1389, 1244, 1767,
			1642, 1033, 1428, 949, 498, 1821, 148, 1177, 1554, 1491,
			1008, 847, 1622, 673, 852, 1521, 1866, 517, 1500, 1175,
			1798, 1989, 1300, 2047, 282, 1329, 1756, 191, 434, 1507,
			1688, 1973, 1010, 939, 1452, 1899, 698, 1259, 56, 1807,
			1986, 1947, 424, 723, 1782, 1179, 904, 861, 1514, 1375,
			1776, 1893, 1226, 1671, 1588, 1609, 1102, 1923, 300, 709,
			2026, 1965, 1820, 807, 1850, 1561, 1864, 483, 1754, 787,
			932, 1351, 1630, 1423, 2016, 1553, 1806, 53, 1940, 1079,
			1162, 1501, 1088, 1471, 706, 339, 1876, 1105, 1458, 1905,
			1924, 903, 2018, 1283, 1188, 1957, 1566, 1517, 1604, 1963,
			1558, 1173, 1704, 1489, 594, 1629, 1364, 601, 1946, 349,
			1592, 1857, 1846, 1699, 1548, 25, 1942, 1223, 1640, 355,
			1214, 1575, 700, 1385, 1918, 679, 1824, 1895, 1746, 1587,
			284, 755, 1818, 1623, 844, 281, 1954, 1657, 964, 1107,
			1310, 1661, 228, 1469, 1438, 959, 1176, 991, 1334, 1407,
			572, 1153, 1346, 1761, 1584, 1293, 750, 1653, 1132, 1391,
			1462, 1873, 312, 2029, 826, 1749, 1388, 237, 1330, 1051,
			1576, 1949, 1098, 833, 1524, 1839, 1602, 1593, 2044, 1569,
			870, 589, 304, 775, 1426, 1321, 1636, 1829, 702, 1255,
			772, 1531, 646, 1139, 1996, 235, 1902, 915, 1440, 85,
			1250, 1911, 1076, 1237, 86, 1851, 1472, 1207, 482, 1499,
			1168, 575, 170, 1769, 556, 1731, 730, 1739, 1648, 1611,
			1014, 385, 188, 1455, 922, 1425, 500, 1581, 1490, 1233,
			1856, 975, 1922, 1969, 1496, 327, 1154, 1753, 564, 509,
			1450, 1253, 1740, 1595, 1418, 1015, 1036, 1527, 722, 1703,
			892, 1513, 1682, 1645, 1936, 2023, 1118, 1289, 1432, 1205,
			1766, 727, 972, 1433, 1822, 1747, 1556, 1103, 854, 929,
			1792, 1621, 1494, 773, 1716, 1431, 1278, 511, 1204, 257,
			1394, 1585, 1348, 1211, 1950, 1763, 764, 1519, 1710, 1195,
			1788, 1133, 98, 1515, 1516, 145, 554, 797, 788, 1053,
			1626, 1435, 1128, 1117, 1218, 1631, 1848, 1439, 1698, 1927,
			1608, 1865, 1066, 1861, 720, 965, 1606, 359, 900, 1063,
			14, 1817, 1180, 739, 1826, 1043, 916, 1607, 1530, 1679,
			404, 1809, 1174, 1365, 1708, 1335, 1126, 1757, 548, 1727,
			1598, 1897, 1780, 835, 1446, 843, 1112, 1159, 1546, 1539,
			1340, 1503, 1654, 1773, 616, 685, 1726, 1429, 1744, 1745,
			1590, 1885, 1256, 857, 1454, 605, 824, 539, 1406, 1955,
			800, 1109, 734, 1479, 1456, 611, 1786, 1831, 1536, 1641,
			1926, 935, 264, 809, 662, 1843, 1420, 1011, 1906, 1879,
			668, 537, 1878, 1913, 1808, 1363, 1670, 1917, 1436, 1725,
			1738, 1215, 748, 1755, 1538, 1663, 848, 1409, 2022, 2017,
			1288, 1549, 1314, 1909, 704, 1647, 1718, 299, 1404, 423,
			1998, 2005, 1724, 493, 1222, 1307, 152, 855, 1898, 1089,
			632, 1457, 1874, 1849, 980, 1825, 1978, 845, 1620, 1031,
			1486, 1577, 1276, 383, 1934, 1511, 1136, 1191, 1722, 1395,
			1624, 885, 1134, 583, 1304, 1113, 1146, 1465
	};
	
	
	/**
	 * _e[u <br>
	 * static random table.
	 */
	private float[] m_RandomTable = new float[  ]
	{
			0.4729110505f, 0.7385413474f, 0.008484064601f, 0.4097665274f, 0.1010872573f,
			0.7390367086f, 0.549525925f, 0.1123771411f, 0.03298647143f, 0.2784920796f,
			0.500902283f, 0.8447555364f, 0.1813803948f, 0.6738673183f, 0.4701518388f,
			0.9616919239f, 0.7217741888f, 0.6537510059f, 0.3652054435f, 0.06291822577f,
			0.4318840131f, 0.2090684543f, 0.1410902003f, 0.6377613959f, 0.2596301902f,
			0.4144928395f, 0.1657741917f, 0.7586248652f, 0.5258959942f, 0.5018094587f,
			0.8614018308f, 0.354548112f, 0.6683020648f, 0.9664831138f, 0.7771698376f,
			0.09609435732f, 0.9322464466f, 0.9886786188f, 0.750093841f, 0.422816385f,
			0.9154602531f, 0.9499844327f, 0.309915605f, 0.7445504875f, 0.3723289557f,
			0.3270894173f, 0.9844008805f, 0.3477885355f, 0.1842292976f, 0.7436627201f,
			0.6612778818f, 0.03837817395f, 0.9021318331f, 0.4616867821f, 0.6630663881f,
			0.05180114182f, 0.7677190918f, 0.09349347046f, 0.6910474701f, 0.2622797177f,
			0.6192693673f, 0.8157533365f, 0.2946238415f, 0.2219612901f, 0.5885561313f,
			0.8666679985f, 0.02232083585f, 0.06143105263f, 0.9950130731f, 0.6076156492f,
			0.9106780076f, 0.7828028244f, 0.343414763f, 0.9304996892f, 0.4672813592f,
			0.9766379953f, 0.8313229419f, 0.2920504841f, 0.8041861923f, 0.4939425965f,
			0.2725484353f, 0.1563302479f, 0.07798058446f, 0.1044924953f, 0.8428786919f,
			0.1266910504f, 0.8927394906f, 0.672736716f, 0.5543209482f, 0.5484359502f,
			0.8221194698f, 0.8825288848f, 0.8641110174f, 0.8634332526f, 0.7068440365f,
			0.04193680035f, 0.3247377034f, 0.4979338921f, 0.8838296374f, 0.9993801289f,
			0.6812328398f, 0.5648419405f, 0.003202253021f, 0.7023462248f, 0.3219769541f,
			0.1616882398f, 0.5894546239f, 0.4299340756f, 0.4892705567f, 0.5455571595f,
			0.002994102426f, 0.2304763724f, 0.155921055f, 0.9662164799f, 0.9583311295f,
			0.5954897054f, 0.9740952924f, 0.4387003998f, 0.2551583359f, 0.901202884f,
			0.2026877124f, 0.2365956693f, 0.8785702689f, 0.6489133821f, 0.01945414767f,
			0.3872808474f, 0.1246737437f, 0.03542190837f, 0.1241612341f, 0.9503686852f,
			0.9078388205f, 0.8847951018f, 0.03900144994f, 0.3606016333f, 0.9058404053f,
			0.4727063519f, 0.01252377965f, 0.6164504751f, 0.699140477f, 0.2746047438f,
			0.9333300032f, 0.595666084f, 0.5605609389f, 0.1689621289f, 0.1597866099f,
			0.2790343068f, 0.05159709509f, 0.12684832f, 0.6720023379f, 0.1635839711f,
			0.08162175212f, 0.9190844116f, 0.4523213375f, 0.6464980184f, 0.5862299455f,
			0.8722242252f, 0.5005819611f, 0.6609777617f, 0.4809742915f, 0.2046138798f,
			0.3903911766f, 0.3453102685f, 0.04674096312f, 0.973779487f, 0.7726646066f,
			0.02638886822f, 0.4030162925f, 0.1663929713f, 0.7326821927f, 0.2989367857f,
			0.2252939967f, 0.9620660157f, 0.4069094844f, 0.4816838983f, 0.3628730299f,
			0.7022221317f, 0.7658345532f, 0.2317466191f, 0.5132960593f, 0.5952968546f,
			0.9690705314f, 0.5984609048f, 0.6096785674f, 0.6895160642f, 0.1989737768f,
			0.2979183882f, 0.07717857789f, 0.1445024298f, 0.3790276609f, 0.4894556361f,
			0.6148570077f, 0.3329599802f, 0.6832419839f, 0.8353465325f, 0.6591786435f,
			0.8036867999f, 0.2428180128f, 0.1249477859f, 0.1854037428f, 0.6371658486f,
			0.9563291464f, 0.2445475622f, 0.003120261244f, 0.2249839068f, 0.8096672036f,
			0.7741672429f, 0.2021667035f, 0.004328646231f, 0.6120043378f, 0.9925663075f,
			0.9051956004f, 0.1788138249f, 0.5540205762f, 0.5717003415f, 0.9831276098f,
			0.9568826077f, 0.4946469832f, 0.7418821692f, 0.8897462441f, 0.3390390114f,
			0.3825744502f, 0.2088961112f, 0.2716832208f, 0.9851574753f, 0.7187781092f,
			0.604315368f, 0.5100444397f, 0.1931205564f, 0.4663073719f, 0.7502725269f,
			0.8499265844f, 0.5200347495f, 0.3135915939f, 0.5199331953f, 0.2740743486f,
			0.07727443287f, 0.6975113638f, 0.5749227586f, 0.7769282879f, 0.03060393827f,
			0.4924854171f, 0.7609562627f, 0.1953132963f, 0.3366277465f, 0.7718231753f,
			0.442921422f, 0.2520177076f, 0.2468188074f, 0.54759291f, 0.560664752f,
			0.9685130222f, 0.6103749857f, 0.8952555321f, 0.6867308277f, 0.1030642586f,
			0.5071536307f, 0.3693140056f, 0.8673046655f, 0.7704809299f, 0.241934272f,
			0.1162283868f, 0.5276072319f, 0.8997586453f, 0.2312594396f, 0.5908464883f,
			0.2229940756f, 0.685861337f, 0.8141036094f, 0.2826001681f, 0.517007086f,
			0.6918941112f, 0.5176202734f, 0.357717244f, 0.7676293752f, 0.7579167252f,
			0.809217135f, 0.6236990318f, 0.1029932867f, 0.3726476887f, 0.8662094292f,
			0.7223135103f, 0.3677915274f, 0.6643089904f, 0.3943013684f, 0.9573541097f,
			0.3216414261f, 0.6668614494f, 0.02614571201f, 0.6634141263f, 0.8706523157f,
			0.01788069215f, 0.3312314623f, 0.5219267607f, 0.6134460415f, 0.7443237538f,
			0.9683496845f, 0.7307207827f, 0.4828805937f, 0.2924363045f, 0.0118874521f,
			0.4333418198f, 0.7647268656f, 0.4580505015f, 0.9831999172f, 0.3143892717f,
			0.2745485357f, 0.3735234654f, 0.618310506f, 0.7671188489f, 0.9740350763f,
			0.2075663814f, 0.9031892386f, 0.5395607371f, 0.8080378859f, 0.7342142267f,
			0.407859175f, 0.2654033862f, 0.04355954705f, 0.4271861212f, 0.4505809848f,
			0.7858929243f, 0.8919462091f, 0.2358863046f, 0.123365643f, 0.6689981967f,
			0.6955330963f, 0.6992957378f, 0.7100652498f, 0.8320914302f, 0.4599931403f,
			0.5540043293f, 0.5282919765f, 0.6743945219f, 0.01363873808f, 0.492633787f,
			0.7264151354f, 0.6254409533f, 0.5749266348f, 0.2289010948f, 0.06688637519f,
			0.5158033296f, 0.009415931534f, 0.5255726138f, 0.2271430013f, 0.6763365436f,
			0.5574292182f, 0.3415588094f, 0.6493394212f, 0.1721865647f, 0.3136668312f,
			0.7543996023f, 0.4701567148f, 0.07781485282f, 0.2400242365f, 0.8143903455f,
			0.5619403296f, 0.199288398f, 0.992862537f, 0.9865984255f, 0.2164159012f,
			0.150085384f, 0.3459821059f, 0.3370204894f, 0.5022331984f, 0.1866664775f,
			0.4905493441f, 0.1191302957f, 0.8275881936f, 0.710061742f, 0.9932265631f,
			0.9170671916f, 0.7391732582f, 0.8397231773f, 0.6937549929f, 0.001715213992f,
			0.4887054828f, 0.965892883f, 0.3232409148f, 0.05592281651f, 0.3982831226f,
			0.6867368482f, 0.1243949193f, 0.9251132207f, 0.5558201675f, 0.03649436496f,
			0.2549742884f, 0.5495353928f, 0.8718090379f, 0.4108930677f, 0.2556785042f,
			0.7344056452f, 0.02866140427f, 0.09607959725f, 0.3637478813f, 0.914189863f,
			0.3538771332f, 0.8073158897f, 0.9535153243f, 0.5672763558f, 0.1482913573f,
			0.1436910909f, 0.8851612112f, 0.4372893339f, 0.5006496706f, 0.3650990948f,
			0.04292140109f, 0.2172930101f, 0.1197614488f, 0.3977317084f, 0.8439983665f,
			0.8531363262f, 0.2154812948f, 0.47433744f, 0.9994254517f, 0.1221883046f,
			0.9597686087f, 0.3154959138f, 0.3081342555f, 0.6437140247f, 0.5590752834f,
			0.2581579089f, 0.7654751386f, 0.9771412248f, 0.4693115246f, 0.237701023f,
			0.7674408569f, 0.9644675283f, 0.7846397967f, 0.02975096181f, 0.6918433192f,
			0.9730582954f, 0.3313468923f, 0.658018453f, 0.6376934699f, 0.1950850999f,
			0.4980441281f, 0.3744017854f, 0.6040342967f, 0.6598548302f, 0.333445665f,
			0.1176049728f, 0.8894769638f, 0.1152794166f, 0.9429749534f, 0.8565215431f,
			0.9936900693f, 0.434736182f, 0.7154493039f, 0.7246339526f, 0.8020920283f,
			0.7055688193f, 0.4110925817f, 0.3516786247f, 0.3349965806f, 0.6554789925f,
			0.642126028f, 0.2988266144f, 0.8424614235f, 0.5730585633f, 0.7771872045f,
			0.00362989679f, 0.5260899696f, 0.3787124427f, 0.8008270641f, 0.1409832817f,
			0.6690362296f, 0.002222067676f, 0.1593351462f, 0.8063519523f, 0.4554628204f,
			0.7231995026f, 0.1241428968f, 0.4275146294f, 0.2607020973f, 0.6306821657f,
			0.7040551142f, 0.8110723607f, 0.6933704126f, 0.8581181811f, 0.6375595187f,
			0.2299729344f, 0.1706854976f, 0.7499923548f, 0.4964644485f, 0.9583009183f,
			0.308236971f, 0.6163427765f, 0.4321146798f, 0.1595833246f, 0.9054599716f,
			0.2314180462f, 0.5954353721f, 0.5348608978f, 0.8080619159f, 0.7327251257f,
			0.7620541384f, 0.6367750298f, 0.4286523811f, 0.07671781536f, 0.1937512406f,
			0.2559202984f, 0.2068261127f, 0.7073758552f, 0.2674879101f, 0.7857126314f,
			0.7899491577f, 0.5939246519f, 0.9032627926f, 0.9720230959f, 0.2158981222f,
			0.2939456301f, 0.3220465188f, 0.9538273122f, 0.8790025539f, 0.1981272092f,
			0.1650443994f, 0.001120492816f, 0.5604404504f, 0.6129064048f, 0.5055372459f,
			0.8563481066f, 0.304336892f, 0.8372510551f, 0.7845503152f, 0.08560216799f,
			0.4208157989f, 0.8898326727f, 0.2016003807f, 0.3458331507f, 0.3972548149f,
			0.04283992108f, 0.591770927f, 0.974327527f, 0.9989933143f, 0.8186827162f,
			0.3203654704f, 0.8067009319f, 0.3407435357f, 0.605836953f, 0.2263890044f,
			0.6296569519f, 0.2099548387f, 0.550079857f, 0.1461075698f, 0.1747615393f,
			0.4233810878f, 0.8773659607f, 0.0479359501f, 0.0594830513f, 0.4981011595f,
			0.3045937056f, 0.3099034918f, 0.5817479137f, 0.4182425751f, 0.6945126681f,
			0.1709480495f, 0.7742619105f, 0.7786582592f, 0.6110214116f, 0.8872880568f,
			0.6248470973f, 0.08680642163f, 0.931105963f, 0.6251227208f, 0.8690443411f,
			0.5040835659f, 0.1696689138f, 0.6209103432f, 0.2612314839f, 0.8078606217f,
			0.6734991474f, 0.6404747651f, 0.7305071317f, 0.8554722029f, 0.34063219f,
			0.2681899373f, 0.3275900688f, 0.3314089901f, 0.02135118749f, 0.05749261612f,
			0.3689842969f, 0.05896323873f, 0.257078507f, 0.07397318305f, 0.684659699f,
			0.6575774117f, 0.5134079633f, 0.8622945906f, 0.3754983284f, 0.8271459374f,
			0.5635276707f, 0.3681894322f, 0.9867563229f, 0.04052009201f, 0.1782835191f,
			0.8467851379f, 0.503791444f, 0.925466008f, 0.7791332761f, 0.2885072944f,
			0.07630624063f, 0.1173258065f, 0.2102413131f, 0.3938110904f, 0.8773568384f,
			0.8636318552f, 0.2859639572f, 0.627990887f, 0.003377353773f, 0.1619241512f,
			0.2699754676f, 0.3873179131f, 0.8214699328f, 0.7120208289f, 0.9422846371f,
			0.8077560854f, 0.6702104155f, 0.4639917924f, 0.410392019f, 0.247505954f,
			0.3202196248f, 0.04308547406f, 0.320837778f, 0.9746267726f, 0.1007502805f,
			0.8328587166f, 0.6273901677f, 0.09098669374f, 0.09853953868f, 0.9977597813f,
			0.5721246311f, 0.2237910894f, 0.3351771552f, 0.2264144807f, 0.03564352822f,
			0.01593899587f, 0.3292392753f, 0.4768654364f, 0.9126864867f, 0.9464576845f,
			0.9494378474f, 0.5050144619f, 0.6693813791f, 0.5122653567f, 0.9650356621f,
			0.4575180705f, 0.7383859241f, 0.3025119645f, 0.1997770164f, 0.3103861078f,
			0.9081699131f, 0.9967481554f, 0.6955840029f, 0.4345335099f, 0.3626880618f,
			0.8181723435f, 0.7922684234f, 0.06953518605f, 0.5276934868f, 0.473205904f,
			0.5295093283f, 0.9868340264f, 0.3799418071f, 0.1086464939f, 0.2773461808f,
			0.1236520349f, 0.3755358709f, 0.3176494972f, 0.001437645406f, 0.4688545871f,
			0.6536611067f, 0.7257875954f, 0.06933600269f, 0.9820178128f, 0.6719615003f,
			0.1884384626f, 0.004027187824f, 0.8269491042f, 0.9298061961f, 0.1307505858f,
			0.09098645486f, 0.7009107484f, 0.9356967239f, 0.06143721053f, 0.2449996658f,
			0.5407966855f, 0.07506485004f, 0.7916484107f, 0.04300020449f, 0.387512391f,
			0.5347110545f, 0.3901712843f, 0.329171516f, 0.6898078839f, 0.9401336322f,
			0.4062082735f, 0.2985652704f, 0.8288138597f, 0.8619984193f, 0.3909836099f,
			0.4654851519f, 0.1445309478f, 0.8479991453f, 0.2494278853f, 0.4228862729f,
			0.2455220944f, 0.1363584092f, 0.4531907463f, 0.7990402132f, 0.8830580707f,
			0.7072192812f, 0.6462317151f, 0.317715684f, 0.1709661051f, 0.8281775294f,
			0.6742391349f, 0.3681248166f, 0.4324316415f, 0.7502044709f, 0.5691272398f,
			0.990885077f, 0.455003222f, 0.7102104491f, 0.5198613503f, 0.6862468049f,
			0.4350504945f, 0.8964989344f, 0.3608611939f, 0.9508363772f, 0.3929253458f,
			0.5333612515f, 0.6092323498f, 0.9491649978f, 0.3400761592f, 0.7410619305f,
			0.5820758198f, 0.2261531111f, 0.9793651975f, 0.3274646839f, 0.6251257234f,
			0.8669204414f, 0.2198391105f, 0.1675490076f, 0.9839651179f, 0.01009165682f,
			0.2872025683f, 0.3270674078f, 0.3490699441f, 0.1208676584f, 0.7112450185f,
			0.5865932526f, 0.6059310962f, 0.9301124942f, 0.9714705697f, 0.5222092485f,
			0.8215046176f, 0.4457058981f, 0.08218099875f, 0.7990865419f, 0.9982400206f,
			0.9424114544f, 0.8982618838f, 0.8342044456f, 0.6269367323f, 0.3365103863f,
			0.422921862f, 0.4844607906f, 0.5696786647f, 0.8514509704f, 0.8986350126f,
			0.9164229026f, 0.3040969097f, 0.3807635754f, 0.9625363643f, 0.3139692033f,
			0.06021055998f, 0.4544913266f, 0.6475205286f, 0.5800714372f, 0.8810956539f,
			0.2153863944f, 0.5102934572f, 0.6889675232f, 0.1386322458f, 0.3111219089f,
			0.6676273248f, 0.844975031f, 0.5355796018f, 0.1087694988f, 0.02206853731f,
			0.1041952828f, 0.1252295193f, 0.137792455f, 0.4583488642f, 0.6153580798f,
			0.3798877732f, 0.1678045206f, 0.2917496967f, 0.1360570537f, 0.8394336854f,
			0.827344304f, 0.7496694303f, 0.9806256434f, 0.3712078207f, 0.1699153185f,
			0.7676439728f, 0.05590369646f, 0.5724778068f, 0.09354164638f, 0.8810703768f,
			0.1411446957f, 0.3467322798f, 0.02008922771f, 0.4938835981f, 0.06831361074f,
			0.1850529541f, 0.7406027745f, 0.3054363779f, 0.9590253746f, 0.1838148185f,
			0.83290831f, 0.1768322508f, 0.1743739853f, 0.3299644557f, 0.5577313323f,
			0.2179616778f, 0.1339022322f, 0.085126488f, 0.6395806037f, 0.376491304f,
			0.6599620478f, 0.7997881477f, 0.8386475649f, 0.3100563413f, 0.003715484403f,
			0.9888119721f, 0.7199713737f, 0.8229060764f, 0.2090263152f, 0.9995266241f,
			0.5261195693f, 0.6482525035f, 0.9704922615f, 0.1036458374f, 0.5596343614f,
			0.857572082f, 0.6418678435f, 0.5442654868f, 0.9814945441f, 0.6781106195f,
			0.5511278575f, 0.5691887834f, 0.4318430349f, 0.9998412798f, 0.2784214774f,
			0.9818295953f, 0.3792300392f, 0.3531257152f, 0.05316698086f, 0.2409438924f,
			0.6046218388f, 0.6383283245f, 0.9265371012f, 0.6404393171f, 0.7264252063f,
			0.3886336363f, 0.8755850038f, 0.6005128794f, 0.1727774441f, 0.847316816f,
			0.4952608878f, 0.6013667774f, 0.5073520485f, 0.6407172992f, 0.4345692126f,
			0.7907523424f, 0.5149299987f, 0.3281655493f, 0.2331165494f, 0.7965921094f,
			0.9529866707f, 0.6101129404f, 0.7143000579f, 0.7759300121f, 0.3755443767f,
			0.475714765f, 0.5913865874f, 0.2314597038f, 0.935540529f, 0.07111636689f,
			0.442732404f, 0.626881002f, 0.571961429f, 0.5696923989f, 0.7123935418f,
			0.3323344593f, 0.4879916813f, 0.8254892058f, 0.8923767796f, 0.9311640584f,
			0.326429233f, 0.09112033201f, 0.5427812422f, 0.4192580325f, 0.9486160371f,
			0.5813651546f, 0.3060806273f, 0.3282178105f, 0.2231343426f, 0.1637206408f,
			0.5717960568f, 0.3036050876f, 0.7305186074f, 0.9571562312f, 0.9478095537f,
			0.1695170202f, 0.7902330384f, 0.120321847f, 0.1945681432f, 0.01073954673f,
			0.7161647547f, 0.6104590236f, 0.7784285797f, 0.3037288324f, 0.7068825774f,
			0.1942651677f, 0.7003926979f, 0.6276708399f, 0.2769114431f, 0.4919609404f,
			0.75648339f, 0.9868690246f, 0.6352724433f, 0.3358107652f, 0.8860112065f,
			0.2757101548f, 0.9175384883f, 0.2243464603f, 0.7639815835f, 0.9174582572f,
			0.6776555963f, 0.1535439971f, 0.2938926937f, 0.208126687f, 0.5457798075f,
			0.6062033824f, 0.1571739232f, 0.3966783234f, 0.4583797231f, 0.9807816665f,
			0.07551497314f, 0.03280388983f, 0.3668546695f, 0.240929076f, 0.9423355861f,
			0.6135283993f, 0.8309184872f, 0.06697827158f, 0.4796458976f, 0.05989572452f,
			0.4029989447f, 0.2906367308f, 0.5765474131f, 0.05498129362f, 0.2099027783f,
			0.894132256f, 0.965624609f, 0.7744829101f, 0.6379963551f, 0.355061607f,
			0.3934771596f, 0.04113969812f, 0.5281519629f, 0.6181922588f, 0.9416427882f,
			0.4342291732f, 0.786709724f, 0.4754672847f, 0.6541607445f, 0.3853924372f,
			0.8187051341f, 0.635463364f, 0.1280259052f, 0.7920374987f, 0.6896122266f,
			0.2635519146f, 0.2227835013f, 0.1795707182f, 0.4218523614f, 0.2740133512f,
			0.545514469f, 0.9437063788f, 0.3323186394f, 0.1553544677f, 0.8674614271f,
			0.7041043811f, 0.817165941f, 0.6100789453f, 0.1285452778f, 0.3005860639f,
			0.4901165906f, 0.7901609852f, 0.1860224335f, 0.463178149f, 0.08053164557f,
			0.4094720664f, 0.9635326685f, 0.687234812f, 0.9974978101f, 0.5144108287f,
			0.1567875957f, 0.3448878773f, 0.9661799744f, 0.1939860801f, 0.1521497676f,
			0.5640751389f, 0.6426893789f, 0.0106029301f, 0.3143524034f, 0.9063968048f,
			0.6137174033f, 0.4328020471f, 0.2996097403f, 0.3750500684f, 0.6871849801f,
			0.05120204156f, 0.5503680101f, 0.7840918028f, 0.8801576346f, 0.8588949735f,
			0.6279470408f, 0.02027938189f, 0.0102761481f, 0.3775449856f, 0.5393224834f,
			0.2287396253f, 0.2969528474f, 0.9104400608f, 0.7142986627f, 0.4537158688f,
			0.8785835188f, 0.7037469051f, 0.7893220549f, 0.7656431594f, 0.6520249471f,
			0.2972189556f, 0.8541853884f, 0.4058015761f, 0.3405880798f, 0.8456075131f,
			0.3178723706f, 0.9797976748f, 0.1967968158f, 0.692026f, 0.04979303945f,
			0.2311240588f, 0.2461624201f, 0.9745173431f, 0.9526597401f, 0.4260470741f,
			0.4782235622f, 0.5470744814f, 0.6232537264f, 0.8810726297f, 0.8911019806f,
			0.9963639989f, 0.2573323874f, 0.6642401428f, 0.7958237715f, 0.03540288238f,
			0.4549270989f, 0.001494609285f, 0.2866563033f, 0.05543840444f, 0.08228170034f,
			0.419386799f, 0.2837107554f, 0.117281131f, 0.8466815958f, 0.1553515759f,
			0.05406028219f, 0.1633410542f, 0.740423481f, 0.8668143437f, 0.6176238023f,
			0.7316168505f, 0.01017569471f, 0.1703756158f, 0.9440654125f, 0.9528882629f,
			0.8079791954f, 0.04232371086f, 0.346959427f, 0.1123616095f, 0.1801391626f,
			0.611725573f, 0.9814710412f, 0.5570184155f, 0.5502572237f, 0.377345717f,
			0.851802621f, 0.2299171719f, 0.3526543053f, 0.3796432992f, 0.2346556168f,
			0.6126982174f, 0.97243411f, 0.3590973117f, 0.9249581024f, 0.3575417469f,
			0.6484372178f, 0.432109904f, 0.2101079393f, 0.3898289441f, 0.4953358127f,
			0.3157378272f, 0.9789815657f, 0.7627562392f, 0.3011190342f, 0.632502005f,
			0.8719584104f, 0.04515269166f, 0.256218954f, 0.3265252286f, 0.878210932f,
			0.5237504984f, 0.2705271775f, 0.7222479773f, 0.2865102831f, 0.001158626284f,
			0.03455207031f, 0.2569723637f, 0.3957975991f, 0.4707895699f, 0.4809666099f,
			0.418484204f, 0.8917709123f, 0.4499892346f, 0.8027968621f, 0.9190032133f,
			0.2957376912f, 0.252619944f, 0.6845010826f, 0.636711326f, 0.3919830043f,
			0.9823465734f, 0.9021894438f, 0.3561091409f, 0.0399033092f, 0.5278758067f,
			0.949234386f, 0.8384504919f, 0.2771558668f, 0.3413985199f, 0.8435215941f,
			0.2535051429f, 0.1200737804f, 0.2814852889f, 0.7725915993f, 0.5038996083f,
			0.9675966594f, 0.3016850217f, 0.7329220055f, 0.4732860983f, 0.01496690884f,
			0.2660767171f, 0.8196003409f, 0.7295895894f, 0.583441643f, 0.6730243466f,
			0.3226375347f, 0.7145830193f, 0.772270225f, 0.568384863f, 0.2861720184f,
			0.9510406074f, 0.3391874302f, 0.4294193326f, 0.6868144525f, 0.2987193004f,
			0.2156722359f, 0.3006571936f, 0.8873830782f, 0.7904183422f, 0.5632222351f,
			0.9629636384f, 0.5222796937f, 0.07936696941f, 0.7768936753f, 0.4170601214f,
			0.470756256f, 0.02919023158f, 0.3423571233f, 0.4627479925f, 0.07432210725f,
			0.4777029366f, 0.9527187534f, 0.655085254f, 0.2545418264f, 0.705781721f,
			0.7913572621f, 0.4187664441f, 0.687473706f, 0.6425652453f, 0.3870264068f,
			0.6019556443f, 0.6909988532f, 0.338232514f, 0.9474731702f, 0.2508226126f,
			0.9812909169f, 0.7356093214f, 0.577821549f, 0.8860320407f, 0.9546764391f,
			0.2718528216f, 0.2899719682f, 0.06243593758f, 0.6511358311f, 0.3414642238f,
			0.2092663199f, 0.4932191367f, 0.05569497589f, 0.1518796128f, 0.8846686278f,
			0.5197479292f, 0.8939574538f, 0.002888894174f, 0.1087113358f, 0.2083718213f,
			0.5780273946f, 0.5211328645f, 0.1534572225f, 0.8554284177f, 0.459072954f,
			0.880928407f, 0.8287269399f, 0.1817014287f, 0.04278041515f, 0.5426718113f,
			0.2688421775f, 0.9975818037f, 0.3239489151f, 0.5400702194f, 0.8541344516f,
			0.6201819885f, 0.8964757966f, 0.8474511956f, 0.1734695192f, 0.8236533082f,
			0.9949825844f, 0.8584004217f, 0.4340374172f, 0.6039564754f, 0.124331587f,
			0.5069775176f, 0.224658126f, 0.5393352224f, 0.4332831232f, 0.06275998661f,
			0.03885285929f, 0.02774305968f, 0.4885433735f, 0.1309652855f, 0.4639309775f,
			0.182473158f, 0.605452857f, 0.8889010199f, 0.4423425272f, 0.6672413568f,
			0.3915655324f, 0.08999326499f, 0.511546405f, 0.2519722967f, 0.6593685253f,
			0.8666430102f, 0.4286441468f, 0.3705386776f, 0.364392479f, 0.8631607299f,
			0.08602934144f, 0.4617036409f, 0.7249625316f, 0.7300290787f, 0.1243026704f,
			0.374516278f, 0.1798399175f, 0.5107437116f, 0.1487025712f, 0.6194102629f,
			0.3400041936f, 0.9524822296f, 0.9553015269f, 0.7462556097f, 0.5908260914f,
			0.2718512495f, 0.6732179802f, 0.6306135557f, 0.500880993f, 0.4069615998f,
			0.229093872f, 0.9494445692f, 0.6936530331f, 0.2870816407f, 0.04008780606f,
			0.6275194823f, 0.3383798255f, 0.1511187092f, 0.3416338377f, 0.5357837486f,
			0.9162878143f, 0.4461786901f, 0.05621588789f, 0.2229248262f, 0.4184682509f,
			0.3374537104f, 0.6094077826f, 0.9613926853f, 0.6316437954f, 0.3606879604f,
			0.5994289164f, 0.8891234412f, 0.6680757431f, 0.2484716387f, 0.7264655419f,
			0.5282161119f, 0.3958618762f, 0.4616130223f, 0.8880076837f, 0.4618125013f,
			0.9258749401f, 0.4568386623f, 0.8464516774f, 0.4504302065f, 0.8115917454f,
			0.222071704f, 0.3752183337f, 0.768998751f, 0.1180628939f, 0.1105383323f,
			0.2896367274f, 0.04584884224f, 0.01627313066f, 0.5049523418f, 0.2688436117f,
			0.3849047548f, 0.05914232042f, 0.3430278325f, 0.8749484569f, 0.05232983781f,
			0.795417049f, 0.03557002963f, 0.6757141147f, 0.5088751479f, 0.8777028499f,
			0.8083942295f, 0.8770031072f, 0.0691812071f, 0.3208870562f, 0.9993228693f,
			0.3712395411f, 0.9692828855f, 0.06720227655f, 0.3415107229f, 0.6081366464f,
			0.1235674093f, 0.5141804973f, 0.7643482205f, 0.193939941f, 0.3524354934f,
			0.1617478086f, 0.7431928948f, 0.6254360192f, 0.3619155991f, 0.03470975626f,
			0.7291789507f, 0.06497696601f, 0.2564813173f, 0.03687731829f, 0.6903549605f,
			0.5627703965f, 0.8663218762f, 0.8930835063f, 0.2953996849f, 0.6326851193f,
			0.6703157737f, 0.8353405921f, 0.7711660177f, 0.5878224261f, 0.5959575358f,
			0.6893879594f, 0.9653030564f, 0.5421030056f, 0.477487599f, 0.5178805804f,
			0.6452062973f, 0.4841194823f, 0.4534753184f, 0.476468117f, 0.564545956f,
			0.3295045812f, 0.08510510018f, 0.03901464771f, 0.3286234126f, 0.358064916f,
			0.4764156598f, 0.2482090192f, 0.5898057823f, 0.9419304039f, 0.1777424044f,
			0.1478158226f, 0.6042886102f, 0.9709693044f, 0.153612941f, 0.05281699542f,
			0.6814366919f, 0.8817188833f, 0.5963457092f, 0.8136940477f, 0.556953019f,
			0.6960817017f, 0.8666017386f, 0.7311009141f, 0.2211258491f, 0.9760375302f,
			0.3421395323f, 0.2771774298f, 0.2334039011f, 0.1006208882f, 0.4560230742f,
			0.2797534326f, 0.0545496759f, 0.7714142073f, 0.705532962f, 0.7256934894f,
			0.4276209013f, 0.152806621f, 0.9130306649f, 0.8396322476f, 0.3390301024f,
			0.5532683786f, 0.5200259066f, 0.5943504116f, 0.5909322971f, 0.05389088392f,
			0.195697173f, 0.3090413446f, 0.5161908162f, 0.9904423598f, 0.541115345f,
			0.491718295f, 0.8671712489f, 0.695189137f, 0.1704204562f, 0.5820122482f,
			0.4096135129f, 0.4047325682f, 0.9502015761f, 0.7506104028f, 0.25283205f,
			0.7401115671f, 0.6783298175f, 0.4115852723f, 0.4474941459f, 0.6654207725f,
			0.9834944694f, 0.6038644118f, 0.8822263763f, 0.3311943375f, 0.7266922551f,
			0.8980907695f, 0.01029917644f, 0.7088053431f, 0.6859197146f, 0.9851236632f,
			0.4376395368f, 0.422130838f, 0.8053187127f, 0.6024303818f, 0.9034218234f,
			0.682732502f, 0.7900250717f, 0.9546184121f, 0.684486723f, 0.7348029353f,
			0.3279703292f, 0.28435829f, 0.9548383136f, 0.7161275726f, 0.719886621f,
			0.7499470776f, 0.1314692595f, 0.3413122222f, 0.1987646888f, 0.2657624641f,
			0.7377641317f, 0.3135262299f, 0.7200150131f, 0.461857493f, 0.8157308535f,
			0.8710112683f, 0.503582071f, 0.4189459132f, 0.4183102702f, 0.3746057507f,
			0.109261719f, 0.3350281557f, 0.213013845f, 0.3425348699f, 0.3264717008f,
			0.7799079353f, 0.7281394792f, 0.838716263f, 0.65972528f, 0.693849477f,
			0.2728154571f, 0.6208312996f, 0.6910579982f, 0.7866253676f, 0.0621225168f,
			0.9544119965f, 0.1006575576f, 0.4932050323f, 0.5785440453f, 0.4991935566f,
			0.6269468288f, 0.1423338363f, 0.7009943989f, 0.1739825327f, 0.7473699837f,
			0.4942528112f, 0.6326753483f, 0.4062906168f, 0.3611317533f, 0.3038090067f,
			0.1590106492f, 0.6729840543f, 0.2551398105f, 0.06520646717f, 0.2669087374f,
			0.7381986827f, 0.6344002779f, 0.5946478331f, 0.6566035491f, 0.4947705958f,
			0.4981163605f, 0.6071165679f, 0.1773234666f, 0.815432433f, 0.1427401039f,
			0.943549809f, 0.7180383881f, 0.3200252932f, 0.5732272766f, 0.6046518451f,
			0.5845349231f, 0.4649762735f, 0.1037453781f, 0.2475982169f, 0.8940697131f,
			0.8612916339f, 0.9290847718f, 0.3018804444f, 0.01885087648f, 0.2273155861f,
			0.9480229425f, 0.3605413781f, 0.6095975791f, 0.8825047072f, 0.6198918796f,
			0.003051175736f, 0.2304277294f, 0.1884679794f, 0.1355985845f, 0.7060739035f,
			0.1363237989f, 0.8435224537f, 0.6843487038f, 0.9983747629f, 0.2244267673f,
			0.4370145388f, 0.09732328681f, 0.5161179425f, 0.690408193f, 0.1696569156f,
			0.6495586685f, 0.114805094f, 0.4211704084f, 0.1461310759f, 0.3012794773f,
			0.694104434f, 0.6551248399f, 0.1462054867f, 0.159934768f, 0.8918204708f,
			0.9412984536f, 0.2806193791f, 0.4441872793f, 0.3032543557f, 0.9285183256f,
			0.4379821625f, 0.731105817f, 0.3822048595f, 0.01592433685f, 0.9289384633f,
			0.7678107615f, 0.6798599744f, 0.3960599941f, 0.2338487897f, 0.6288227006f,
			0.5778291402f, 0.5217913748f, 0.26023582f, 0.5003641876f, 0.1715660961f,
			0.5283041974f, 0.01624631695f, 0.872864624f, 0.4604323572f, 0.6414290168f,
			0.1063786671f, 0.4229182671f, 0.5006513158f, 0.1035445449f, 0.9557260443f,
			0.365945363f, 0.6774029685f, 0.6483090953f, 0.1689851992f, 0.5608064043f,
			0.7523092674f, 0.05547015416f, 0.9304808732f, 0.1476195133f, 0.8425600966f,
			0.8170020753f, 0.8514558375f, 3.094924614e-005f, 0.9879298741f, 0.4458219004f,
			0.170876557f, 0.7731887414f, 0.4619347779f, 0.4583333046f, 0.7160044797f,
			0.828669447f, 0.483380598f, 0.5620486666f, 0.5289829504f, 0.8176080338f,
			0.4845512128f, 0.07953926409f, 0.56568975f, 0.203280888f, 0.5922876904f,
			0.1399635938f, 0.3731052596f, 0.5043919473f, 0.4782080157f, 0.6694238172f,
			0.1514462493f, 0.5403119582f, 0.2343174415f, 0.7114003305f, 0.1073152926f,
			0.4595208592f, 0.4302594652f, 0.1085144603f, 0.504115805f, 0.8325032885f,
			0.008457430638f, 0.07686928334f, 0.3159827087f, 0.5903472169f, 0.1733967541f,
			0.7042185725f, 0.8914787211f, 0.09029570548f, 0.9312977763f, 0.9032138665f,
			0.533306269f, 0.08950178837f, 0.4364292389f, 0.8509796658f, 0.4002850279f,
			0.9082364808f, 0.8003123859f, 0.4462667522f, 0.6378450859f, 0.5637999116f,
			0.5200656904f, 0.8154336349f, 0.1432857327f, 0.1563855815f, 0.182140206f,
			0.3985061203f, 0.8720498737f, 0.2881477452f, 0.5976955434f, 0.6465650075f,
			0.09126406908f, 0.7967219199f, 0.02586647216f, 0.8617119086f, 0.4867941979f,
			0.5844485178f, 0.6411701469f, 0.210863194f, 0.5300667472f, 0.8245496037f,
			0.9013039591f, 0.4446220626f, 0.01090572588f, 0.3255087784f, 0.9715840137f,
			0.3524787375f, 0.1426352039f, 0.334904186f, 0.8622742305f, 0.4855887857f,
			0.1456974763f, 0.5639446466f, 0.4350560708f, 0.1783795641f, 0.7160368524f,
			0.7139589149f, 0.9348888891f, 0.4002347891f, 0.2844990697f, 0.286088062f,
			0.2035109093f, 0.4685072326f, 0.4734963328f, 0.955430984f, 0.2308308268f,
			0.1541095418f, 0.6571879778f, 0.2908930345f, 0.2004600344f, 0.2109331847f,
			0.0314267613f, 0.1019877824f, 0.6856354745f, 0.8603455205f, 0.09972077422f,
			0.1938418946f, 0.1517831152f, 0.2620149949f, 0.9814609811f, 0.8116531442f,
			0.4219720522f, 0.50231446f, 0.448664384f, 0.5558515429f, 0.261509235f,
			0.1315526203f, 0.09748281166f, 0.04921359895f, 0.7379248189f, 0.7812836026f,
			0.5607273336f, 0.1371797002f, 0.5125981411f, 0.8929446512f, 0.1676582992f,
			0.9026246215f, 0.7202743227f, 0.08907194855f, 0.9572910015f, 0.2763311579f,
			0.5927214948f, 0.2183445604f, 0.4514669664f, 0.5244168821f, 0.4827786507f,
			0.6057065059f, 0.09394086711f, 0.3939640275f, 0.4450441217f, 0.5388169535f,
			0.7617330626f, 0.1981024961f, 0.02945467923f, 0.5220785406f, 0.2549977619f,
			0.621795991f, 0.4440052612f, 0.3294938193f, 0.1716568135f, 0.5295812744f,
			0.7428593235f, 0.3875998263f, 0.07304911874f, 0.5565105504f, 0.1960998168f,
			0.5197307789f, 0.3468456715f, 0.763546973f, 0.4973707879f, 0.5828588945f,
			0.673480222f, 0.1386632784f, 0.9656596063f, 0.02826333651f, 0.5023455657f,
			0.2248935434f, 0.3974698158f, 0.9172772844f, 0.4440054577f, 0.6565880678f,
			0.7256346112f, 0.4233631291f, 0.9846721515f, 0.8851213823f, 0.1410209397f,
			0.3517657933f, 0.4291995633f, 0.8753033816f, 0.8333742274f, 0.7079941765f,
			0.478842061f, 0.05374358175f, 0.007553731091f, 0.846380726f, 0.3500288781f,
			0.2904185033f, 0.3314085146f, 0.2299691313f, 0.8404041529f, 0.1946921791f,
			0.4715440506f, 0.3329801452f, 0.2483825926f, 0.5070397868f, 0.8732294468f,
			0.7171055288f, 0.5524707623f, 0.867724407f, 0.4406952979f, 0.8128801216f,
			0.7566039991f, 0.743676906f, 0.2740721619f, 0.4373820373f, 0.807748951f,
			0.7948289434f, 0.1192196617f, 0.5795109835f, 0.9920217413f, 0.4611491053f,
			0.6866962118f, 0.4840947078f, 0.2155717574f, 0.05163216172f, 0.4961193698f,
			0.5660735671f, 0.07648106478f, 0.1164914495f, 0.4021668127f, 0.1860132241f,
			0.1339294463f, 0.3838043804f, 0.4584679389f, 0.8181954664f, 0.2808750663f,
			0.04186107358f, 0.2756360946f, 0.6425371529f, 0.6265007593f, 0.6484661135f,
			0.5296914252f, 0.09158728318f, 0.7946759444f, 0.4484434328f, 0.7771243518f,
			0.3838521936f, 0.04468416423f, 0.3805943201f, 0.2328496734f, 0.5746988771f,
			0.1204662491f, 0.5553585528f, 0.6673012925f, 0.1560864286f, 0.2346291058f,
			0.4844286549f, 0.07891756762f, 0.7363756155f, 0.09347013198f, 0.8435672796f,
			0.2982672891f, 0.8314665728f, 0.3692672551f, 0.04987771763f, 0.180066281f,
			0.2985146237f, 0.5260845963f, 0.4347775294f, 0.5393346278f, 0.4434742243f,
			0.4053437598f, 0.2939253035f, 0.4879445257f, 0.3337210347f, 0.4774107467f,
			0.5953505388f, 0.3278087592f, 0.3470021137f, 0.1654484943f, 0.627036653f,
			0.6569598028f, 0.4879642394f, 0.1477850396f, 0.3652071147f, 0.8447695477f,
			0.5035103546f, 0.04504730925f, 0.8445647019f, 0.5325596528f, 0.3282341366f,
			0.3983105328f, 0.3117338843f, 0.3158525219f, 0.8911826932f, 0.3445132822f,
			0.4431563313f, 0.2645129049f, 0.8151973826f, 0.8953881357f, 0.408689545f,
			0.4370301245f, 0.04008275876f, 0.226157967f, 0.06215861766f, 0.04519092757f,
			0.9008536418f, 0.8802478593f, 0.04011111474f, 0.4253929621f, 0.6923103132f,
			0.2962626442f, 0.05002508266f, 0.4728488782f, 0.2511918363f, 0.5634800661f,
			0.1292201816f, 0.6949310554f, 0.5871575014f, 0.812109571f, 0.1557219434f,
			0.5399069535f, 0.09384639608f, 0.1445667204f, 0.3923291541f, 0.1573150894f,
			0.3712651008f, 0.5140132308f, 0.3451343621f, 0.2462316388f, 0.1907535088f,
			0.4564126376f, 0.7177475109f, 0.1476776628f, 0.6337787719f, 0.08235158399f,
			0.7424726966f, 0.837416959f, 0.9358073701f, 0.2348767351f, 0.6696880511f,
			0.9753945386f, 0.0665053078f, 0.2195973173f, 0.6966787498f, 0.6680657277f,
			0.5775164333f, 0.01330328174f, 0.1171731441f, 0.09986589383f, 0.7490688846f,
			0.357349094f, 0.9728320199f, 0.6900707977f, 0.5666596596f, 0.6420531478f,
			0.9879409797f, 0.9312975695f, 0.5590673112f, 0.9883628041f, 0.06855595065f,
			0.5658963108f, 0.028942768f, 0.4330350552f, 0.1473518177f, 0.2564823208f,
			0.7072282792f, 0.6235828139f, 0.6554241809f, 0.4068589481f, 0.3626544853f,
			0.9292368274f, 0.4022942386f, 0.2895810669f, 0.397565613f, 0.3741732165f,
			0.1453667949f, 0.1364091793f, 0.9613227961f, 0.2992566396f, 0.6300913929f,
			0.3479041411f, 0.61253552f, 0.1585490815f, 0.3820765722f, 0.4784125136f,
			0.0613711928f, 0.3568342682f, 0.03240725165f, 0.1526925405f, 0.02319284016f,
			0.5344077051f, 0.4574152376f, 0.5704307491f, 0.7147749257f, 0.2053823415f,
			0.5141528561f, 0.7548991768f, 0.02434729645f, 0.1557598598f, 0.6528197112f,
			0.2020032229f, 0.8867172529f, 0.5075175893f, 0.1873925678f, 0.08597012516f,
			0.8947197446f, 0.8549610451f, 0.5057083587f, 0.6779280612f, 0.6782456902f,
			0.3795920927f, 0.0002503185533f, 0.1336258752f, 0.08209842304f, 0.3497427367f,
			0.0008872407489f, 0.3065434294f, 0.6739282613f,
	};
	
}
