// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiTextureCoordinates̃LbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiTextureCoordinatesCache extends RiCacheBase {
	
	public RiTextureCoordinatesCache(float s1, float t1, float s2, float t2, float s3, float t3, float s4, float t4)
	{
		m_s1 = s1;
		m_t1 = t1;
		m_s2 = s2;
		m_t2 = t2;
		m_s3 = s3;
		m_t3 = t3;
		m_s4 = s4;
		m_t4 = t4;
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiTextureCoordinates(m_s1, m_t1, m_s2, m_t2, m_s3, m_t3, m_s4, m_t4);
	}
	
	private float m_s1;
	private float m_t1;
	private float m_s2;
	private float m_t2;
	private float m_s3;
	private float m_t3;
	private float m_s4;
	private float m_t4;
	
}
