// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiSubdivisionMeshṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiSubdivisionMeshCache extends RiCacheBase {

	public RiSubdivisionMeshCache(String scheme, int nfaces, int[] nvertices, int[] vertices, int ntags, String[] tags, int[] nargs, int[] intargs, float[] floatargs, int count, String[] tokens, Object[] values)
	{
//		int __scheme_length = strlen(scheme);
//		m_scheme = new char[ __scheme_length + 1 ];
//		strcpy(m_scheme, scheme);
		m_scheme = new String( scheme );
		m_nfaces = nfaces;
		int __nvertices_length = nfaces;
		m_nvertices = new int[__nvertices_length];
		int __nvertices_index;
		for(__nvertices_index = 0; __nvertices_index<__nvertices_length; __nvertices_index++)
		{
			m_nvertices[__nvertices_index] = nvertices[__nvertices_index];
		}
		int __vertices_length = 0;
		{
			int __i;
			for(__i=0; __i<nfaces; __i++)
				__vertices_length+=nvertices[__i];
		}
		m_vertices = new int[__vertices_length];
		int __vertices_index;
		for(__vertices_index = 0; __vertices_index<__vertices_length; __vertices_index++)
		{
			m_vertices[__vertices_index] = vertices[__vertices_index];
		}
		m_ntags = ntags;
		int __tags_length = ntags;		m_tags = new String[__tags_length];
		int __tags_index;
		for(__tags_index = 0; __tags_index<__tags_length; __tags_index++)
		{
//			int __tags_slength = strlen(tags[__tags_index]);
//			m_tags[__tags_index] = new char[ __tags_slength + 1 ];
//			strcpy(m_tags[__tags_index], tags[__tags_index]);
			m_tags[__tags_index] = new String( tags[__tags_index] );
		}
		int __nargs_length = ntags*2;
		m_nargs = new int[__nargs_length];
		int __nargs_index;
		for(__nargs_index = 0; __nargs_index<__nargs_length; __nargs_index++)
		{
			m_nargs[__nargs_index] = nargs[__nargs_index];
		}
		int __intargs_length = 0;
		{
			int __i;
			for(__i=0; __i<ntags*2; __i+=2)
				__intargs_length+=nargs[__i];
		}
		m_intargs = new int[__intargs_length];
		int __intargs_index;
		for(__intargs_index = 0; __intargs_index<__intargs_length; __intargs_index++)
		{
			m_intargs[__intargs_index] = intargs[__intargs_index];
		}
		int __floatargs_length = 0;
		{
			int __i;
			for(__i=0; __i<ntags*2; __i+=2)
				__floatargs_length+=nargs[__i+1];
		}
		m_floatargs = new float[__floatargs_length];
		int __floatargs_index;
		for(__floatargs_index = 0; __floatargs_index<__floatargs_length; __floatargs_index++)
		{
			m_floatargs[__floatargs_index] = floatargs[__floatargs_index];
		}
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		varying_size=0;
		{
			int __i;
			for(__i=0; __i<__vertices_length; __i++)
				if(vertices[__i]>varying_size)
					varying_size=vertices[__i];
		}
		varying_size+=1;
		vertex_size=varying_size;
		facevarying_size=0;
		{
			int __i;
			for(__i=0; __i<nfaces; __i++)
				facevarying_size+=nvertices[__i];
		}
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}

	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_scheme);
//		delete[](m_nvertices);
//		delete[](m_vertices);
//		int __tags_length = 1;
//		int __tags_index;
//		for(__tags_index = 0; __tags_index<__tags_length; __tags_index++)
//		{
//			delete[](m_tags[__tags_index]);
//		}
//		delete[](m_tags);
//		delete[](m_nargs);
//		delete[](m_intargs);
//		delete[](m_floatargs);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiSubdivisionMeshV(m_scheme, m_nfaces, m_nvertices, m_vertices, m_ntags, m_tags, m_nargs, m_intargs, m_floatargs, m_count, m_tokens, m_values);
	}


	private String		m_scheme;
	private int		m_nfaces;
	private int[]		m_nvertices;
	private int[]		m_vertices;
	private int		m_ntags;
	private String[]	m_tags;
	private int[]		m_nargs;
	private int[]		m_intargs;
	private float[]	m_floatargs;
	// plist information is stored in the base class.
	
}
