// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * 
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiPointsGeneralPolygonsCache extends RiCacheBase {
	
	public RiPointsGeneralPolygonsCache(int npolys, int nloops[], int nverts[], int verts[], int count, String[] tokens, Object[] values)
	{
		m_npolys = npolys;
		int __nloops_length = npolys;
		m_nloops = new int[__nloops_length];
		int __nloops_index;
		for(__nloops_index = 0; __nloops_index<__nloops_length; __nloops_index++)
		{
			m_nloops[__nloops_index] = nloops[__nloops_index];
		}
		int __nverts_length = 0;
		{
			int __i;
			for(__i=0; __i<npolys; __i++)
				__nverts_length+=nloops[__i];
		}
		m_nverts = new int[__nverts_length];
		int __nverts_index;
		for(__nverts_index = 0; __nverts_index<__nverts_length; __nverts_index++)
		{
			m_nverts[__nverts_index] = nverts[__nverts_index];
		}
		int __verts_length = 0;
		{
			int __i;
			for(__i=0; __i<__nverts_length; __i++)
				__verts_length+=nverts[__i];
		}
		m_verts = new int[__verts_length];
		int __verts_index;
		for(__verts_index = 0; __verts_index<__verts_length; __verts_index++)
		{
			m_verts[__verts_index] = verts[__verts_index];
		}
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		varying_size=0;
		{
			int __i;
			for(__i=0; __i<__verts_length; __i++)
				if(verts[__i]>varying_size)
					varying_size=verts[__i];
		}
		varying_size+=1;
		vertex_size=varying_size;
		facevarying_size=0;
		{
			int __i;
			for(__i=0; __i<npolys; __i++)
				facevarying_size+=nverts[__i];
		}
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_nloops);
//		delete[](m_nverts);
//		delete[](m_verts);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiPointsGeneralPolygonsV(m_npolys, m_nloops, m_nverts, m_verts, m_count, m_tokens, m_values);
	}
	
	private int m_npolys;
	private int[] m_nloops;
	private int[] m_nverts;
	private int[] m_verts;
	// plist information is stored in the base class.
	
}
