// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiNuPatchṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiNuPatchCache extends RiCacheBase {

	public RiNuPatchCache(int nu, int uorder, float uknot[], float umin, float umax, int nv, int vorder, float vknot[], float vmin, float vmax, int count, String[] tokens, Object[] values)
	{
		m_nu = nu;
		m_uorder = uorder;
		int __uknot_length = nu + uorder;
		m_uknot = new float[__uknot_length];
		int __uknot_index;
		for(__uknot_index = 0; __uknot_index<__uknot_length; __uknot_index++)
		{
			m_uknot[__uknot_index] = uknot[__uknot_index];
		}
		m_umin = umin;
		m_umax = umax;
		m_nv = nv;
		m_vorder = vorder;
		int __vknot_length = nv + vorder;
		m_vknot = new float[__vknot_length];
		int __vknot_index;
		for(__vknot_index = 0; __vknot_index<__vknot_length; __vknot_index++)
		{
			m_vknot[__vknot_index] = vknot[__vknot_index];
		}
		m_vmin = vmin;
		m_vmax = vmax;
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		uniform_size=(1+nu-uorder+1)*(1+nv-vorder+1);
		varying_size=(1+nu-uorder+1)*(1+nv-vorder+1);
		vertex_size=nu*nv;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}

	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_uknot);
//		delete[](m_vknot);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiNuPatchV(m_nu, m_uorder, m_uknot, m_umin, m_umax, m_nv, m_vorder, m_vknot, m_vmin, m_vmax, m_count, m_tokens, m_values);
	}

	private int		m_nu;
	private int		m_uorder;
	private float[]	m_uknot;
	private float		m_umin;
	private float		m_umax;
	private int		m_nv;
	private int		m_vorder;
	private float[]	m_vknot;
	private float		m_vmin;
	private float		m_vmax;
	// plist information is stored in the base class.

	
}
