// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library.cache;

import net.cellcomputing.himawari.library.RendermanInterface;

/**
 * 
 * RiGeneralPolygonṼLbV
 * 
 * @author NTT DATA Corporation
 */
public strictfp class RiGeneralPolygonCache extends RiCacheBase {
	
	public RiGeneralPolygonCache(int nloops, int nverts[], int count, String[] tokens, Object[] values)
	{
		m_nloops = nloops;
		int __nverts_length = nloops;
		m_nverts = new int[__nverts_length];
		int __nverts_index;
		for(__nverts_index = 0; __nverts_index<__nverts_length; __nverts_index++)
		{
			m_nverts[__nverts_index] = nverts[__nverts_index];
		}
		// Copy the plist here.
		int constant_size = 1;
		int uniform_size = 1;
		int varying_size = 1;
		int vertex_size = 1;
		int facevarying_size = 1;
		varying_size = 0;
		{
			int __i;
			for(__i=0;__i<nloops;__i++)
				varying_size+=nverts[__i];
		}
		vertex_size = varying_size;
		facevarying_size = varying_size;
		CachePlist(count, tokens, values, constant_size, uniform_size, varying_size, vertex_size, facevarying_size);
	}
	
	@Override
	public void destruct()
	{
		super.destruct();
//		delete[](m_nverts);
		// plist gets destroyed by the base class.
	}
	
	@Override
	public void ReCall()
	{
		RendermanInterface.RiGeneralPolygonV(m_nloops, m_nverts, m_count, m_tokens, m_values);
	}
	
	private int m_nloops;
	private int[] m_nverts;
	// plist information is stored in the base class.
	
}
