/// Aqsis
// Copyright (c) 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/**
 * Copyright (C) 2006-2007  NTT DATA CORPORATION
 * 
 * Version: 1.0.0 2007/04/01
 *  
 */
package net.cellcomputing.himawari.library;

import net.cellcomputing.himawari.accessory.Valarray;
import net.cellcomputing.himawari.library.types.CqColor;

import static net.cellcomputing.himawari.library.EqSampleIndices.*;
/**
 * SqImageSampleef̏i[邽߂̍\
 * 
 * pixelǗNXB
 * @author NTT DATA Corporation
 */
public strictfp class SqImageSample {
	
	private CqColor fColor;	//ʎqÕJ[(臒l0`1) Himawari add.
	
	/**
	 * RXgN^
	 * ̕AVectorzpӂB
	 *@ftHg9
	 */
	public SqImageSample()
	{
		m_Data.resize( 9 );
	}
	
	public SqImageSample( int NumData  )
    {
        m_Data.resize( NumData );
    }
	
	public SqImageSample( SqImageSample from )
	{
		   m_flags		= from.m_flags;
		   m_Data		= new Valarray( from.m_Data );
		   m_pCSGNode	= from.m_pCSGNode;
	}
	
/**
 * ̗񋓕̕ςB<br>
 * enum {<br>
 *       Flag_Occludes = 0x0001,<br>
 *       Flag_Matte = 0x0002,<br>
 *		 Flag_Valid = 0x0004<br>
 * };<br>
 */
 	public static final int Flag_Occludes = 0x0001;
	public static final int Flag_Matte = 0x0002;
	public static final int Flag_Valid = 0x0004;
	
	/**
	 * SqImageSamplefCs̒liF̒ljԂB
	 * @return F̏Ԃ
	 */
    public CqColor Cs()
    {
        return( new CqColor( m_Data.valueAt(Sample_Red), m_Data.valueAt(Sample_Green), m_Data.valueAt(Sample_Blue) ) );
    }
    /**
	 * SqImageSamplefCs̒lݒ肷BAvfmۂłĂȂ΃G[͂B
	 */
    public void SetCs( CqColor col )
    {
        assert( m_Data.size() >= Sample_Blue+1 );
        m_Data.setValueAt(Sample_Red,col.fRed() );
        m_Data.setValueAt(Sample_Green, col.fGreen() );
        m_Data.setValueAt(Sample_Blue, col.fBlue());
    }
	/**
	 * SqImageSamplefOs̒lix̒ljԂB
	 * @return x̏Ԃ
	 */
    public CqColor Os()
    {
        return( new CqColor( m_Data.valueAt(Sample_ORed), m_Data.valueAt(Sample_OGreen), m_Data.valueAt(Sample_OBlue) ) );
    }
    /**
	 * SqImageSamplefOs̒lݒ肷BAvfmۂłĂȂ΃G[͂B
	 */
    public void SetOs( CqColor col )
    {
        assert( m_Data.size() >= Sample_OBlue+1);
        m_Data.setValueAt(Sample_ORed, col.fRed());
        m_Data.setValueAt(Sample_OGreen , col.fGreen());
        m_Data.setValueAt(Sample_OBlue, col.fBlue());
    }

    /**
	 * SqImageSample[xԂB
	 * @return [x̏Ԃ
	 */
    public float Depth()
    {
        assert( m_Data.size() >= Sample_Depth+1 );
        return( m_Data.valueAt(Sample_Depth) );
    }
    /**
	 * SqImageSample[xݒ肷B
	 */
    public void SetDepth( float d )
    {
        assert( m_Data.size() >= Sample_Depth+1 );
        m_Data.setValueAt(Sample_Depth,d);
    }
    /**
	 * SqImageSample͈͂ԂB
	 */
    public float Coverage()
    {
        assert( m_Data.size() >= Sample_Coverage+1 );
        return( m_Data.valueAt(Sample_Coverage) );
    }
    /**
	 * SqImageSample͈͂ݒ肷B
	 */
    public void SetCoverage( float d )
    {
        assert( m_Data.size() >= Sample_Coverage+1 );
        m_Data.setValueAt(Sample_Coverage , d);
    }
    /**
	 * SqImageSamplẽlԂB
	 */
    public float Alpha()
	{
        assert( m_Data.size() >= Sample_Alpha+1 );
		return(m_Data.valueAt(Sample_Alpha));
	}
    /**
	 * SqImageSamplẽlݒ肷B
	 */
    public void SetAlpha(float a)
	{
        assert( m_Data.size() >= Sample_Alpha+1 );
		m_Data.setValueAt(Sample_Alpha, a);
	}
    /**
	 * SqImageSample̔z̃TCYԂB
	 */
    public int DataSize()
    {
        return( m_Data.size() );
    }

    int m_flags;
//    std::valarray<TqFloat>	m_Data;
    Valarray m_Data = new Valarray();
    CqCSGTreeNode	m_pCSGNode ;	///< Pointer to the CSG node this sample is part of, NULL if not part of a solid.

    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
    	return m_Data.toString();
    }

 
	/**
	 * ʎqÕJ[Ԃ
	 * nullԂꍇ
	 * Himawari add.
	 * @return Returns the fColor.
	 */
	public CqColor getFColor() {
		return fColor;
	}

	/**
	 * ʎqÕJ[Zbg
	 * himawari add.
	 * @param color The fColor to set.
	 */
	public void setFColor(CqColor color) {
		fColor = color;
	}
}
